/*
 * Decompiled with CFR 0.152.
 */
package moagg.level.xml;

import java.util.LinkedList;
import moagg.level.xml.Handler;
import moagg.level.xml.RootHandler;
import moagg.level.xml.data.LevelData;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class LevelContentHandler
extends DefaultHandler {
    private static Logger log = Logger.getLogger(LevelContentHandler.class);
    private LinkedList<Handler> handlers = new LinkedList();
    private StringBuilder buffer = new StringBuilder();

    public LevelContentHandler() {
        this.handlers.add(new RootHandler());
    }

    public LevelData getLevel() {
        return ((RootHandler)this.handlers.get(0)).getLevel();
    }

    public void startElement(String uri, String localName, String qName, Attributes attrs) {
        log.trace(qName);
        Handler handler = this.handlers.getLast();
        Handler subHandler = handler.createSubHandler(qName, attrs);
        this.handlers.add(subHandler != null ? subHandler : handler);
        this.resetBuffer();
    }

    public void endElement(String uri, String localName, String qName) {
        log.trace(qName);
        Handler handler = this.handlers.removeLast();
        handler.handleTag(qName, this.resetBuffer());
        Handler parent = this.handlers.getLast();
        if (parent != handler) {
            parent.finishSubHandler(qName, handler);
        }
    }

    public void characters(char[] ch, int start, int length) {
        this.buffer.append(ch, start, length);
    }

    protected String resetBuffer() {
        String result = this.buffer.toString();
        this.buffer = new StringBuilder();
        return result;
    }
}

