/*
 * Decompiled with CFR 0.152.
 */
package moagg.level;

import com.golden.gamedev.GameObject;
import com.golden.gamedev.util.ImageUtil;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.DataInputStream;
import java.io.IOException;
import moagg.artwork.tiles.TileImageFactory;
import moagg.game.SystemProperties;
import moagg.level.MapReaderException;
import moagg.model.level.Map;
import moagg.types.math.Point;
import moagg.util.ArrayTool;
import moagg.util.ImageTool;
import org.apache.log4j.Logger;

public class MapReader {
    private static Logger log = Logger.getLogger(MapReader.class);
    private static MapReader instance = new MapReader();

    public static MapReader getInstance() {
        return instance;
    }

    public Map readMap(String mission, String map, GameObject loader) {
        log.debug("Reading map '" + mission + "/" + map + "'");
        try {
            DataInputStream dis = new DataInputStream(loader.bsIO.getStream(SystemProperties.getInstance().getMissionsPath() + "/" + mission + "/" + map));
            byte version = dis.readByte();
            switch (version) {
                case 1: {
                    return this.readMapV1(dis);
                }
                case 2: {
                    return this.readMapV2(dis);
                }
            }
            throw new MapReaderException("Illegal map version: " + version);
        }
        catch (IOException e) {
            throw new MapReaderException("I/O exception while reading map '" + mission + "/" + map + "'", e);
        }
    }

    protected Map readMapV1(DataInputStream dis) throws IOException, MapReaderException {
        short xTiles = dis.readShort();
        short yTiles = dis.readShort();
        int layers = dis.readByte();
        if (layers == 0) {
            throw new MapReaderException("There must be at least one layer.");
        }
        Map m = new Map(xTiles, yTiles);
        BufferedImage image = ImageUtil.createImage((int)(xTiles * 16), (int)(yTiles * 16));
        Graphics2D g = image.createGraphics();
        g.clearRect(0, 0, image.getWidth(), image.getHeight());
        for (int layer = 1; layer <= layers; ++layer) {
            int categoryId = dis.readByte() & 0xFF;
            for (short y = 0; y < yTiles; y = (short)(y + 1)) {
                for (short x = 0; x < xTiles; x = (short)(x + 1)) {
                    int tileId = dis.readByte() & 0xFF;
                    if (tileId == 0) continue;
                    m.markAsForegroundTile(x, y);
                    int alpha = categoryId == 255 ? 128 : 255;
                    BufferedImage tile = TileImageFactory.getInstance().getTile(categoryId, tileId, alpha, 128);
                    g.drawImage(tile, null, x * 16, y * 16);
                }
            }
        }
        g.dispose();
        m.setImage(image);
        m.setRGB(ImageTool.getRGB(image));
        return m;
    }

    protected Map readMapV2(DataInputStream dis) throws IOException, MapReaderException {
        short xTiles = dis.readShort();
        short yTiles = dis.readShort();
        int layers = dis.readByte();
        if (layers == 0) {
            throw new MapReaderException("There must be at least one layer.");
        }
        Map m = new Map(xTiles, yTiles);
        BufferedImage image = ImageUtil.createImage((int)(xTiles * 16), (int)(yTiles * 16));
        Graphics2D g = image.createGraphics();
        g.clearRect(0, 0, image.getWidth(), image.getHeight());
        int[] rgb = new int[image.getWidth() * image.getHeight()];
        for (int layer = 1; layer <= layers; ++layer) {
            int categoryId = dis.readByte() & 0xFF;
            int background = dis.readByte() & 0xFF;
            int alpha = dis.readByte() & 0xFF;
            int brightness = dis.readByte() & 0xFF;
            log.trace("Layer " + layer + ": categoryId = " + categoryId + ", background = " + background + ", alpha = " + alpha + ", brightness = " + brightness);
            if (categoryId == 0 || categoryId == 255) {
                throw new MapReaderException("The category index '" + categoryId + "' must not be used for version 2 maps.");
            }
            for (short y = 0; y < yTiles; y = (short)(y + 1)) {
                for (short x = 0; x < xTiles; x = (short)(x + 1)) {
                    int tileId = dis.readByte() & 0xFF;
                    if (tileId == 0) continue;
                    BufferedImage tile = TileImageFactory.getInstance().getTile(categoryId, tileId, alpha, brightness);
                    g.drawImage(tile, null, x * 16, y * 16);
                    if (background != 0) continue;
                    ArrayTool.copyNonAlphaPixels(TileImageFactory.getInstance().getRGB(categoryId, tileId), 16, rgb, image.getWidth(), new Point(x * 16, y * 16));
                    m.markAsForegroundTile(x, y);
                }
            }
        }
        while ((layers = (byte)(layers - 1)) > 0) {
        }
        g.dispose();
        m.setImage(image);
        m.setRGB(rgb);
        return m;
    }
}

