/*
 * Decompiled with CFR 0.152.
 */
package moagg.game.menu;

import com.golden.gamedev.GameEngine;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RescaleOp;
import moagg.game.LevelGameObject;
import moagg.game.Strings;
import moagg.game.menu.AbstractMenu;
import moagg.game.menu.ControlsMenu;
import moagg.game.menu.SystemMenu;
import org.apache.log4j.Logger;

public class InGameSettingsMenu
extends AbstractMenu {
    private static Logger log = Logger.getLogger(InGameSettingsMenu.class);
    private static final int INDEX_CONTINUE = 0;
    private static final int INDEX_SYSTEM = 1;
    private static final int INDEX_CONTROLS = 2;
    private static final int INDEX_ABORT = 3;
    private static final String KEY_CONTINUE = "menu.settings.ingame.continue";
    private static final String KEY_SYSTEM = "menu.settings.ingame.system";
    private static final String KEY_CONTROLS = "menu.settings.ingame.controls";
    private static final String KEY_ABORT = "menu.settings.ingame.abort";
    private LevelGameObject level = null;

    public InGameSettingsMenu(GameEngine parent, LevelGameObject level) {
        super(parent);
        this.level = level;
    }

    public void initResources() {
        log.trace("");
        super.initResources();
        this.background = new BufferedImage(this.parent.getWidth(), this.parent.getHeight(), 1);
        Graphics2D g = this.background.createGraphics();
        this.level.render(g);
        g.dispose();
        g = this.background.createGraphics();
        RescaleOp op = new RescaleOp(0.5f, 0.0f, null);
        g.drawImage(this.background, op, 0, 0);
        g.dispose();
    }

    protected void initMenuItems() {
        this.menuItems.clear();
        this.menuItems.add(new AbstractMenu.MenuItem(100, 100, Strings.getString(KEY_CONTINUE)));
        this.menuItems.add(new AbstractMenu.MenuItem(100, 120, Strings.getString(KEY_SYSTEM)));
        this.menuItems.add(new AbstractMenu.MenuItem(100, 140, Strings.getString(KEY_CONTROLS)));
        this.menuItems.add(new AbstractMenu.MenuItem(100, 160, Strings.getString(KEY_ABORT)));
    }

    public void enter() {
        switch (this.selectedItemIndex) {
            case 0: {
                this.finish();
                break;
            }
            case 1: {
                new SystemMenu(this.parent, this.background).start();
                this.initMenuItems();
                break;
            }
            case 2: {
                new ControlsMenu(this.parent, this.background).start();
                break;
            }
            case 3: {
                this.level.finish();
                this.finish();
            }
        }
    }
}

