/*
 * Decompiled with CFR 0.152.
 */
package moagg.game.menu;

import com.golden.gamedev.GameEngine;
import java.awt.Graphics2D;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import moagg.game.Strings;
import moagg.game.menu.AbstractMenu;
import moagg.prefs.control.ControlPrefs;
import org.apache.log4j.Logger;

public class ControlsMenu
extends AbstractMenu {
    private static Logger log = Logger.getLogger(ControlsMenu.class);
    private static final int INDEX_THRUST = 0;
    private static final int INDEX_ALIGN = 1;
    private static final int INDEX_LEFT = 2;
    private static final int INDEX_RIGHT = 3;
    private static final int INDEX_SHOOT = 4;
    private static final int INDEX_SCREENSHOT = 5;
    private static final int INDEX_BACK = 6;
    private static final String KEY_THRUST = "menu.controls.thrust";
    private static final String KEY_ALIGN = "menu.controls.align";
    private static final String KEY_LEFT = "menu.controls.left";
    private static final String KEY_RIGHT = "menu.controls.right";
    private static final String KEY_SHOOT = "menu.controls.shoot";
    private static final String KEY_SCREENSHOT = "menu.controls.screenshot";
    private static final String KEY_BACK = "menu.back";
    private ControlPrefs prefs = ControlPrefs.getInstance();
    private String[] keyText = new String[6];
    private boolean selectKey = false;

    public ControlsMenu(GameEngine parent, BufferedImage background) {
        super(parent, background);
    }

    public void initResources() {
        log.trace("");
        super.initResources();
        this.keyText[0] = KeyEvent.getKeyText(this.prefs.getThrust());
        this.keyText[1] = KeyEvent.getKeyText(this.prefs.getAlign());
        this.keyText[2] = KeyEvent.getKeyText(this.prefs.getLeft());
        this.keyText[3] = KeyEvent.getKeyText(this.prefs.getRight());
        this.keyText[4] = KeyEvent.getKeyText(this.prefs.getShoot());
        this.keyText[5] = KeyEvent.getKeyText(this.prefs.getScreenShot());
    }

    protected void initMenuItems() {
        this.maxTextWidth = 0;
        this.updateMaxTextWidth(Strings.getString(KEY_THRUST));
        this.updateMaxTextWidth(Strings.getString(KEY_ALIGN));
        this.updateMaxTextWidth(Strings.getString(KEY_LEFT));
        this.updateMaxTextWidth(Strings.getString(KEY_RIGHT));
        this.updateMaxTextWidth(Strings.getString(KEY_SHOOT));
        this.updateMaxTextWidth(Strings.getString(KEY_SCREENSHOT));
        this.menuItems.clear();
        this.menuItems.add(new AbstractMenu.MenuItem(100, 100, Strings.getString(KEY_THRUST)));
        this.menuItems.add(new AbstractMenu.MenuItem(100, 120, Strings.getString(KEY_ALIGN)));
        this.menuItems.add(new AbstractMenu.MenuItem(100, 140, Strings.getString(KEY_LEFT)));
        this.menuItems.add(new AbstractMenu.MenuItem(100, 160, Strings.getString(KEY_RIGHT)));
        this.menuItems.add(new AbstractMenu.MenuItem(100, 180, Strings.getString(KEY_SHOOT)));
        this.menuItems.add(new AbstractMenu.MenuItem(100, 210, Strings.getString(KEY_SCREENSHOT)));
        this.menuItems.add(new AbstractMenu.MenuItem(100, 240, Strings.getString(KEY_BACK)));
    }

    public void update(long elapsedTime) {
        if (this.selectKey) {
            int key = this.bsInput.getKeyPressed();
            if (key != Integer.MIN_VALUE) {
                if (key != 27) {
                    switch (this.selectedItemIndex) {
                        case 0: {
                            this.prefs.setThrust(key);
                            break;
                        }
                        case 1: {
                            this.prefs.setAlign(key);
                            break;
                        }
                        case 2: {
                            this.prefs.setLeft(key);
                            break;
                        }
                        case 3: {
                            this.prefs.setRight(key);
                            break;
                        }
                        case 4: {
                            this.prefs.setShoot(key);
                            break;
                        }
                        case 5: {
                            this.prefs.setScreenShot(key);
                        }
                    }
                    this.keyText[this.selectedItemIndex] = KeyEvent.getKeyText(key);
                }
                this.selectKey = false;
            }
        } else {
            super.update(elapsedTime);
        }
    }

    public void enter() {
        switch (this.selectedItemIndex) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                this.selectKey = true;
                break;
            }
            case 6: {
                this.finish();
            }
        }
    }

    public void render(Graphics2D g) {
        super.render(g);
        for (int i = 0; i < this.keyText.length; ++i) {
            int x = 100 + this.maxTextWidth + 32;
            int y = ((AbstractMenu.MenuItem)this.menuItems.get(i)).getY();
            try {
                this.renderText(g, this.keyText[i], x, y, this.selectKey && i == this.selectedItemIndex);
                continue;
            }
            catch (RuntimeException e) {
                this.keyText[i] = this.keyText[i].replaceAll("\u00e4", "ae").replaceAll("\u00f6", "oe").replaceAll("\u00fc", "ue").replaceAll("\u00c4", "AE").replaceAll("\u00d6", "OE").replaceAll("\u00dc", "UE").replaceAll("\u00df", "ss");
                try {
                    this.renderText(g, this.keyText[i], x, y, this.selectKey && i == this.selectedItemIndex);
                    continue;
                }
                catch (RuntimeException e2) {
                    this.keyText[i] = "unknown";
                }
            }
        }
    }
}

