/*
 * Decompiled with CFR 0.152.
 */
package moagg.game.menu;

import com.golden.gamedev.GameEngine;
import com.golden.gamedev.GameObject;
import com.golden.gamedev.object.GameFont;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import moagg.artwork.font.FontFactory;
import moagg.artwork.sound.MusicClips;
import org.apache.log4j.Logger;

public abstract class AbstractMenu
extends GameObject {
    private static Logger log = Logger.getLogger(AbstractMenu.class);
    protected static final String KEY_SWITCH_PREFIX = "menu.switch.";
    private MusicClips musicClips = MusicClips.getInstance();
    protected BufferedImage background = null;
    protected List<MenuItem> menuItems = new ArrayList<MenuItem>();
    protected int selectedItemIndex = 0;
    protected GameFont font;
    protected int maxTextWidth = 0;

    protected AbstractMenu(GameEngine parent) {
        super(parent);
    }

    protected AbstractMenu(GameEngine parent, BufferedImage background) {
        super(parent);
        this.background = background;
    }

    public void initResources() {
        log.trace("");
        this.font = FontFactory.getInstance().getMenuFont();
        this.initMenuItems();
    }

    protected abstract void initMenuItems();

    protected void updateMaxTextWidth(String text) {
        int textWidth = this.font.getWidth(text);
        if (textWidth > this.maxTextWidth) {
            this.maxTextWidth = textWidth;
        }
    }

    public void render(Graphics2D g) {
        g.setColor(Color.BLACK);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.background != null) {
            g.drawImage(this.background, null, null);
        }
        MenuItem selectedMenuItem = this.menuItems.get(this.selectedItemIndex);
        for (MenuItem menuItem : this.menuItems) {
            menuItem.render(g, menuItem == selectedMenuItem);
        }
    }

    protected void renderText(Graphics2D g, String text, int x, int y, boolean highlighted) {
        if (highlighted) {
            g.setColor(Color.GRAY);
            g.fillRect(x - 1, y - 1, this.font.getWidth(text) + 2, 18);
        }
        this.font.drawString(g, text, x, y);
    }

    public void update(long elapsedTime) {
        this.musicClips.update(elapsedTime);
        if (this.keyPressed(40)) {
            if (this.selectedItemIndex < this.menuItems.size() - 1) {
                ++this.selectedItemIndex;
            }
        } else if (this.keyPressed(38)) {
            if (this.selectedItemIndex > 0) {
                --this.selectedItemIndex;
            }
        } else if (this.keyPressed(36)) {
            this.selectedItemIndex = 0;
        } else if (this.keyPressed(35)) {
            this.selectedItemIndex = this.menuItems.size() - 1;
        } else if (this.keyPressed(10)) {
            this.enter();
        } else if (this.keyPressed(27)) {
            this.finish();
        }
    }

    protected abstract void enter();

    protected class MenuItem {
        private int x;
        private int y;
        private String text;

        public MenuItem(int x, int y, String text) {
            this.x = x;
            this.y = y;
            this.text = text;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public void render(Graphics2D g, boolean selected) {
            AbstractMenu.this.renderText(g, this.text, this.x, this.y, selected);
        }
    }
}

