/*
 * Decompiled with CFR 0.152.
 */
package moagg.game.control.weapon.turret;

import moagg.artwork.object.TurretImageFactory;
import moagg.game.control.GameControl;
import moagg.game.control.weapon.ProjectileFactory;
import moagg.game.control.weapon.turret.aiming.AimingStrategy;
import moagg.game.control.weapon.turret.aiming.FixedAimingStrategy;
import moagg.game.control.weapon.turret.aiming.RandomAimingStrategy;
import moagg.game.control.weapon.turret.aiming.SmartAimingStrategy;
import moagg.game.control.weapon.turret.aiming.SweepAimingStrategy;
import moagg.model.object.ShootableObject;
import moagg.model.object.sprite.Turret;
import moagg.model.weapon.turret.AbstractBarrel;
import moagg.model.weapon.turret.aiming.AbstractAiming;
import moagg.model.weapon.turret.aiming.FixedAiming;
import moagg.model.weapon.turret.aiming.RandomAiming;
import moagg.model.weapon.turret.aiming.SmartAiming;
import moagg.model.weapon.turret.aiming.SweepAiming;
import moagg.types.math.Vector;

public abstract class AbstractProjectileFactoryImpl
implements ProjectileFactory {
    protected AimingStrategy createAiming(AbstractBarrel barrel) {
        AbstractAiming aiming = barrel.getAiming();
        if (aiming instanceof FixedAiming) {
            return new FixedAimingStrategy();
        }
        if (aiming instanceof RandomAiming) {
            return new RandomAimingStrategy();
        }
        if (aiming instanceof SweepAiming) {
            return new SweepAimingStrategy();
        }
        if (aiming instanceof SmartAiming) {
            return new SmartAimingStrategy();
        }
        return null;
    }

    protected void initProjectile(ShootableObject projectile, Turret turret, AbstractBarrel barrel, int angle, GameControl gameControl) {
        int x = (int)turret.getX();
        int y = (int)turret.getY();
        switch (turret.getOrientation()) {
            case TOP: {
                x += turret.getWidth() / 2 - projectile.getWidth() / 2;
                y += TurretImageFactory.getInstance().getTurretHeight(turret.getType());
                break;
            }
            case BOTTOM: {
                x += turret.getWidth() / 2 - projectile.getWidth() / 2;
                y += turret.getHeight() - TurretImageFactory.getInstance().getTurretHeight(turret.getType());
                y -= projectile.getHeight();
                break;
            }
            case LEFT: {
                x += TurretImageFactory.getInstance().getTurretHeight(turret.getType());
                y += turret.getHeight() / 2 - projectile.getHeight() / 2;
                break;
            }
            case RIGHT: {
                x += turret.getWidth() - TurretImageFactory.getInstance().getTurretHeight(turret.getType());
                x -= projectile.getWidth();
                y += turret.getHeight() / 2 - projectile.getHeight() / 2;
            }
        }
        projectile.setX(x);
        projectile.setY(y);
        Vector v = Vector.exp(barrel.getSpeed(), angle);
        projectile.setSpeed(v.getX(), v.getY());
    }
}

