/*
 * Decompiled with CFR 0.152.
 */
package moagg.game.control.warhead.missile;

import moagg.artwork.object.ProjectileImageFactory;
import moagg.game.control.GameControl;
import moagg.game.control.warhead.WarheadHandler;
import moagg.model.object.sprite.Missile;
import moagg.model.object.sprite.Projectile;
import moagg.model.object.sprite.Ship;
import moagg.model.warhead.Warhead;
import moagg.model.warhead.missile.StarBurstWarhead;
import moagg.types.math.Point;
import moagg.types.math.Vector;

public class StarBurstImpl
implements WarheadHandler {
    private static final double PROJECTILE_SPEED = 0.075;

    public void update(Warhead warhead, GameControl gameControl, long elapsedTime) {
        Vector centerMissile;
        Ship player = gameControl.getPlayer();
        if (player == null) {
            return;
        }
        StarBurstWarhead sbWarhead = (StarBurstWarhead)warhead;
        Missile missile = sbWarhead.getMissile();
        Vector centerPlayer = new Vector(player.getPositionRectangle().getCenter());
        if (Vector.distance(centerPlayer, centerMissile = new Vector(missile.getPositionRectangle().getCenter())) < 100.0) {
            this.createProjectiles(missile, gameControl);
            missile.setActive(false);
        }
    }

    protected void createProjectiles(Missile missile, GameControl gameControl) {
        Vector v = missile.getSpeed();
        for (int angle = 0; angle < 360; angle += 45) {
            Projectile projectile = new Projectile();
            projectile.setImage(ProjectileImageFactory.getInstance().getProjectileImage());
            Point pos = missile.getPositionRectangle().getCenter();
            pos.subX(projectile.getWidth() / 2);
            pos.subY(projectile.getHeight() / 2);
            projectile.setX(pos.getX());
            projectile.setY(pos.getY());
            Vector vp = Vector.exp(0.075, angle);
            vp.add(v);
            projectile.setSpeed(vp.getX(), vp.getY());
            projectile.setHealth(1);
            projectile.setShooter(missile.getShooter());
            gameControl.addProjectile(projectile);
        }
    }
}

