/*
 * Decompiled with CFR 0.152.
 */
package moagg.game.control.warhead.grenade;

import moagg.artwork.object.ProjectileImageFactory;
import moagg.game.control.GameControl;
import moagg.game.control.warhead.WarheadHandler;
import moagg.model.object.sprite.Grenade;
import moagg.model.object.sprite.Projectile;
import moagg.model.warhead.Warhead;
import moagg.model.warhead.grenade.StarBurstWarhead;
import moagg.types.math.Point;
import moagg.types.math.Vector;

public class StarBurstImpl
implements WarheadHandler {
    private static final double PROJECTILE_SPEED = 0.075;

    public void update(Warhead warhead, GameControl gameControl, long elapsedTime) {
        StarBurstWarhead sbWarhead = (StarBurstWarhead)warhead;
        Grenade grenade = sbWarhead.getGrenade();
        if (sbWarhead.isExploderTimerExpired()) {
            this.createProjectiles(grenade, gameControl);
            grenade.setActive(false);
        }
    }

    protected void createProjectiles(Grenade grenade, GameControl gameControl) {
        Vector v = grenade.getSpeed();
        for (int angle = 0; angle < 360; angle += 45) {
            Projectile projectile = new Projectile();
            projectile.setImage(ProjectileImageFactory.getInstance().getProjectileImage());
            Point pos = grenade.getPositionRectangle().getCenter();
            pos.subX(projectile.getWidth() / 2);
            pos.subY(projectile.getHeight() / 2);
            projectile.setX(pos.getX());
            projectile.setY(pos.getY());
            Vector vp = Vector.exp(0.075, angle);
            vp.add(v);
            projectile.setSpeed(vp.getX(), vp.getY());
            projectile.setHealth(1);
            projectile.setShooter(grenade.getShooter());
            gameControl.addProjectile(projectile);
        }
    }
}

