/*
 * Decompiled with CFR 0.152.
 */
package moagg.game.control.handler.explosion;

import com.golden.gamedev.object.Sprite;
import moagg.game.control.GameControl;
import moagg.game.control.handler.explosion.Explosion;
import moagg.model.object.DestroyableObject;
import moagg.model.object.sprite.Particle;
import moagg.types.math.Vector;
import moagg.util.RandomTool;

public class ProjectileExplosionImpl
implements Explosion {
    public static final double PARTICLE_SPEED = 0.03;
    public static final double PARTICLE_SPEED_FUZZ = 0.03;
    public static final int PARTICLE_LIFETIME = 500;
    public static final int PARTICLE_LIFETIME_FUZZ = 100;

    public void update(DestroyableObject destroyable, GameControl gameControl) {
        Sprite sprite = (Sprite)destroyable;
        int numberOfParticles = 2 * sprite.getWidth();
        for (int i = 0; i < numberOfParticles; ++i) {
            Particle particle = this.createExplosionParticle(sprite);
            gameControl.addParticle(particle);
        }
    }

    protected Particle createExplosionParticle(Sprite projectile) {
        int x = (int)projectile.getX() + projectile.getWidth() / 2;
        int y = (int)projectile.getY() + projectile.getHeight() / 2;
        int r = projectile.getHeight() / 2;
        Vector offset = Vector.exp((double)r * Math.random(), Math.random() * 360.0);
        Particle particle = new Particle();
        particle.setGradient(false);
        particle.setX((double)x + offset.getX());
        particle.setY((double)y + offset.getY());
        particle.setSpeed(Vector.exp(RandomTool.getRandom(0.03, 0.03), Math.random() * 360.0));
        particle.setLifeTime(RandomTool.getRandom(500, 100));
        return particle;
    }
}

