/*
 * Decompiled with CFR 0.152.
 */
package moagg.game.control.handler;

import java.util.HashMap;
import moagg.game.control.GameControl;
import moagg.game.control.GameControlImpl;
import moagg.game.control.handler.GameControlHandler;
import moagg.model.level.Map;
import moagg.model.object.ActivatableObject;
import moagg.model.object.MoaggGameObject;
import moagg.model.object.sprite.Blackhole;
import moagg.model.object.sprite.Magnet;
import moagg.types.math.Matrix;
import moagg.types.math.Rectangle;
import moagg.types.math.Vector;
import moagg.util.math.AngleUtil;
import moagg.util.math.SinusTable;
import org.apache.log4j.Logger;

public class GravityUpdateHandler
implements GameControlHandler {
    private static Logger log = Logger.getLogger(GravityUpdateHandler.class);
    private java.util.Map<ActivatableObject, Boolean> activationState = new HashMap<ActivatableObject, Boolean>();

    public void update(GameControlImpl gameControl, long elapsedTime) {
        for (MoaggGameObject object : gameControl.getObjects()) {
            if (object instanceof Magnet) {
                this.updateMagnet((Magnet)object, gameControl, elapsedTime);
                continue;
            }
            if (!(object instanceof Blackhole)) continue;
            this.updateBlackHole((Blackhole)object, gameControl, elapsedTime);
        }
    }

    protected void updateMagnet(Magnet magnet, GameControlImpl gameControl, long elapsedTime) {
        Boolean activationTransition = this.getActivationTransition(magnet);
        if (activationTransition != null) {
            log.trace("Magnet " + magnet.getID() + " changed activation state to " + activationTransition);
            Rectangle r = this.getGravityRectangle(magnet);
            Vector gravity = this.getGravityVector(magnet);
            if (!activationTransition.booleanValue()) {
                gravity.mul(-1.0);
            }
            gameControl.addGravity(r, gravity);
        }
    }

    protected void updateBlackHole(Blackhole blackHole, GameControl gameControl, long elapsedTime) {
        Boolean activationTransition = this.getActivationTransition(blackHole);
        if (activationTransition != null) {
            log.trace("Black hole " + blackHole.getID() + " changed activation state to " + activationTransition);
            int tileOffset = blackHole.getWidth() / 2 / 16;
            int tileX = (int)blackHole.getX() / 16 + tileOffset;
            int tileY = (int)blackHole.getY() / 16 + tileOffset;
            Matrix gx = gameControl.getLevel().getPlayGround().getGravityX();
            Matrix gy = gameControl.getLevel().getPlayGround().getGravityY();
            Map map = gameControl.getLevel().getPlayGround().getMap();
            for (int y = 0; y < map.getHeight(); ++y) {
                for (int x = 0; x < map.getWidth(); ++x) {
                    int rx = x - tileX;
                    int ry = y - tileY;
                    int r2 = rx * rx + ry * ry;
                    double a = AngleUtil.getAngle(rx, ry);
                    if (r2 == 0) continue;
                    gx.add(x, y, (double)(-blackHole.getGravity()) * SinusTable.sin(a) * 8.0E-7 / (double)r2);
                    gy.add(x, y, (double)(-blackHole.getGravity()) * SinusTable.cos(a) * 8.0E-7 / (double)r2);
                }
            }
        }
    }

    protected Boolean getActivationTransition(ActivatableObject activatable) {
        if (!this.activationState.containsKey(activatable)) {
            this.activationState.put(activatable, false);
        }
        if (this.activationState.get(activatable).booleanValue() == activatable.isActivated()) {
            return null;
        }
        this.activationState.put(activatable, activatable.isActivated());
        return activatable.isActivated();
    }

    protected Rectangle getGravityRectangle(Magnet magnet) {
        switch (magnet.getOrientation()) {
            case TOP: {
                return new Rectangle((int)magnet.getX() / 16, (int)magnet.getY() / 16 + 1, magnet.getWidth() / 16, magnet.getDistance());
            }
            case BOTTOM: {
                return new Rectangle((int)magnet.getX() / 16, (int)magnet.getY() / 16 - 1 - magnet.getDistance(), magnet.getWidth() / 16, magnet.getDistance());
            }
            case LEFT: {
                return new Rectangle((int)magnet.getX() / 16 + 1, (int)magnet.getY() / 16, magnet.getDistance(), magnet.getHeight() / 16);
            }
            case RIGHT: {
                return new Rectangle((int)magnet.getX() / 16 - 1 - magnet.getDistance(), (int)magnet.getY() / 16, magnet.getDistance(), magnet.getHeight() / 16);
            }
        }
        return null;
    }

    protected Vector getGravityVector(Magnet magnet) {
        double strength = (double)magnet.getStrength() * 8.0E-7;
        switch (magnet.getOrientation()) {
            case TOP: {
                return new Vector(0.0, -strength);
            }
            case BOTTOM: {
                return new Vector(0.0, strength);
            }
            case LEFT: {
                return new Vector(-strength, 0.0);
            }
            case RIGHT: {
                return new Vector(strength, 0.0);
            }
        }
        return null;
    }
}

