/*
 * Decompiled with CFR 0.152.
 */
package moagg.game.control.handler;

import com.golden.gamedev.object.Timer;
import moagg.game.control.GameControlImpl;
import moagg.game.control.handler.GameControlHandler;
import moagg.model.object.sprite.Ship;
import moagg.prefs.ghost.Ghost;
import moagg.prefs.ghost.GhostFrame;

public class GhostRecordHandler
implements GameControlHandler {
    private static int FRAME_DELAY = 50;
    private boolean firstUpdate = true;
    private Timer timer = new Timer(FRAME_DELAY);

    public void update(GameControlImpl gameControl, long elapsedTime) {
        Ghost data = gameControl.getGhostRecord();
        if (this.firstUpdate) {
            data.setFrameDelay(FRAME_DELAY);
            this.firstUpdate = false;
        }
        if (this.timer.action(elapsedTime)) {
            Ship player = gameControl.getPlayer();
            GhostFrame state = new GhostFrame();
            state.setActive(player.isActive());
            state.setX((short)player.getX());
            state.setY((short)player.getY());
            state.setAngle((short)player.getAngle());
            state.setThrust(player.isThrust());
            state.setVX((float)player.getHorizontalSpeed());
            state.setVY((float)player.getVerticalSpeed());
            data.add(state);
        }
    }
}

