/*
 * Decompiled with CFR 0.152.
 */
package moagg.game.control.handler;

import com.golden.gamedev.object.Sprite;
import java.io.IOException;
import java.util.Properties;
import moagg.game.control.GameControlImpl;
import moagg.game.control.handler.GameControlHandler;
import moagg.game.control.handler.explosion.Explosion;
import moagg.model.object.DestroyableObject;
import moagg.model.object.MoaggGameObject;
import org.apache.log4j.Logger;

public class ExplosionHandler
implements GameControlHandler {
    private static Logger log = Logger.getLogger(ExplosionHandler.class);
    private static final String EXPLOSION_HANDLERS = "/properties/explosionHandlers.properties";
    private Properties explosionHandlers = new Properties();

    public ExplosionHandler() {
        try {
            this.explosionHandlers.load(this.getClass().getResourceAsStream(EXPLOSION_HANDLERS));
        }
        catch (IOException e) {
            throw new RuntimeException("Error loading '/properties/explosionHandlers.properties'", e);
        }
    }

    public void update(GameControlImpl gameControl, long elapsedTime) {
        for (Sprite player : gameControl.getPlayersSpriteGroup().getSprites()) {
            if (!(player instanceof DestroyableObject)) continue;
            this.handleObject((DestroyableObject)player, gameControl, elapsedTime);
        }
        for (Sprite ghost : gameControl.getGhostsSpriteGroup().getSprites()) {
            if (!(ghost instanceof DestroyableObject)) continue;
            this.handleObject((DestroyableObject)ghost, gameControl, elapsedTime);
        }
        for (MoaggGameObject object : gameControl.getObjects()) {
            if (!(object instanceof DestroyableObject)) continue;
            this.handleObject((DestroyableObject)object, gameControl, elapsedTime);
        }
        for (Sprite projectile : gameControl.getProjectilesSpriteGroup().getSprites()) {
            if (projectile == null) continue;
            this.handleObject((DestroyableObject)projectile, gameControl, elapsedTime);
        }
    }

    protected void handleObject(DestroyableObject destroyable, GameControlImpl gameControl, long elapsedTime) {
        if (!((Sprite)destroyable).isActive() || destroyable.getHealth() > 0) {
            return;
        }
        try {
            log.trace("Object " + destroyable.getID() + " is going to explode.");
            Class<?> explosionClass = Class.forName(this.explosionHandlers.getProperty(destroyable.getClass().getName()));
            Explosion explosion = (Explosion)explosionClass.newInstance();
            explosion.update(destroyable, gameControl);
            gameControl.callScript("onDestroyed", destroyable);
            ((Sprite)destroyable).setActive(false);
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating Explosion for '" + destroyable.getClass().getName() + "'", e);
        }
    }
}

