/*
 * Decompiled with CFR 0.152.
 */
package moagg.game.control.handler;

import moagg.game.control.GameControlImpl;
import moagg.game.control.handler.GameControlHandler;
import moagg.model.object.MoaggGameObject;
import moagg.model.object.sprite.Fountain;
import moagg.model.object.sprite.Particle;
import moagg.types.math.Vector;

public class CreateFountainParticlesHandler
implements GameControlHandler {
    public void update(GameControlImpl gameControl, long elapsedTime) {
        for (MoaggGameObject object : gameControl.getObjects()) {
            Fountain fountain;
            Particle particle;
            if (!(object instanceof Fountain) || (particle = this.createFountainParticle(fountain = (Fountain)object)) == null) continue;
            gameControl.addParticle(particle);
        }
    }

    protected Particle createFountainParticle(Fountain fountain) {
        if (!fountain.isActivated()) {
            return null;
        }
        Particle particle = new Particle();
        particle.setCollision(true);
        particle.setLifeTime(fountain.getParticleLifeTime());
        int x = (int)fountain.getX() + 6;
        int y = (int)fountain.getY() + 6;
        int w = 4;
        int h = 4;
        particle.setX(x + (int)(Math.random() * (double)w));
        particle.setY(y + (int)(Math.random() * (double)h));
        Vector speed = this.getInitialParticleSpeed(fountain);
        Vector scatter = new Vector((double)fountain.getParticleScatter() * (Math.random() - 0.5), (double)fountain.getParticleScatter() * (Math.random() - 0.5));
        particle.setSpeed(Vector.mul(Vector.add(speed, scatter), 0.002));
        return particle;
    }

    protected Vector getInitialParticleSpeed(Fountain fountain) {
        int particleSpeed = fountain.getParticleSpeed();
        switch (fountain.getOrientation()) {
            case TOP: {
                return new Vector(0.0, particleSpeed);
            }
            case BOTTOM: {
                return new Vector(0.0, -particleSpeed);
            }
            case LEFT: {
                return new Vector(particleSpeed, 0.0);
            }
            case RIGHT: {
                return new Vector(-particleSpeed, 0.0);
            }
        }
        return null;
    }
}

