/*
 * Decompiled with CFR 0.152.
 */
package moagg.game.control.collision;

import moagg.game.control.GameControl;
import moagg.game.control.collision.AbstractCollisionHandler;
import moagg.model.object.DestroyableObject;
import moagg.model.object.MoaggGameObject;
import moagg.model.object.ShootableObject;
import moagg.model.object.sprite.Crate;
import moagg.model.object.sprite.Particle;
import moagg.model.object.sprite.Ship;
import moagg.model.weapon.SingleFireStrategy;
import moagg.model.weapon.Weapon;
import moagg.model.weapon.WeaponDecorator;
import moagg.model.weapon.ship.BackDecorator;
import moagg.model.weapon.ship.DoubleDecorator;
import moagg.model.weapon.ship.Laser;
import moagg.model.weapon.ship.TripleDecorator;
import org.apache.log4j.Logger;

public class ShipCollisionHandler
extends AbstractCollisionHandler {
    private static Logger log = Logger.getLogger(ShipCollisionHandler.class);

    public ShipCollisionHandler(GameControl gameControl) {
        super(gameControl);
    }

    public void onCollidedWithPlayfield(Ship ship) {
        log.trace("Collision between ship and playfield detected.");
        ship.setHealth(0);
    }

    public void onCollided(Ship ship, MoaggGameObject object) {
        if (object instanceof Crate) {
            this.onCollided(ship, (Crate)object);
        } else if (object instanceof Particle) {
            Particle particle = (Particle)((Object)object);
            particle.setActive(false);
        } else if (object instanceof ShootableObject) {
            ShootableObject shootable = (ShootableObject)object;
            log.trace("Collision between ship and projectile (shooted from object " + shootable.getShooter().getID() + ") detected.");
            shootable.setHealth(0);
            ship.setHealth(ship.getHealth() - shootable.getDamage());
        } else {
            log.trace("Collision between ship and object " + object.getID() + " detected.");
            ship.setHealth(0);
            if (object instanceof DestroyableObject) {
                ((DestroyableObject)object).setHealth(0);
            }
        }
    }

    protected void onCollided(Ship ship, Crate crate) {
        if (!ship.isLanded()) {
            return;
        }
        switch (crate.getType()) {
            case SMALL: 
            case MEDIUM: 
            case BIG: {
                if (!ship.hasCapacityForCrate(crate)) break;
                log.trace("Ship picking up crate " + crate.getID());
                ship.pickupCrate(crate);
                this.gameControl.callScript("onCratePickup", crate);
                break;
            }
            case BONUS: {
                this.gameControl.getScore().incPoints();
                crate.setVisible(false);
                this.gameControl.callScript("onCratePickup", crate);
                break;
            }
            case FUEL: {
                long newFuel = ship.getFuel() + (long)crate.getFuelPercentage() * ship.getFuelCapacity() / 100L;
                if (newFuel > ship.getFuelCapacity()) {
                    newFuel = ship.getFuelCapacity();
                }
                ship.setFuel(newFuel);
                crate.setVisible(false);
                this.gameControl.callScript("onCratePickup", crate);
                break;
            }
            case LASER: {
                this.updateShipWeapon(ship, new Laser(new SingleFireStrategy()));
                crate.setVisible(false);
                this.gameControl.callScript("onCratePickup", crate);
                break;
            }
            case DOUBLE: {
                this.updateShipWeaponDecorator(ship, new DoubleDecorator());
                crate.setVisible(false);
                this.gameControl.callScript("onCratePickup", crate);
                break;
            }
            case TRIPLE: {
                this.updateShipWeaponDecorator(ship, new TripleDecorator());
                crate.setVisible(false);
                this.gameControl.callScript("onCratePickup", crate);
                break;
            }
            case BACK: {
                this.updateShipWeaponDecorator(ship, new BackDecorator());
                crate.setVisible(false);
                this.gameControl.callScript("onCratePickup", crate);
            }
        }
    }

    protected void updateShipWeapon(Ship ship, Weapon weapon) {
        Weapon currentWeapon = ship.getWeapon();
        if (currentWeapon instanceof WeaponDecorator) {
            ((WeaponDecorator)currentWeapon).setWeapon(weapon);
        } else {
            ship.setWeapon(weapon);
        }
    }

    protected void updateShipWeaponDecorator(Ship ship, WeaponDecorator weaponDecorator) {
        Weapon currentWeapon = ship.getWeapon();
        if (currentWeapon instanceof WeaponDecorator) {
            weaponDecorator.setWeapon(((WeaponDecorator)currentWeapon).getWeapon());
            ship.setWeapon(weaponDecorator);
        } else {
            weaponDecorator.setWeapon(currentWeapon);
            ship.setWeapon(weaponDecorator);
        }
    }
}

