/*
 * Decompiled with CFR 0.152.
 */
package moagg.game.control.collision;

import moagg.game.control.GameControl;
import moagg.game.control.collision.AbstractCollisionHandler;
import moagg.model.object.DestroyableObject;
import moagg.model.object.MoaggGameObject;
import moagg.model.object.ShootableObject;
import moagg.model.object.sprite.Switch;
import org.apache.log4j.Logger;

public class ProjectileCollisionHandler
extends AbstractCollisionHandler {
    private static Logger log = Logger.getLogger(ProjectileCollisionHandler.class);

    public ProjectileCollisionHandler(GameControl gameControl) {
        super(gameControl);
    }

    public void onCollidedWithPlayfield(ShootableObject shootable) {
        log.trace("");
        shootable.setHealth(0);
    }

    public void onCollided(ShootableObject shootable, MoaggGameObject object) {
        shootable.setHealth(0);
        if (object instanceof DestroyableObject) {
            log.trace("");
            DestroyableObject destroyable = (DestroyableObject)object;
            if (destroyable.getHealth() <= 0) {
                return;
            }
            destroyable.setHealth(destroyable.getHealth() - shootable.getDamage());
            if (destroyable.getHealth() <= 0 && shootable.getShooter() == this.gameControl.getPlayer()) {
                this.gameControl.getScore().addPoints(destroyable.getScorePoints());
            }
        }
        if (object instanceof Switch) {
            log.trace("Switch " + object.getID() + " was hit by projectile.");
            this.gameControl.callScript("onSwitch", object);
        }
    }

    public void onCollided(ShootableObject shootable1, ShootableObject shootable2) {
        if (shootable1.isDestroyableByProjectile() || shootable2.isDestroyableByProjectile()) {
            log.trace("");
            shootable1.setHealth(shootable1.getHealth() - shootable2.getDamage());
            shootable2.setHealth(shootable2.getHealth() - shootable1.getDamage());
        }
    }
}

