/*
 * Decompiled with CFR 0.152.
 */
package moagg.game.control;

import com.golden.gamedev.object.Sprite;
import com.golden.gamedev.object.SpriteGroup;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import moagg.game.LevelGameObject;
import moagg.game.SystemProperties;
import moagg.game.control.GameControl;
import moagg.game.control.handler.CreateFountainParticlesHandler;
import moagg.game.control.handler.CreateThrustParticlesHandler;
import moagg.game.control.handler.ExplosionHandler;
import moagg.game.control.handler.GameControlHandler;
import moagg.game.control.handler.GhostPlaybackHandler;
import moagg.game.control.handler.GhostRecordHandler;
import moagg.game.control.handler.GravityUpdateHandler;
import moagg.game.control.handler.LandingHandler;
import moagg.game.control.handler.MissileControlHandler;
import moagg.game.control.handler.PhysicHandler;
import moagg.game.control.handler.ShootHandler;
import moagg.game.control.handler.UpdateAngleHandler;
import moagg.game.control.handler.WarheadHandler;
import moagg.game.control.objective.Objective;
import moagg.game.control.objective.Objectives;
import moagg.game.level.LevelStrings;
import moagg.model.level.Level;
import moagg.model.object.MoaggGameObject;
import moagg.model.object.ShootableObject;
import moagg.model.object.sprite.Crate;
import moagg.model.object.sprite.Particle;
import moagg.model.object.sprite.Platform;
import moagg.model.object.sprite.Ship;
import moagg.prefs.ghost.Ghost;
import moagg.prefs.score.Score;
import moagg.types.math.Rectangle;
import moagg.types.math.Vector;
import moagg.util.MatrixTool;
import org.apache.log4j.Logger;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GameControlImpl
implements GameControl {
    private static Logger log = Logger.getLogger(GameControlImpl.class);
    private static Logger jsLog = Logger.getLogger("SCRIPTING");
    private static final String COMMON_JS = "common.js";
    private LevelGameObject levelGame = null;
    private Level level = null;
    private Ship player = null;
    private boolean finished = false;
    private List<GameControlHandler> gameControlHandlers = new LinkedList<GameControlHandler>();
    private List<Crate> cratesToUnload = new LinkedList<Crate>();
    private Objectives objectives = null;
    private String statusText = null;
    private Context context = null;
    private Scriptable scope = null;
    private String popUpText = null;

    public GameControlImpl(LevelGameObject levelGame) {
        this.levelGame = levelGame;
        this.level = levelGame.getLevel();
        this.player = levelGame.getPlayer();
        this.popUpText = LevelStrings.getDescription(this.level.getMission(), this.level.getLevel());
        this.gameControlHandlers.add(new GravityUpdateHandler());
        this.gameControlHandlers.add(new MissileControlHandler());
        this.gameControlHandlers.add(new UpdateAngleHandler());
        this.gameControlHandlers.add(new PhysicHandler());
        this.gameControlHandlers.add(new CreateThrustParticlesHandler());
        this.gameControlHandlers.add(new CreateFountainParticlesHandler());
        this.gameControlHandlers.add(new LandingHandler());
        this.gameControlHandlers.add(new ShootHandler());
        this.gameControlHandlers.add(new WarheadHandler());
        this.gameControlHandlers.add(new ExplosionHandler());
        if (levelGame.getGhostRecord() != null) {
            this.gameControlHandlers.add(new GhostRecordHandler());
        }
        if (levelGame.getGhostPlayback() != null) {
            this.gameControlHandlers.add(new GhostPlaybackHandler());
        }
        this.objectives = new Objectives();
        this.initScripting();
    }

    protected void initScripting() {
        this.context = Context.enter();
        this.scope = this.context.initStandardObjects();
        this.scope.put("gameControl", this.scope, Context.javaToJS(this, this.scope));
        this.scope.put("log", this.scope, Context.javaToJS(jsLog, this.scope));
        try {
            BufferedReader r = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(SystemProperties.getInstance().getMissionsPath() + "/" + COMMON_JS)));
            this.context.evaluateReader(this.scope, r, COMMON_JS, 1, null);
        }
        catch (IOException e) {
            throw new RuntimeException("Error executing script 'common.js'.", e);
        }
        this.context.evaluateString(this.scope, this.level.getGameControlScript(), "", 1, null);
        this.callScript("init", new Object[0]);
    }

    public void cleanup() {
        Context.exit();
    }

    @Override
    public Level getLevel() {
        return this.level;
    }

    @Override
    public void update(long elapsedTime) {
        this.getScore().addElapsedTime(elapsedTime);
        for (GameControlHandler handler : this.gameControlHandlers) {
            handler.update(this, elapsedTime);
        }
        this.callScript("update", elapsedTime);
        this.objectives.update(this);
    }

    @Override
    public void addParticle(Particle particle) {
        this.levelGame.getParticlesSpriteGroup().add((Sprite)particle);
    }

    @Override
    public void addProjectile(ShootableObject shootable) {
        this.levelGame.getProjectilesSpriteGroup().add((Sprite)shootable);
    }

    @Override
    public void addGravity(Rectangle r, Vector gravity) {
        log.trace("r = " + r + ", gravity = " + gravity);
        this.level.getPlayGround().getGravityX().add(r, gravity.getX());
        this.level.getPlayGround().getGravityY().add(r, gravity.getY());
    }

    @Override
    public void addStreamSpeed(Rectangle r, Vector stream) {
        log.trace("r = " + r + ", stream = " + stream);
        this.level.getPlayGround().getStreamX().add(r, stream.getX());
        this.level.getPlayGround().getStreamY().add(r, stream.getY());
    }

    @Override
    public void addFriction(Rectangle r, double friction) {
        log.trace("r = " + r + ", friction = " + friction);
        this.level.getPlayGround().getFriction().add(r, friction);
    }

    @Override
    public Vector getGravityFor(MoaggGameObject object) {
        return new Vector(MatrixTool.getAverageTileValue(this.level.getPlayGround().getGravityX(), object, 0.0), MatrixTool.getAverageTileValue(this.level.getPlayGround().getGravityY(), object, 0.0));
    }

    @Override
    public Vector getStreamSpeedFor(MoaggGameObject object) {
        return new Vector(MatrixTool.getAverageTileValue(this.level.getPlayGround().getStreamX(), object, 0.0), MatrixTool.getAverageTileValue(this.level.getPlayGround().getStreamY(), object, 0.0));
    }

    @Override
    public double getFrictionFor(MoaggGameObject object) {
        return MatrixTool.getAverageTileValue(this.level.getPlayGround().getFriction(), object, 0.0);
    }

    @Override
    public Ship getPlayer() {
        return this.player;
    }

    public Ship getGhost() {
        return this.levelGame.getGhost();
    }

    public SpriteGroup getProjectilesSpriteGroup() {
        return this.levelGame.getProjectilesSpriteGroup();
    }

    public SpriteGroup getGhostsSpriteGroup() {
        return this.levelGame.getGhostsSpriteGroup();
    }

    public SpriteGroup getPlayersSpriteGroup() {
        return this.levelGame.getPlayersSpriteGroup();
    }

    public List<Platform> getPlatforms() {
        return this.level.getPlayGround().getPlatforms();
    }

    public List<MoaggGameObject> getObjects() {
        return this.level.getPlayGround().getObjects();
    }

    public boolean hasCratesToUnload() {
        return !this.cratesToUnload.isEmpty();
    }

    public Crate getCrateToUnload() {
        Iterator<Crate> iter = this.cratesToUnload.iterator();
        Crate crate = iter.next();
        iter.remove();
        return crate;
    }

    public void addCrateToUnload(Crate crate) {
        this.levelGame.getObjectsSpriteGroup().remove((Sprite)crate);
        this.cratesToUnload.add(crate);
    }

    public Objectives getObjectives() {
        return this.objectives;
    }

    @Override
    public void addObjective(Objective objective) {
        this.objectives.add(objective);
    }

    @Override
    public Platform getStartPlatform() {
        return this.level.getStartPlatform();
    }

    @Override
    public MoaggGameObject getObjectById(int id) {
        return this.level.getPlayGround().getObjectById(id);
    }

    @Override
    public void setStatusText(String text) {
        this.statusText = text;
    }

    public String getStatusText() {
        return this.statusText;
    }

    public void clearPopUpText() {
        this.popUpText = null;
    }

    @Override
    public void setPopUpText(String key) {
        this.popUpText = LevelStrings.getString(this.level.getMission(), this.level.getLevel(), key);
    }

    @Override
    public void setPopUpText(String key, Object ... args) {
        this.popUpText = LevelStrings.getString(this.level.getMission(), this.level.getLevel(), key, args);
    }

    public String getPopUpText() {
        return this.popUpText;
    }

    @Override
    public Score getScore() {
        return this.levelGame.getScore();
    }

    public Ghost getGhostPlayback() {
        return this.levelGame.getGhostPlayback();
    }

    public Ghost getGhostRecord() {
        return this.levelGame.getGhostRecord();
    }

    @Override
    public boolean isBackgroundBetween(MoaggGameObject o1, MoaggGameObject o2) {
        Vector c1 = new Vector(o1.getPositionRectangle().getCenter());
        c1.mul(0.0625);
        Vector c2 = new Vector(o2.getPositionRectangle().getCenter());
        c2.mul(0.0625);
        return this.level.getPlayGround().getMap().isBackgroundBetween((int)c1.getX(), (int)c1.getY(), (int)c2.getX(), (int)c2.getY());
    }

    @Override
    public void finish() {
        this.finished = true;
    }

    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public void callScript(String name, Object ... args) {
        Object f = this.scope.get(name, this.scope);
        if (f instanceof Function) {
            ((Function)f).call(this.context, this.scope, this.scope, args);
        }
    }

    static {
        jsLog.setAdditivity(false);
    }
}

