/*
 * Decompiled with CFR 0.152.
 */
package moagg.game;

import com.golden.gamedev.GameEngine;
import com.golden.gamedev.GameObject;
import com.golden.gamedev.object.GameFont;
import com.golden.gamedev.util.ImageUtil;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import moagg.artwork.font.FontFactory;
import moagg.artwork.sound.MusicClips;
import moagg.game.InitializerThread;
import moagg.game.ReleaseProperties;
import moagg.game.Strings;
import moagg.game.menu.MainMenu;
import org.apache.log4j.Logger;

public class SplashScreen
extends GameObject {
    private static Logger log = Logger.getLogger(SplashScreen.class);
    private static final String KEY_INITIALIZING = "splashscreen.initializing";
    private BufferedImage background = null;
    private GameFont font = null;
    private InitializerThread initializer = new InitializerThread(this);
    private int percentage = 0;

    public SplashScreen(GameEngine parent) {
        super(parent);
    }

    public void initResources() {
        log.trace("");
        MusicClips.getInstance().init(this);
        MusicClips.getInstance().playTitle();
        this.bsGraphics.setWindowIcon((Image)this.getImage("/gfx/gui/icon.png"));
        this.bsGraphics.setWindowTitle(ReleaseProperties.getInstance().getDescription());
        BufferedImage image = this.getImage("/gfx/gui/background.png");
        this.background = ImageUtil.createImage((int)this.getWidth(), (int)this.getHeight());
        Graphics2D g = this.background.createGraphics();
        g.drawImage(image, 0, 0, this.background.getWidth(), this.background.getHeight(), 0, 0, image.getWidth(), image.getHeight(), null);
        g.dispose();
        FontFactory.getInstance().init(this);
        this.font = FontFactory.getInstance().getMenuFont();
        this.initializer.start();
    }

    public void update(long elapsedTime) {
        this.percentage = this.initializer.getPercentage();
        if (this.percentage == 100) {
            try {
                this.initializer.join();
            }
            catch (InterruptedException e) {
                log.warn("Error joining initializer thread.", e);
            }
            if (this.initializer.getException() != null) {
                throw new RuntimeException("Error initializing game", this.initializer.getException());
            }
            new MainMenu(this.parent, this.background).start();
            this.finish();
        }
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void render(Graphics2D g) {
        g.setColor(Color.BLACK);
        g.fillRect(0, 0, this.parent.getWidth(), this.parent.getHeight());
        g.drawImage(this.background, null, null);
        int margin = 100;
        int width = this.getWidth() - 2 * margin;
        g.setColor(Color.LIGHT_GRAY);
        g.drawRect(margin, this.getHeight() / 2 + 50, width, 20);
        g.fill3DRect(margin, this.getHeight() / 2 + 50, width * this.percentage / 100, 20, true);
        this.font.drawString(g, Strings.getString(KEY_INITIALIZING), this.getWidth() / 2 - this.font.getWidth(Strings.getString(KEY_INITIALIZING)) / 2, this.getHeight() / 2 - 50);
    }
}

