/*
 * Decompiled with CFR 0.152.
 */
package moagg.game;

import com.golden.gamedev.GameObject;
import moagg.artwork.object.BarrierImageFactory;
import moagg.artwork.object.BlackHoleImageFactory;
import moagg.artwork.object.CrateImageFactory;
import moagg.artwork.object.FountainImageFactory;
import moagg.artwork.object.GrinderImageFactory;
import moagg.artwork.object.MagnetImageFactory;
import moagg.artwork.object.MissileImageFactory;
import moagg.artwork.object.PlatformImageFactory;
import moagg.artwork.object.ProjectileImageFactory;
import moagg.artwork.object.SamBatteryImageFactory;
import moagg.artwork.object.ShipImageFactory;
import moagg.artwork.object.StatusBarImageFactory;
import moagg.artwork.object.SwitchImageFactory;
import moagg.artwork.object.TankImageFactory;
import moagg.artwork.object.ThornImageFactory;
import moagg.artwork.object.TurretImageFactory;
import moagg.artwork.sound.GuiSoundClips;
import moagg.artwork.tiles.TileImageFactory;
import moagg.level.MissionReader;
import moagg.prefs.control.ControlPrefs;
import moagg.prefs.handicap.HandicapPrefs;
import moagg.prefs.player.PlayerPrefs;
import moagg.prefs.score.ScorePrefs;
import moagg.prefs.system.SystemPrefs;
import org.apache.log4j.Logger;
import org.mozilla.javascript.Context;

public class InitializerThread
extends Thread {
    private static Logger log = Logger.getLogger(InitializerThread.class);
    private GameObject game = null;
    private int steps = 0;
    private int totalSteps = 21;
    private Exception exception = null;

    public InitializerThread(GameObject game) {
        this.game = game;
    }

    public void run() {
        try {
            log.debug("Initializing resources.");
            MissionReader.getInstance().init();
            ++this.steps;
            TileImageFactory.getInstance().init(this.game);
            ++this.steps;
            BarrierImageFactory.getInstance().init(this.game);
            ++this.steps;
            BlackHoleImageFactory.getInstance().init(this.game);
            ++this.steps;
            CrateImageFactory.getInstance().init(this.game);
            ++this.steps;
            GrinderImageFactory.getInstance().init(this.game);
            ++this.steps;
            MagnetImageFactory.getInstance().init(this.game);
            ++this.steps;
            MissileImageFactory.getInstance().init(this.game);
            ++this.steps;
            FountainImageFactory.getInstance().init(this.game);
            ++this.steps;
            PlatformImageFactory.getInstance().init(this.game);
            ++this.steps;
            ProjectileImageFactory.getInstance().init(this.game);
            ++this.steps;
            SamBatteryImageFactory.getInstance().init(this.game);
            ++this.steps;
            SwitchImageFactory.getInstance().init(this.game);
            ++this.steps;
            TankImageFactory.getInstance().init(this.game);
            ++this.steps;
            ThornImageFactory.getInstance().init(this.game);
            ++this.steps;
            TurretImageFactory.getInstance().init(this.game);
            ++this.steps;
            ShipImageFactory.getInstance().init(this.game);
            ++this.steps;
            GuiSoundClips.getInstance().init(this.game);
            ++this.steps;
            StatusBarImageFactory.getInstance().init(this.game);
            ++this.steps;
            SystemPrefs.getInstance();
            PlayerPrefs.getInstance();
            ControlPrefs.getInstance();
            HandicapPrefs.getInstance();
            ScorePrefs.getInstance();
            ++this.steps;
            Context context = Context.enter();
            context.initStandardObjects();
            Context.exit();
            ++this.steps;
            log.debug("Initializing resources finished.");
        }
        catch (Exception e) {
            this.exception = e;
            this.steps = this.totalSteps;
        }
    }

    public int getPercentage() {
        return 100 * this.steps / this.totalSteps;
    }

    public Exception getException() {
        return this.exception;
    }
}

