/*
 * Decompiled with CFR 0.152.
 */
package moagg.artwork.tiles;

import com.golden.gamedev.GameObject;
import com.golden.gamedev.util.ImageUtil;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RescaleOp;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import moagg.game.SystemProperties;
import moagg.util.ImageTool;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.log4j.Logger;

public class TileImageFactory {
    private static Logger log = Logger.getLogger(TileImageFactory.class);
    private static final String CATEGORIES_INDEX = "categories.idx";
    private static final String TILES_INDEX = "tiles.idx";
    private static final int DEFAULT_ALPHA = 255;
    private static final int DEFAULT_BRIGHTNESS = 128;
    private static TileImageFactory instance = new TileImageFactory();
    private Map<String, Integer> categoryMap = new HashMap<String, Integer>();
    private Map<Key, Entry> map = new HashMap<Key, Entry>();

    public static TileImageFactory getInstance() {
        return instance;
    }

    public void init(GameObject loader) throws IOException {
        log.trace("Loading tile categories.");
        BufferedReader reader = new BufferedReader(new InputStreamReader(loader.bsLoader.getBaseIO().getStream(SystemProperties.getInstance().getTilesPath() + "/" + CATEGORIES_INDEX)));
        while (reader.ready()) {
            String line = reader.readLine().trim();
            if (line.length() == 0 || line.startsWith("#")) continue;
            StringTokenizer st = new StringTokenizer(line);
            int category = Integer.parseInt(st.nextToken(), 16) & 0xFF;
            String dir = st.nextToken();
            this.categoryMap.put(dir, category);
            this.initCategory(category, dir, loader);
        }
        log.trace("Finished.");
    }

    protected void initCategory(int categoryId, String dir, GameObject loader) throws IOException {
        log.trace("Loading tile category '" + dir + "'.");
        BufferedReader reader = new BufferedReader(new InputStreamReader(loader.bsLoader.getBaseIO().getStream(SystemProperties.getInstance().getTilesPath() + "/" + dir + "/" + TILES_INDEX)));
        while (reader.ready()) {
            String line = reader.readLine().trim();
            if (line.length() == 0 || line.startsWith("#")) continue;
            StringTokenizer st = new StringTokenizer(line);
            int index = Integer.parseInt(st.nextToken(), 16) & 0xFF;
            String name = st.nextToken();
            this.initTile(categoryId, index, dir, name, loader);
        }
    }

    protected void initTile(int categoryId, int tileId, String dir, String name, GameObject loader) {
        Key key = new Key(categoryId, tileId);
        BufferedImage tile = ImageUtil.getImage((URL)loader.bsIO.getURL(SystemProperties.getInstance().getTilesPath() + "/" + dir + "/" + name), (int)3);
        Entry entry = new Entry(tile, ImageTool.getRGB(tile));
        this.map.put(key, entry);
    }

    protected void initTile(int categoryId, int tileId, int alpha, int brightness) {
        Key key = new Key(categoryId, tileId);
        Entry entry = this.map.get(key);
        if (entry == null) {
            return;
        }
        BufferedImage orig = entry.getImage();
        BufferedImage tile = ImageUtil.createImage((int)orig.getWidth(), (int)orig.getHeight(), (int)3);
        float scale = 1.0f;
        float offset = 0.0f;
        if (brightness < 128) {
            scale = (float)brightness / 128.0f;
            offset = 0.0f;
        } else if (brightness > 128) {
            scale = (float)(255 - brightness) / 128.0f;
            offset = (float)(brightness - 128) / 128.0f;
        } else {
            scale = 1.0f;
            offset = 0.0f;
        }
        float[] scales = new float[]{scale, scale, scale, (float)alpha / 255.0f};
        float[] offsets = new float[]{offset, offset, offset, 0.0f};
        RescaleOp op = new RescaleOp(scales, offsets, null);
        Graphics2D g = tile.createGraphics();
        g.drawImage(orig, op, 0, 0);
        g.dispose();
        key = new Key(categoryId, tileId, alpha, brightness);
        entry = new Entry(tile, entry.getRGB());
        this.map.put(key, entry);
    }

    public int getCategoryId(String category) {
        Integer categoryId = this.categoryMap.get(category);
        return categoryId != null ? categoryId : -1;
    }

    public BufferedImage getTile(int categoryId, int tileId) {
        return this.getTile(categoryId, tileId, 255, 128);
    }

    public BufferedImage getTile(int categoryId, int tileId, int alpha, int brightness) {
        Key key = new Key(categoryId, tileId, alpha, brightness);
        if (!(this.map.containsKey(key) || alpha == 255 && brightness == 128)) {
            this.initTile(categoryId, tileId, alpha, brightness);
        }
        return this.map.get(key).getImage();
    }

    public int[] getRGB(int categoryId, int tileId) {
        Key key = new Key(categoryId, tileId);
        return this.map.get(key).getRGB();
    }

    private static class Entry {
        private BufferedImage image;
        private int[] rgb;

        public Entry(BufferedImage image, int[] rgb) {
            this.image = image;
            this.rgb = rgb;
        }

        public BufferedImage getImage() {
            return this.image;
        }

        public int[] getRGB() {
            return this.rgb;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Key
    implements Comparable<Key> {
        private int categoryId;
        private int tileId;
        private int alpha;
        private int brightness;

        public Key(int categoryId, int tileId) {
            this.categoryId = categoryId;
            this.tileId = tileId;
            this.alpha = 255;
            this.brightness = 128;
        }

        public Key(int categoryId, int tileId, int alpha, int brightness) {
            this.categoryId = categoryId;
            this.tileId = tileId;
            this.alpha = alpha;
            this.brightness = brightness;
        }

        public int hashCode() {
            return new HashCodeBuilder().append(this.categoryId).append(this.tileId).append(this.alpha).append(this.brightness).toHashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Key)) {
                return false;
            }
            Key other = (Key)obj;
            return new EqualsBuilder().append(this.categoryId, other.categoryId).append(this.tileId, other.tileId).append(this.alpha, other.alpha).append(this.brightness, other.brightness).isEquals();
        }

        @Override
        public int compareTo(Key o) {
            return new CompareToBuilder().append(this.categoryId, o.categoryId).append(this.tileId, o.tileId).append(this.alpha, o.alpha).append(this.brightness, o.brightness).toComparison();
        }
    }
}

