/*
 * Decompiled with CFR 0.152.
 */
package moagg.artwork.object;

import com.golden.gamedev.GameObject;
import com.golden.gamedev.util.ImageUtil;
import java.awt.image.BufferedImage;
import moagg.artwork.object.AbstractImageFactory;
import moagg.types.Orientation;
import org.apache.log4j.Logger;

public class FountainImageFactory
extends AbstractImageFactory {
    private static Logger log = Logger.getLogger(FountainImageFactory.class);
    private static final String PATH = "/gfx/object/decoration/";
    private static FountainImageFactory instance = new FountainImageFactory();
    private BufferedImage[] fountains = null;
    private BufferedImage particle = null;

    public static FountainImageFactory getInstance() {
        return instance;
    }

    public void init(GameObject loader) {
        log.trace("Loading images.");
        this.fountains = new BufferedImage[Orientation.values().length];
        BufferedImage img = loader.getImage("/gfx/object/decoration/particlefountain.png");
        for (int i = 0; i < Orientation.values().length; ++i) {
            this.fountains[i] = ImageUtil.rotate((BufferedImage)img, (int)(i * 90));
        }
        this.particle = new BufferedImage(1, 1, 2);
        log.trace("Finished.");
    }

    public BufferedImage getImage(Orientation orientation) {
        log.trace("Getting image for a " + (Object)((Object)orientation) + " particle fountain.");
        return this.fountains[orientation.ordinal()];
    }

    public BufferedImage getParticle() {
        return this.particle;
    }
}

