/*
 * Decompiled with CFR 0.152.
 */
package moagg.artwork.object;

import com.golden.gamedev.GameObject;
import java.awt.image.BufferedImage;
import moagg.artwork.object.AbstractImageFactory;
import moagg.types.CrateType;
import moagg.util.ArgumentChecker;
import org.apache.log4j.Logger;

public class CrateImageFactory
extends AbstractImageFactory {
    private static Logger log = Logger.getLogger(CrateImageFactory.class);
    private static final String PATH = "/gfx/object/crate/";
    private static CrateImageFactory instance = new CrateImageFactory();
    private BufferedImage[] crates = null;

    public static CrateImageFactory getInstance() {
        return instance;
    }

    public void init(GameObject loader) {
        log.trace("Loading images.");
        CrateType[] values = CrateType.values();
        this.crates = new BufferedImage[values.length];
        for (CrateType crateType : values) {
            this.crates[crateType.ordinal()] = loader.getImage(PATH + crateType.getName() + ".png");
        }
        log.trace("Finished.");
    }

    public BufferedImage getImage(CrateType crateType) {
        ArgumentChecker.checkNotNull((Object)crateType);
        log.trace("Getting image for a " + (Object)((Object)crateType) + " crate.");
        return this.crates[crateType.ordinal()];
    }

    public int getCrateWidth(CrateType crateType) {
        return this.crates[crateType.ordinal()].getWidth();
    }

    public int getCrateHeight(CrateType crateType) {
        return this.crates[crateType.ordinal()].getHeight();
    }
}

