/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.helpgui.util;

import java.io.IOException;
import java.net.URL;

public class BrowserControl {
    private static final String URLTOKEN = "%URLTOKEN%";
    private static final int WIN_ID = 1;
    private static final String WIN_PREFIX = "Windows";
    private static final String[] WIN_CMDLINE = new String[]{"rundll32", "url.dll,FileProtocolHandler", "%URLTOKEN%"};
    private static final int MAC_ID = 2;
    private static final String MAC_PREFIX = "Mac";
    private static final String[] MAC_CMDLINE = new String[]{"open", "%URLTOKEN%"};
    private static final int OTHER_ID = -1;
    private static final String[][] OTHER_CMDLINES = new String[][]{{"firefox", "-remote", "openURL(%URLTOKEN%,new-tab)"}, {"mozilla", "-remote", "openURL(%URLTOKEN%,new-window)"}, {"htmlview", "%URLTOKEN%"}, {"netscape", "-remote", "openURL(%URLTOKEN%)"}};
    private static final String[][] OTHER_FALLBACKS = new String[][]{{"firefox", "%URLTOKEN%"}, {"mozilla", "%URLTOKEN%"}, null, {"netscape", "%URLTOKEN%"}};

    public static boolean displayURL(String url) {
        try {
            Class<?> serManClass = Class.forName("javax.jnlp.ServiceManager");
            Class<?> basSerClass = Class.forName("javax.jnlp.BasicService");
            Class[] stringParam = new Class[]{String.class};
            Class[] urlParam = new Class[]{URL.class};
            Object basicService = serManClass.getMethod("lookup", stringParam).invoke(serManClass, "javax.jnlp.BasicService");
            basSerClass.getMethod("showDocument", urlParam).invoke(basicService, new URL(url));
            return true;
        }
        catch (Exception e) {
            Object cmd = null;
            switch (BrowserControl.getPlatform()) {
                case 1: {
                    return BrowserControl.runCmdLine(BrowserControl.replaceToken(WIN_CMDLINE, URLTOKEN, url));
                }
                case 2: {
                    return BrowserControl.runCmdLine(BrowserControl.replaceToken(MAC_CMDLINE, URLTOKEN, url));
                }
            }
            for (int i = 0; i < OTHER_CMDLINES.length; ++i) {
                if (!BrowserControl.runCmdLine(BrowserControl.replaceToken(OTHER_CMDLINES[i], URLTOKEN, url), BrowserControl.replaceToken(OTHER_FALLBACKS[i], URLTOKEN, url))) continue;
                return true;
            }
            return false;
        }
    }

    private static int getPlatform() {
        String os = System.getProperty("os.name");
        if (os != null && os.startsWith(WIN_PREFIX)) {
            return 1;
        }
        if (os != null && os.startsWith(MAC_PREFIX)) {
            return 2;
        }
        return -1;
    }

    private static String connectStringArray(String[] a) {
        if (a == null) {
            return null;
        }
        String s = "";
        for (int i = 0; i < a.length; ++i) {
            if (i > 0) {
                s = s + " ";
            }
            s = s + a[i];
        }
        return s;
    }

    private static String[] replaceToken(String[] target, String token, String replacement) {
        if (null == target) {
            return null;
        }
        String[] result = new String[target.length];
        for (int i = 0; i < target.length; ++i) {
            result[i] = target[i].replaceAll(token, replacement);
        }
        return result;
    }

    private static boolean runCmdLine(String[] cmdLine) {
        return BrowserControl.runCmdLine(cmdLine, null);
    }

    private static boolean runCmdLine(String[] cmdLine, String[] fallBackCmdLine) {
        try {
            int exitCode;
            Process p = Runtime.getRuntime().exec(cmdLine);
            if (null != fallBackCmdLine && (exitCode = p.waitFor()) != 0) {
                Runtime.getRuntime().exec(fallBackCmdLine);
            }
            System.out.println();
            return true;
        }
        catch (InterruptedException e) {
            System.out.println("Caught: " + e);
        }
        catch (IOException e) {
            System.out.println("Caught: " + e);
        }
        return false;
    }
}

