/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.raytracer;

import artofillusion.ArtOfIllusion;
import artofillusion.Camera;
import artofillusion.PluginRegistry;
import artofillusion.RenderListener;
import artofillusion.Renderer;
import artofillusion.RenderingMesh;
import artofillusion.RenderingTriangle;
import artofillusion.Scene;
import artofillusion.image.ComplexImage;
import artofillusion.material.MaterialMapping;
import artofillusion.material.MaterialSpec;
import artofillusion.material.UniformMaterialMapping;
import artofillusion.math.BoundingBox;
import artofillusion.math.FastMath;
import artofillusion.math.Mat4;
import artofillusion.math.RGBColor;
import artofillusion.math.Vec3;
import artofillusion.object.Cube;
import artofillusion.object.Cylinder;
import artofillusion.object.DirectionalLight;
import artofillusion.object.ImplicitObject;
import artofillusion.object.Light;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectCollection;
import artofillusion.object.ObjectInfo;
import artofillusion.object.ObjectWrapper;
import artofillusion.object.PointLight;
import artofillusion.object.SceneCamera;
import artofillusion.object.Sphere;
import artofillusion.object.SpotLight;
import artofillusion.object.TriangleMesh;
import artofillusion.raytracer.CompoundPhotonSource;
import artofillusion.raytracer.CubePhotonSource;
import artofillusion.raytracer.CylinderPhotonSource;
import artofillusion.raytracer.DirectionalPhotonSource;
import artofillusion.raytracer.DisplacedTrianglePhotonSource;
import artofillusion.raytracer.EllipsoidPhotonSource;
import artofillusion.raytracer.EnvironmentPhotonSource;
import artofillusion.raytracer.OctreeNode;
import artofillusion.raytracer.PhotonMap;
import artofillusion.raytracer.PhotonSource;
import artofillusion.raytracer.PhotonSourceFactory;
import artofillusion.raytracer.PixelInfo;
import artofillusion.raytracer.PointPhotonSource;
import artofillusion.raytracer.RTCube;
import artofillusion.raytracer.RTCylinder;
import artofillusion.raytracer.RTDirectionalLight;
import artofillusion.raytracer.RTDisplacedTriangle;
import artofillusion.raytracer.RTEllipsoid;
import artofillusion.raytracer.RTImplicitObject;
import artofillusion.raytracer.RTLight;
import artofillusion.raytracer.RTObject;
import artofillusion.raytracer.RTObjectFactory;
import artofillusion.raytracer.RTSphere;
import artofillusion.raytracer.RTSphericalLight;
import artofillusion.raytracer.RTTriangle;
import artofillusion.raytracer.RTTriangleLowMemory;
import artofillusion.raytracer.Ray;
import artofillusion.raytracer.RaytracerContext;
import artofillusion.raytracer.SpotlightPhotonSource;
import artofillusion.raytracer.SurfaceIntersection;
import artofillusion.raytracer.TrianglePhotonSource;
import artofillusion.texture.ParameterValue;
import artofillusion.texture.Texture;
import artofillusion.texture.TextureMapping;
import artofillusion.texture.TextureSpec;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.PanelDialog;
import artofillusion.ui.Translate;
import artofillusion.ui.UIUtilities;
import artofillusion.ui.ValueField;
import artofillusion.util.ThreadManager;
import buoy.event.ValueChangedEvent;
import buoy.event.WidgetEvent;
import buoy.widget.BCheckBox;
import buoy.widget.BComboBox;
import buoy.widget.BLabel;
import buoy.widget.ColumnContainer;
import buoy.widget.FormContainer;
import buoy.widget.LayoutInfo;
import buoy.widget.RowContainer;
import buoy.widget.Widget;
import buoy.widget.WindowWidget;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.image.MemoryImageSource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Raytracer
implements Renderer,
Runnable {
    protected RTObject[] sceneObject;
    protected RTLight[] light;
    protected OctreeNode rootNode;
    protected OctreeNode cameraNode;
    protected OctreeNode[] lightNode;
    protected ColumnContainer configPanel;
    protected BCheckBox depthBox;
    protected BCheckBox glossBox;
    protected BCheckBox shadowBox;
    protected BCheckBox causticsBox;
    protected BCheckBox transparentBox;
    protected BCheckBox adaptiveBox;
    protected BCheckBox rouletteBox;
    protected BCheckBox reducedMemoryBox;
    protected BComboBox aliasChoice;
    protected BComboBox maxRaysChoice;
    protected BComboBox minRaysChoice;
    protected BComboBox giModeChoice;
    protected BComboBox scatterModeChoice;
    protected BComboBox diffuseRaysChoice;
    protected BComboBox glossRaysChoice;
    protected BComboBox shadowRaysChoice;
    protected ValueField errorField;
    protected ValueField rayDepthField;
    protected ValueField rayCutoffField;
    protected ValueField smoothField;
    protected ValueField stepSizeField;
    protected ValueField extraGIField;
    protected ValueField extraGIEnvField;
    protected ValueField globalPhotonsField;
    protected ValueField globalNeighborPhotonsField;
    protected ValueField causticsPhotonsField;
    protected ValueField causticsNeighborPhotonsField;
    protected ValueField volumePhotonsField;
    protected ValueField volumeNeighborPhotonsField;
    protected int[] pixel;
    protected int width;
    protected int height;
    protected int rtWidth;
    protected int rtHeight;
    protected int maxRayDepth = 8;
    protected int minRays = 4;
    protected int maxRays = 16;
    protected int diffuseRays;
    protected int glossRays;
    protected int shadowRays;
    protected int antialiasLevel;
    protected MemoryImageSource imageSource;
    protected Scene theScene;
    protected Camera theCamera;
    protected SceneCamera sceneCamera;
    protected RenderListener listener;
    protected Image img;
    protected volatile Thread renderThread;
    protected RGBColor ambColor;
    protected RGBColor envColor;
    protected RGBColor fogColor;
    protected double[] envParamValue;
    protected TextureMapping envMapping;
    protected int envMode;
    protected double time;
    protected double fogDist;
    protected double surfaceError = 0.02;
    protected double stepSize = 1.0;
    protected double smoothing = 1.0;
    protected double smoothScale;
    protected double extraGISmoothing = 10.0;
    protected double extraGIEnvSmoothing = 100.0;
    protected int giMode = 0;
    protected int scatterMode = 0;
    protected int globalPhotons = 10000;
    protected int globalNeighborPhotons = 200;
    protected int causticsPhotons = 10000;
    protected int causticsNeighborPhotons = 100;
    protected int volumePhotons = 10000;
    protected int volumeNeighborPhotons = 100;
    protected float minRayIntensity = 0.01f;
    protected float[][] floatImage;
    protected float[] depthImage;
    protected float[] errorImage;
    protected float[] objectImage;
    protected boolean fog;
    protected boolean depth = false;
    protected boolean gloss = false;
    protected boolean penumbra = false;
    protected boolean caustics = false;
    protected boolean transparentBackground = false;
    protected boolean adaptive = true;
    protected boolean roulette = false;
    protected boolean reducedMemory = false;
    protected boolean needCopyToUI = true;
    protected boolean isPreview;
    protected PhotonMap globalMap;
    protected PhotonMap causticsMap;
    protected PhotonMap volumeMap;
    protected BoundingBox materialBounds;
    protected ThreadLocal threadContext = new ThreadLocal(){

        protected Object initialValue() {
            return new RaytracerContext(Raytracer.this);
        }
    };
    public static final double TOL = 1.0E-12;
    public static final int GI_NONE = 0;
    public static final int GI_AMBIENT_OCCLUSION = 1;
    public static final int GI_MONTE_CARLO = 2;
    public static final int GI_PHOTON = 3;
    public static final int GI_HYBRID = 4;
    public static final int SCATTER_SINGLE = 0;
    public static final int SCATTER_PHOTONS = 1;
    public static final int SCATTER_BOTH = 2;
    public static final float COLOR_THRESH_ABS = 0.0078125f;
    public static final float COLOR_THRESH_REL = 0.03125f;
    public static final int[] distrib1 = new int[]{0, 3, 1, 2, 1, 2, 0, 3, 2, 0, 3, 1, 3, 1, 2, 0};
    public static final int[] distrib2 = new int[]{0, 1, 2, 3, 3, 0, 1, 2, 1, 2, 3, 0, 0, 1, 2, 3};

    public String getName() {
        return "Raytracer";
    }

    public synchronized void renderScene(Scene theScene, Camera theCamera, RenderListener rl, SceneCamera sceneCamera) {
        if (this.renderThread != null && this.renderThread.isAlive()) {
            Thread oldRenderThread = this.renderThread;
            this.renderThread = null;
            try {
                oldRenderThread.join();
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
        }
        Dimension dim = theCamera.getSize();
        this.listener = rl;
        this.theScene = theScene;
        this.theCamera = theCamera.duplicate();
        if (sceneCamera == null) {
            sceneCamera = new SceneCamera();
            sceneCamera.setDepthOfField(0.0);
            sceneCamera.setFocalDistance(theCamera.getDistToScreen());
        } else {
            sceneCamera = sceneCamera.duplicate();
        }
        this.sceneCamera = sceneCamera;
        this.time = theScene.getTime();
        this.width = dim.width;
        this.height = dim.height;
        this.renderThread = new Thread((Runnable)this, "Raytracer main thread");
        this.renderThread.setPriority(5);
        this.renderThread.start();
    }

    public synchronized void cancelRendering(Scene sc) {
        Thread t = this.renderThread;
        if (this.theScene != sc) {
            return;
        }
        this.renderThread = null;
        if (t == null) {
            return;
        }
        try {
            while (t.isAlive()) {
                Thread.sleep(100L);
            }
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        RenderListener rl = this.listener;
        this.listener = null;
        if (rl != null) {
            rl.renderingCanceled();
        }
        this.finish();
    }

    public Widget getConfigPanel() {
        if (this.configPanel == null) {
            this.configPanel = new ColumnContainer();
            FormContainer choicesPanel = new FormContainer(2, 4);
            this.configPanel.add((Widget)choicesPanel);
            LayoutInfo leftLayout = new LayoutInfo(LayoutInfo.EAST, LayoutInfo.NONE, new Insets(0, 0, 0, 5), null);
            LayoutInfo rightLayout = new LayoutInfo(LayoutInfo.WEST, LayoutInfo.NONE, null, null);
            choicesPanel.add((Widget)Translate.label((String)"surfaceAccuracy"), 0, 0, leftLayout);
            choicesPanel.add((Widget)new BLabel(Translate.text((String)"Antialiasing") + ":"), 0, 1, leftLayout);
            choicesPanel.add((Widget)Translate.label((String)"minRaysPixel"), 0, 2, leftLayout);
            choicesPanel.add((Widget)Translate.label((String)"maxRaysPixel"), 0, 3, leftLayout);
            this.errorField = new ValueField(this.surfaceError, 3, 6);
            choicesPanel.add((Widget)this.errorField, 1, 0, rightLayout);
            this.aliasChoice = new BComboBox((Object[])new String[]{Translate.text((String)"none"), Translate.text((String)"Medium"), Translate.text((String)"Maximum")});
            choicesPanel.add((Widget)this.aliasChoice, 1, 1, rightLayout);
            this.minRaysChoice = new BComboBox();
            choicesPanel.add((Widget)this.minRaysChoice, 1, 2, rightLayout);
            this.maxRaysChoice = new BComboBox();
            choicesPanel.add((Widget)this.maxRaysChoice, 1, 3, rightLayout);
            for (int i = 4; i <= 1024; i *= 2) {
                this.minRaysChoice.add((Object)Integer.toString(i));
                this.maxRaysChoice.add((Object)Integer.toString(i));
            }
            ColumnContainer boxes = new ColumnContainer();
            this.configPanel.add((Widget)boxes);
            boxes.setDefaultLayout(new LayoutInfo(LayoutInfo.WEST, LayoutInfo.NONE, null, null));
            this.depthBox = new BCheckBox(Translate.text((String)"depthOfField"), this.depth);
            boxes.add((Widget)this.depthBox);
            this.glossBox = new BCheckBox(Translate.text((String)"glossTranslucency"), this.gloss);
            boxes.add((Widget)this.glossBox);
            LayoutInfo indent = new LayoutInfo(LayoutInfo.EAST, LayoutInfo.NONE, new Insets(0, 30, 0, 0), null);
            RowContainer row = new RowContainer();
            boxes.add((Widget)row);
            row.add((Widget)Translate.label((String)"raysToSample"), indent);
            this.glossRaysChoice = new BComboBox();
            row.add((Widget)this.glossRaysChoice);
            this.shadowBox = new BCheckBox(Translate.text((String)"softShadows"), this.penumbra);
            boxes.add((Widget)this.shadowBox);
            row = new RowContainer();
            boxes.add((Widget)row);
            row.add((Widget)Translate.label((String)"raysToSample"), indent);
            this.shadowRaysChoice = new BComboBox();
            row.add((Widget)this.shadowRaysChoice);
            this.glossRaysChoice.add((Object)"1");
            this.shadowRaysChoice.add((Object)"1");
            for (int i = 4; i <= 64; i *= 2) {
                this.glossRaysChoice.add((Object)Integer.toString(i));
                this.shadowRaysChoice.add((Object)Integer.toString(i));
            }
            this.glossBox.addEventLink(ValueChangedEvent.class, new Object(){

                void processEvent() {
                    UIUtilities.setEnabled((Widget)Raytracer.this.glossRaysChoice.getParent(), (Raytracer.this.aliasChoice.getSelectedIndex() > 0 && Raytracer.this.glossBox.getState() ? 1 : 0) != 0);
                }
            });
            this.shadowBox.addEventLink(ValueChangedEvent.class, new Object(){

                void processEvent() {
                    UIUtilities.setEnabled((Widget)Raytracer.this.shadowRaysChoice.getParent(), (Raytracer.this.aliasChoice.getSelectedIndex() > 0 && Raytracer.this.shadowBox.getState() ? 1 : 0) != 0);
                }
            });
            RowContainer buttons = new RowContainer();
            this.configPanel.add((Widget)buttons);
            buttons.add((Widget)Translate.button((String)"illumination", (Object)this, (String)"showIlluminationWindow"));
            this.giModeChoice = new BComboBox((Object[])new String[]{Translate.text((String)"none"), Translate.text((String)"ambientOcclusion"), Translate.text((String)"monteCarlo"), Translate.text((String)"photonMappingDirect"), Translate.text((String)"photonMappingFinalGather")});
            this.scatterModeChoice = new BComboBox((Object[])new String[]{Translate.text((String)"singleScattering"), Translate.text((String)"photonMapping"), Translate.text((String)"Both")});
            this.diffuseRaysChoice = new BComboBox();
            this.diffuseRaysChoice.add((Object)"1");
            for (int i = 4; i <= 64; i *= 2) {
                this.diffuseRaysChoice.add((Object)Integer.toString(i));
            }
            this.globalPhotonsField = new ValueField((float)this.globalPhotons, 7, 7);
            this.globalNeighborPhotonsField = new ValueField((float)this.globalNeighborPhotons, 7, 4);
            this.causticsPhotonsField = new ValueField((float)this.causticsPhotons, 7, 7);
            this.causticsNeighborPhotonsField = new ValueField((float)this.causticsNeighborPhotons, 7, 4);
            this.volumePhotonsField = new ValueField((float)this.volumePhotons, 7, 7);
            this.volumeNeighborPhotonsField = new ValueField((float)this.volumeNeighborPhotons, 7, 4);
            this.causticsBox = new BCheckBox(Translate.text((String)"useCausticsMap"), this.caustics);
            buttons.add((Widget)Translate.button((String)"output", (Object)this, (String)"showOutputOptionsWindow"));
            this.transparentBox = new BCheckBox(Translate.text((String)"transparentBackground"), this.transparentBackground);
            buttons.add((Widget)Translate.button((String)"advanced", (Object)this, (String)"showAdvancedOptionsWindow"));
            this.rayDepthField = new ValueField((float)this.maxRayDepth, 7);
            this.rayCutoffField = new ValueField(this.minRayIntensity, 1);
            this.smoothField = new ValueField(this.smoothing, 1);
            this.extraGIField = new ValueField(this.extraGISmoothing, 3);
            this.extraGIEnvField = new ValueField(this.extraGIEnvSmoothing, 3);
            this.stepSizeField = new ValueField(this.stepSize, 3);
            this.adaptiveBox = new BCheckBox(Translate.text((String)"reduceAccuracyForDistant"), this.adaptive);
            this.rouletteBox = new BCheckBox(Translate.text((String)"russianRoulette"), this.roulette);
            this.reducedMemoryBox = new BCheckBox(Translate.text((String)"useLessMemory"), this.reducedMemory);
            Object raysListener = new Object(){

                void processEvent(WidgetEvent ev) {
                    boolean multi = Raytracer.this.aliasChoice.getSelectedIndex() > 0;
                    Raytracer.this.depthBox.setEnabled(multi);
                    Raytracer.this.glossBox.setEnabled(multi);
                    Raytracer.this.shadowBox.setEnabled(multi);
                    Raytracer.this.minRaysChoice.setEnabled(multi);
                    Raytracer.this.maxRaysChoice.setEnabled(multi);
                    UIUtilities.setEnabled((Widget)Raytracer.this.glossRaysChoice.getParent(), (multi && Raytracer.this.glossBox.getState() ? 1 : 0) != 0);
                    UIUtilities.setEnabled((Widget)Raytracer.this.shadowRaysChoice.getParent(), (multi && Raytracer.this.shadowBox.getState() ? 1 : 0) != 0);
                    if (Raytracer.this.minRaysChoice.getSelectedIndex() > Raytracer.this.maxRaysChoice.getSelectedIndex()) {
                        if (ev.getWidget() == Raytracer.this.maxRaysChoice) {
                            Raytracer.this.minRaysChoice.setSelectedIndex(Raytracer.this.maxRaysChoice.getSelectedIndex());
                        } else {
                            Raytracer.this.maxRaysChoice.setSelectedIndex(Raytracer.this.minRaysChoice.getSelectedIndex());
                        }
                    }
                }
            };
            this.aliasChoice.addEventLink(ValueChangedEvent.class, raysListener);
            this.minRaysChoice.addEventLink(ValueChangedEvent.class, raysListener);
            this.maxRaysChoice.addEventLink(ValueChangedEvent.class, raysListener);
            this.aliasChoice.dispatchEvent((Object)new ValueChangedEvent((Widget)this.aliasChoice));
            Object illumListener = new Object(){

                void processEvent() {
                    int mode = Raytracer.this.giModeChoice.getSelectedIndex();
                    UIUtilities.setEnabled((Widget)Raytracer.this.diffuseRaysChoice.getParent(), (mode == 2 || mode == 4 || mode == 1 ? 1 : 0) != 0);
                    UIUtilities.setEnabled((Widget)Raytracer.this.globalPhotonsField.getParent(), (mode == 3 || mode == 4 ? 1 : 0) != 0);
                    UIUtilities.setEnabled((Widget)Raytracer.this.causticsPhotonsField.getParent(), (boolean)Raytracer.this.causticsBox.getState());
                    UIUtilities.setEnabled((Widget)Raytracer.this.volumePhotonsField.getParent(), (Raytracer.this.scatterModeChoice.getSelectedIndex() > 0 ? 1 : 0) != 0);
                }
            };
            this.giModeChoice.addEventLink(ValueChangedEvent.class, illumListener);
            this.causticsBox.addEventLink(ValueChangedEvent.class, illumListener);
            this.scatterModeChoice.addEventLink(ValueChangedEvent.class, illumListener);
        }
        if (this.needCopyToUI) {
            this.copyConfigurationToUI();
        }
        return this.configPanel;
    }

    protected void showAdvancedOptionsWindow(WidgetEvent ev) {
        FormContainer content = new FormContainer(2, 10);
        content.setColumnWeight(0, 0.0);
        LayoutInfo leftLayout = new LayoutInfo(LayoutInfo.EAST, LayoutInfo.NONE, new Insets(0, 0, 0, 5), null);
        LayoutInfo rightLayout = new LayoutInfo(LayoutInfo.WEST, LayoutInfo.HORIZONTAL, null, null);
        content.add((Widget)Translate.label((String)"maxRayTreeDepth"), 0, 0, leftLayout);
        content.add((Widget)Translate.label((String)"minRayIntensity"), 0, 1, leftLayout);
        content.add((Widget)Translate.label((String)"matStepSize"), 0, 3, leftLayout);
        content.add((Widget)Translate.label((String)"texSmoothing"), 0, 4, leftLayout);
        content.add((Widget)this.rayDepthField, 1, 0, rightLayout);
        content.add((Widget)this.rayCutoffField, 1, 1, rightLayout);
        content.add((Widget)this.stepSizeField, 1, 3, rightLayout);
        content.add((Widget)this.smoothField, 1, 4, rightLayout);
        content.add((Widget)Translate.label((String)"extraGISmoothing"), 0, 5, 2, 1, rightLayout);
        RowContainer row = new RowContainer();
        content.add((Widget)row, 0, 6, 2, 1);
        row.add((Widget)new BLabel(Translate.text((String)"Textures") + ":"));
        row.add((Widget)this.extraGIField);
        row.add((Widget)new BLabel(Translate.text((String)"environment") + ":"));
        row.add((Widget)this.extraGIEnvField);
        content.add((Widget)this.adaptiveBox, 0, 7, 2, 1, rightLayout);
        content.add((Widget)this.reducedMemoryBox, 0, 8, 2, 1, rightLayout);
        content.add((Widget)this.rouletteBox, 0, 9, 2, 1, rightLayout);
        this.maxRayDepth = (int)this.rayDepthField.getValue();
        this.minRayIntensity = (float)this.rayCutoffField.getValue();
        this.stepSize = this.stepSizeField.getValue();
        this.smoothing = this.smoothField.getValue();
        this.extraGISmoothing = this.extraGIField.getValue();
        this.extraGIEnvSmoothing = this.extraGIEnvField.getValue();
        this.adaptive = this.adaptiveBox.getState();
        this.roulette = this.rouletteBox.getState();
        WindowWidget parent = UIUtilities.findWindow((Widget)ev.getWidget());
        PanelDialog dlg = new PanelDialog(parent, Translate.text((String)"advancedOptions"), (Widget)content);
        if (!dlg.clickedOk()) {
            this.rayDepthField.setValue((double)this.maxRayDepth);
            this.rayCutoffField.setValue((double)this.minRayIntensity);
            this.stepSizeField.setValue(this.stepSize);
            this.smoothField.setValue(this.smoothing);
            this.extraGIField.setValue(this.extraGISmoothing);
            this.extraGIEnvField.setValue(this.extraGIEnvSmoothing);
            this.adaptiveBox.setState(this.adaptive);
            this.rouletteBox.setState(this.roulette);
            this.reducedMemoryBox.setState(this.reducedMemory);
        }
    }

    protected void showIlluminationWindow(WidgetEvent ev) {
        ColumnContainer content = new ColumnContainer();
        LayoutInfo indent0 = new LayoutInfo(LayoutInfo.WEST, LayoutInfo.NONE, null, null);
        LayoutInfo indent1 = new LayoutInfo(LayoutInfo.WEST, LayoutInfo.NONE, new Insets(0, 20, 0, 0), null);
        RowContainer row = new RowContainer();
        content.add((Widget)row, indent0);
        row.add((Widget)Translate.label((String)"globalIllumination"));
        row.add((Widget)this.giModeChoice);
        row = new RowContainer();
        content.add((Widget)row, indent1);
        row.add((Widget)Translate.label((String)"raysToSampleEnvironment"));
        row.add((Widget)this.diffuseRaysChoice);
        row = new RowContainer();
        content.add((Widget)row, indent1);
        row.add((Widget)Translate.label((String)"totalPhotons"));
        row.add((Widget)this.globalPhotonsField);
        row.add((Widget)Translate.label((String)"numToEstimateLight"));
        row.add((Widget)this.globalNeighborPhotonsField);
        content.add((Widget)this.causticsBox, indent0);
        row = new RowContainer();
        content.add((Widget)row, indent1);
        row.add((Widget)Translate.label((String)"totalPhotons"));
        row.add((Widget)this.causticsPhotonsField);
        row.add((Widget)Translate.label((String)"numToEstimateLight"));
        row.add((Widget)this.causticsNeighborPhotonsField);
        row = new RowContainer();
        content.add((Widget)row, indent0);
        row.add((Widget)Translate.label((String)"materialScattering"));
        row.add((Widget)this.scatterModeChoice);
        row = new RowContainer();
        content.add((Widget)row, indent1);
        row.add((Widget)Translate.label((String)"totalPhotons"));
        row.add((Widget)this.volumePhotonsField);
        row.add((Widget)Translate.label((String)"numToEstimateLight"));
        row.add((Widget)this.volumeNeighborPhotonsField);
        this.causticsBox.dispatchEvent((Object)new ValueChangedEvent((Widget)this.causticsBox));
        this.giMode = this.giModeChoice.getSelectedIndex();
        this.diffuseRays = Integer.parseInt((String)this.diffuseRaysChoice.getSelectedValue());
        this.globalPhotons = (int)this.globalPhotonsField.getValue();
        this.globalNeighborPhotons = (int)this.globalNeighborPhotonsField.getValue();
        this.caustics = this.causticsBox.getState();
        this.causticsPhotons = (int)this.causticsPhotonsField.getValue();
        this.causticsNeighborPhotons = (int)this.causticsNeighborPhotonsField.getValue();
        this.scatterMode = this.scatterModeChoice.getSelectedIndex();
        this.volumePhotons = (int)this.volumePhotonsField.getValue();
        this.volumeNeighborPhotons = (int)this.volumeNeighborPhotonsField.getValue();
        WindowWidget parent = UIUtilities.findWindow((Widget)ev.getWidget());
        PanelDialog dlg = new PanelDialog(parent, Translate.text((String)"illuminationOptions"), (Widget)content);
        if (!dlg.clickedOk()) {
            this.giModeChoice.setSelectedIndex(this.giMode);
            this.diffuseRaysChoice.setSelectedValue((Object)Integer.toString(this.diffuseRays));
            this.globalPhotonsField.setValue((double)this.globalPhotons);
            this.globalNeighborPhotonsField.setValue((double)this.globalNeighborPhotons);
            this.causticsBox.setState(this.caustics);
            this.causticsPhotonsField.setValue((double)this.causticsPhotons);
            this.causticsNeighborPhotonsField.setValue((double)this.causticsNeighborPhotons);
            this.scatterModeChoice.setSelectedIndex(this.scatterMode);
            this.volumePhotonsField.setValue((double)this.volumePhotons);
            this.volumeNeighborPhotonsField.setValue((double)this.volumeNeighborPhotons);
        }
    }

    protected void showOutputOptionsWindow(WidgetEvent ev) {
        this.transparentBackground = this.transparentBox.getState();
        WindowWidget parent = UIUtilities.findWindow((Widget)ev.getWidget());
        ComponentsDialog dlg = new ComponentsDialog(parent, Translate.text((String)"outputOptions"), new Widget[]{this.transparentBox}, new String[]{""});
        if (!dlg.clickedOk()) {
            this.transparentBox.setState(this.transparentBackground);
        }
    }

    protected void copyConfigurationToUI() {
        this.needCopyToUI = false;
        if (this.configPanel == null) {
            this.getConfigPanel();
        }
        this.rayDepthField.setValue((double)this.maxRayDepth);
        this.rayCutoffField.setValue((double)this.minRayIntensity);
        this.stepSizeField.setValue(this.stepSize);
        this.smoothField.setValue(this.smoothing);
        this.extraGIField.setValue(this.extraGISmoothing);
        this.extraGIEnvField.setValue(this.extraGIEnvSmoothing);
        this.adaptiveBox.setState(this.adaptive);
        this.rouletteBox.setState(this.roulette);
        this.errorField.setValue(this.surfaceError);
        this.aliasChoice.setSelectedIndex(this.antialiasLevel);
        this.depthBox.setState(this.depth);
        this.glossBox.setState(this.gloss);
        this.glossRaysChoice.setSelectedValue((Object)Integer.toString(this.glossRays));
        this.shadowBox.setState(this.penumbra);
        this.shadowRaysChoice.setSelectedValue((Object)Integer.toString(this.shadowRays));
        this.minRaysChoice.setSelectedValue((Object)Integer.toString(this.minRays));
        this.maxRaysChoice.setSelectedValue((Object)Integer.toString(this.maxRays));
        this.reducedMemoryBox.setState(this.reducedMemory);
        this.giModeChoice.setSelectedIndex(this.giMode);
        this.diffuseRaysChoice.setSelectedValue((Object)Integer.toString(this.diffuseRays));
        this.globalPhotonsField.setValue((double)this.globalPhotons);
        this.globalNeighborPhotonsField.setValue((double)this.globalNeighborPhotons);
        this.causticsBox.setState(this.caustics);
        this.causticsPhotonsField.setValue((double)this.causticsPhotons);
        this.causticsNeighborPhotonsField.setValue((double)this.causticsNeighborPhotons);
        this.scatterModeChoice.setSelectedIndex(this.scatterMode);
        this.volumePhotonsField.setValue((double)this.volumePhotons);
        this.volumeNeighborPhotonsField.setValue((double)this.volumeNeighborPhotons);
        this.transparentBox.setState(this.transparentBackground);
        this.aliasChoice.dispatchEvent((Object)new ValueChangedEvent((Widget)this.aliasChoice));
    }

    public boolean recordConfiguration() {
        this.maxRayDepth = (int)this.rayDepthField.getValue();
        this.minRayIntensity = (float)this.rayCutoffField.getValue();
        this.stepSize = this.stepSizeField.getValue();
        this.smoothing = this.smoothField.getValue();
        this.extraGISmoothing = this.extraGIField.getValue();
        this.extraGIEnvSmoothing = this.extraGIEnvField.getValue();
        this.adaptive = this.adaptiveBox.getState();
        this.roulette = this.rouletteBox.getState();
        this.surfaceError = this.errorField.getValue();
        this.antialiasLevel = this.aliasChoice.getSelectedIndex();
        this.depth = this.depthBox.getState();
        this.gloss = this.glossBox.getState();
        this.glossRays = Integer.parseInt((String)this.glossRaysChoice.getSelectedValue());
        this.penumbra = this.shadowBox.getState();
        this.shadowRays = Integer.parseInt((String)this.shadowRaysChoice.getSelectedValue());
        this.minRays = Integer.parseInt((String)this.minRaysChoice.getSelectedValue());
        this.maxRays = Integer.parseInt((String)this.maxRaysChoice.getSelectedValue());
        this.transparentBackground = this.transparentBox.getState();
        this.giMode = this.giModeChoice.getSelectedIndex();
        this.diffuseRays = Integer.parseInt((String)this.diffuseRaysChoice.getSelectedValue());
        this.globalPhotons = (int)this.globalPhotonsField.getValue();
        this.globalNeighborPhotons = (int)this.globalNeighborPhotonsField.getValue();
        this.caustics = this.causticsBox.getState();
        this.causticsPhotons = (int)this.causticsPhotonsField.getValue();
        this.causticsNeighborPhotons = (int)this.causticsNeighborPhotonsField.getValue();
        this.scatterMode = this.scatterModeChoice.getSelectedIndex();
        this.volumePhotons = (int)this.volumePhotonsField.getValue();
        this.volumeNeighborPhotons = (int)this.volumeNeighborPhotonsField.getValue();
        this.reducedMemory = this.reducedMemoryBox.getState();
        this.isPreview = false;
        return true;
    }

    public Map<String, Object> getConfiguration() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("maxRayDepth", this.maxRayDepth);
        map.put("minRayIntensity", Float.valueOf(this.minRayIntensity));
        map.put("materialStepSize", this.stepSize);
        map.put("textureSmoothing", this.smoothing);
        map.put("extraGISmoothing", this.extraGISmoothing);
        map.put("extraGIEnvSmoothing", this.extraGIEnvSmoothing);
        map.put("reduceAccuracyForDistant", this.adaptive);
        map.put("russianRouletteSampling", this.roulette);
        map.put("useLessMemory", this.reducedMemory);
        map.put("maxSurfaceError", this.surfaceError);
        map.put("antialiasing", this.antialiasLevel);
        map.put("depthOfField", this.depth);
        map.put("gloss", this.gloss);
        map.put("raysToSampleGloss", this.glossRays);
        map.put("softShadows", this.penumbra);
        map.put("raysToSampleShadows", this.shadowRays);
        map.put("minRaysPerPixel", this.minRays);
        map.put("maxRaysPerPixel", this.maxRays);
        map.put("transparentBackground", this.transparentBackground);
        map.put("globalIlluminationMode", this.giMode);
        map.put("raysToSampleEnvironment", this.diffuseRays);
        map.put("globalIlluminationPhotons", this.globalPhotons);
        map.put("globalIlluminationPhotonsInEstimate", this.globalNeighborPhotons);
        map.put("caustics", this.caustics);
        map.put("causticsPhotons", this.causticsPhotons);
        map.put("causticsPhotonsInEstimate", this.causticsNeighborPhotons);
        map.put("scatteringMode", this.scatterMode);
        map.put("scatteringPhotons", this.volumePhotons);
        map.put("scatteringPhotonsInEstimate", this.volumeNeighborPhotons);
        return map;
    }

    public void setConfiguration(String property, Object value) {
        this.needCopyToUI = true;
        this.isPreview = false;
        if ("maxRayDepth".equals(property)) {
            this.maxRayDepth = (Integer)value;
        } else if ("minRayIntensity".equals(property)) {
            this.minRayIntensity = ((Number)value).floatValue();
        } else if ("materialStepSize".equals(property)) {
            this.stepSize = ((Number)value).doubleValue();
        } else if ("textureSmoothing".equals(property)) {
            this.smoothing = ((Number)value).doubleValue();
        } else if ("extraGISmoothing".equals(property)) {
            this.extraGISmoothing = ((Number)value).doubleValue();
        } else if ("extraGIEnvSmoothing".equals(property)) {
            this.extraGIEnvSmoothing = ((Number)value).doubleValue();
        } else if ("reduceAccuracyForDistant".equals(property)) {
            this.adaptive = (Boolean)value;
        } else if ("russianRouletteSampling".equals(property)) {
            this.roulette = (Boolean)value;
        } else if ("useLessMemory".equals(property)) {
            this.reducedMemory = (Boolean)value;
        } else if ("maxSurfaceError".equals(property)) {
            this.surfaceError = ((Number)value).doubleValue();
        } else if ("antialiasing".equals(property)) {
            this.antialiasLevel = (Integer)value;
        } else if ("depthOfField".equals(property)) {
            this.depth = (Boolean)value;
        } else if ("gloss".equals(property)) {
            this.gloss = (Boolean)value;
        } else if ("raysToSampleGloss".equals(property)) {
            this.glossRays = (Integer)value;
        } else if ("softShadows".equals(property)) {
            this.penumbra = (Boolean)value;
        } else if ("raysToSampleShadows".equals(property)) {
            this.shadowRays = (Integer)value;
        } else if ("minRaysPerPixel".equals(property)) {
            this.minRays = (Integer)value;
        } else if ("maxRaysPerPixel".equals(property)) {
            this.maxRays = (Integer)value;
        } else if ("transparentBackground".equals(property)) {
            this.transparentBackground = (Boolean)value;
        } else if ("globalIlluminationMode".equals(property)) {
            this.giMode = (Integer)value;
        } else if ("raysToSampleEnvironment".equals(property)) {
            this.diffuseRays = (Integer)value;
        } else if ("globalIlluminationPhotons".equals(property)) {
            this.globalPhotons = (Integer)value;
        } else if ("globalIlluminationPhotonsInEstimate".equals(property)) {
            this.globalNeighborPhotons = (Integer)value;
        } else if ("caustics".equals(property)) {
            this.caustics = (Boolean)value;
        } else if ("causticsPhotons".equals(property)) {
            this.causticsPhotons = (Integer)value;
        } else if ("causticsPhotonsInEstimate".equals(property)) {
            this.causticsNeighborPhotons = (Integer)value;
        } else if ("scatteringMode".equals(property)) {
            this.scatterMode = (Integer)value;
        } else if ("scatteringPhotons".equals(property)) {
            this.volumePhotons = (Integer)value;
        } else if ("scatteringPhotonsInEstimate".equals(property)) {
            this.volumeNeighborPhotons = (Integer)value;
        }
    }

    public void configurePreview() {
        if (this.needCopyToUI) {
            this.copyConfigurationToUI();
        }
        this.maxRayDepth = 6;
        this.minRayIntensity = 0.02f;
        this.antialiasLevel = 0;
        this.transparentBackground = false;
        this.penumbra = false;
        this.gloss = false;
        this.depth = false;
        this.minRays = 4;
        this.maxRays = 4;
        this.antialiasLevel = 2;
        this.stepSize = 1.0;
        this.smoothing = 1.0;
        this.extraGISmoothing = 10.0;
        this.extraGIEnvSmoothing = 100.0;
        this.adaptive = true;
        this.reducedMemory = false;
        this.roulette = false;
        this.surfaceError = ArtOfIllusion.getPreferences().getInteractiveSurfaceError();
        this.giMode = 0;
        this.scatterMode = 0;
        this.caustics = false;
        this.isPreview = true;
    }

    protected void buildScene(final Scene theScene, final Camera theCamera) {
        int i;
        final List obj = Collections.synchronizedList(new ArrayList());
        final List lt = Collections.synchronizedList(new ArrayList());
        final Thread mainThread = Thread.currentThread();
        final List factories = PluginRegistry.getPlugins(RTObjectFactory.class);
        ThreadManager threads = new ThreadManager(theScene.getNumObjects(), new ThreadManager.Task(){

            public void execute(int index) {
                if (Raytracer.this.renderThread != mainThread) {
                    return;
                }
                ObjectInfo info = theScene.getObject(index);
                if (info.isVisible()) {
                    Raytracer.this.addObject(obj, lt, info, theCamera, mainThread, factories);
                }
            }

            public void cleanup() {
            }
        });
        threads.run();
        threads.finish();
        this.sceneObject = new RTObject[obj.size()];
        for (i = 0; i < this.sceneObject.length; ++i) {
            this.sceneObject[i] = (RTObject)obj.get(i);
            this.sceneObject[i].index = i;
            if (this.sceneObject[i].getMaterialMapping() == null) continue;
            if (this.materialBounds == null) {
                this.materialBounds = new BoundingBox(this.sceneObject[i].getBounds());
                continue;
            }
            this.materialBounds.extend(this.sceneObject[i].getBounds());
        }
        this.light = new RTLight[lt.size()];
        for (i = 0; i < this.light.length; ++i) {
            this.light[i] = (RTLight)lt.get(i);
        }
        this.ambColor = theScene.getAmbientColor();
        this.envColor = theScene.getEnvironmentColor();
        this.envMapping = theScene.getEnvironmentMapping();
        this.envMode = theScene.getEnvironmentMode();
        this.fogColor = theScene.getFogColor();
        this.fog = theScene.getFogState();
        this.fogDist = theScene.getFogDistance();
        ParameterValue[] envParam = theScene.getEnvironmentParameterValues();
        this.envParamValue = new double[envParam.length];
        for (int i2 = 0; i2 < this.envParamValue.length; ++i2) {
            this.envParamValue[i2] = envParam[i2].getAverageValue();
        }
    }

    protected void addObject(List<RTObject> obj, List<RTLight> lt, ObjectInfo info, Camera camera, Thread mainThread, List<RTObjectFactory> factories) {
        RenderingMesh mesh;
        double dist;
        boolean displaced = false;
        if (this.renderThread != mainThread) {
            return;
        }
        for (RTObjectFactory factory : factories) {
            if (!factory.processObject(info, this.theScene, camera, obj, lt)) continue;
            return;
        }
        Object3D theObject = info.getObject();
        Mat4 toLocal = info.getCoords().toLocal();
        Mat4 fromLocal = info.getCoords().fromLocal();
        if (theObject instanceof PointLight) {
            lt.add(new RTSphericalLight((PointLight)theObject, info.getCoords(), this.penumbra));
            return;
        }
        if (theObject instanceof SpotLight) {
            lt.add(new RTSphericalLight((SpotLight)theObject, info.getCoords(), this.penumbra));
            return;
        }
        if (theObject instanceof DirectionalLight) {
            lt.add(new RTDirectionalLight((DirectionalLight)theObject, info.getCoords(), this.penumbra));
            return;
        }
        while (theObject instanceof ObjectWrapper) {
            theObject = ((ObjectWrapper)theObject).getWrappedObject();
        }
        if (theObject instanceof ObjectCollection) {
            Enumeration enm = ((ObjectCollection)theObject).getObjects(info, false, this.theScene);
            while (enm.hasMoreElements()) {
                ObjectInfo elem = (ObjectInfo)enm.nextElement();
                if (!elem.isVisible()) continue;
                ObjectInfo copy = elem.duplicate();
                copy.getCoords().transformCoordinates(fromLocal);
                this.addObject(obj, lt, copy, camera, mainThread, factories);
            }
            return;
        }
        Vec3 cameraOrig = camera.getCameraCoordinates().getOrigin();
        double distToScreen = this.theCamera.getDistToScreen();
        double tol = this.adaptive ? ((dist = info.getBounds().distanceToPoint(toLocal.times(cameraOrig))) < distToScreen ? this.surfaceError : this.surfaceError * dist / distToScreen) : this.surfaceError;
        Texture tex = theObject.getTexture();
        if (tex != null && tex.hasComponent(6)) {
            displaced = true;
            if (theObject.canConvertToTriangleMesh() != 0) {
                TriangleMesh tm = theObject.convertToTriangleMesh(tol);
                tm.setTexture(tex, theObject.getTextureMapping().duplicate());
                if (theObject.getMaterialMapping() != null) {
                    tm.setMaterial(theObject.getMaterial(), theObject.getMaterialMapping().duplicate());
                }
                theObject = tm;
            }
        }
        if (!info.isDistorted()) {
            if (theObject instanceof Sphere) {
                Vec3 rad = ((Sphere)theObject).getRadii();
                if (rad.x == rad.y && rad.x == rad.z) {
                    obj.add(new RTSphere((Sphere)theObject, fromLocal, toLocal, info.getObject().getAverageParameterValues()));
                    return;
                }
                obj.add(new RTEllipsoid((Sphere)theObject, fromLocal, toLocal, info.getObject().getAverageParameterValues()));
                return;
            }
            if (theObject instanceof Cylinder) {
                obj.add(new RTCylinder((Cylinder)theObject, fromLocal, toLocal, info.getObject().getAverageParameterValues()));
                return;
            }
            if (theObject instanceof Cube) {
                obj.add(new RTCube((Cube)theObject, fromLocal, toLocal, info.getObject().getAverageParameterValues()));
                return;
            }
            if (theObject instanceof ImplicitObject && ((ImplicitObject)theObject).getPreferDirectRendering()) {
                obj.add(new RTImplicitObject((ImplicitObject)theObject, fromLocal, toLocal, info.getObject().getAverageParameterValues(), tol));
                return;
            }
        }
        if (this.isPreview) {
            mesh = info.getPreviewMesh();
            if (mesh != null) {
                mesh = mesh.clone();
            }
        } else {
            mesh = info.getRenderingMesh(tol);
        }
        if (mesh == null) {
            return;
        }
        mesh.transformMesh(fromLocal);
        Vec3[] vert = mesh.vert;
        RenderingTriangle[] t = mesh.triangle;
        if (displaced) {
            int i;
            Vec3 cameraZDir = camera.getCameraCoordinates().getZDirection();
            double[] vertTol = new double[vert.length];
            if (this.adaptive) {
                for (i = 0; i < vert.length; ++i) {
                    Vec3 offset = vert[i].minus(cameraOrig);
                    double vertDist = offset.length();
                    if (offset.dot(cameraZDir) < 0.0) {
                        vertDist = -vertDist;
                    }
                    vertTol[i] = vertDist < distToScreen ? this.surfaceError : this.surfaceError * vertDist / distToScreen;
                }
            }
            for (i = 0; i < t.length; ++i) {
                double localTol;
                RenderingTriangle tri = mesh.triangle[i];
                if (mesh.faceNorm[i].length() < 1.0E-12 || vert[tri.v1].distance(vert[tri.v2]) < 1.0E-12 || vert[tri.v1].distance(vert[tri.v3]) < 1.0E-12 || vert[tri.v2].distance(vert[tri.v3]) < 1.0E-12) continue;
                if (this.adaptive) {
                    localTol = vertTol[tri.v1];
                    if (vertTol[tri.v2] < localTol) {
                        localTol = vertTol[tri.v2];
                    }
                    if (vertTol[tri.v3] < localTol) {
                        localTol = vertTol[tri.v3];
                    }
                } else {
                    localTol = tol;
                }
                RTDisplacedTriangle dispTri = new RTDisplacedTriangle(mesh, i, fromLocal, toLocal, localTol, this.time);
                RTObject dt = dispTri;
                if (!dispTri.isReallyDisplaced()) {
                    dt = this.reducedMemory ? new RTTriangleLowMemory(mesh, i, fromLocal, toLocal) : new RTTriangle(mesh, i, fromLocal, toLocal);
                }
                obj.add(dt);
                if (this.adaptive && dt instanceof RTDisplacedTriangle) {
                    double dist2 = dt.getBounds().distanceToPoint(cameraOrig);
                    if (dist2 < distToScreen) {
                        ((RTDisplacedTriangle)dt).setTolerance(this.surfaceError);
                    } else {
                        ((RTDisplacedTriangle)dt).setTolerance(this.surfaceError * dist2 / distToScreen);
                    }
                }
                if (this.renderThread == mainThread) continue;
                return;
            }
        } else {
            for (int i = 0; i < t.length; ++i) {
                RenderingTriangle tri = mesh.triangle[i];
                if (mesh.faceNorm[i].length() < 1.0E-12 || vert[tri.v1].distance(vert[tri.v2]) < 1.0E-12 || vert[tri.v1].distance(vert[tri.v3]) < 1.0E-12 || vert[tri.v2].distance(vert[tri.v3]) < 1.0E-12) continue;
                if (this.reducedMemory) {
                    obj.add(new RTTriangleLowMemory(mesh, i, fromLocal, toLocal));
                    continue;
                }
                obj.add(new RTTriangle(mesh, i, fromLocal, toLocal));
            }
        }
    }

    protected void buildTree() {
        int i;
        BoundingBox[] objBounds = new BoundingBox[this.sceneObject.length];
        double minz = Double.MAX_VALUE;
        double miny = Double.MAX_VALUE;
        double minx = Double.MAX_VALUE;
        double maxz = -1.7976931348623157E308;
        double maxy = -1.7976931348623157E308;
        double maxx = -1.7976931348623157E308;
        for (i = 0; i < this.sceneObject.length; ++i) {
            objBounds[i] = this.sceneObject[i].getBounds();
            if (objBounds[i].minx < minx) {
                minx = objBounds[i].minx;
            }
            if (objBounds[i].maxx > maxx) {
                maxx = objBounds[i].maxx;
            }
            if (objBounds[i].miny < miny) {
                miny = objBounds[i].miny;
            }
            if (objBounds[i].maxy > maxy) {
                maxy = objBounds[i].maxy;
            }
            if (objBounds[i].minz < minz) {
                minz = objBounds[i].minz;
            }
            if (!(objBounds[i].maxz > maxz)) continue;
            maxz = objBounds[i].maxz;
        }
        this.rootNode = new OctreeNode(minx -= 1.0E-12, maxx += 1.0E-12, miny -= 1.0E-12, maxy += 1.0E-12, minz -= 1.0E-12, maxz += 1.0E-12, this.sceneObject, objBounds, null);
        this.cameraNode = this.rootNode.findNode(this.theCamera.getCameraCoordinates().getOrigin());
        this.lightNode = new OctreeNode[this.light.length];
        for (i = 0; i < this.light.length; ++i) {
            this.lightNode[i] = this.light[i].getLight() instanceof DirectionalLight ? null : this.rootNode.findNode(this.light[i].getCoords().getOrigin());
        }
    }

    protected void buildPhotonMap() {
        MaterialMapping mm;
        Texture tex;
        BoundingBox bounds;
        if (this.giMode != 3 && this.giMode != 4 && !this.caustics && this.scatterMode != 1 && this.scatterMode != 2) {
            return;
        }
        PhotonMap shared = null;
        if (this.giMode == 3) {
            this.listener.statusChanged("Building Global Photon Map");
            this.globalMap = shared = new PhotonMap(this.globalPhotons, this.globalNeighborPhotons, false, false, true, false, this, this.rootNode, 1, null);
            this.generatePhotons(this.globalMap);
        } else if (this.giMode == 4) {
            this.listener.statusChanged("Building Global Photon Map");
            this.globalMap = shared = new PhotonMap(this.globalPhotons, this.globalNeighborPhotons, true, true, true, false, this, this.rootNode, 0, null);
            this.generatePhotons(this.globalMap);
        }
        if (this.caustics) {
            bounds = null;
            for (RTObject obj : this.sceneObject) {
                tex = obj.getTextureMapping().getTexture();
                mm = obj.getMaterialMapping();
                if (!tex.hasComponent(1) && (!tex.hasComponent(2) || mm == null || mm.getMaterial().indexOfRefraction() == 1.0)) continue;
                bounds = bounds == null ? obj.getBounds() : bounds.merge(obj.getBounds());
            }
            if (bounds == null) {
                bounds = new BoundingBox(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
            }
            this.listener.statusChanged("Building Caustics Photon Map");
            this.causticsMap = shared = new PhotonMap(this.causticsPhotons, this.causticsNeighborPhotons, true, false, false, false, this, bounds, 2, shared);
            this.generatePhotons(this.causticsMap);
        }
        if (this.scatterMode == 1 || this.scatterMode == 2) {
            bounds = null;
            for (RTObject obj : this.sceneObject) {
                tex = obj.getTextureMapping().getTexture();
                mm = obj.getMaterialMapping();
                if (!tex.hasComponent(2) || mm == null || !mm.getMaterial().isScattering()) continue;
                bounds = bounds == null ? obj.getBounds() : bounds.merge(obj.getBounds());
            }
            if (bounds == null) {
                bounds = new BoundingBox(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
            }
            this.listener.statusChanged("Building Volume Photon Map");
            this.volumeMap = new PhotonMap(this.volumePhotons, this.volumeNeighborPhotons, false, this.scatterMode == 1, true, true, this, bounds, 0, shared);
            this.generatePhotons(this.volumeMap);
        }
    }

    protected void generatePhotons(PhotonMap map) {
        List factories = PluginRegistry.getPlugins(PhotonSourceFactory.class);
        ArrayList<PhotonSource> sources = new ArrayList<PhotonSource>();
        for (RTLight lt : this.light) {
            boolean processed = false;
            for (PhotonSourceFactory factory : factories) {
                if (!factory.processLight(lt, map, sources)) continue;
                processed = true;
                break;
            }
            if (processed) continue;
            if (lt.getLight() instanceof DirectionalLight) {
                sources.add(new DirectionalPhotonSource((DirectionalLight)lt.getLight(), lt.getCoords(), map));
                continue;
            }
            if (lt.getLight() instanceof PointLight) {
                sources.add(new PointPhotonSource((PointLight)lt.getLight(), lt.getCoords(), map));
                continue;
            }
            if (!(lt.getLight() instanceof SpotLight)) continue;
            sources.add(new SpotlightPhotonSource((SpotLight)lt.getLight(), lt.getCoords(), map));
        }
        ArrayList<TrianglePhotonSource> objectSources = new ArrayList<TrianglePhotonSource>();
        for (RTObject obj : this.sceneObject) {
            PhotonSource src;
            boolean processed = false;
            for (PhotonSourceFactory factory : factories) {
                if (!factory.processObject(obj, map, sources)) continue;
                processed = true;
                break;
            }
            if (processed || !obj.getTextureMapping().getTexture().hasComponent(4)) continue;
            if (obj instanceof RTTriangle) {
                src = new TrianglePhotonSource(((RTTriangle)obj).tri, map);
            } else if (obj instanceof RTTriangleLowMemory) {
                src = new TrianglePhotonSource(((RTTriangleLowMemory)obj).tri, map);
            } else if (obj instanceof RTDisplacedTriangle) {
                src = new DisplacedTrianglePhotonSource((RTDisplacedTriangle)obj, map);
            } else if (obj instanceof RTEllipsoid) {
                src = new EllipsoidPhotonSource((RTEllipsoid)obj, map);
            } else if (obj instanceof RTSphere) {
                src = new EllipsoidPhotonSource((RTSphere)obj, map);
            } else if (obj instanceof RTCylinder) {
                src = new CylinderPhotonSource((RTCylinder)obj, map);
            } else {
                if (!(obj instanceof RTCube)) continue;
                src = new CubePhotonSource((RTCube)obj, map);
            }
            if (!(src.getTotalIntensity() > 0.0)) continue;
            objectSources.add((TrianglePhotonSource)src);
        }
        if (objectSources.size() > 0) {
            sources.add(new CompoundPhotonSource(objectSources.toArray(new PhotonSource[objectSources.size()])));
        }
        sources.add(new EnvironmentPhotonSource(this.theScene, map));
        PhotonSource[] src = sources.toArray(new PhotonSource[sources.size()]);
        map.generatePhotons(src);
    }

    @Override
    public void run() {
        long updateTime = System.currentTimeMillis();
        final Thread thisThread = Thread.currentThread();
        if (this.renderThread != thisThread) {
            return;
        }
        this.pixel = new int[this.width * this.height];
        this.imageSource = new MemoryImageSource(this.width, this.height, this.pixel, 0, this.width);
        this.imageSource.setAnimated(true);
        this.img = Toolkit.getDefaultToolkit().createImage(this.imageSource);
        int requiredComponents = this.sceneCamera.getComponentsForFilters();
        this.floatImage = new float[4][this.width * this.height];
        if ((requiredComponents & 0x10) != 0) {
            this.depthImage = new float[this.width * this.height];
        }
        if ((requiredComponents & 0x40) != 0) {
            this.errorImage = new float[this.width * this.height];
        }
        if ((requiredComponents & 0x20) != 0) {
            this.objectImage = new float[this.width * this.height];
        }
        this.listener.statusChanged(Translate.text((String)"Processing Scene"));
        this.buildScene(this.theScene, this.theCamera);
        if (this.renderThread != thisThread) {
            return;
        }
        this.buildTree();
        this.buildPhotonMap();
        this.listener.statusChanged(Translate.text((String)"Rendering"));
        for (int i = 0; i < this.pixel.length; ++i) {
            this.pixel[i] = 0;
        }
        int maxRaysInUse = this.maxRays;
        int minRaysInUse = this.minRays;
        if (this.antialiasLevel == 0) {
            maxRaysInUse = 1;
            minRaysInUse = 1;
        }
        this.smoothScale = this.smoothing * 2.0 * Math.tan(this.sceneCamera.getFieldOfView() * Math.PI / 360.0) / (double)this.height;
        if (maxRaysInUse == 1) {
            this.rtWidth = this.width;
            this.rtHeight = this.height;
        } else {
            this.rtWidth = 2 * this.width + 2;
            this.rtHeight = 2 * this.height + 2;
            this.smoothScale *= 0.5;
        }
        final int finalMinRays = minRaysInUse;
        final int[] currentScale = new int[1];
        final int[] currentWidth = new int[1];
        final boolean[] isFirstPass = new boolean[]{true};
        ThreadManager threads = new ThreadManager(this.width, new ThreadManager.Task(){

            public void execute(int index) {
                if (Raytracer.this.renderThread != thisThread) {
                    return;
                }
                int row = index / currentWidth[0];
                int col = index - row * currentWidth[0];
                if (!isFirstPass[0] && row % 2 == 0 && col % 2 == 0) {
                    return;
                }
                int subsample = finalMinRays > 1 ? 2 : 1;
                RaytracerContext context = (RaytracerContext)Raytracer.this.threadContext.get();
                PixelInfo pixel = context.tempPixel;
                pixel.clear();
                pixel.depth = (float)Raytracer.this.spawnEyeRay(context, col * subsample * currentScale[0], row * subsample * currentScale[0], 4, finalMinRays);
                pixel.object = context.firstObjectHit == null ? 0.0f : Float.intBitsToFloat(context.firstObjectHit.getObject().hashCode());
                pixel.add(context.color[0], (float)context.transparency[0]);
                Raytracer.this.recordPixel(col * currentScale[0], row * currentScale[0], currentScale[0], pixel);
            }

            public void cleanup() {
                ((RaytracerContext)Raytracer.this.threadContext.get()).cleanup();
            }
        });
        currentScale[0] = 1 << (int)(Math.log(this.width / 32) / Math.log(2.0));
        while (currentScale[0] >= 1) {
            currentWidth[0] = (int)Math.ceil((double)this.width / (double)currentScale[0]);
            int currentHeight = (int)Math.ceil((double)this.height / (double)currentScale[0]);
            threads.setNumIndices(currentWidth[0] * currentHeight);
            threads.run();
            isFirstPass[0] = false;
            if (this.renderThread != thisThread) {
                threads.finish();
                return;
            }
            long currentTime = System.currentTimeMillis();
            if (currentTime - updateTime > 250L || currentScale[0] == 1 && currentTime - updateTime > 150L) {
                this.imageSource.newPixels();
                this.listener.imageUpdated(this.img);
                updateTime = System.currentTimeMillis();
            }
            currentScale[0] = currentScale[0] / 2;
        }
        if (maxRaysInUse == 1) {
            this.imageSource.newPixels();
            threads.finish();
            this.finish();
            return;
        }
        PixelInfo tempPixel = new PixelInfo();
        RGBColor tempColor = new RGBColor();
        final PixelInfo[][] pix = new PixelInfo[6][this.rtWidth];
        for (int i = 0; i < pix.length; ++i) {
            for (int j = 0; j < pix[i].length; ++j) {
                pix[i][j] = new PixelInfo();
            }
        }
        this.loadRow(pix[0], 0, tempColor);
        this.loadRow(pix[2], 1, tempColor);
        this.loadRow(pix[4], 2, tempColor);
        int minPerSubpixel = minRaysInUse / 4;
        int maxPerSubpixel = maxRaysInUse / 4;
        final int[] currentRow = new int[1];
        final int[] currentCount = new int[1];
        threads = new ThreadManager(this.rtWidth, new ThreadManager.Task(){

            public void execute(int index) {
                RaytracerContext context = (RaytracerContext)Raytracer.this.threadContext.get();
                PixelInfo tempPixel = context.tempPixel;
                for (int m = 0; m < 6; ++m) {
                    PixelInfo thisPixel = pix[m][index];
                    thisPixel.converged = true;
                    if (!thisPixel.needsMore) continue;
                    tempPixel.clear();
                    int baseNum = (m & 1) * 8 + (index & 1) * 4;
                    int numNeeded = currentCount[0] - thisPixel.raysSent;
                    for (int k = thisPixel.raysSent; k < currentCount[0]; ++k) {
                        float dist = (float)Raytracer.this.spawnEyeRay(context, index, 2 * currentRow[0] + m, baseNum + k, numNeeded);
                        if (k < currentCount[0] / 2) {
                            thisPixel.add(context.color[0], (float)context.transparency[0]);
                            if (!(dist < thisPixel.depth)) continue;
                            thisPixel.depth = dist;
                            thisPixel.object = context.firstObjectHit == null ? 0.0f : Float.intBitsToFloat(context.firstObjectHit.getObject().hashCode());
                            continue;
                        }
                        tempPixel.add(context.color[0], (float)context.transparency[0]);
                        if (!(dist < tempPixel.depth)) continue;
                        tempPixel.depth = dist;
                        tempPixel.object = context.firstObjectHit == null ? 0.0f : Float.intBitsToFloat(context.firstObjectHit.getObject().hashCode());
                    }
                    if (currentCount[0] > 1) {
                        thisPixel.converged = thisPixel.matches(tempPixel, 0.0078125f, 0.03125f);
                    }
                    thisPixel.add(tempPixel);
                }
            }

            public void cleanup() {
                ((RaytracerContext)Raytracer.this.threadContext.get()).cleanup();
            }
        });
        currentRow[0] = 0;
        while (currentRow[0] < this.height - 1) {
            int j;
            boolean done = false;
            currentCount[0] = minPerSubpixel;
            while (currentCount[0] <= maxPerSubpixel && !done) {
                int j2;
                int m;
                threads.run();
                if (this.renderThread != thisThread) {
                    threads.finish();
                    return;
                }
                if (currentCount[0] == 1) {
                    for (m = 0; m < 5; ++m) {
                        for (j2 = 0; j2 < this.rtWidth - 1; ++j2) {
                            if (!pix[m][j2].matches(pix[m + 1][j2], 0.0078125f, 0.03125f)) {
                                pix[m + 1][j2].converged = false;
                                pix[m][j2].converged = false;
                            }
                            if (pix[m][j2].matches(pix[m][j2 + 1], 0.0078125f, 0.03125f)) continue;
                            pix[m][j2 + 1].converged = false;
                            pix[m][j2].converged = false;
                        }
                    }
                }
                for (m = 0; m < 6; ++m) {
                    for (j2 = 0; j2 < this.rtWidth; ++j2) {
                        pix[m][j2].needsMore = false;
                    }
                }
                done = true;
                for (m = 0; m < 6; ++m) {
                    for (j2 = 0; j2 < this.rtWidth; ++j2) {
                        if (pix[m][j2].converged) continue;
                        done = false;
                        pix[m][j2].needsMore = true;
                        if (m > 0) {
                            pix[m - 1][j2].needsMore = true;
                        }
                        if (m < 5) {
                            pix[m + 1][j2].needsMore = true;
                        }
                        if (j2 > 0) {
                            pix[m][j2 - 1].needsMore = true;
                        }
                        if (j2 >= this.rtWidth - 1) continue;
                        pix[m][j2 + 1].needsMore = true;
                    }
                }
                currentCount[0] = currentCount[0] * 2;
            }
            this.recordRow(pix, tempPixel, currentRow[0]);
            if (System.currentTimeMillis() - updateTime > 5000L) {
                this.imageSource.newPixels();
                this.listener.imageUpdated(this.img);
                updateTime = System.currentTimeMillis();
            }
            PixelInfo[] temp1 = pix[0];
            PixelInfo[] temp2 = pix[1];
            for (j = 0; j < 4; ++j) {
                pix[j] = pix[j + 2];
            }
            pix[4] = temp1;
            pix[5] = temp2;
            for (j = 0; j < this.rtWidth; ++j) {
                pix[5][j].clear();
            }
            this.loadRow(pix[4], currentRow[0] + 2, tempColor);
            currentRow[0] = currentRow[0] + 1;
        }
        this.recordRow(pix, tempPixel, this.height - 1);
        this.imageSource.newPixels();
        threads.finish();
        this.finish();
    }

    protected void loadRow(PixelInfo[] pix, int y, RGBColor temp) {
        for (PixelInfo p : pix) {
            p.clear();
        }
        if (y >= this.height) {
            return;
        }
        for (int i = 0; i < this.width; ++i) {
            int x = i * 2 + 1;
            int index = i + y * this.width;
            temp.setRGB(this.floatImage[0][index], this.floatImage[1][index], this.floatImage[2][index]);
            pix[x].add(temp, 1.0f - this.floatImage[3][index]);
            if (this.depthImage != null) {
                pix[x].depth = this.depthImage[index];
            }
            if (this.objectImage == null) continue;
            pix[x].object = this.objectImage[index];
        }
    }

    protected void recordRow(PixelInfo[][] pix, PixelInfo tempPixel, int row) {
        for (int i = 0; i < this.width; ++i) {
            int x = i * 2 + 1;
            tempPixel.copy(pix[1][x]);
            tempPixel.add(pix[1][x + 1]);
            tempPixel.add(pix[2][x]);
            tempPixel.add(pix[2][x + 1]);
            if (this.antialiasLevel == 2) {
                tempPixel.add(tempPixel);
                tempPixel.add(pix[0][x]);
                tempPixel.add(pix[0][x + 1]);
                tempPixel.add(pix[3][x]);
                tempPixel.add(pix[3][x + 1]);
                tempPixel.add(pix[1][x - 1]);
                tempPixel.add(pix[2][x - 1]);
                tempPixel.add(pix[1][x + 2]);
                tempPixel.add(pix[2][x + 2]);
            }
            this.recordPixel(i, row, 1, tempPixel);
            if (this.errorImage == null) continue;
            if (pix[1][x].raysSent + pix[1][x + 1].raysSent + pix[2][x].raysSent + pix[2][x + 1].raysSent == 4) {
                float ninvTotal = 1.0f / (float)tempPixel.raysSent;
                PixelInfo p1 = pix[1][x];
                PixelInfo p2 = pix[1][x + 1];
                PixelInfo p3 = pix[2][x];
                PixelInfo p4 = pix[2][x + 1];
                float ninv1 = 1.0f / (float)p1.raysSent;
                float ninv2 = 1.0f / (float)p2.raysSent;
                float ninv3 = 1.0f / (float)p3.raysSent;
                float ninv4 = 1.0f / (float)p4.raysSent;
                float r = tempPixel.red * ninvTotal;
                float g = tempPixel.green * ninvTotal;
                float b = tempPixel.blue * ninvTotal;
                this.errorImage[i + row * this.width] = ((p1.red * ninv1 - r) * (p1.red * ninv1 - r) + (p1.green * ninv1 - g) * (p1.green * ninv1 - g) + (p1.blue * ninv1 - b) * (p1.blue * ninv1 - b) + (p2.red * ninv2 - r) * (p2.red * ninv2 - r) + (p2.green * ninv2 - g) * (p2.green * ninv2 - g) + (p2.blue * ninv2 - b) * (p2.blue * ninv2 - b) + (p3.red * ninv3 - r) * (p2.red * ninv3 - r) + (p3.green * ninv3 - g) * (p3.green * ninv3 - g) + (p3.blue * ninv3 - b) * (p3.blue * ninv3 - b) + (p4.red * ninv4 - r) * (p3.red * ninv4 - r) + (p4.green * ninv4 - g) * (p4.green * ninv4 - g) + (p4.blue * ninv4 - b) * (p4.blue * ninv4 - b)) / 12.0f;
                continue;
            }
            int degreesOfFreedom = this.antialiasLevel == 2 ? tempPixel.raysSent / 2 : tempPixel.raysSent;
            this.errorImage[i + row * this.width] = (tempPixel.getRedVariance() + tempPixel.getGreenVariance() + tempPixel.getBlueVariance()) / (3.0f * (float)degreesOfFreedom);
        }
    }

    protected void recordPixel(int x, int y, int size, PixelInfo pix) {
        int index = x + y * this.width;
        if (size == 1) {
            this.pixel[index] = pix.calcARGB();
        } else {
            int rows = Math.min(size, this.width - x);
            int cols = Math.min(size, this.height - y);
            int argb = pix.calcARGB();
            for (int i = 0; i < rows; ++i) {
                for (int j = 0; j < cols; ++j) {
                    this.pixel[x + i + (y + j) * this.width] = argb;
                }
            }
        }
        float ninv = 1.0f / (float)pix.raysSent;
        this.floatImage[0][index] = pix.red * ninv;
        this.floatImage[1][index] = pix.green * ninv;
        this.floatImage[2][index] = pix.blue * ninv;
        this.floatImage[3][index] = 1.0f - pix.transparency * ninv;
        if (this.depthImage != null) {
            this.depthImage[index] = pix.depth;
        }
        if (this.objectImage != null) {
            this.objectImage[index] = pix.object;
        }
    }

    protected void finish() {
        this.sceneObject = null;
        this.light = null;
        this.rootNode = null;
        this.cameraNode = null;
        this.lightNode = null;
        this.theScene = null;
        this.theCamera = null;
        this.envMapping = null;
        this.renderThread = null;
        this.globalMap = null;
        this.causticsMap = null;
        this.volumeMap = null;
        RenderListener rl = this.listener;
        ComplexImage im = null;
        Image image = this.img;
        if (image != null) {
            im = new ComplexImage(image);
            if (rl != null) {
                im.setComponentValues(4, this.floatImage[0]);
                im.setComponentValues(2, this.floatImage[1]);
                im.setComponentValues(1, this.floatImage[2]);
                im.setComponentValues(8, this.floatImage[3]);
                if (this.depthImage != null) {
                    im.setComponentValues(16, this.depthImage);
                }
                if (this.objectImage != null) {
                    im.setComponentValues(32, this.objectImage);
                }
                if (this.errorImage != null) {
                    im.setComponentValues(64, this.errorImage);
                }
                this.listener = null;
            }
        }
        this.img = null;
        this.imageSource = null;
        this.pixel = null;
        this.floatImage = null;
        this.depthImage = null;
        this.errorImage = null;
        this.objectImage = null;
        System.gc();
        if (rl != null && im != null) {
            rl.imageComplete(im);
        }
    }

    protected double spawnEyeRay(RaytracerContext rt, int i, int j, int number, int outOf) {
        Ray ray = rt.ray[0];
        Vec3 orig = ray.getOrigin();
        Vec3 dir = ray.getDirection();
        double h = (double)i - (double)this.rtWidth * 0.5 + 0.5;
        double v = (double)j - (double)this.rtHeight * 0.5 + 0.5;
        if (this.antialiasLevel > 0) {
            int rows = FastMath.ceil((double)Math.sqrt(outOf));
            int cols = outOf / rows;
            int num = number % outOf;
            int row = num / cols;
            int col = num - row * cols;
            h += ((double)col + rt.random.nextDouble()) / (double)cols - 0.5;
            v += ((double)row + rt.random.nextDouble()) / (double)rows - 0.5;
        }
        double dof1 = 0.0;
        double dof2 = 0.0;
        if (this.depth) {
            dof1 = 0.25 * (rt.random.nextDouble() + (double)distrib1[number & 0xF]);
            dof2 = 0.25 * (rt.random.nextDouble() + (double)distrib2[number & 0xF]);
        }
        this.sceneCamera.getRayFromCamera(h / (double)this.rtHeight, v / (double)this.rtHeight, dof1, dof2, orig, dir);
        this.theCamera.getCameraCoordinates().fromLocal().transform(orig);
        this.theCamera.getCameraCoordinates().fromLocal().transformDirection(dir);
        ray.newID();
        rt.rayIntensity[0].setRGB(1.0f, 1.0f, 1.0f);
        rt.firstObjectHit = null;
        double distScale = 1.0 / dir.dot(this.theCamera.getCameraCoordinates().getZDirection());
        OctreeNode node = this.cameraNode;
        if (node == null) {
            node = this.rootNode.findFirstNode(ray);
        }
        if (node == null) {
            RGBColor color = rt.color[0];
            TextureSpec surfSpec = rt.surfSpec[0];
            if (this.transparentBackground) {
                rt.transparency[0] = 1.0;
                color.setRGB(0.0f, 0.0f, 0.0f);
                return 3.4028234663852886E38;
            }
            if (this.envMode == 0) {
                color.copy(this.envColor);
                return 3.4028234663852886E38;
            }
            this.envMapping.getTextureSpec(ray.direction, surfSpec, 1.0, this.smoothScale, this.time, this.envParamValue);
            if (this.envMode == 1) {
                color.copy(surfSpec.diffuse);
            } else {
                color.copy(surfSpec.emissive);
            }
            return 3.4028234663852886E38;
        }
        if (!rt.materialAtCameraIsFixed) {
            rt.materialAtCamera = this.getMaterialAtPoint(rt, orig, node);
            boolean bl = rt.materialAtCameraIsFixed = !this.depth;
        }
        if (rt.materialAtCamera == null) {
            return distScale * this.spawnRay(rt, 0, node, null, null, null, null, null, number, 0.0, true, false);
        }
        return distScale * this.spawnRay(rt, 0, node, null, rt.materialAtCamera.getMaterialMapping(), null, rt.materialAtCamera.toLocal(), null, number, 0.0, true, false);
    }

    protected RTObject getMaterialAtPoint(RaytracerContext rt, Vec3 pos, OctreeNode node) {
        if (this.materialBounds == null || !this.materialBounds.contains(pos)) {
            return null;
        }
        Ray r = rt.ray[this.maxRayDepth];
        r.origin.set(pos);
        double len2 = pos.length2();
        if (len2 > 1.0E-5) {
            r.direction.set(pos);
            r.direction.scale(1.0 / Math.sqrt(len2));
        } else {
            r.direction.set(0.0, 0.0, 1.0);
        }
        r.newID();
        int matCount = 0;
        MaterialIntersection[] matChange = r.rt.matChange;
        Vec3 trueNorm = r.rt.trueNormal[0];
        RTObject next = null;
        while (true) {
            RTObject first;
            if (next == null) {
                if ((node = this.traceRay(r, node)) == null) {
                    return null;
                }
                first = rt.intersect.first;
                next = rt.intersect.second;
            } else {
                first = next;
                next = null;
            }
            SurfaceIntersection intersection = rt.lastRayResult[first.index];
            MaterialMapping mat = first.getMaterialMapping();
            if (mat != null) {
                boolean entered;
                intersection.trueNormal(trueNorm);
                double angle = -trueNorm.dot(r.getDirection());
                boolean bl = entered = angle > 0.0;
                if (entered) {
                    if (matCount == matChange.length) {
                        rt.increaseMaterialChangeLength();
                        matChange = rt.matChange;
                    }
                    matChange[matCount++].mat = mat;
                } else if (matCount > 0 && matChange[matCount - 1].mat == mat) {
                    --matCount;
                } else {
                    return first;
                }
            }
            if (next != null) continue;
            intersection.intersectionPoint(0, r.getOrigin());
            r.newID();
        }
    }

    protected double spawnRay(RaytracerContext rt, int treeDepth, OctreeNode node, RTObject first, MaterialMapping currentMaterial, MaterialMapping prevMaterial, Mat4 currentMatTrans, Mat4 prevMatTrans, int rayNumber, double totalDist, boolean transmitted, boolean diffuse) {
        int i;
        int numRays;
        double d;
        Vec3 temp;
        double texSmoothing;
        OctreeNode nextNode;
        RTObject second = null;
        double beta = 0.0;
        Vec3 intersectionPoint = rt.pos[treeDepth];
        Vec3 norm = rt.normal[treeDepth];
        Vec3 trueNorm = rt.trueNormal[treeDepth];
        boolean totalReflect = false;
        Ray r = rt.ray[treeDepth];
        TextureSpec spec = rt.surfSpec[treeDepth];
        Mat4 oldMatTrans = null;
        RGBColor color = rt.color[treeDepth];
        RGBColor rayIntensity = rt.rayIntensity[treeDepth];
        rt.transparency[treeDepth] = 0.0;
        SurfaceIntersection intersection = SurfaceIntersection.NO_INTERSECTION;
        if (first != null && (intersection = r.findIntersection(first)) == SurfaceIntersection.NO_INTERSECTION) {
            Ray r2 = rt.ray[treeDepth + 1];
            r2.origin.set(r.origin);
            r2.direction.set(r.direction);
            r2.origin.x -= 1.0E-12 * r.direction.x;
            r2.origin.y -= 1.0E-12 * r.direction.y;
            r2.origin.z -= 1.0E-12 * r.direction.z;
            intersection = r2.findIntersection(first);
        }
        if (intersection != SurfaceIntersection.NO_INTERSECTION) {
            intersection.intersectionPoint(0, intersectionPoint);
            nextNode = this.rootNode.findNode(intersectionPoint);
        } else {
            nextNode = this.traceRay(r, node);
            if (nextNode == null) {
                if (transmitted && this.transparentBackground) {
                    color.setRGB(0.0f, 0.0f, 0.0f);
                    rt.transparency[treeDepth] = Math.min(Math.min(rayIntensity.getRed(), rayIntensity.getGreen()), rayIntensity.getBlue());
                    return 3.4028234663852886E38;
                }
                if (this.envMode == 0) {
                    color.copy(this.envColor);
                    color.multiply(rayIntensity);
                    return 3.4028234663852886E38;
                }
                double envSmoothing = diffuse ? this.smoothScale * this.extraGIEnvSmoothing : this.smoothScale;
                this.envMapping.getTextureSpec(r.direction, spec, 1.0, this.smoothing * envSmoothing, this.time, this.envParamValue);
                if (this.envMode == 1) {
                    color.copy(spec.diffuse);
                } else {
                    color.copy(spec.emissive);
                }
                color.multiply(rayIntensity);
                return 3.4028234663852886E38;
            }
            first = rt.intersect.first;
            second = rt.intersect.second;
            intersection = rt.lastRayResult[first.index];
            intersection.intersectionPoint(0, intersectionPoint);
        }
        if (treeDepth == 0) {
            rt.firstObjectHit = first;
        }
        double dist = intersection.intersectionDist(0);
        totalDist += dist;
        intersection.trueNormal(trueNorm);
        double truedot = trueNorm.dot(r.getDirection());
        double d2 = texSmoothing = diffuse ? this.smoothScale * this.extraGISmoothing : this.smoothScale;
        if (truedot > 0.0) {
            intersection.intersectionProperties(spec, norm, r.getDirection(), totalDist * texSmoothing * 3.0 / (2.0 + truedot), this.time);
        } else {
            intersection.intersectionProperties(spec, norm, r.getDirection(), totalDist * texSmoothing * 3.0 / (2.0 - truedot), this.time);
        }
        this.getDirectLight(rt, intersectionPoint, norm, truedot < 0.0, r.getDirection(), treeDepth, nextNode, rayNumber, totalDist, currentMaterial, prevMaterial, currentMatTrans, prevMatTrans, diffuse);
        if (currentMaterial != null) {
            this.propagateRay(r, node, dist, currentMaterial, prevMaterial, currentMatTrans, prevMatTrans, rt.tempColor, rayIntensity, treeDepth, totalDist);
            color.multiply(rayIntensity);
            color.add(rt.tempColor);
        } else if (this.fog) {
            float fract = (float)Math.exp(-dist / this.fogDist);
            color.scale(fract);
            rt.tempColor.copy(this.fogColor);
            rt.tempColor.scale(1.0f - fract);
            color.add(rt.tempColor);
            color.multiply(rayIntensity);
            rayIntensity.scale(fract);
        } else {
            color.multiply(rayIntensity);
        }
        if (treeDepth == this.maxRayDepth - 1) {
            return dist;
        }
        if (this.giMode == 1 && diffuse) {
            return dist;
        }
        boolean spawnSpecular = false;
        boolean spawnTransmitted = false;
        boolean spawnDiffuse = false;
        float specularScale = 1.0f;
        float transmittedScale = 1.0f;
        float diffuseScale = 1.0f;
        if (this.roulette) {
            float prob = (rayIntensity.getRed() * spec.specular.getRed() + rayIntensity.getGreen() * spec.specular.getGreen() + rayIntensity.getBlue() * spec.specular.getBlue()) / 3.0f;
            if (prob > rt.random.nextFloat()) {
                spawnSpecular = true;
                specularScale = 1.0f / prob;
            }
            if ((prob = (rayIntensity.getRed() * spec.transparent.getRed() + rayIntensity.getGreen() * spec.transparent.getGreen() + rayIntensity.getBlue() * spec.transparent.getBlue()) / 3.0f) > rt.random.nextFloat()) {
                spawnTransmitted = true;
                transmittedScale = 1.0f / prob;
            }
            if ((this.giMode == 2 || this.giMode == 1 || this.giMode == 4 && !diffuse) && (prob = (rayIntensity.getRed() * spec.diffuse.getRed() + rayIntensity.getGreen() * spec.diffuse.getGreen() + rayIntensity.getBlue() * spec.diffuse.getBlue()) / 3.0f) > rt.random.nextFloat()) {
                spawnDiffuse = true;
                diffuseScale = 1.0f / prob;
            }
        } else {
            spawnSpecular = rayIntensity.getRed() * spec.specular.getRed() > this.minRayIntensity || rayIntensity.getGreen() * spec.specular.getGreen() > this.minRayIntensity || rayIntensity.getBlue() * spec.specular.getBlue() > this.minRayIntensity;
            boolean bl = spawnTransmitted = rayIntensity.getRed() * spec.transparent.getRed() > this.minRayIntensity || rayIntensity.getGreen() * spec.transparent.getGreen() > this.minRayIntensity || rayIntensity.getBlue() * spec.transparent.getBlue() > this.minRayIntensity;
            if (this.giMode == 2 || this.giMode == 1 || this.giMode == 4 && !diffuse) {
                spawnDiffuse = rayIntensity.getRed() * spec.diffuse.getRed() > this.minRayIntensity || rayIntensity.getGreen() * spec.diffuse.getGreen() > this.minRayIntensity || rayIntensity.getBlue() * spec.diffuse.getBlue() > this.minRayIntensity;
            }
        }
        double dot = norm.dot(r.getDirection());
        RGBColor col = rt.rayIntensity[treeDepth + 1];
        if (spawnTransmitted) {
            double n;
            MaterialMapping oldMaterial;
            Mat4 nextMatTrans;
            MaterialMapping nextMaterial;
            col.copy(rayIntensity);
            col.multiply(spec.transparent);
            col.scale(transmittedScale);
            rt.ray[treeDepth + 1].getOrigin().set(intersectionPoint);
            temp = rt.ray[treeDepth].tempVec1;
            if (first.getMaterialMapping() == null) {
                temp.set(r.getDirection());
                nextMaterial = currentMaterial;
                nextMatTrans = currentMatTrans;
                oldMaterial = prevMaterial;
                oldMatTrans = prevMatTrans;
            } else if (truedot < 0.0) {
                nextMaterial = first.getMaterialMapping();
                nextMatTrans = first.toLocal();
                oldMaterial = currentMaterial;
                oldMatTrans = currentMatTrans;
                n = currentMaterial == null ? nextMaterial.indexOfRefraction() : nextMaterial.indexOfRefraction() / currentMaterial.indexOfRefraction();
                beta = -(dot + Math.sqrt(n * n - 1.0 + dot * dot));
                temp.set(norm);
                temp.scale(beta);
                temp.add(r.getDirection());
                temp.scale(1.0 / n);
            } else {
                if (currentMaterial == first.getMaterialMapping()) {
                    nextMaterial = prevMaterial;
                    nextMatTrans = prevMatTrans;
                    oldMaterial = null;
                    n = nextMaterial == null ? 1.0 / currentMaterial.indexOfRefraction() : nextMaterial.indexOfRefraction() / currentMaterial.indexOfRefraction();
                } else {
                    nextMaterial = currentMaterial;
                    nextMatTrans = currentMatTrans;
                    if (prevMaterial == first.getMaterialMapping()) {
                        oldMaterial = null;
                    } else {
                        oldMaterial = prevMaterial;
                        oldMatTrans = prevMatTrans;
                    }
                    n = 1.0;
                }
                beta = dot - Math.sqrt(n * n - 1.0 + dot * dot);
                temp.set(norm);
                temp.scale(-beta);
                temp.add(r.getDirection());
                temp.scale(1.0 / n);
            }
            if (Double.isNaN(beta)) {
                totalReflect = true;
            } else {
                double d3 = d = truedot > 0.0 ? temp.dot(trueNorm) : -temp.dot(trueNorm);
                if (d < 0.0) {
                    temp.x -= (d += 1.0E-12) * trueNorm.x;
                    temp.y -= d * trueNorm.y;
                    temp.z -= d * trueNorm.z;
                    temp.normalize();
                }
                rt.ray[treeDepth + 1].newID();
                int n2 = numRays = this.gloss && spec.cloudiness != 0.0 ? this.glossRays : 1;
                if (transmitted && this.transparentBackground) {
                    rt.transparency[treeDepth] = 0.0;
                }
                for (i = 0; i < numRays; ++i) {
                    rt.ray[treeDepth + 1].getDirection().set(temp);
                    if (this.gloss) {
                        this.randomizeDirection(rt.ray[treeDepth + 1].getDirection(), norm, rt.random, spec.cloudiness, rayNumber + treeDepth + 1);
                    }
                    this.spawnRay(rt, treeDepth + 1, nextNode, second, nextMaterial, oldMaterial, nextMatTrans, oldMatTrans, rayNumber, totalDist, transmitted, diffuse);
                    rt.color[treeDepth + 1].scale(1.0 / (double)numRays);
                    color.add(rt.color[treeDepth + 1]);
                    if (!transmitted || !this.transparentBackground) continue;
                    int n3 = treeDepth;
                    rt.transparency[n3] = rt.transparency[n3] + rt.transparency[treeDepth + 1] / (double)numRays;
                }
            }
        }
        if (spawnSpecular || totalReflect) {
            col.copy(spec.specular);
            col.scale(specularScale);
            if (totalReflect) {
                col.add(spec.transparent.getRed() * transmittedScale, spec.transparent.getGreen() * transmittedScale, spec.transparent.getBlue() * transmittedScale);
            }
            col.multiply(rayIntensity);
            temp = rt.ray[treeDepth].tempVec1;
            temp.set(norm);
            temp.scale(-2.0 * dot);
            temp.add(r.getDirection());
            double d4 = d = truedot > 0.0 ? temp.dot(trueNorm) : -temp.dot(trueNorm);
            if (d >= 0.0) {
                temp.x += (d += 1.0E-12) * trueNorm.x;
                temp.y += d * trueNorm.y;
                temp.z += d * trueNorm.z;
                temp.normalize();
            }
            rt.ray[treeDepth + 1].getOrigin().set(intersectionPoint);
            rt.ray[treeDepth + 1].newID();
            numRays = this.gloss && spec.roughness != 0.0 ? this.glossRays : 1;
            for (i = 0; i < numRays; ++i) {
                rt.ray[treeDepth + 1].getDirection().set(temp);
                if (this.gloss) {
                    this.randomizeDirection(rt.ray[treeDepth + 1].getDirection(), norm, rt.random, spec.roughness, rayNumber + treeDepth + 1 + i);
                }
                this.spawnRay(rt, treeDepth + 1, nextNode, null, currentMaterial, prevMaterial, currentMatTrans, prevMatTrans, rayNumber, totalDist, false, diffuse);
                rt.color[treeDepth + 1].scale(1.0 / (double)numRays);
                color.add(rt.color[treeDepth + 1]);
            }
        }
        if (spawnDiffuse) {
            numRays = diffuse ? 1 : this.diffuseRays;
            col.copy(spec.diffuse);
            col.multiply(rayIntensity);
            col.scale(diffuseScale);
            temp = rt.ray[treeDepth + 1].getDirection();
            for (i = 0; i < numRays; ++i) {
                do {
                    temp.set(0.0, 0.0, 0.0);
                    this.randomizePoint(temp, rt.random, 1.0, rayNumber + treeDepth + 1 + i);
                    temp.normalize();
                    d = temp.dot(trueNorm) * (truedot > 0.0 ? 1.0 : -1.0);
                } while (rt.random.nextDouble() > (d < 0.0 ? -d : d));
                if (d > 0.0) {
                    temp.scale(-1.0);
                }
                rt.ray[treeDepth + 1].getOrigin().set(intersectionPoint);
                rt.ray[treeDepth + 1].newID();
                this.spawnRay(rt, treeDepth + 1, nextNode, null, currentMaterial, prevMaterial, currentMatTrans, prevMatTrans, rayNumber, totalDist, false, true);
                rt.color[treeDepth + 1].scale(1.0f / (float)numRays);
                color.add(rt.color[treeDepth + 1]);
            }
        }
        return dist;
    }

    protected void getDirectLight(RaytracerContext rt, Vec3 pos, Vec3 normal, boolean front, Vec3 viewDir, int treeDepth, OctreeNode node, int rayNumber, double totalDist, MaterialMapping currentMaterial, MaterialMapping prevMaterial, Mat4 currentMatTrans, Mat4 prevMatTrans, boolean diffuse) {
        RGBColor lightColor = rt.color[treeDepth + 1];
        RGBColor finalColor = rt.color[treeDepth];
        TextureSpec spec = rt.surfSpec[treeDepth];
        Ray r = rt.ray[treeDepth + 1];
        finalColor.copy(this.ambColor);
        finalColor.multiply(spec.diffuse);
        finalColor.add(spec.emissive);
        if (this.giMode == 1 && diffuse) {
            return;
        }
        if (this.giMode == 4 && diffuse) {
            rt.globalMap.getLight(pos, spec, normal, viewDir, front, lightColor);
            finalColor.add(lightColor);
            return;
        }
        if (this.giMode == 3) {
            rt.globalMap.getLight(pos, spec, normal, viewDir, front, lightColor);
            finalColor.add(lightColor);
        }
        if (this.caustics) {
            rt.causticsMap.getLight(pos, spec, normal, viewDir, front, lightColor);
            finalColor.add(lightColor);
        }
        Vec3 dir = r.getDirection();
        double sign = front ? 1.0 : -1.0;
        boolean hilight = (double)spec.hilight.getRed() != 0.0 || (double)spec.hilight.getGreen() != 0.0 || (double)spec.hilight.getBlue() != 0.0;
        for (int i = this.light.length - 1; i >= 0; --i) {
            int numRays = this.light[i].getSoftShadows() ? this.shadowRays : 1;
            for (int j = 0; j < numRays; ++j) {
                Light lt = this.light[i].getLight();
                double distToLight = this.light[i].findRayToLight(pos, r, rayNumber + treeDepth + 1 + j);
                r.newID();
                double dot = lt.getType() == 2 ? 1.0 : sign * dir.dot(normal);
                if (!(dot > 0.0)) continue;
                lt.getLight(lightColor, this.light[i].getCoords().toLocal().times(pos));
                if (Math.abs((double)lightColor.getRed() * ((double)spec.diffuse.getRed() * dot + (double)spec.hilight.getRed())) < (double)this.minRayIntensity && Math.abs((double)lightColor.getGreen() * ((double)spec.diffuse.getGreen() * dot + (double)spec.hilight.getGreen())) < (double)this.minRayIntensity && Math.abs((double)lightColor.getBlue() * ((double)spec.diffuse.getBlue() * dot + (double)spec.hilight.getBlue())) < (double)this.minRayIntensity || lt.getType() != 2 && lt.getType() != 1 && !this.traceLightRay(r, lt, treeDepth + 1, node, this.lightNode[i], distToLight, totalDist, currentMaterial, prevMaterial, currentMatTrans, prevMatTrans)) continue;
                RGBColor tempColor = rt.tempColor;
                tempColor.copy(lightColor);
                tempColor.multiply(spec.diffuse);
                tempColor.scale(dot / (double)numRays);
                finalColor.add(tempColor);
                if (!hilight) continue;
                dir.subtract(viewDir);
                dir.normalize();
                dot = sign * dir.dot(normal);
                if (!(dot > 0.0)) continue;
                tempColor.copy(lightColor);
                tempColor.multiply(spec.hilight);
                tempColor.scale(FastMath.pow((double)dot, (int)((int)((1.0 - spec.roughness) * 128.0) + 1)) / (double)numRays);
                finalColor.add(tempColor);
            }
        }
    }

    protected OctreeNode traceRay(Ray r, OctreeNode node) {
        RTObject first = null;
        RTObject second = null;
        double firstDist = Double.MAX_VALUE;
        double secondDist = Double.MAX_VALUE;
        Vec3 intersectionPoint = r.rt.pos[this.maxRayDepth];
        while (first == null) {
            RTObject[] obj = node.getObjects();
            for (int i = obj.length - 1; i >= 0; --i) {
                SurfaceIntersection intersection = r.findIntersection(obj[i]);
                if (intersection == SurfaceIntersection.NO_INTERSECTION) continue;
                intersection.intersectionPoint(0, intersectionPoint);
                if (!node.contains(intersectionPoint)) continue;
                double dist = intersection.intersectionDist(0);
                if (dist < firstDist) {
                    secondDist = firstDist;
                    second = first;
                    firstDist = dist;
                    first = obj[i];
                    continue;
                }
                if (!(dist < secondDist)) continue;
                secondDist = dist;
                second = obj[i];
            }
            if (first != null || (node = node.findNextNode(r)) != null) continue;
            return null;
        }
        RayIntersection intersect = r.rt.intersect;
        intersect.first = first;
        intersect.dist = firstDist;
        intersect.second = secondDist - firstDist < 1.0E-12 ? second : null;
        return node;
    }

    protected boolean traceLightRay(Ray r, Light lt, int treeDepth, OctreeNode node, OctreeNode endNode, double distToLight, double totalDist, MaterialMapping currentMaterial, MaterialMapping prevMaterial, Mat4 currentMatTrans, Mat4 prevMatTrans) {
        int i;
        RGBColor lightColor = r.rt.color[treeDepth];
        RGBColor transColor = r.rt.surfSpec[treeDepth].transparent;
        Vec3 intersectionPoint = r.rt.pos[this.maxRayDepth];
        Vec3 trueNorm = r.rt.trueNormal[this.maxRayDepth];
        MaterialIntersection[] matChange = r.rt.matChange;
        int matCount = 0;
        do {
            RTObject[] obj = node.getObjects();
            block1: for (i = obj.length - 1; i >= 0; --i) {
                SurfaceIntersection intersection = r.findIntersection(obj[i]);
                if (intersection == SurfaceIntersection.NO_INTERSECTION) continue;
                int j = 0;
                while (true) {
                    double dist;
                    intersection.intersectionPoint(j, intersectionPoint);
                    if (node.contains(intersectionPoint) && (dist = intersection.intersectionDist(j)) < distToLight) {
                        intersection.trueNormal(trueNorm);
                        double angle = -trueNorm.dot(r.getDirection());
                        intersection.intersectionTransparency(j, transColor, angle, (totalDist + dist) * this.smoothScale, this.time);
                        lightColor.multiply(transColor);
                        if (lightColor.getRed() < this.minRayIntensity && lightColor.getGreen() < this.minRayIntensity && lightColor.getBlue() < this.minRayIntensity) {
                            return false;
                        }
                        MaterialMapping mat = obj[i].getMaterialMapping();
                        if (mat != null && mat.castsShadows()) {
                            if (matCount == matChange.length) {
                                r.rt.increaseMaterialChangeLength();
                                matChange = r.rt.matChange;
                            }
                            matChange[matCount].mat = mat;
                            matChange[matCount].toLocal = obj[i].toLocal();
                            matChange[matCount].dist = dist;
                            matChange[matCount].node = node;
                            matChange[matCount].entered = angle > 0.0 ^ j % 2 == 1;
                            ++matCount;
                        }
                    }
                    if (j >= intersection.numIntersections() - 1) continue block1;
                    ++j;
                }
            }
        } while (node != endNode && (node = node.findNextNode(r)) != null);
        if (currentMaterial == null && matCount == 0) {
            return true;
        }
        this.sortMaterialList(matChange, matCount);
        if (matCount == matChange.length) {
            r.rt.increaseMaterialChangeLength();
            matChange = r.rt.matChange;
        }
        matChange[matCount++].dist = distToLight;
        double dist = 0.0;
        i = 0;
        while (true) {
            double n1;
            if (currentMaterial != null && currentMaterial.castsShadows()) {
                this.propagateLightRay(r, node, dist, matChange[i].dist, currentMaterial, lightColor, currentMatTrans, totalDist);
                if (lightColor.getRed() < this.minRayIntensity && lightColor.getGreen() < this.minRayIntensity && lightColor.getBlue() < this.minRayIntensity) {
                    return false;
                }
            }
            if (i == matCount - 1) break;
            double d = n1 = currentMaterial == null ? 1.0 : currentMaterial.indexOfRefraction();
            if (matChange[i].entered) {
                if (matChange[i].mat != currentMaterial) {
                    prevMaterial = currentMaterial;
                    prevMatTrans = currentMatTrans;
                    currentMaterial = matChange[i].mat;
                    currentMatTrans = matChange[i].toLocal;
                }
            } else if (matChange[i].mat == currentMaterial) {
                currentMaterial = prevMaterial;
                currentMatTrans = prevMatTrans;
                prevMaterial = null;
            } else if (matChange[i].mat == prevMaterial) {
                prevMaterial = null;
            }
            if (this.caustics) {
                double n2;
                double d2 = n2 = currentMaterial == null ? 1.0 : currentMaterial.indexOfRefraction();
                if (n1 != n2) {
                    return false;
                }
            }
            node = matChange[i].node;
            dist = matChange[i].dist;
            ++i;
        }
        return true;
    }

    protected void propagateRay(Ray r, OctreeNode node, double dist, MaterialMapping material, MaterialMapping prevMaterial, Mat4 currentMatTrans, Mat4 prevMatTrans, RGBColor emitted, RGBColor filter, int treeDepth, double totalDist) {
        float be;
        float ge;
        float re;
        boolean scattering = material.isScattering();
        MaterialSpec matSpec = r.rt.matSpec;
        float rf = filter.getRed();
        float gf = filter.getGreen();
        float bf = filter.getBlue();
        if (material instanceof UniformMaterialMapping && !scattering) {
            material.getMaterialSpec(r.origin, matSpec, 0.0, this.time);
            RGBColor trans = matSpec.transparency;
            RGBColor blend = matSpec.color;
            float d = (float)dist;
            float rs = trans.getRed() == 1.0f ? 1.0f : (float)Math.pow(trans.getRed(), d);
            float gs = trans.getGreen() == 1.0f ? 1.0f : (float)Math.pow(trans.getGreen(), d);
            float bs = trans.getBlue() == 1.0f ? 1.0f : (float)Math.pow(trans.getBlue(), d);
            re = blend.getRed() * rf * (1.0f - rs);
            ge = blend.getGreen() * gf * (1.0f - gs);
            be = blend.getBlue() * bf * (1.0f - bs);
            rf *= rs;
            gf *= gs;
            bf *= bs;
        } else {
            Vec3 v = r.rt.ray[treeDepth + 1].origin;
            Vec3 origin = r.origin;
            Vec3 direction = r.direction;
            double x = 0.0;
            double distToScreen = this.theCamera.getDistToScreen();
            v.set(origin);
            currentMatTrans.transform(v);
            double origx = v.x;
            double origy = v.y;
            double origz = v.z;
            v.set(direction);
            currentMatTrans.transformDirection(v);
            double dirx = v.x;
            double diry = v.y;
            double dirz = v.z;
            be = 0.0f;
            ge = 0.0f;
            re = 0.0f;
            double step = this.stepSize * material.getStepSize();
            do {
                double newx;
                double dx = step * (1.5 * r.rt.random.nextDouble());
                if (this.adaptive && totalDist > distToScreen) {
                    dx *= totalDist / distToScreen;
                }
                if ((newx = x + dx) > dist) {
                    dx = dist - x;
                    x = dist;
                } else {
                    x = newx;
                }
                totalDist += dx;
                v.set(origx + dirx * x, origy + diry * x, origz + dirz * x);
                material.getMaterialSpec(v, matSpec, dx, this.time);
                RGBColor trans = matSpec.transparency;
                RGBColor blend = matSpec.color;
                float rs = trans.getRed() == 1.0f ? 1.0f : (float)Math.pow(trans.getRed(), dx);
                float gs = trans.getGreen() == 1.0f ? 1.0f : (float)Math.pow(trans.getGreen(), dx);
                float bs = trans.getBlue() == 1.0f ? 1.0f : (float)Math.pow(trans.getBlue(), dx);
                re += blend.getRed() * rf * (1.0f - rs);
                ge += blend.getGreen() * gf * (1.0f - gs);
                be += blend.getBlue() * bf * (1.0f - bs);
                if (scattering) {
                    RGBColor rayIntensity = r.rt.rayIntensity[treeDepth + 1];
                    rayIntensity.setRGB(rf, gf, bf);
                    rayIntensity.multiply(matSpec.scattering);
                    if (rayIntensity.getRed() > this.minRayIntensity || rayIntensity.getGreen() > this.minRayIntensity || rayIntensity.getBlue() > this.minRayIntensity) {
                        RGBColor color;
                        if (this.scatterMode == 0 || this.scatterMode == 2) {
                            v.set(origin.x + direction.x * x, origin.y + direction.y * x, origin.z + direction.z * x);
                            while (node != null && !node.contains(v)) {
                                node = node.findNextNode(r);
                            }
                            if (node == null) break;
                            this.getScatteredLight(r.rt, treeDepth + 1, node, matSpec.eccentricity, totalDist, material, prevMaterial, currentMatTrans, prevMatTrans);
                            color = r.rt.color[treeDepth + 1];
                            re += color.getRed() * (1.0f - rs);
                            ge += color.getGreen() * (1.0f - gs);
                            be += color.getBlue() * (1.0f - bs);
                        }
                        if (r.rt.volumeMap != null) {
                            color = r.rt.color[treeDepth + 1];
                            r.rt.volumeMap.getVolumeLight(v, matSpec, r.getDirection(), color);
                            color.multiply(rayIntensity);
                            re += color.getRed() * (1.0f - rs);
                            ge += color.getGreen() * (1.0f - gs);
                            be += color.getBlue() * (1.0f - bs);
                        }
                    }
                }
                rf *= rs;
                gf *= gs;
                bf *= bs;
                if (!(rf < this.minRayIntensity) || !(gf < this.minRayIntensity) || !(bf < this.minRayIntensity)) continue;
                bf = 0.0f;
                gf = 0.0f;
                rf = 0.0f;
                break;
            } while (x < dist);
        }
        emitted.setRGB(re, ge, be);
        filter.setRGB(rf, gf, bf);
    }

    protected void propagateLightRay(Ray r, OctreeNode node, double startDist, double endDist, MaterialMapping material, RGBColor filter, Mat4 toLocal, double totalDist) {
        float rf = filter.getRed();
        float gf = filter.getGreen();
        float bf = filter.getBlue();
        MaterialSpec matSpec = r.rt.matSpec;
        if (material instanceof UniformMaterialMapping) {
            material.getMaterialSpec(r.origin, matSpec, 0.0, this.time);
            RGBColor trans = matSpec.transparency;
            float d = (float)(endDist - startDist);
            if (trans.getRed() != 1.0f) {
                rf *= (float)Math.pow(trans.getRed(), d);
            }
            if (trans.getGreen() != 1.0f) {
                gf *= (float)Math.pow(trans.getGreen(), d);
            }
            if (trans.getBlue() != 1.0f) {
                bf *= (float)Math.pow(trans.getBlue(), d);
            }
        } else {
            Vec3 v = r.rt.ray[this.maxRayDepth].origin;
            double x = startDist;
            double distToScreen = this.theCamera.getDistToScreen();
            v.set(r.origin);
            toLocal.transform(v);
            double origx = v.x;
            double origy = v.y;
            double origz = v.z;
            v.set(r.direction);
            toLocal.transformDirection(v);
            double dirx = v.x;
            double diry = v.y;
            double dirz = v.z;
            double step = this.stepSize * material.getStepSize();
            do {
                double newx;
                double dx = step * (1.5 * r.rt.random.nextDouble());
                if (this.adaptive && totalDist > distToScreen) {
                    dx *= totalDist / distToScreen;
                }
                if ((newx = x + dx) > endDist) {
                    dx = endDist - x;
                    x = endDist;
                } else {
                    x = newx;
                }
                totalDist += dx;
                v.set(origx + dirx * x, origy + diry * x, origz + dirz * x);
                material.getMaterialSpec(v, matSpec, dx, this.time);
                RGBColor trans = matSpec.transparency;
                if (trans.getRed() != 1.0f) {
                    rf *= (float)Math.pow(trans.getRed(), dx);
                }
                if (trans.getGreen() != 1.0f) {
                    gf *= (float)Math.pow(trans.getGreen(), dx);
                }
                if (trans.getBlue() != 1.0f) {
                    bf *= (float)Math.pow(trans.getBlue(), dx);
                }
                if (!(rf < this.minRayIntensity) || !(gf < this.minRayIntensity) || !(bf < this.minRayIntensity)) continue;
                bf = 0.0f;
                gf = 0.0f;
                rf = 0.0f;
                break;
            } while (x < endDist);
        }
        filter.setRGB(rf, gf, bf);
    }

    protected void getScatteredLight(RaytracerContext rt, int treeDepth, OctreeNode node, double eccentricity, double totalDist, MaterialMapping currentMaterial, MaterialMapping prevMaterial, Mat4 currentMatTrans, Mat4 prevMatTrans) {
        RGBColor filter = rt.rayIntensity[treeDepth];
        RGBColor lightColor = rt.color[treeDepth];
        Ray r = rt.ray[treeDepth];
        Vec3 pos = r.origin;
        Vec3 viewDir = rt.ray[treeDepth - 1].direction;
        double ec2 = eccentricity * eccentricity;
        rt.tempColor2.setRGB(0.0f, 0.0f, 0.0f);
        Vec3 dir = r.getDirection();
        for (int i = this.light.length - 1; i >= 0; --i) {
            Light lt = this.light[i].getLight();
            double distToLight = this.light[i].findRayToLight(pos, r, -1);
            r.newID();
            lt.getLight(lightColor, this.light[i].getCoords().toLocal().times(pos));
            lightColor.multiply(filter);
            if (eccentricity != 0.0 && lt.getType() != 2) {
                double dot = dir.dot(viewDir);
                double fatt = (1.0 - ec2) / Math.pow(1.0 + ec2 - 2.0 * eccentricity * dot, 1.5);
                lightColor.scale(fatt);
            }
            if (lightColor.getRed() < this.minRayIntensity && lightColor.getGreen() < this.minRayIntensity && lightColor.getBlue() < this.minRayIntensity || lt.getType() != 2 && lt.getType() != 1 && !this.traceLightRay(r, lt, treeDepth, node, this.lightNode[i], distToLight, totalDist, currentMaterial, prevMaterial, currentMatTrans, prevMatTrans)) continue;
            rt.tempColor2.add(lightColor);
        }
        rt.color[treeDepth].copy(rt.tempColor2);
    }

    public void randomizePoint(Vec3 pos, Random random, double size, int number) {
        double z;
        double y;
        double x;
        if (size == 0.0) {
            return;
        }
        while ((x = random.nextDouble()) * x + (y = random.nextDouble()) * y + (z = random.nextDouble()) * z > 1.0) {
        }
        x *= size;
        y *= size;
        z *= size;
        int d = distrib1[number & 0xF];
        if (d < 2) {
            x *= -1.0;
        }
        if (d == 1 || d == 2) {
            y *= -1.0;
        }
        if ((distrib2[number & 0xF] & 1) == 0) {
            z *= -1.0;
        }
        pos.x += x;
        pos.y += y;
        pos.z += z;
    }

    public void randomizeDirection(Vec3 dir, Vec3 norm, Random random, double roughness, int number) {
        double z;
        double y;
        double x;
        if (roughness <= 0.0) {
            return;
        }
        while ((x = random.nextDouble()) * x + (y = random.nextDouble()) * y + (z = random.nextDouble()) * z > 1.0) {
        }
        double scale = Math.pow(roughness, 1.7) * 0.5;
        x *= scale;
        y *= scale;
        z *= scale;
        int d = distrib1[number & 0xF];
        if (d < 2) {
            x *= -1.0;
        }
        if (d == 1 || d == 2) {
            y *= -1.0;
        }
        if ((distrib2[number & 0xF] & 1) == 0) {
            z *= -1.0;
        }
        double dot1 = dir.dot(norm);
        dir.x += x;
        dir.y += y;
        dir.z += z;
        double dot2 = 2.0 * dir.dot(norm);
        if (dot1 < 0.0 && dot2 > 0.0) {
            dir.x -= dot2 * norm.x;
            dir.y -= dot2 * norm.y;
            dir.z -= dot2 * norm.z;
        } else if (dot1 > 0.0 && dot2 < 0.0) {
            dir.x += dot2 * norm.x;
            dir.y += dot2 * norm.y;
            dir.z += dot2 * norm.z;
        }
        dir.normalize();
    }

    protected void sortMaterialList(MaterialIntersection[] matChange, int count) {
        for (int i = 1; i < count; ++i) {
            for (int j = i; j > 0 && matChange[j].dist < matChange[j - 1].dist; --j) {
                MaterialIntersection temp = matChange[j - 1];
                matChange[j - 1] = matChange[j];
                matChange[j] = temp;
            }
        }
    }

    public static class MaterialIntersection {
        public MaterialMapping mat;
        public Mat4 toLocal;
        public double dist;
        public boolean entered;
        public OctreeNode node;
    }

    public static class RayIntersection {
        public RTObject first;
        public RTObject second;
        public double dist;
    }
}

