/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.raster;

import artofillusion.ArtOfIllusion;
import artofillusion.Camera;
import artofillusion.RenderListener;
import artofillusion.Renderer;
import artofillusion.RenderingMesh;
import artofillusion.RenderingTriangle;
import artofillusion.Scene;
import artofillusion.image.ComplexImage;
import artofillusion.material.UniformMaterialMapping;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.FastMath;
import artofillusion.math.Mat4;
import artofillusion.math.RGBColor;
import artofillusion.math.Vec2;
import artofillusion.math.Vec3;
import artofillusion.object.DirectionalLight;
import artofillusion.object.Light;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectCollection;
import artofillusion.object.ObjectInfo;
import artofillusion.object.ObjectWrapper;
import artofillusion.object.PointLight;
import artofillusion.object.SceneCamera;
import artofillusion.object.SpotLight;
import artofillusion.raster.CompositingContext;
import artofillusion.raster.Fragment;
import artofillusion.raster.MaterialFragment;
import artofillusion.raster.ObjectMaterialInfo;
import artofillusion.raster.OpaqueFragment;
import artofillusion.raster.RasterContext;
import artofillusion.raster.TransparentFragment;
import artofillusion.texture.ParameterValue;
import artofillusion.texture.TextureMapping;
import artofillusion.texture.TextureSpec;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.Translate;
import artofillusion.ui.UIUtilities;
import artofillusion.ui.ValueField;
import artofillusion.util.ThreadManager;
import buoy.event.ValueChangedEvent;
import buoy.event.WidgetEvent;
import buoy.widget.BCheckBox;
import buoy.widget.BComboBox;
import buoy.widget.FormContainer;
import buoy.widget.LayoutInfo;
import buoy.widget.Widget;
import buoy.widget.WindowWidget;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.image.MemoryImageSource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Raster
implements Renderer,
Runnable {
    private ObjectInfo[] light;
    private FormContainer configPanel;
    private BCheckBox transparentBox;
    private BCheckBox adaptiveBox;
    private BCheckBox hideBackfaceBox;
    private BCheckBox hdrBox;
    private BComboBox shadeChoice;
    private BComboBox aliasChoice;
    private BComboBox sampleChoice;
    private ValueField errorField;
    private ValueField smoothField;
    private int[] imagePixel;
    private int width;
    private int height;
    private int envMode;
    private int imageWidth;
    private int imageHeight;
    private int shadingMode = 2;
    private int samplesPerPixel = 1;
    private int subsample = 1;
    private Fragment[] fragment;
    private long updateTime;
    private MemoryImageSource imageSource;
    private Scene theScene;
    private Camera theCamera;
    private RenderListener listener;
    private Image img;
    private Thread renderThread;
    private RGBColor ambColor;
    private RGBColor envColor;
    private RGBColor fogColor;
    private TextureMapping envMapping;
    private ThreadLocal threadRasterContext = new ThreadLocal(){

        protected Object initialValue() {
            return new RasterContext(Raster.this.theCamera, Raster.this.width);
        }
    };
    private ThreadLocal threadCompositingContext = new ThreadLocal(){

        protected Object initialValue() {
            return new CompositingContext(Raster.this.theCamera);
        }
    };
    private RowLock[] lock;
    private double[] envParamValue;
    private double time;
    private double smoothing = 1.0;
    private double smoothScale;
    private double focalDist;
    private double surfaceError = 0.02;
    private double fogDist;
    private boolean fog;
    private boolean transparentBackground = false;
    private boolean adaptive = true;
    private boolean hideBackfaces = true;
    private boolean generateHDR = false;
    private boolean positionNeeded;
    private boolean depthNeeded;
    private boolean needCopyToUI = true;
    private boolean isPreview;
    public static final int GOURAUD = 0;
    public static final int HYBRID = 1;
    public static final int PHONG = 2;
    public static final double TOL = 1.0E-12;
    public static final float INTENSITY_CUTOFF = 0.005f;
    public static final Fragment BACKGROUND_FRAGMENT = new OpaqueFragment(0, Float.MAX_VALUE);
    private static final int WHITE_ERGB = new RGBColor(1.0f, 1.0f, 1.0f).getERGB();

    public String getName() {
        return "Raster";
    }

    public synchronized void renderScene(Scene theScene, Camera camera, RenderListener rl, SceneCamera sceneCamera) {
        if (this.renderThread != null && this.renderThread.isAlive()) {
            Thread oldRenderThread = this.renderThread;
            this.renderThread = null;
            try {
                oldRenderThread.join();
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
        }
        Dimension dim = camera.getSize();
        this.listener = rl;
        this.theScene = theScene;
        this.theCamera = camera.duplicate();
        if (sceneCamera == null) {
            sceneCamera = new SceneCamera();
            sceneCamera.setDepthOfField(0.0);
            sceneCamera.setFocalDistance(this.theCamera.getDistToScreen());
        }
        this.focalDist = sceneCamera.getFocalDistance();
        this.depthNeeded = (sceneCamera.getComponentsForFilters() & 0x10) != 0;
        this.time = theScene.getTime();
        if (this.imagePixel == null || this.imageWidth != dim.width || this.imageHeight != dim.height) {
            this.imageWidth = dim.width;
            this.imageHeight = dim.height;
            this.imagePixel = new int[this.imageWidth * this.imageHeight];
            this.imageSource = new MemoryImageSource(this.imageWidth, this.imageHeight, this.imagePixel, 0, this.imageWidth);
            this.imageSource.setAnimated(true);
            this.img = Toolkit.getDefaultToolkit().createImage(this.imageSource);
        }
        this.width = this.imageWidth * this.samplesPerPixel;
        this.height = this.imageHeight * this.samplesPerPixel;
        this.theCamera.setScreenTransform(sceneCamera.getScreenTransform(this.width, this.height), this.width, this.height);
        this.renderThread = new Thread((Runnable)this, "Raster Renderer Main Thread");
        this.renderThread.start();
    }

    public synchronized void cancelRendering(Scene sc) {
        Thread t = this.renderThread;
        RenderListener rl = this.listener;
        if (this.theScene != sc) {
            return;
        }
        this.renderThread = null;
        if (t == null) {
            return;
        }
        try {
            while (t.isAlive()) {
                Thread.sleep(100L);
            }
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        this.finish(null);
        rl.renderingCanceled();
    }

    public Widget getConfigPanel() {
        if (this.configPanel == null) {
            this.configPanel = new FormContainer(3, 5);
            LayoutInfo leftLayout = new LayoutInfo(LayoutInfo.EAST, LayoutInfo.NONE, new Insets(0, 0, 0, 5), null);
            LayoutInfo rightLayout = new LayoutInfo(LayoutInfo.WEST, LayoutInfo.NONE, null, null);
            this.configPanel.add((Widget)Translate.label((String)"surfaceAccuracy"), 0, 0, leftLayout);
            this.configPanel.add((Widget)Translate.label((String)"shadingMethod"), 0, 1, leftLayout);
            this.configPanel.add((Widget)Translate.label((String)"supersampling"), 0, 2, leftLayout);
            this.errorField = new ValueField(this.surfaceError, 3, 6);
            this.configPanel.add((Widget)this.errorField, 1, 0, rightLayout);
            this.shadeChoice = new BComboBox((Object[])new String[]{Translate.text((String)"gouraud"), Translate.text((String)"hybrid"), Translate.text((String)"phong")});
            this.configPanel.add((Widget)this.shadeChoice, 1, 1, rightLayout);
            this.aliasChoice = new BComboBox((Object[])new String[]{Translate.text((String)"none"), Translate.text((String)"Edges"), Translate.text((String)"Everything")});
            this.configPanel.add((Widget)this.aliasChoice, 1, 2, rightLayout);
            this.sampleChoice = new BComboBox((Object[])new String[]{"2x2", "3x3"});
            this.configPanel.add((Widget)this.sampleChoice, 2, 2, rightLayout);
            this.sampleChoice.setEnabled(false);
            this.transparentBox = new BCheckBox(Translate.text((String)"transparentBackground"), this.transparentBackground);
            this.configPanel.add((Widget)this.transparentBox, 0, 3, 3, 1);
            this.configPanel.add((Widget)Translate.button((String)"advanced", (Object)this, (String)"showAdvancedWindow"), 0, 4, 3, 1);
            this.smoothField = new ValueField(this.smoothing, 1);
            this.adaptiveBox = new BCheckBox(Translate.text((String)"reduceAccuracyForDistant"), this.adaptive);
            this.hideBackfaceBox = new BCheckBox(Translate.text((String)"eliminateBackfaces"), this.hideBackfaces);
            this.hdrBox = new BCheckBox(Translate.text((String)"generateHDR"), this.generateHDR);
            this.aliasChoice.addEventLink(ValueChangedEvent.class, new Object(){

                void processEvent() {
                    Raster.this.sampleChoice.setEnabled(Raster.this.aliasChoice.getSelectedIndex() > 0);
                }
            });
        }
        if (this.needCopyToUI) {
            this.copyConfigurationToUI();
        }
        return this.configPanel;
    }

    private void showAdvancedWindow(WidgetEvent ev) {
        this.smoothing = this.smoothField.getValue();
        this.adaptive = this.adaptiveBox.getState();
        this.hideBackfaces = this.hideBackfaceBox.getState();
        this.generateHDR = this.hdrBox.getState();
        WindowWidget parent = UIUtilities.findWindow((Widget)ev.getWidget());
        ComponentsDialog dlg = new ComponentsDialog(parent, Translate.text((String)"advancedOptions"), new Widget[]{this.smoothField, this.adaptiveBox, this.hideBackfaceBox, this.hdrBox}, new String[]{Translate.text((String)"texSmoothing"), null, null, null});
        if (!dlg.clickedOk()) {
            this.smoothField.setValue(this.smoothing);
            this.adaptiveBox.setState(this.adaptive);
            this.hideBackfaceBox.setState(this.hideBackfaces);
            this.hdrBox.setState(this.generateHDR);
        }
    }

    private void copyConfigurationToUI() {
        this.needCopyToUI = false;
        if (this.configPanel == null) {
            this.getConfigPanel();
        }
        this.smoothField.setValue(this.smoothing);
        this.adaptiveBox.setState(this.adaptive);
        this.hideBackfaceBox.setState(this.hideBackfaces);
        this.hdrBox.setState(this.generateHDR);
        this.errorField.setValue(this.surfaceError);
        this.shadeChoice.setSelectedIndex(this.shadingMode);
        this.transparentBox.setState(this.transparentBackground);
        if (this.samplesPerPixel == 1) {
            this.aliasChoice.setSelectedIndex(0);
        } else if (this.subsample == 1) {
            this.aliasChoice.setSelectedIndex(2);
            this.sampleChoice.setSelectedIndex(this.samplesPerPixel - 2);
        } else {
            this.aliasChoice.setSelectedIndex(1);
            this.sampleChoice.setSelectedIndex(this.samplesPerPixel - 2);
        }
        this.sampleChoice.setEnabled(this.aliasChoice.getSelectedIndex() > 0);
    }

    public boolean recordConfiguration() {
        this.smoothing = this.smoothField.getValue();
        this.adaptive = this.adaptiveBox.getState();
        this.hideBackfaces = this.hideBackfaceBox.getState();
        this.generateHDR = this.hdrBox.getState();
        this.surfaceError = this.errorField.getValue();
        this.shadingMode = this.shadeChoice.getSelectedIndex();
        this.transparentBackground = this.transparentBox.getState();
        if (this.aliasChoice.getSelectedIndex() == 0) {
            this.subsample = 1;
            this.samplesPerPixel = 1;
        } else if (this.aliasChoice.getSelectedIndex() == 1) {
            this.samplesPerPixel = this.subsample = this.sampleChoice.getSelectedIndex() + 2;
        } else {
            this.samplesPerPixel = this.sampleChoice.getSelectedIndex() + 2;
            this.subsample = 1;
        }
        this.isPreview = false;
        return true;
    }

    public Map<String, Object> getConfiguration() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("textureSmoothing", this.smoothing);
        map.put("reduceAccuracyForDistant", this.adaptive);
        map.put("hideBackfaces", this.hideBackfaces);
        map.put("highDynamicRange", this.generateHDR);
        map.put("maxSurfaceError", this.surfaceError);
        map.put("shadingMethod", this.shadingMode);
        map.put("transparentBackground", this.transparentBackground);
        int antialiasLevel = 0;
        if (this.samplesPerPixel == 2) {
            antialiasLevel = this.subsample;
        } else if (this.samplesPerPixel == 3) {
            antialiasLevel = this.subsample == 1 ? 3 : 4;
        }
        map.put("antialiasing", antialiasLevel);
        return map;
    }

    public void setConfiguration(String property, Object value) {
        this.needCopyToUI = true;
        this.isPreview = false;
        if ("textureSmoothing".equals(property)) {
            this.smoothing = ((Number)value).doubleValue();
        } else if ("reduceAccuracyForDistant".equals(property)) {
            this.adaptive = (Boolean)value;
        } else if ("hideBackfaces".equals(property)) {
            this.hideBackfaces = (Boolean)value;
        } else if ("highDynamicRange".equals(property)) {
            this.generateHDR = (Boolean)value;
        } else if ("maxSurfaceError".equals(property)) {
            this.surfaceError = ((Number)value).doubleValue();
        } else if ("shadingMethod".equals(property)) {
            this.shadingMode = (Integer)value;
        } else if ("transparentBackground".equals(property)) {
            this.transparentBackground = (Boolean)value;
        } else if ("antialiasing".equals(property)) {
            int antialiasLevel = (Integer)value;
            switch (antialiasLevel) {
                case 0: {
                    this.subsample = 1;
                    this.samplesPerPixel = 1;
                    break;
                }
                case 1: {
                    this.samplesPerPixel = 2;
                    this.subsample = 1;
                    break;
                }
                case 2: {
                    this.samplesPerPixel = 2;
                    this.subsample = 2;
                    break;
                }
                case 3: {
                    this.samplesPerPixel = 3;
                    this.subsample = 1;
                    break;
                }
                case 4: {
                    this.samplesPerPixel = 3;
                    this.subsample = 3;
                }
            }
        }
    }

    public void configurePreview() {
        if (this.needCopyToUI) {
            this.copyConfigurationToUI();
        }
        this.transparentBackground = false;
        this.smoothing = 1.0;
        this.hideBackfaces = true;
        this.adaptive = true;
        this.generateHDR = false;
        this.surfaceError = ArtOfIllusion.getPreferences().getInteractiveSurfaceError();
        this.shadingMode = 1;
        this.subsample = 1;
        this.samplesPerPixel = 1;
        this.isPreview = true;
    }

    void findLights() {
        int i;
        Vector<ObjectInfo> lt = new Vector<ObjectInfo>();
        this.positionNeeded = false;
        for (i = 0; i < this.theScene.getNumObjects(); ++i) {
            ObjectInfo info = this.theScene.getObject(i);
            if (!(info.getObject() instanceof Light) || !info.isVisible()) continue;
            lt.addElement(info);
        }
        this.light = new ObjectInfo[lt.size()];
        for (i = 0; i < this.light.length; ++i) {
            this.light[i] = (ObjectInfo)lt.elementAt(i);
            if (this.light[i].getObject() instanceof DirectionalLight) continue;
            this.positionNeeded = true;
        }
    }

    @Override
    public void run() {
        final Thread thisThread = Thread.currentThread();
        if (this.renderThread != thisThread) {
            return;
        }
        this.fragment = new Fragment[this.width * this.height];
        Arrays.fill(this.fragment, BACKGROUND_FRAGMENT);
        this.lock = new RowLock[this.height];
        for (int i = 0; i < this.lock.length; ++i) {
            this.lock[i] = new RowLock();
        }
        this.updateTime = System.currentTimeMillis();
        this.findLights();
        this.ambColor = this.theScene.getAmbientColor();
        this.envColor = this.theScene.getEnvironmentColor();
        this.envMapping = this.theScene.getEnvironmentMapping();
        this.envMode = this.theScene.getEnvironmentMode();
        this.fogColor = this.theScene.getFogColor();
        this.fog = this.theScene.getFogState();
        this.fogDist = this.theScene.getFogDistance();
        ParameterValue[] envParam = this.theScene.getEnvironmentParameterValues();
        this.envParamValue = new double[envParam.length];
        for (int i = 0; i < this.envParamValue.length; ++i) {
            this.envParamValue[i] = envParam[i].getAverageValue();
        }
        final Vec3 viewdir = this.theCamera.getViewToWorld().timesDirection(Vec3.vz());
        Point p = new Point(this.width / 2, this.height / 2);
        final Vec3 orig = this.theCamera.getCameraCoordinates().getOrigin();
        Vec3 center = this.theCamera.convertScreenToWorld(p, this.focalDist);
        ++p.x;
        Vec3 hvec = this.theCamera.convertScreenToWorld(p, this.focalDist).minus(center);
        --p.x;
        ++p.y;
        Vec3 vvec = this.theCamera.convertScreenToWorld(p, this.focalDist).minus(center);
        --p.y;
        this.smoothScale = this.smoothing * hvec.length() / this.focalDist;
        final ObjectInfo[] sortedObjects = this.sortObjects();
        ThreadManager threads = new ThreadManager(sortedObjects.length, new ThreadManager.Task(){

            public void execute(int index) {
                RasterContext context = (RasterContext)Raster.this.threadRasterContext.get();
                ObjectInfo obj = sortedObjects[index];
                context.camera.setObjectTransform(obj.getCoords().fromLocal());
                Raster.this.renderObject(obj, orig, viewdir, obj.getCoords().toLocal(), context, thisThread);
                if (thisThread != Raster.this.renderThread) {
                    return;
                }
                if (System.currentTimeMillis() - Raster.this.updateTime > 5000L) {
                    Raster.this.updateImage();
                }
            }

            public void cleanup() {
                ((RasterContext)Raster.this.threadRasterContext.get()).cleanup();
            }
        });
        threads.run();
        threads.finish();
        this.finish(this.createFinalImage(center, orig, hvec, vvec));
    }

    private ObjectInfo[] sortObjects() {
        class SortRecord
        implements Comparable {
            public ObjectInfo object;
            public double depth;
            public boolean isTransparent;

            SortRecord(ObjectInfo object) {
                this.object = object;
                this.depth = ((Raster)Raster.this).theCamera.getObjectToView().times((Vec3)object.getBounds().getCenter()).z;
                if (object.getObject().getTexture() != null) {
                    this.isTransparent = object.getObject().getTexture().hasComponent(2);
                }
            }

            public int compareTo(Object o) {
                SortRecord other = (SortRecord)o;
                if (this.isTransparent == other.isTransparent) {
                    if (this.depth < other.depth) {
                        return -1;
                    }
                    if (this.depth == other.depth) {
                        return 0;
                    }
                    return 1;
                }
                if (this.isTransparent) {
                    return 1;
                }
                return -1;
            }
        }
        ArrayList<SortRecord> objects = new ArrayList<SortRecord>();
        for (int i = 0; i < this.theScene.getNumObjects(); ++i) {
            ObjectInfo obj = this.theScene.getObject(i);
            this.theCamera.setObjectTransform(obj.getCoords().fromLocal());
            objects.add(new SortRecord(obj));
        }
        Collections.sort(objects);
        ObjectInfo[] result = new ObjectInfo[objects.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = ((SortRecord)objects.get((int)i)).object;
        }
        return result;
    }

    private synchronized void updateImage() {
        if (System.currentTimeMillis() - this.updateTime < 5000L) {
            return;
        }
        RGBColor frontColor = new RGBColor();
        int i1 = 0;
        int i2 = 0;
        while (i1 < this.imageHeight) {
            int j1 = 0;
            int j2 = 0;
            while (j1 < this.imageWidth) {
                this.fragment[i2 * this.width + j2].getAdditiveColor(frontColor);
                this.imagePixel[i1 * this.imageWidth + j1] = frontColor.getARGB();
                ++j1;
                j2 += this.samplesPerPixel;
            }
            ++i1;
            i2 += this.samplesPerPixel;
        }
        this.imageSource.newPixels();
        this.listener.imageUpdated(this.img);
        this.updateTime = System.currentTimeMillis();
    }

    private synchronized void updateFinalImage() {
        if (System.currentTimeMillis() - this.updateTime < 5000L) {
            return;
        }
        this.imageSource.newPixels();
        this.listener.imageUpdated(this.img);
        this.updateTime = System.currentTimeMillis();
    }

    private ComplexImage createFinalImage(final Vec3 center, final Vec3 orig, final Vec3 hvec, final Vec3 vvec) {
        final Thread thisThread = Thread.currentThread();
        if (this.renderThread != thisThread) {
            return null;
        }
        final int n = this.samplesPerPixel * this.samplesPerPixel;
        final float[][] hdrImage = this.generateHDR ? new float[3][this.imageWidth * this.imageHeight] : (float[][])null;
        ThreadManager threads = new ThreadManager(this.imageHeight, new ThreadManager.Task(){

            public void execute(int i1) {
                CompositingContext context = (CompositingContext)Raster.this.threadCompositingContext.get();
                Vec3 dir = context.tempVec[1];
                RGBColor totalColor = context.totalColor;
                RGBColor totalTransparency = context.totalTransparency;
                RGBColor addColor = context.addColor;
                RGBColor multColor = context.multColor;
                RGBColor subpixelColor = context.subpixelColor;
                RGBColor subpixelMult = context.subpixelMult;
                ArrayList<ObjectMaterialInfo> materialStack = context.materialStack;
                TextureSpec surfSpec = context.surfSpec;
                int i2 = i1 * Raster.this.samplesPerPixel;
                int j1 = 0;
                int j2 = 0;
                while (j1 < Raster.this.imageWidth) {
                    totalColor.setRGB(0.0f, 0.0f, 0.0f);
                    totalTransparency.setRGB(0.0f, 0.0f, 0.0f);
                    for (int k = 0; k < Raster.this.samplesPerPixel; ++k) {
                        int base = Raster.this.width * (i2 + k) + j2;
                        for (int m = 0; m < Raster.this.samplesPerPixel; ++m) {
                            subpixelColor.setRGB(0.0f, 0.0f, 0.0f);
                            subpixelMult.setRGB(1.0f, 1.0f, 1.0f);
                            Fragment f = Raster.this.fragment[base + m];
                            float lastDepth = 0.0f;
                            while (true) {
                                ObjectMaterialInfo fragmentMaterial = f.getMaterialMapping();
                                ObjectMaterialInfo currentMaterial = null;
                                if (materialStack.size() > 0) {
                                    currentMaterial = materialStack.get(materialStack.size() - 1);
                                }
                                Raster.this.adjustColorsForMaterial(currentMaterial, j2 + m, i2 + k, lastDepth, f.getDepth(), addColor, context.multColor, context);
                                addColor.multiply(subpixelMult);
                                subpixelColor.add(addColor);
                                subpixelMult.multiply(multColor);
                                if (fragmentMaterial != null) {
                                    if (f.isEntering()) {
                                        materialStack.add(fragmentMaterial);
                                    } else {
                                        materialStack.remove(fragmentMaterial);
                                    }
                                }
                                lastDepth = f.getDepth();
                                if (f == BACKGROUND_FRAGMENT) {
                                    if (Raster.this.transparentBackground) {
                                        addColor.setRGB(0.0f, 0.0f, 0.0f);
                                    } else if (Raster.this.envMode == 0) {
                                        addColor.copy(Raster.this.envColor);
                                    } else {
                                        double h = (double)(j2 + k) - (double)Raster.this.width / 2.0;
                                        double v = (double)(i2 + m) - (double)Raster.this.height / 2.0;
                                        dir.x = center.x + h * hvec.x + v * vvec.x;
                                        dir.y = center.y + h * hvec.y + v * vvec.y;
                                        dir.z = center.z + h * hvec.z + v * vvec.z;
                                        dir.subtract(orig);
                                        dir.normalize();
                                        Raster.this.envMapping.getTextureSpec(dir, surfSpec, 1.0, Raster.this.smoothScale, Raster.this.time, Raster.this.envParamValue);
                                        if (Raster.this.envMode == 1) {
                                            addColor.copy(surfSpec.diffuse);
                                        } else {
                                            addColor.copy(surfSpec.emissive);
                                        }
                                    }
                                } else {
                                    f.getAdditiveColor(addColor);
                                }
                                addColor.multiply(subpixelMult);
                                subpixelColor.add(addColor);
                                if (f.isOpaque()) {
                                    if (f == BACKGROUND_FRAGMENT && Raster.this.transparentBackground) break;
                                    subpixelMult.setRGB(0.0f, 0.0f, 0.0f);
                                    break;
                                }
                                f.getMultiplicativeColor(multColor);
                                subpixelMult.multiply(multColor);
                                f = f.getNextFragment();
                            }
                            totalColor.add(subpixelColor);
                            totalTransparency.add(subpixelMult);
                            materialStack.clear();
                        }
                    }
                    totalColor.scale(1.0f / (float)n);
                    totalTransparency.scale(1.0f / (float)n);
                    ((Raster)Raster.this).imagePixel[i1 * ((Raster)Raster.this).imageWidth + j1] = Raster.this.calcARGB(totalColor, totalTransparency);
                    if (Raster.this.generateHDR) {
                        hdrImage[0][i1 * ((Raster)Raster.this).imageWidth + j1] = totalColor.getRed();
                        hdrImage[1][i1 * ((Raster)Raster.this).imageWidth + j1] = totalColor.getGreen();
                        hdrImage[2][i1 * ((Raster)Raster.this).imageWidth + j1] = totalColor.getBlue();
                    }
                    ++j1;
                    j2 += Raster.this.samplesPerPixel;
                }
                if (Raster.this.renderThread != thisThread) {
                    return;
                }
                if (System.currentTimeMillis() - Raster.this.updateTime > 5000L) {
                    Raster.this.updateFinalImage();
                }
            }

            public void cleanup() {
                ((CompositingContext)Raster.this.threadCompositingContext.get()).cleanup();
            }
        });
        threads.run();
        threads.finish();
        this.imageSource.newPixels();
        ComplexImage image = new ComplexImage(this.img);
        if (this.generateHDR) {
            image.setComponentValues(4, hdrImage[0]);
            image.setComponentValues(2, hdrImage[1]);
            image.setComponentValues(1, hdrImage[2]);
        }
        if (this.depthNeeded) {
            float[] imageZbuffer = new float[this.imageWidth * this.imageHeight];
            int i1 = 0;
            int i2 = 0;
            while (i1 < this.imageHeight) {
                int j1 = 0;
                int j2 = 0;
                while (j1 < this.imageWidth) {
                    float minDepth = Float.MAX_VALUE;
                    for (int k = 0; k < this.samplesPerPixel; ++k) {
                        int base = this.width * (i2 + k) + j2;
                        for (int m = 0; m < this.samplesPerPixel; ++m) {
                            float z = this.fragment[base + m].getDepth();
                            if (!(z < minDepth)) continue;
                            minDepth = z;
                        }
                    }
                    imageZbuffer[i1 * this.imageWidth + j1] = minDepth;
                    ++j1;
                    j2 += this.samplesPerPixel;
                }
                ++i1;
                i2 += this.samplesPerPixel;
            }
            image.setComponentValues(16, imageZbuffer);
        }
        return image;
    }

    private void adjustColorsForMaterial(ObjectMaterialInfo material, int x, int y, float startDepth, float endDepth, RGBColor addColor, RGBColor multColor, CompositingContext context) {
        if (material == null) {
            if (this.fog) {
                float fract1 = (float)Math.exp((double)(startDepth - endDepth) / this.fogDist);
                float fract2 = 1.0f - fract1;
                multColor.setRGB(fract1, fract1, fract1);
                addColor.setRGB(fract1 * addColor.getRed() + fract2 * this.fogColor.getRed(), fract1 * addColor.getGreen() + fract2 * this.fogColor.getGreen(), fract1 * addColor.getBlue() + fract2 * this.fogColor.getBlue());
            } else {
                addColor.setRGB(0.0f, 0.0f, 0.0f);
                multColor.setRGB(1.0f, 1.0f, 1.0f);
            }
            return;
        }
        if (material.getMapping() instanceof UniformMaterialMapping) {
            material.getMapping().getMaterialSpec(context.tempVec[0], context.matSpec, 0.0, this.time);
            RGBColor trans = context.matSpec.transparency;
            RGBColor blend = context.matSpec.color;
            double dist = endDepth - startDepth;
            float rs = (float)Math.pow(trans.getRed(), dist);
            float gs = (float)Math.pow(trans.getGreen(), dist);
            float bs = (float)Math.pow(trans.getBlue(), dist);
            multColor.setRGB(rs, gs, bs);
            addColor.setRGB(rs * addColor.getRed() + (1.0f - rs) * blend.getRed(), gs * addColor.getGreen() + (1.0f - gs) * blend.getGreen(), bs * addColor.getBlue() + (1.0f - bs) * blend.getBlue());
            return;
        }
        Vec2 imagePos = new Vec2((double)x, (double)y);
        Vec3 startPoint = context.camera.convertScreenToWorld(imagePos, (double)startDepth, false);
        Vec3 endPoint = context.camera.convertScreenToWorld(imagePos, (double)endDepth, false);
        double distToPoint = context.camera.getCameraCoordinates().getOrigin().distance(startPoint);
        material.getToLocal().transform(startPoint);
        material.getToLocal().transform(endPoint);
        double dist = startPoint.distance(endPoint);
        double stepSize = material.getMapping().getStepSize();
        double distToScreen = context.camera.getDistToScreen();
        if (distToPoint > distToScreen) {
            stepSize *= distToPoint / distToScreen;
        }
        int steps = FastMath.ceil((double)(dist / stepSize));
        stepSize = dist / (double)steps;
        multColor.setRGB(1.0f, 1.0f, 1.0f);
        addColor.setRGB(0.0f, 0.0f, 0.0f);
        for (int i = 0; i < steps; ++i) {
            double fract2 = (0.5 + (double)i) / (double)steps;
            double fract1 = 1.0 - fract2;
            context.tempVec[0].set(fract1 * startPoint.x + fract2 * endPoint.x, fract1 * startPoint.y + fract2 * endPoint.y, fract1 * startPoint.z + fract2 * endPoint.z);
            material.getMapping().getMaterialSpec(context.tempVec[0], context.matSpec, stepSize, this.time);
            RGBColor trans = context.matSpec.transparency;
            RGBColor blend = context.matSpec.color;
            float rs = (float)Math.pow(trans.getRed(), stepSize);
            float gs = (float)Math.pow(trans.getGreen(), stepSize);
            float bs = (float)Math.pow(trans.getBlue(), stepSize);
            multColor.multiply(rs, gs, bs);
            addColor.setRGB(multColor.getRed() * addColor.getRed() + (1.0f - multColor.getRed()) * blend.getRed(), multColor.getGreen() * addColor.getGreen() + (1.0f - multColor.getGreen()) * blend.getGreen(), multColor.getBlue() * addColor.getBlue() + (1.0f - multColor.getBlue()) * blend.getBlue());
            if (!(multColor.getMaxComponent() < 0.005f)) continue;
            multColor.setRGB(0.0f, 0.0f, 0.0f);
            return;
        }
    }

    private void finish(ComplexImage finalImage) {
        this.light = null;
        this.theScene = null;
        this.theCamera = null;
        this.envMapping = null;
        this.img = null;
        this.imagePixel = null;
        this.fragment = null;
        RenderListener rl = this.listener;
        this.listener = null;
        this.renderThread = null;
        if (rl != null && finalImage != null) {
            rl.imageComplete(finalImage);
        }
    }

    private int calcARGB(RGBColor color, RGBColor transparency) {
        double t = (double)(transparency.getRed() + transparency.getGreen() + transparency.getBlue()) / 3.0;
        if (!this.transparentBackground || t <= 0.0) {
            return color.getARGB();
        }
        if (t >= 1.0) {
            return 0;
        }
        double scale = 255.0 / (1.0 - t);
        int a = (int)(255.0 * (1.0 - t));
        int r = (int)((double)color.getRed() * scale);
        int g = (int)((double)color.getGreen() * scale);
        int b = (int)((double)color.getBlue() * scale);
        if (r < 0) {
            r = 0;
        }
        if (r > 255) {
            r = 255;
        }
        if (g < 0) {
            g = 0;
        }
        if (g > 255) {
            g = 255;
        }
        if (b < 0) {
            b = 0;
        }
        if (b > 255) {
            b = 255;
        }
        return (a << 24) + (r << 16) + (g << 8) + b;
    }

    private void renderObject(ObjectInfo obj, Vec3 orig, Vec3 viewdir, Mat4 toLocal, RasterContext context, Thread mainThread) {
        RenderingMesh mesh;
        double distToScreen;
        double dist;
        if (mainThread != this.renderThread) {
            return;
        }
        if (!obj.isVisible()) {
            return;
        }
        Object3D theObject = obj.getObject();
        if (context.camera.visibility(obj.getBounds()) == 0) {
            return;
        }
        while (theObject instanceof ObjectWrapper) {
            theObject = ((ObjectWrapper)theObject).getWrappedObject();
        }
        if (theObject instanceof ObjectCollection) {
            Enumeration objects = ((ObjectCollection)theObject).getObjects(obj, false, this.theScene);
            Mat4 fromLocal = context.camera.getObjectToWorld();
            while (objects.hasMoreElements()) {
                ObjectInfo elem = (ObjectInfo)objects.nextElement();
                CoordinateSystem coords = elem.getCoords().duplicate();
                coords.transformCoordinates(fromLocal);
                context.camera.setObjectTransform(coords.fromLocal());
                this.renderObject(elem, orig, viewdir, coords.toLocal(), context, mainThread);
            }
            return;
        }
        double tol = this.adaptive ? ((dist = obj.getBounds().distanceToPoint(toLocal.times(orig))) < (distToScreen = context.camera.getDistToScreen()) ? this.surfaceError : this.surfaceError * dist / distToScreen) : this.surfaceError;
        RenderingMesh renderingMesh = mesh = this.isPreview ? obj.getPreviewMesh() : obj.getRenderingMesh(tol);
        if (mesh == null) {
            return;
        }
        if (mainThread != this.renderThread) {
            return;
        }
        viewdir = toLocal.timesDirection(viewdir);
        if (context.lightPosition == null) {
            context.lightPosition = new Vec3[this.light.length];
            context.lightDirection = new Vec3[this.light.length];
        }
        for (int i = this.light.length - 1; i >= 0; --i) {
            context.lightPosition[i] = toLocal.times(this.light[i].getCoords().getOrigin());
            if (this.light[i].getObject() instanceof PointLight) continue;
            context.lightDirection[i] = toLocal.timesDirection(this.light[i].getCoords().getZDirection());
        }
        boolean bumpMap = theObject.getTexture().hasComponent(5);
        boolean cullBackfaces = this.hideBackfaces && theObject.isClosed() && !theObject.getTexture().hasComponent(2);
        ObjectMaterialInfo material = null;
        if (theObject.getMaterialMapping() != null) {
            material = new ObjectMaterialInfo(theObject.getMaterialMapping(), toLocal);
        }
        if (theObject.getTexture().hasComponent(6)) {
            this.renderMeshDisplaced(mesh, viewdir, tol, cullBackfaces, bumpMap, material, context);
        } else if (this.shadingMode == 0) {
            this.renderMeshGouraud(mesh, viewdir, cullBackfaces, material, context);
        } else if (this.shadingMode == 1 && !bumpMap) {
            this.renderMeshHybrid(mesh, viewdir, cullBackfaces, material, context);
        } else {
            this.renderMeshPhong(mesh, viewdir, cullBackfaces, bumpMap, material, context);
        }
    }

    private void calcLight(Vec3 pos, Vec3 norm, Vec3 viewdir, Vec3 faceNorm, double roughness, RGBColor diffuse, RGBColor specular, RGBColor highlight, RasterContext context) {
        Vec3 reflectDir = context.tempVec[0];
        Vec3 lightDir = context.tempVec[1];
        double viewDot = viewdir.dot(norm);
        double faceDot = viewdir.dot(faceNorm);
        RGBColor outputColor = context.tempColor[0];
        if (diffuse != null) {
            diffuse.copy(this.ambColor);
        }
        if (highlight != null) {
            highlight.setRGB(0.0f, 0.0f, 0.0f);
        }
        if (specular != null) {
            if (this.envMode == 0) {
                specular.copy(this.envColor);
            } else {
                reflectDir.set(norm);
                reflectDir.scale(-2.0 * viewDot);
                reflectDir.add(viewdir);
                context.camera.getViewToWorld().transformDirection(reflectDir);
                this.envMapping.getTextureSpec(reflectDir, context.surfSpec2, 1.0, this.smoothScale, this.time, this.envParamValue);
                if (this.envMode == 1) {
                    specular.copy(context.surfSpec2.diffuse);
                } else {
                    specular.copy(context.surfSpec2.emissive);
                }
            }
        }
        if (viewDot < 0.0 && faceDot > 0.0) {
            viewDot = 1.0E-12;
        } else if (viewDot > 0.0 && faceDot < 0.0) {
            viewDot = -1.0E-12;
        }
        for (int i = this.light.length - 1; i >= 0; --i) {
            double distToLight;
            Light lt = (Light)this.light[i].getObject();
            Vec3 lightPos = context.lightPosition[i];
            if (lt instanceof PointLight) {
                lightDir.set(pos);
                lightDir.subtract(lightPos);
                distToLight = lightDir.length();
                lightDir.scale(1.0 / distToLight);
            } else if (lt instanceof SpotLight) {
                lightDir.set(pos);
                lightDir.subtract(lightPos);
                distToLight = lightDir.length();
                lightDir.scale(1.0 / distToLight);
            } else if (lt instanceof DirectionalLight) {
                lightDir.set(context.lightDirection[i]);
            }
            lt.getLight(outputColor, this.light[i].getCoords().toLocal().times(pos));
            if (lt.getType() == 2) {
                if (diffuse == null) continue;
                diffuse.add(outputColor.getRed(), outputColor.getGreen(), outputColor.getBlue());
                continue;
            }
            double lightDot = lightDir.dot(norm);
            if (lightDot >= 0.0 && viewDot <= 0.0 || lightDot <= 0.0 && viewDot >= 0.0) continue;
            if (diffuse != null) {
                float dot = (float)(lightDot < 0.0 ? -lightDot : lightDot);
                diffuse.add(outputColor.getRed() * dot, outputColor.getGreen() * dot, outputColor.getBlue() * dot);
            }
            if (highlight == null) continue;
            lightDir.add(viewdir);
            lightDir.normalize();
            double dot = lightDir.dot(norm);
            dot = dot < 0.0 ? -dot : dot;
            outputColor.scale(FastMath.pow((double)dot, (int)((int)((1.0 - roughness) * 128.0) + 1)));
            highlight.add(outputColor);
        }
    }

    private Fragment createFragment(int addColor, int multColor, float depth, ObjectMaterialInfo material, boolean isBackface) {
        if (multColor == 0) {
            return new OpaqueFragment(addColor, depth);
        }
        if (addColor == 0 && multColor == WHITE_ERGB && material == null) {
            return null;
        }
        if (material == null) {
            return new TransparentFragment(addColor, multColor, depth, BACKGROUND_FRAGMENT);
        }
        return new MaterialFragment(addColor, multColor, depth, BACKGROUND_FRAGMENT, material, !isBackface);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordRow(int row, int xstart, int xend, RasterContext context) {
        Fragment[] source = context.fragment;
        int indexBase = row * this.width;
        RowLock rowLock = this.lock[row];
        synchronized (rowLock) {
            for (int x = xstart; x < xend; ++x) {
                Fragment f = source[x];
                if (f == null) continue;
                int index = indexBase + x;
                Fragment current = this.fragment[index];
                this.fragment[index] = f.getDepth() < current.getDepth() ? f.insertNextFragment(current) : current.insertNextFragment(f);
            }
        }
    }

    private Vec3[] clipTriangle(Vec3 v1, Vec3 v2, Vec3 v3, float z1, float z2, float z3, float[] newz, double[] newu, double[] newv, RasterContext context) {
        Vec3 u4;
        Vec3 u3;
        Vec3 u2;
        Vec3 u1;
        double clip = context.camera.getClipDistance();
        boolean c1 = (double)z1 < clip;
        boolean c2 = (double)z2 < clip;
        boolean c3 = (double)z3 < clip;
        int clipCount = 0;
        if (c1) {
            ++clipCount;
        }
        if (c2) {
            ++clipCount;
        }
        if (c3) {
            ++clipCount;
        }
        if (clipCount == 2) {
            Vec3 u32;
            Vec3 u22;
            Vec3 u12;
            if (!c1) {
                u12 = v1;
                newz[0] = z1;
                newu[0] = 1.0;
                newv[0] = 0.0;
                double f2 = ((double)z1 - clip) / (double)(z1 - z2);
                double f1 = 1.0 - f2;
                u22 = new Vec3(f1 * v1.x + f2 * v2.x, f1 * v1.y + f2 * v2.y, f1 * v1.z + f2 * v2.z);
                newz[1] = (float)(f1 * (double)z1 + f2 * (double)z2);
                newu[1] = f1;
                newv[1] = f2;
                f2 = ((double)z1 - clip) / (double)(z1 - z3);
                f1 = 1.0 - f2;
                u32 = new Vec3(f1 * v1.x + f2 * v3.x, f1 * v1.y + f2 * v3.y, f1 * v1.z + f2 * v3.z);
                newz[2] = (float)(f1 * (double)z1 + f2 * (double)z3);
                newu[2] = f1;
                newv[2] = 0.0;
            } else if (!c2) {
                u22 = v2;
                newz[1] = z2;
                newu[1] = 0.0;
                newv[1] = 1.0;
                double f2 = ((double)z2 - clip) / (double)(z2 - z3);
                double f1 = 1.0 - f2;
                u32 = new Vec3(f1 * v2.x + f2 * v3.x, f1 * v2.y + f2 * v3.y, f1 * v2.z + f2 * v3.z);
                newz[2] = (float)(f1 * (double)z2 + f2 * (double)z3);
                newu[2] = 0.0;
                newv[2] = f1;
                f2 = ((double)z2 - clip) / (double)(z2 - z1);
                f1 = 1.0 - f2;
                u12 = new Vec3(f1 * v2.x + f2 * v1.x, f1 * v2.y + f2 * v1.y, f1 * v2.z + f2 * v1.z);
                newz[0] = (float)(f1 * (double)z2 + f2 * (double)z1);
                newu[0] = f2;
                newv[0] = f1;
            } else {
                u32 = v3;
                newz[2] = z3;
                newu[2] = 0.0;
                newv[2] = 0.0;
                double f2 = ((double)z3 - clip) / (double)(z3 - z1);
                double f1 = 1.0 - f2;
                u12 = new Vec3(f1 * v3.x + f2 * v1.x, f1 * v3.y + f2 * v1.y, f1 * v3.z + f2 * v1.z);
                newz[0] = (float)(f1 * (double)z3 + f2 * (double)z1);
                newu[0] = f2;
                newv[0] = 0.0;
                f2 = ((double)z3 - clip) / (double)(z3 - z2);
                f1 = 1.0 - f2;
                u22 = new Vec3(f1 * v3.x + f2 * v2.x, f1 * v3.y + f2 * v2.y, f1 * v3.z + f2 * v2.z);
                newz[1] = (float)(f1 * (double)z3 + f2 * (double)z2);
                newu[1] = 0.0;
                newv[1] = f2;
            }
            return new Vec3[]{u12, u22, u32};
        }
        if (c1) {
            u1 = v2;
            newz[0] = z2;
            newu[0] = 0.0;
            newv[0] = 1.0;
            u2 = v3;
            newz[1] = z3;
            newu[1] = 0.0;
            newv[1] = 0.0;
            double f1 = ((double)z2 - clip) / (double)(z2 - z1);
            double f2 = 1.0 - f1;
            u3 = new Vec3(f1 * v1.x + f2 * v2.x, f1 * v1.y + f2 * v2.y, f1 * v1.z + f2 * v2.z);
            newz[2] = (float)(f1 * (double)z1 + f2 * (double)z2);
            newu[2] = f1;
            newv[2] = f2;
            f1 = ((double)z3 - clip) / (double)(z3 - z1);
            f2 = 1.0 - f1;
            u4 = new Vec3(f1 * v1.x + f2 * v3.x, f1 * v1.y + f2 * v3.y, f1 * v1.z + f2 * v3.z);
            newz[3] = (float)(f1 * (double)z1 + f2 * (double)z3);
            newu[3] = f1;
            newv[3] = 0.0;
        } else if (c2) {
            u1 = v3;
            newz[0] = z3;
            newu[0] = 0.0;
            newv[0] = 0.0;
            u2 = v1;
            newz[1] = z1;
            newu[1] = 1.0;
            newv[1] = 0.0;
            double f1 = ((double)z3 - clip) / (double)(z3 - z2);
            double f2 = 1.0 - f1;
            u3 = new Vec3(f1 * v2.x + f2 * v3.x, f1 * v2.y + f2 * v3.y, f1 * v2.z + f2 * v3.z);
            newz[2] = (float)(f1 * (double)z2 + f2 * (double)z3);
            newu[2] = 0.0;
            newv[2] = f1;
            f1 = ((double)z1 - clip) / (double)(z1 - z2);
            f2 = 1.0 - f1;
            u4 = new Vec3(f1 * v2.x + f2 * v1.x, f1 * v2.y + f2 * v1.y, f1 * v2.z + f2 * v1.z);
            newz[3] = (float)(f1 * (double)z2 + f2 * (double)z1);
            newu[3] = f2;
            newv[3] = f1;
        } else {
            u1 = v1;
            newz[0] = z1;
            newu[0] = 1.0;
            newv[0] = 0.0;
            u2 = v2;
            newz[1] = z2;
            newu[1] = 0.0;
            newv[1] = 1.0;
            double f1 = ((double)z1 - clip) / (double)(z1 - z3);
            double f2 = 1.0 - f1;
            u3 = new Vec3(f1 * v3.x + f2 * v1.x, f1 * v3.y + f2 * v1.y, f1 * v3.z + f2 * v1.z);
            newz[2] = (float)(f1 * (double)z3 + f2 * (double)z1);
            newu[2] = f2;
            newv[2] = 0.0;
            f1 = ((double)z2 - clip) / (double)(z2 - z3);
            f2 = 1.0 - f1;
            u4 = new Vec3(f1 * v3.x + f2 * v2.x, f1 * v3.y + f2 * v2.y, f1 * v3.z + f2 * v2.z);
            newz[3] = (float)(f1 * (double)z3 + f2 * (double)z2);
            newu[3] = 0.0;
            newv[3] = f2;
        }
        return new Vec3[]{u1, u2, u3, u4};
    }

    private void renderMeshGouraud(RenderingMesh mesh, Vec3 viewdir, boolean cullBackfaces, ObjectMaterialInfo material, RasterContext context) {
        int i;
        Vec3[] vert = mesh.vert;
        Vec3[] norm = mesh.norm;
        Vec2[] pos = new Vec2[vert.length];
        float[] z = new float[vert.length];
        float clip = (float)context.camera.getClipDistance();
        float[] clipz = new float[4];
        double[] clipu = new double[4];
        double[] clipv = new double[4];
        double distToScreen = context.camera.getDistToScreen();
        double tol = this.smoothScale;
        RGBColor[] diffuse = new RGBColor[4];
        RGBColor[] specular = new RGBColor[4];
        RGBColor[] highlight = new RGBColor[4];
        Mat4 toView = context.camera.getObjectToView();
        Mat4 toScreen = context.camera.getObjectToScreen();
        for (i = 0; i < 4; ++i) {
            diffuse[i] = new RGBColor();
            specular[i] = new RGBColor();
            highlight[i] = new RGBColor();
        }
        for (i = vert.length - 1; i >= 0; --i) {
            pos[i] = toScreen.timesXY(vert[i]);
            z[i] = (float)toView.timesZ(vert[i]);
        }
        for (i = mesh.triangle.length - 1; i >= 0; --i) {
            RenderingTriangle tri = mesh.triangle[i];
            int v1 = tri.v1;
            int v2 = tri.v2;
            int v3 = tri.v3;
            int n1 = tri.n1;
            int n2 = tri.n2;
            int n3 = tri.n3;
            if (z[v1] < clip && z[v2] < clip && z[v3] < clip) continue;
            boolean backface = (pos[v2].x - pos[v1].x) * (pos[v3].y - pos[v1].y) - (pos[v2].y - pos[v1].y) * (pos[v3].x - pos[v1].x) > 0.0;
            double viewdot = viewdir.dot(mesh.faceNorm[i]);
            if (z[v1] < clip || z[v2] < clip || z[v3] < clip) {
                Vec3[] clipPos = this.clipTriangle(vert[v1], vert[v2], vert[v3], z[v1], z[v2], z[v3], clipz, clipu, clipv, context);
                Vec2[] clipPos2D = new Vec2[clipPos.length];
                for (int j = clipPos.length - 1; j >= 0; --j) {
                    clipPos2D[j] = toScreen.timesXY(clipPos[j]);
                    double u = clipu[j];
                    double v = clipv[j];
                    double w = 1.0 - u - v;
                    tri.getTextureSpec(context.surfSpec, viewdot, u, v, 1.0 - u - v, tol, this.time);
                    context.tempVec[2].set(norm[n1].x * u + norm[n2].x * v + norm[n3].x * w, norm[n1].y * u + norm[n2].y * v + norm[n3].y * w, norm[n1].z * u + norm[n2].z * v + norm[n3].z * w);
                    context.tempVec[2].normalize();
                    this.calcLight(clipPos[j], context.tempVec[2], viewdir, mesh.faceNorm[i], context.surfSpec.roughness, diffuse[j], specular[j], highlight[j], context);
                    specular[j].add(highlight[j]);
                }
                this.renderTriangleGouraud(clipPos2D[0], clipz[0], clipu[0], clipv[0], diffuse[0], specular[0], clipPos2D[1], clipz[1], clipu[1], clipv[1], diffuse[1], specular[1], clipPos2D[2], clipz[2], clipu[2], clipv[2], diffuse[2], specular[2], tri, clip, viewdot, backface, material, context);
                if (clipPos.length != 4) continue;
                this.renderTriangleGouraud(clipPos2D[1], clipz[1], clipu[1], clipv[1], diffuse[1], specular[1], clipPos2D[2], clipz[2], clipu[2], clipv[2], diffuse[2], specular[2], clipPos2D[3], clipz[3], clipu[3], clipv[3], diffuse[3], specular[3], tri, clip, viewdot, backface, material, context);
                continue;
            }
            if (cullBackfaces && backface) continue;
            if ((double)z[v1] > distToScreen) {
                tol = this.smoothScale * (double)z[v1];
            }
            tri.getTextureSpec(context.surfSpec, viewdot, 1.0, 0.0, 0.0, tol, this.time);
            this.calcLight(vert[v1], norm[n1], viewdir, mesh.faceNorm[i], context.surfSpec.roughness, diffuse[0], specular[0], highlight[0], context);
            specular[0].add(highlight[0]);
            if ((double)z[v2] > distToScreen) {
                tol = this.smoothScale * (double)z[v2];
            }
            tri.getTextureSpec(context.surfSpec, viewdot, 0.0, 1.0, 0.0, tol, this.time);
            this.calcLight(vert[v2], norm[n2], viewdir, mesh.faceNorm[i], context.surfSpec.roughness, diffuse[1], specular[1], highlight[1], context);
            specular[1].add(highlight[1]);
            if ((double)z[v3] > distToScreen) {
                tol = this.smoothScale * (double)z[v3];
            }
            tri.getTextureSpec(context.surfSpec, viewdot, 0.0, 0.0, 1.0, tol, this.time);
            this.calcLight(vert[v3], norm[n3], viewdir, mesh.faceNorm[i], context.surfSpec.roughness, diffuse[2], specular[2], highlight[2], context);
            specular[2].add(highlight[2]);
            this.renderTriangleGouraud(pos[v1], z[v1], 1.0, 0.0, diffuse[0], specular[0], pos[v2], z[v2], 0.0, 1.0, diffuse[1], specular[1], pos[v3], z[v3], 0.0, 0.0, diffuse[2], specular[2], tri, clip, viewdot, backface, material, context);
        }
    }

    private void renderTriangleGouraud(Vec2 pos1, float zf1, double uf1, double vf1, RGBColor diffuse1, RGBColor specular1, Vec2 pos2, float zf2, double uf2, double vf2, RGBColor diffuse2, RGBColor specular2, Vec2 pos3, float zf3, double uf3, double vf3, RGBColor diffuse3, RGBColor specular3, RenderingTriangle tri, double clip, double viewdot, boolean isBackface, ObjectMaterialInfo material, RasterContext context) {
        double wl;
        double vl;
        double ul;
        float zl;
        int i;
        boolean repeat;
        float dspecblue;
        float specblue;
        float dspecgreen;
        float specgreen;
        float dspecred;
        float specred;
        float ddifblue;
        float difblue;
        float ddifgreen;
        float difgreen;
        float ddifred;
        float difred;
        double dv;
        double v;
        double du;
        double u;
        float dz;
        float z;
        int right;
        int left;
        int index;
        int yend;
        float mspecblue2;
        float mspecgreen2;
        float mspecred2;
        float mdifblue2;
        float mdifgreen2;
        float mdifred2;
        double mv2;
        double mu2;
        float mz2;
        double mx2;
        float specblueend;
        float specgreenend;
        float specredend;
        float difblueend;
        float difgreenend;
        float difredend;
        double vend;
        double uend;
        float zend;
        double xend;
        RGBColor spec3;
        RGBColor dif3;
        double v3;
        double u3;
        float z3;
        double y3;
        double x3;
        RGBColor spec2;
        RGBColor dif2;
        double v2;
        double u2;
        float z2;
        double y2;
        double x2;
        RGBColor spec1;
        RGBColor dif1;
        double v1;
        double u1;
        float z1;
        double y1;
        double x1;
        int lastAddColor = 0;
        int lastMultColor = 0;
        boolean doSubsample = this.subsample > 1;
        TextureSpec surfSpec = context.surfSpec;
        if (pos1.y <= pos2.y && pos1.y <= pos3.y) {
            x1 = pos1.x;
            y1 = pos1.y;
            z1 = zf1;
            u1 = uf1;
            v1 = vf1;
            dif1 = diffuse1;
            spec1 = specular1;
            if (pos2.y < pos3.y) {
                x2 = pos2.x;
                y2 = pos2.y;
                z2 = zf2;
                u2 = uf2;
                v2 = vf2;
                dif2 = diffuse2;
                spec2 = specular2;
                x3 = pos3.x;
                y3 = pos3.y;
                z3 = zf3;
                u3 = uf3;
                v3 = vf3;
                dif3 = diffuse3;
                spec3 = specular3;
            } else {
                x2 = pos3.x;
                y2 = pos3.y;
                z2 = zf3;
                u2 = uf3;
                v2 = vf3;
                dif2 = diffuse3;
                spec2 = specular3;
                x3 = pos2.x;
                y3 = pos2.y;
                z3 = zf2;
                u3 = uf2;
                v3 = vf2;
                dif3 = diffuse2;
                spec3 = specular2;
            }
        } else if (pos2.y <= pos1.y && pos2.y <= pos3.y) {
            x1 = pos2.x;
            y1 = pos2.y;
            z1 = zf2;
            u1 = uf2;
            v1 = vf2;
            dif1 = diffuse2;
            spec1 = specular2;
            if (pos1.y < pos3.y) {
                x2 = pos1.x;
                y2 = pos1.y;
                z2 = zf1;
                u2 = uf1;
                v2 = vf1;
                dif2 = diffuse1;
                spec2 = specular1;
                x3 = pos3.x;
                y3 = pos3.y;
                z3 = zf3;
                u3 = uf3;
                v3 = vf3;
                dif3 = diffuse3;
                spec3 = specular3;
            } else {
                x2 = pos3.x;
                y2 = pos3.y;
                z2 = zf3;
                u2 = uf3;
                v2 = vf3;
                dif2 = diffuse3;
                spec2 = specular3;
                x3 = pos1.x;
                y3 = pos1.y;
                z3 = zf1;
                u3 = uf1;
                v3 = vf1;
                dif3 = diffuse1;
                spec3 = specular1;
            }
        } else {
            x1 = pos3.x;
            y1 = pos3.y;
            z1 = zf3;
            u1 = uf3;
            v1 = vf3;
            dif1 = diffuse3;
            spec1 = specular3;
            if (pos1.y < pos2.y) {
                x2 = pos1.x;
                y2 = pos1.y;
                z2 = zf1;
                u2 = uf1;
                v2 = vf1;
                dif2 = diffuse1;
                spec2 = specular1;
                x3 = pos2.x;
                y3 = pos2.y;
                z3 = zf2;
                u3 = uf2;
                v3 = vf2;
                dif3 = diffuse2;
                spec3 = specular2;
            } else {
                x2 = pos2.x;
                y2 = pos2.y;
                z2 = zf2;
                u2 = uf2;
                v2 = vf2;
                dif2 = diffuse2;
                spec2 = specular2;
                x3 = pos1.x;
                y3 = pos1.y;
                z3 = zf1;
                u3 = uf1;
                v3 = vf1;
                dif3 = diffuse1;
                spec3 = specular1;
            }
        }
        x1 = FastMath.round((double)x1);
        y1 = FastMath.round((double)y1);
        x2 = FastMath.round((double)x2);
        y2 = FastMath.round((double)y2);
        x3 = FastMath.round((double)x3);
        y3 = FastMath.round((double)y3);
        z1 = 1.0f / z1;
        u1 *= (double)z1;
        v1 *= (double)z1;
        z2 = 1.0f / z2;
        u2 *= (double)z2;
        v2 *= (double)z2;
        z3 = 1.0f / z3;
        u3 *= (double)z3;
        v3 *= (double)z3;
        double dx1 = x3 - x1;
        double dy1 = y3 - y1;
        float dz1 = z3 - z1;
        if (dy1 == 0.0) {
            return;
        }
        double du1 = u3 - u1;
        double dv1 = v3 - v1;
        float ddifred1 = dif3.getRed() - dif1.getRed();
        float ddifgreen1 = dif3.getGreen() - dif1.getGreen();
        float ddifblue1 = dif3.getBlue() - dif1.getBlue();
        float dspecred1 = spec3.getRed() - spec1.getRed();
        float dspecgreen1 = spec3.getGreen() - spec1.getGreen();
        float dspecblue1 = spec3.getBlue() - spec1.getBlue();
        double dx2 = x2 - x1;
        double dy2 = y2 - y1;
        float dz2 = z2 - z1;
        double du2 = u2 - u1;
        double dv2 = v2 - v1;
        float ddifred2 = dif2.getRed() - dif1.getRed();
        float ddifgreen2 = dif2.getGreen() - dif1.getGreen();
        float ddifblue2 = dif2.getBlue() - dif1.getBlue();
        float dspecred2 = spec2.getRed() - spec1.getRed();
        float dspecgreen2 = spec2.getGreen() - spec1.getGreen();
        float dspecblue2 = spec2.getBlue() - spec1.getBlue();
        float denom = (float)(1.0 / dy1);
        double mx1 = dx1 * (double)denom;
        float mz1 = dz1 * denom;
        double mu1 = du1 * (double)denom;
        double mv1 = dv1 * (double)denom;
        float mdifred1 = ddifred1 * denom;
        float mdifgreen1 = ddifgreen1 * denom;
        float mdifblue1 = ddifblue1 * denom;
        float mspecred1 = dspecred1 * denom;
        float mspecgreen1 = dspecgreen1 * denom;
        float mspecblue1 = dspecblue1 * denom;
        double xstart = xend = x1;
        float zstart = zend = z1;
        double ustart = uend = u1;
        double vstart = vend = v1;
        float difredstart = difredend = dif1.getRed();
        float difgreenstart = difgreenend = dif1.getGreen();
        float difbluestart = difblueend = dif1.getBlue();
        float specredstart = specredend = spec1.getRed();
        float specgreenstart = specgreenend = spec1.getGreen();
        float specbluestart = specblueend = spec1.getBlue();
        int y = FastMath.round((double)y1);
        if (dy2 > 0.0) {
            denom = (float)(1.0 / dy2);
            mx2 = dx2 * (double)denom;
            mz2 = dz2 * denom;
            mu2 = du2 * (double)denom;
            mv2 = dv2 * (double)denom;
            mdifred2 = ddifred2 * denom;
            mdifgreen2 = ddifgreen2 * denom;
            mdifblue2 = ddifblue2 * denom;
            mspecred2 = dspecred2 * denom;
            mspecgreen2 = dspecgreen2 * denom;
            mspecblue2 = dspecblue2 * denom;
            if (y2 < 0.0) {
                xstart += mx1 * dy2;
                xend += mx2 * dy2;
                zstart = (float)((double)zstart + (double)mz1 * dy2);
                zend = (float)((double)zend + (double)mz2 * dy2);
                ustart += mu1 * dy2;
                uend += mu2 * dy2;
                vstart += mv1 * dy2;
                vend += mv2 * dy2;
                difredstart = (float)((double)difredstart + (double)mdifred1 * dy2);
                difredend = (float)((double)difredend + (double)mdifred2 * dy2);
                difgreenstart = (float)((double)difgreenstart + (double)mdifgreen1 * dy2);
                difgreenend = (float)((double)difgreenend + (double)mdifgreen2 * dy2);
                difbluestart = (float)((double)difbluestart + (double)mdifblue1 * dy2);
                difblueend = (float)((double)difblueend + (double)mdifblue2 * dy2);
                specredstart = (float)((double)specredstart + (double)mspecred1 * dy2);
                specredend = (float)((double)specredend + (double)mspecred2 * dy2);
                specgreenstart = (float)((double)specgreenstart + (double)mspecgreen1 * dy2);
                specgreenend = (float)((double)specgreenend + (double)mspecgreen2 * dy2);
                specbluestart = (float)((double)specbluestart + (double)mspecblue1 * dy2);
                specblueend = (float)((double)specblueend + (double)mspecblue2 * dy2);
                y = FastMath.round((double)y2);
            } else if (y < 0) {
                xstart -= mx1 * (double)y;
                xend -= mx2 * (double)y;
                zstart -= mz1 * (float)y;
                zend -= mz2 * (float)y;
                ustart -= mu1 * (double)y;
                uend -= mu2 * (double)y;
                vstart -= mv1 * (double)y;
                vend -= mv2 * (double)y;
                difredstart -= mdifred1 * (float)y;
                difredend -= mdifred2 * (float)y;
                difgreenstart -= mdifgreen1 * (float)y;
                difgreenend -= mdifgreen2 * (float)y;
                difbluestart -= mdifblue1 * (float)y;
                difblueend -= mdifblue2 * (float)y;
                specredstart -= mspecred1 * (float)y;
                specredend -= mspecred2 * (float)y;
                specgreenstart -= mspecgreen1 * (float)y;
                specgreenend -= mspecgreen2 * (float)y;
                specbluestart -= mspecblue1 * (float)y;
                specblueend -= mspecblue2 * (float)y;
                y = 0;
            }
            yend = FastMath.round((double)y2);
            if (yend > this.height) {
                yend = this.height;
            }
            index = y * this.width;
            while (y < yend) {
                if (xstart < xend) {
                    left = FastMath.round((double)xstart);
                    right = FastMath.round((double)xend);
                    z = zstart;
                    dz = zend - zstart;
                    u = ustart;
                    du = uend - ustart;
                    v = vstart;
                    dv = vend - vstart;
                    difred = difredstart;
                    ddifred = difredend - difredstart;
                    difgreen = difgreenstart;
                    ddifgreen = difgreenend - difgreenstart;
                    difblue = difbluestart;
                    ddifblue = difblueend - difbluestart;
                    specred = specredstart;
                    dspecred = specredend - specredstart;
                    specgreen = specgreenstart;
                    dspecgreen = specgreenend - specgreenstart;
                    specblue = specbluestart;
                    dspecblue = specblueend - specbluestart;
                } else {
                    left = FastMath.round((double)xend);
                    right = FastMath.round((double)xstart);
                    z = zend;
                    dz = zstart - zend;
                    u = uend;
                    du = ustart - uend;
                    v = vend;
                    dv = vstart - vend;
                    difred = difredend;
                    ddifred = difredstart - difredend;
                    difgreen = difgreenend;
                    ddifgreen = difgreenstart - difgreenend;
                    difblue = difblueend;
                    ddifblue = difbluestart - difblueend;
                    specred = specredend;
                    dspecred = specredstart - specredend;
                    specgreen = specgreenend;
                    dspecgreen = specgreenstart - specgreenend;
                    specblue = specblueend;
                    dspecblue = specbluestart - specblueend;
                }
                if (left != right) {
                    denom = xend == xstart ? 1.0f : (xend > xstart ? (float)(1.0 / (xend - xstart)) : (float)(1.0 / (xstart - xend)));
                    dz *= denom;
                    du *= (double)denom;
                    dv *= (double)denom;
                    ddifred *= denom;
                    ddifgreen *= denom;
                    ddifblue *= denom;
                    dspecred *= denom;
                    dspecgreen *= denom;
                    dspecblue *= denom;
                    if (left < 0) {
                        z -= dz * (float)left;
                        u -= du * (double)left;
                        v -= dv * (double)left;
                        difred -= ddifred * (float)left;
                        difgreen -= ddifgreen * (float)left;
                        difblue -= ddifblue * (float)left;
                        specred -= dspecred * (float)left;
                        specgreen -= dspecgreen * (float)left;
                        specblue -= dspecblue * (float)left;
                        left = 0;
                    }
                    if (right > this.width) {
                        right = this.width;
                    }
                    repeat = false;
                    for (i = left; i < right; ++i) {
                        zl = 1.0f / z;
                        if (zl < this.fragment[index + i].getOpaqueDepth() && (double)zl > clip) {
                            if (!repeat || i % this.subsample == 0) {
                                ul = u * (double)zl;
                                vl = v * (double)zl;
                                wl = 1.0 - ul - vl;
                                tri.getTextureSpec(surfSpec, viewdot, ul, vl, wl, this.smoothScale * (double)z, this.time);
                                context.tempColor[0].setRGB(surfSpec.diffuse.getRed() * difred + surfSpec.hilight.getRed() * specred + surfSpec.emissive.getRed(), surfSpec.diffuse.getGreen() * difgreen + surfSpec.hilight.getGreen() * specgreen + surfSpec.emissive.getGreen(), surfSpec.diffuse.getBlue() * difblue + surfSpec.hilight.getBlue() * specblue + surfSpec.emissive.getBlue());
                                lastAddColor = context.tempColor[0].getERGB();
                                lastMultColor = surfSpec.transparent.getERGB();
                            }
                            context.fragment[i] = this.createFragment(lastAddColor, lastMultColor, zl, material, isBackface);
                            repeat = doSubsample;
                        } else {
                            context.fragment[i] = null;
                            repeat = false;
                        }
                        z += dz;
                        u += du;
                        v += dv;
                        difred += ddifred;
                        difgreen += ddifgreen;
                        difblue += ddifblue;
                        specred += dspecred;
                        specgreen += dspecgreen;
                        specblue += dspecblue;
                    }
                    this.recordRow(y, left, right, context);
                }
                xstart += mx1;
                zstart += mz1;
                ustart += mu1;
                vstart += mv1;
                difredstart += mdifred1;
                difgreenstart += mdifgreen1;
                difbluestart += mdifblue1;
                specredstart += mspecred1;
                specgreenstart += mspecgreen1;
                specbluestart += mspecblue1;
                xend += mx2;
                zend += mz2;
                uend += mu2;
                vend += mv2;
                difredend += mdifred2;
                difgreenend += mdifgreen2;
                difblueend += mdifblue2;
                specredend += mspecred2;
                specgreenend += mspecgreen2;
                specblueend += mspecblue2;
                index += this.width;
                ++y;
            }
        }
        dx2 = x3 - x2;
        dy2 = y3 - y2;
        dz2 = z3 - z2;
        du2 = u3 - u2;
        dv2 = v3 - v2;
        ddifred2 = dif3.getRed() - dif2.getRed();
        ddifgreen2 = dif3.getGreen() - dif2.getGreen();
        ddifblue2 = dif3.getBlue() - dif2.getBlue();
        dspecred2 = spec3.getRed() - spec2.getRed();
        dspecgreen2 = spec3.getGreen() - spec2.getGreen();
        dspecblue2 = spec3.getBlue() - spec2.getBlue();
        if (dy2 > 0.0) {
            denom = (float)(1.0 / dy2);
            mx2 = dx2 * (double)denom;
            mz2 = dz2 * denom;
            mu2 = du2 * (double)denom;
            mv2 = dv2 * (double)denom;
            mdifred2 = ddifred2 * denom;
            mdifgreen2 = ddifgreen2 * denom;
            mdifblue2 = ddifblue2 * denom;
            mspecred2 = dspecred2 * denom;
            mspecgreen2 = dspecgreen2 * denom;
            mspecblue2 = dspecblue2 * denom;
            xend = x2;
            zend = z2;
            uend = u2;
            vend = v2;
            difredend = dif2.getRed();
            difgreenend = dif2.getGreen();
            difblueend = dif2.getBlue();
            specredend = spec2.getRed();
            specgreenend = spec2.getGreen();
            specblueend = spec2.getBlue();
            if (y < 0) {
                xstart -= mx1 * (double)y;
                xend -= mx2 * (double)y;
                zstart -= mz1 * (float)y;
                zend -= mz2 * (float)y;
                ustart -= mu1 * (double)y;
                uend -= mu2 * (double)y;
                vstart -= mv1 * (double)y;
                vend -= mv2 * (double)y;
                difredstart -= mdifred1 * (float)y;
                difredend -= mdifred2 * (float)y;
                difgreenstart -= mdifgreen1 * (float)y;
                difgreenend -= mdifgreen2 * (float)y;
                difbluestart -= mdifblue1 * (float)y;
                difblueend -= mdifblue2 * (float)y;
                specredstart -= mspecred1 * (float)y;
                specredend -= mspecred2 * (float)y;
                specgreenstart -= mspecgreen1 * (float)y;
                specgreenend -= mspecgreen2 * (float)y;
                specbluestart -= mspecblue1 * (float)y;
                specblueend -= mspecblue2 * (float)y;
                y = 0;
            }
            yend = FastMath.round((double)(y3 < (double)this.height ? y3 : (double)this.height));
            index = y * this.width;
            while (y < yend) {
                if (xstart < xend) {
                    left = FastMath.round((double)xstart);
                    right = FastMath.round((double)xend);
                    z = zstart;
                    dz = zend - zstart;
                    u = ustart;
                    du = uend - ustart;
                    v = vstart;
                    dv = vend - vstart;
                    difred = difredstart;
                    ddifred = difredend - difredstart;
                    difgreen = difgreenstart;
                    ddifgreen = difgreenend - difgreenstart;
                    difblue = difbluestart;
                    ddifblue = difblueend - difbluestart;
                    specred = specredstart;
                    dspecred = specredend - specredstart;
                    specgreen = specgreenstart;
                    dspecgreen = specgreenend - specgreenstart;
                    specblue = specbluestart;
                    dspecblue = specblueend - specbluestart;
                } else {
                    left = FastMath.round((double)xend);
                    right = FastMath.round((double)xstart);
                    z = zend;
                    dz = zstart - zend;
                    u = uend;
                    du = ustart - uend;
                    v = vend;
                    dv = vstart - vend;
                    difred = difredend;
                    ddifred = difredstart - difredend;
                    difgreen = difgreenend;
                    ddifgreen = difgreenstart - difgreenend;
                    difblue = difblueend;
                    ddifblue = difbluestart - difblueend;
                    specred = specredend;
                    dspecred = specredstart - specredend;
                    specgreen = specgreenend;
                    dspecgreen = specgreenstart - specgreenend;
                    specblue = specblueend;
                    dspecblue = specbluestart - specblueend;
                }
                if (left != right) {
                    denom = xend == xstart ? 1.0f : (xend > xstart ? (float)(1.0 / (xend - xstart)) : (float)(1.0 / (xstart - xend)));
                    dz *= denom;
                    du *= (double)denom;
                    dv *= (double)denom;
                    ddifred *= denom;
                    ddifgreen *= denom;
                    ddifblue *= denom;
                    dspecred *= denom;
                    dspecgreen *= denom;
                    dspecblue *= denom;
                    if (left < 0) {
                        z -= dz * (float)left;
                        u -= du * (double)left;
                        v -= dv * (double)left;
                        difred -= ddifred * (float)left;
                        difgreen -= ddifgreen * (float)left;
                        difblue -= ddifblue * (float)left;
                        specred -= dspecred * (float)left;
                        specgreen -= dspecgreen * (float)left;
                        specblue -= dspecblue * (float)left;
                        left = 0;
                    }
                    if (right > this.width) {
                        right = this.width;
                    }
                    repeat = false;
                    for (i = left; i < right; ++i) {
                        zl = 1.0f / z;
                        if (zl < this.fragment[index + i].getOpaqueDepth() && (double)zl > clip) {
                            if (!repeat || i % this.subsample == 0) {
                                ul = u * (double)zl;
                                vl = v * (double)zl;
                                wl = 1.0 - ul - vl;
                                tri.getTextureSpec(surfSpec, viewdot, ul, vl, wl, this.smoothScale * (double)z, this.time);
                                context.tempColor[0].setRGB(surfSpec.diffuse.getRed() * difred + surfSpec.hilight.getRed() * specred + surfSpec.emissive.getRed(), surfSpec.diffuse.getGreen() * difgreen + surfSpec.hilight.getGreen() * specgreen + surfSpec.emissive.getGreen(), surfSpec.diffuse.getBlue() * difblue + surfSpec.hilight.getBlue() * specblue + surfSpec.emissive.getBlue());
                                lastAddColor = context.tempColor[0].getERGB();
                                lastMultColor = surfSpec.transparent.getERGB();
                            }
                            context.fragment[i] = this.createFragment(lastAddColor, lastMultColor, zl, material, isBackface);
                            repeat = doSubsample;
                        } else {
                            context.fragment[i] = null;
                            repeat = false;
                        }
                        z += dz;
                        u += du;
                        v += dv;
                        difred += ddifred;
                        difgreen += ddifgreen;
                        difblue += ddifblue;
                        specred += dspecred;
                        specgreen += dspecgreen;
                        specblue += dspecblue;
                    }
                    this.recordRow(y, left, right, context);
                }
                xstart += mx1;
                zstart += mz1;
                ustart += mu1;
                vstart += mv1;
                difredstart += mdifred1;
                difgreenstart += mdifgreen1;
                difbluestart += mdifblue1;
                specredstart += mspecred1;
                specgreenstart += mspecgreen1;
                specbluestart += mspecblue1;
                xend += mx2;
                zend += mz2;
                uend += mu2;
                vend += mv2;
                difredend += mdifred2;
                difgreenend += mdifgreen2;
                difblueend += mdifblue2;
                specredend += mspecred2;
                specgreenend += mspecgreen2;
                specblueend += mspecblue2;
                index += this.width;
                ++y;
            }
        }
    }

    private void renderMeshHybrid(RenderingMesh mesh, Vec3 viewdir, boolean cullBackfaces, ObjectMaterialInfo material, RasterContext context) {
        int i;
        Vec3[] vert = mesh.vert;
        Vec3[] norm = mesh.norm;
        Vec3[] clipNorm = new Vec3[4];
        Vec2[] pos = new Vec2[vert.length];
        float[] z = new float[vert.length];
        float clip = (float)context.camera.getClipDistance();
        float[] clipz = new float[4];
        double[] clipu = new double[4];
        double[] clipv = new double[4];
        double distToScreen = context.camera.getDistToScreen();
        double tol = this.smoothScale;
        RGBColor[] diffuse = new RGBColor[4];
        Mat4 toView = context.camera.getObjectToView();
        Mat4 toScreen = context.camera.getObjectToScreen();
        for (i = 0; i < 4; ++i) {
            diffuse[i] = new RGBColor();
            clipNorm[i] = new Vec3();
        }
        for (i = vert.length - 1; i >= 0; --i) {
            pos[i] = toScreen.timesXY(vert[i]);
            z[i] = (float)toView.timesZ(vert[i]);
        }
        for (i = mesh.triangle.length - 1; i >= 0; --i) {
            RenderingTriangle tri = mesh.triangle[i];
            int v1 = tri.v1;
            int v2 = tri.v2;
            int v3 = tri.v3;
            int n1 = tri.n1;
            int n2 = tri.n2;
            int n3 = tri.n3;
            if (z[v1] < clip && z[v2] < clip && z[v3] < clip) continue;
            boolean backface = (pos[v2].x - pos[v1].x) * (pos[v3].y - pos[v1].y) - (pos[v2].y - pos[v1].y) * (pos[v3].x - pos[v1].x) > 0.0;
            double viewdot = viewdir.dot(mesh.faceNorm[i]);
            if (z[v1] < clip || z[v2] < clip || z[v3] < clip) {
                Vec3[] clipPos = this.clipTriangle(vert[v1], vert[v2], vert[v3], z[v1], z[v2], z[v3], clipz, clipu, clipv, context);
                Vec2[] clipPos2D = new Vec2[clipPos.length];
                for (int j = clipPos.length - 1; j >= 0; --j) {
                    clipPos2D[j] = toScreen.timesXY(clipPos[j]);
                    double u = clipu[j];
                    double v = clipv[j];
                    double w = 1.0 - u - v;
                    tri.getTextureSpec(context.surfSpec, viewdot, u, v, 1.0 - u - v, tol, this.time);
                    clipNorm[j].set(norm[n1].x * u + norm[n2].x * v + norm[n3].x * w, norm[n1].y * u + norm[n2].y * v + norm[n3].y * w, norm[n1].z * u + norm[n2].z * v + norm[n3].z * w);
                    clipNorm[j].normalize();
                    this.calcLight(clipPos[j], context.tempVec[2], viewdir, mesh.faceNorm[i], context.surfSpec.roughness, diffuse[j], null, null, context);
                }
                this.renderTriangleHybrid(clipPos2D[0], clipz[0], clipPos[0], clipNorm[0], clipu[0], clipv[0], diffuse[0], clipPos2D[1], clipz[1], clipPos[1], clipNorm[1], clipu[1], clipv[1], diffuse[1], clipPos2D[2], clipz[2], clipPos[2], clipNorm[2], clipu[2], clipv[2], diffuse[2], tri, viewdir, mesh.faceNorm[i], clip, viewdot, backface, material, context);
                if (clipPos.length != 4) continue;
                this.renderTriangleHybrid(clipPos2D[1], clipz[1], clipPos[1], clipNorm[1], clipu[1], clipv[1], diffuse[1], clipPos2D[2], clipz[2], clipPos[2], clipNorm[2], clipu[2], clipv[2], diffuse[2], clipPos2D[3], clipz[3], clipPos[3], clipNorm[3], clipu[3], clipv[3], diffuse[3], tri, viewdir, mesh.faceNorm[i], clip, viewdot, backface, material, context);
                continue;
            }
            if (cullBackfaces && backface) continue;
            if ((double)z[v1] > distToScreen) {
                tol = this.smoothScale * (double)z[v1];
            }
            tri.getTextureSpec(context.surfSpec, viewdot, 1.0, 0.0, 0.0, tol, this.time);
            this.calcLight(vert[v1], norm[n1], viewdir, mesh.faceNorm[i], context.surfSpec.roughness, diffuse[0], null, null, context);
            if ((double)z[v2] > distToScreen) {
                tol = this.smoothScale * (double)z[v2];
            }
            tri.getTextureSpec(context.surfSpec, viewdot, 0.0, 1.0, 0.0, tol, this.time);
            this.calcLight(vert[v2], norm[n2], viewdir, mesh.faceNorm[i], context.surfSpec.roughness, diffuse[1], null, null, context);
            if ((double)z[v3] > distToScreen) {
                tol = this.smoothScale * (double)z[v3];
            }
            tri.getTextureSpec(context.surfSpec, viewdot, 0.0, 0.0, 1.0, tol, this.time);
            this.calcLight(vert[v3], norm[n3], viewdir, mesh.faceNorm[i], context.surfSpec.roughness, diffuse[2], null, null, context);
            this.renderTriangleHybrid(pos[v1], z[v1], vert[v1], norm[n1], 1.0, 0.0, diffuse[0], pos[v2], z[v2], vert[v2], norm[n2], 0.0, 1.0, diffuse[1], pos[v3], z[v3], vert[v3], norm[n3], 0.0, 0.0, diffuse[2], tri, viewdir, mesh.faceNorm[i], clip, viewdot, backface, material, context);
        }
    }

    private void renderTriangleHybrid(Vec2 pos1, float zf1, Vec3 vert1, Vec3 normf1, double uf1, double vf1, RGBColor diffuse1, Vec2 pos2, float zf2, Vec3 vert2, Vec3 normf2, double uf2, double vf2, RGBColor diffuse2, Vec2 pos3, float zf3, Vec3 vert3, Vec3 normf3, double uf3, double vf3, RGBColor diffuse3, RenderingTriangle tri, Vec3 viewdir, Vec3 faceNorm, double clip, double viewdot, boolean isBackface, ObjectMaterialInfo material, RasterContext context) {
        double wl;
        double vl;
        double ul;
        float zl;
        int i;
        boolean repeat;
        double dnormz;
        double normz;
        double dnormy;
        double normy;
        double dnormx;
        double normx;
        float ddifblue;
        float difblue;
        float ddifgreen;
        float difgreen;
        float ddifred;
        float difred;
        double dv;
        double v;
        double du;
        double u;
        float dz;
        float z;
        int right;
        int left;
        int index;
        int yend;
        double mnormz2;
        double mnormy2;
        double mnormx2;
        float mdifblue2;
        float mdifgreen2;
        float mdifred2;
        double mv2;
        double mu2;
        float mz2;
        double mx2;
        double normzend;
        double normyend;
        double normxend;
        float difblueend;
        float difgreenend;
        float difredend;
        double vend;
        double uend;
        float zend;
        double xend;
        Vec3 norm3;
        RGBColor dif3;
        double v3;
        double u3;
        float z3;
        double y3;
        double x3;
        Vec3 norm2;
        RGBColor dif2;
        double v2;
        double u2;
        float z2;
        double y2;
        double x2;
        Vec3 norm1;
        RGBColor dif1;
        double v1;
        double u1;
        float z1;
        double y1;
        double x1;
        RGBColor specular = context.tempColor[1];
        RGBColor highlight = context.tempColor[2];
        int lastAddColor = 0;
        int lastMultColor = 0;
        boolean doSubsample = this.subsample > 1;
        TextureSpec surfSpec = context.surfSpec;
        if (pos1.y <= pos2.y && pos1.y <= pos3.y) {
            x1 = pos1.x;
            y1 = pos1.y;
            z1 = zf1;
            u1 = uf1;
            v1 = vf1;
            dif1 = diffuse1;
            norm1 = normf1;
            if (pos2.y < pos3.y) {
                x2 = pos2.x;
                y2 = pos2.y;
                z2 = zf2;
                u2 = uf2;
                v2 = vf2;
                dif2 = diffuse2;
                norm2 = normf2;
                x3 = pos3.x;
                y3 = pos3.y;
                z3 = zf3;
                u3 = uf3;
                v3 = vf3;
                dif3 = diffuse3;
                norm3 = normf3;
            } else {
                x2 = pos3.x;
                y2 = pos3.y;
                z2 = zf3;
                u2 = uf3;
                v2 = vf3;
                dif2 = diffuse3;
                norm2 = normf3;
                x3 = pos2.x;
                y3 = pos2.y;
                z3 = zf2;
                u3 = uf2;
                v3 = vf2;
                dif3 = diffuse2;
                norm3 = normf2;
            }
        } else if (pos2.y <= pos1.y && pos2.y <= pos3.y) {
            x1 = pos2.x;
            y1 = pos2.y;
            z1 = zf2;
            u1 = uf2;
            v1 = vf2;
            dif1 = diffuse2;
            norm1 = normf2;
            if (pos1.y < pos3.y) {
                x2 = pos1.x;
                y2 = pos1.y;
                z2 = zf1;
                u2 = uf1;
                v2 = vf1;
                dif2 = diffuse1;
                norm2 = normf1;
                x3 = pos3.x;
                y3 = pos3.y;
                z3 = zf3;
                u3 = uf3;
                v3 = vf3;
                dif3 = diffuse3;
                norm3 = normf3;
            } else {
                x2 = pos3.x;
                y2 = pos3.y;
                z2 = zf3;
                u2 = uf3;
                v2 = vf3;
                dif2 = diffuse3;
                norm2 = normf3;
                x3 = pos1.x;
                y3 = pos1.y;
                z3 = zf1;
                u3 = uf1;
                v3 = vf1;
                dif3 = diffuse1;
                norm3 = normf1;
            }
        } else {
            x1 = pos3.x;
            y1 = pos3.y;
            z1 = zf3;
            u1 = uf3;
            v1 = vf3;
            dif1 = diffuse3;
            norm1 = normf3;
            if (pos1.y < pos2.y) {
                x2 = pos1.x;
                y2 = pos1.y;
                z2 = zf1;
                u2 = uf1;
                v2 = vf1;
                dif2 = diffuse1;
                norm2 = normf1;
                x3 = pos2.x;
                y3 = pos2.y;
                z3 = zf2;
                u3 = uf2;
                v3 = vf2;
                dif3 = diffuse2;
                norm3 = normf2;
            } else {
                x2 = pos2.x;
                y2 = pos2.y;
                z2 = zf2;
                u2 = uf2;
                v2 = vf2;
                dif2 = diffuse2;
                norm2 = normf2;
                x3 = pos1.x;
                y3 = pos1.y;
                z3 = zf1;
                u3 = uf1;
                v3 = vf1;
                dif3 = diffuse1;
                norm3 = normf1;
            }
        }
        x1 = FastMath.round((double)x1);
        y1 = FastMath.round((double)y1);
        x2 = FastMath.round((double)x2);
        y2 = FastMath.round((double)y2);
        x3 = FastMath.round((double)x3);
        y3 = FastMath.round((double)y3);
        z1 = 1.0f / z1;
        u1 *= (double)z1;
        v1 *= (double)z1;
        z2 = 1.0f / z2;
        u2 *= (double)z2;
        v2 *= (double)z2;
        z3 = 1.0f / z3;
        u3 *= (double)z3;
        v3 *= (double)z3;
        double dx1 = x3 - x1;
        double dy1 = y3 - y1;
        float dz1 = z3 - z1;
        if (dy1 == 0.0) {
            return;
        }
        double du1 = u3 - u1;
        double dv1 = v3 - v1;
        float ddifred1 = dif3.getRed() - dif1.getRed();
        float ddifgreen1 = dif3.getGreen() - dif1.getGreen();
        float ddifblue1 = dif3.getBlue() - dif1.getBlue();
        double dnormx1 = norm3.x - norm1.x;
        double dnormy1 = norm3.y - norm1.y;
        double dnormz1 = norm3.z - norm1.z;
        double dx2 = x2 - x1;
        double dy2 = y2 - y1;
        float dz2 = z2 - z1;
        double du2 = u2 - u1;
        double dv2 = v2 - v1;
        float ddifred2 = dif2.getRed() - dif1.getRed();
        float ddifgreen2 = dif2.getGreen() - dif1.getGreen();
        float ddifblue2 = dif2.getBlue() - dif1.getBlue();
        double dnormx2 = norm2.x - norm1.x;
        double dnormy2 = norm2.y - norm1.y;
        double dnormz2 = norm2.z - norm1.z;
        float denom = (float)(1.0 / dy1);
        double mx1 = dx1 * (double)denom;
        float mz1 = dz1 * denom;
        double mu1 = du1 * (double)denom;
        double mv1 = dv1 * (double)denom;
        float mdifred1 = ddifred1 * denom;
        float mdifgreen1 = ddifgreen1 * denom;
        float mdifblue1 = ddifblue1 * denom;
        double mnormx1 = dnormx1 * (double)denom;
        double mnormy1 = dnormy1 * (double)denom;
        double mnormz1 = dnormz1 * (double)denom;
        double xstart = xend = x1;
        float zstart = zend = z1;
        double ustart = uend = u1;
        double vstart = vend = v1;
        float difredstart = difredend = dif1.getRed();
        float difgreenstart = difgreenend = dif1.getGreen();
        float difbluestart = difblueend = dif1.getBlue();
        double normxstart = normxend = norm1.x;
        double normystart = normyend = norm1.y;
        double normzstart = normzend = norm1.z;
        int y = FastMath.round((double)y1);
        if (dy2 > 0.0) {
            denom = (float)(1.0 / dy2);
            mx2 = dx2 * (double)denom;
            mz2 = dz2 * denom;
            mu2 = du2 * (double)denom;
            mv2 = dv2 * (double)denom;
            mdifred2 = ddifred2 * denom;
            mdifgreen2 = ddifgreen2 * denom;
            mdifblue2 = ddifblue2 * denom;
            mnormx2 = dnormx2 * (double)denom;
            mnormy2 = dnormy2 * (double)denom;
            mnormz2 = dnormz2 * (double)denom;
            if (y2 < 0.0) {
                xstart += mx1 * dy2;
                xend += mx2 * dy2;
                zstart = (float)((double)zstart + (double)mz1 * dy2);
                zend = (float)((double)zend + (double)mz2 * dy2);
                ustart += mu1 * dy2;
                uend += mu2 * dy2;
                vstart += mv1 * dy2;
                vend += mv2 * dy2;
                difredstart = (float)((double)difredstart + (double)mdifred1 * dy2);
                difredend = (float)((double)difredend + (double)mdifred2 * dy2);
                difgreenstart = (float)((double)difgreenstart + (double)mdifgreen1 * dy2);
                difgreenend = (float)((double)difgreenend + (double)mdifgreen2 * dy2);
                difbluestart = (float)((double)difbluestart + (double)mdifblue1 * dy2);
                difblueend = (float)((double)difblueend + (double)mdifblue2 * dy2);
                normxstart += mnormx1 * dy2;
                normxend += mnormx2 * dy2;
                normystart += mnormy1 * dy2;
                normyend += mnormy2 * dy2;
                normzstart += mnormz1 * dy2;
                normzend += mnormz2 * dy2;
                y = FastMath.round((double)y2);
            } else if (y < 0) {
                xstart -= mx1 * (double)y;
                xend -= mx2 * (double)y;
                zstart -= mz1 * (float)y;
                zend -= mz2 * (float)y;
                ustart -= mu1 * (double)y;
                uend -= mu2 * (double)y;
                vstart -= mv1 * (double)y;
                vend -= mv2 * (double)y;
                difredstart -= mdifred1 * (float)y;
                difredend -= mdifred2 * (float)y;
                difgreenstart -= mdifgreen1 * (float)y;
                difgreenend -= mdifgreen2 * (float)y;
                difbluestart -= mdifblue1 * (float)y;
                difblueend -= mdifblue2 * (float)y;
                normxstart -= mnormx1 * (double)y;
                normxend -= mnormx2 * (double)y;
                normystart -= mnormy1 * (double)y;
                normyend -= mnormy2 * (double)y;
                normzstart -= mnormz1 * (double)y;
                normzend -= mnormz2 * (double)y;
                y = 0;
            }
            yend = FastMath.round((double)y2);
            if (yend > this.height) {
                yend = this.height;
            }
            index = y * this.width;
            while (y < yend) {
                if (xstart < xend) {
                    left = FastMath.round((double)xstart);
                    right = FastMath.round((double)xend);
                    z = zstart;
                    dz = zend - zstart;
                    u = ustart;
                    du = uend - ustart;
                    v = vstart;
                    dv = vend - vstart;
                    difred = difredstart;
                    ddifred = difredend - difredstart;
                    difgreen = difgreenstart;
                    ddifgreen = difgreenend - difgreenstart;
                    difblue = difbluestart;
                    ddifblue = difblueend - difbluestart;
                    normx = normxstart;
                    dnormx = normxend - normxstart;
                    normy = normystart;
                    dnormy = normyend - normystart;
                    normz = normzstart;
                    dnormz = normzend - normzstart;
                } else {
                    left = FastMath.round((double)xend);
                    right = FastMath.round((double)xstart);
                    z = zend;
                    dz = zstart - zend;
                    u = uend;
                    du = ustart - uend;
                    v = vend;
                    dv = vstart - vend;
                    difred = difredend;
                    ddifred = difredstart - difredend;
                    difgreen = difgreenend;
                    ddifgreen = difgreenstart - difgreenend;
                    difblue = difblueend;
                    ddifblue = difbluestart - difblueend;
                    normx = normxend;
                    dnormx = normxstart - normxend;
                    normy = normyend;
                    dnormy = normystart - normyend;
                    normz = normzend;
                    dnormz = normzstart - normzend;
                }
                if (left != right) {
                    denom = xend == xstart ? 1.0f : (xend > xstart ? (float)(1.0 / (xend - xstart)) : (float)(1.0 / (xstart - xend)));
                    dz *= denom;
                    du *= (double)denom;
                    dv *= (double)denom;
                    ddifred *= denom;
                    ddifgreen *= denom;
                    ddifblue *= denom;
                    dnormx *= (double)denom;
                    dnormy *= (double)denom;
                    dnormz *= (double)denom;
                    if (left < 0) {
                        z -= dz * (float)left;
                        u -= du * (double)left;
                        v -= dv * (double)left;
                        difred -= ddifred * (float)left;
                        difgreen -= ddifgreen * (float)left;
                        difblue -= ddifblue * (float)left;
                        normx -= dnormx * (double)left;
                        normy -= dnormy * (double)left;
                        normz -= dnormz * (double)left;
                        left = 0;
                    }
                    if (right > this.width) {
                        right = this.width;
                    }
                    repeat = false;
                    for (i = left; i < right; ++i) {
                        zl = 1.0f / z;
                        if (zl < this.fragment[index + i].getOpaqueDepth() && (double)zl > clip) {
                            if (!repeat || i % this.subsample == 0) {
                                ul = u * (double)zl;
                                vl = v * (double)zl;
                                wl = 1.0 - ul - vl;
                                tri.getTextureSpec(surfSpec, viewdot, ul, vl, wl, this.smoothScale * (double)z, this.time);
                                if (surfSpec.hilight.getRed() == 0.0f && surfSpec.hilight.getGreen() == 0.0f && surfSpec.hilight.getBlue() == 0.0f && surfSpec.specular.getRed() == 0.0f && surfSpec.specular.getGreen() == 0.0f && surfSpec.specular.getBlue() == 0.0f) {
                                    context.tempColor[0].setRGB(surfSpec.diffuse.getRed() * difred + surfSpec.emissive.getRed(), surfSpec.diffuse.getGreen() * difgreen + surfSpec.emissive.getGreen(), surfSpec.diffuse.getBlue() * difblue + surfSpec.emissive.getBlue());
                                } else {
                                    if (this.positionNeeded) {
                                        context.tempVec[2].set(ul * vert1.x + vl * vert2.x + wl * vert3.x, ul * vert1.y + vl * vert2.y + wl * vert3.y, ul * vert1.z + vl * vert2.z + wl * vert3.z);
                                    }
                                    context.tempVec[3].set(normx, normy, normz);
                                    context.tempVec[3].normalize();
                                    this.calcLight(context.tempVec[2], context.tempVec[3], viewdir, faceNorm, surfSpec.roughness, null, specular, highlight, context);
                                    context.tempColor[0].setRGB(surfSpec.diffuse.getRed() * difred + surfSpec.hilight.getRed() * highlight.getRed() + surfSpec.specular.getRed() * specular.getRed() + surfSpec.emissive.getRed(), surfSpec.diffuse.getGreen() * difgreen + surfSpec.hilight.getGreen() * highlight.getGreen() + surfSpec.specular.getGreen() * specular.getGreen() + surfSpec.emissive.getGreen(), surfSpec.diffuse.getBlue() * difblue + surfSpec.hilight.getBlue() * highlight.getBlue() + surfSpec.specular.getBlue() * specular.getBlue() + surfSpec.emissive.getBlue());
                                }
                                lastAddColor = context.tempColor[0].getERGB();
                                lastMultColor = surfSpec.transparent.getERGB();
                            }
                            context.fragment[i] = this.createFragment(lastAddColor, lastMultColor, zl, material, isBackface);
                            repeat = doSubsample;
                        } else {
                            context.fragment[i] = null;
                            repeat = false;
                        }
                        z += dz;
                        u += du;
                        v += dv;
                        difred += ddifred;
                        difgreen += ddifgreen;
                        difblue += ddifblue;
                        normx += dnormx;
                        normy += dnormy;
                        normz += dnormz;
                    }
                    this.recordRow(y, left, right, context);
                }
                xstart += mx1;
                zstart += mz1;
                ustart += mu1;
                vstart += mv1;
                difredstart += mdifred1;
                difgreenstart += mdifgreen1;
                difbluestart += mdifblue1;
                normxstart += mnormx1;
                normystart += mnormy1;
                normzstart += mnormz1;
                xend += mx2;
                zend += mz2;
                uend += mu2;
                vend += mv2;
                difredend += mdifred2;
                difgreenend += mdifgreen2;
                difblueend += mdifblue2;
                normxend += mnormx2;
                normyend += mnormy2;
                normzend += mnormz2;
                index += this.width;
                ++y;
            }
        }
        dx2 = x3 - x2;
        dy2 = y3 - y2;
        dz2 = z3 - z2;
        du2 = u3 - u2;
        dv2 = v3 - v2;
        ddifred2 = dif3.getRed() - dif2.getRed();
        ddifgreen2 = dif3.getGreen() - dif2.getGreen();
        ddifblue2 = dif3.getBlue() - dif2.getBlue();
        dnormx2 = norm3.x - norm2.x;
        dnormy2 = norm3.y - norm2.y;
        dnormz2 = norm3.z - norm2.z;
        if (dy2 > 0.0) {
            denom = (float)(1.0 / dy2);
            mx2 = dx2 * (double)denom;
            mz2 = dz2 * denom;
            mu2 = du2 * (double)denom;
            mv2 = dv2 * (double)denom;
            mdifred2 = ddifred2 * denom;
            mdifgreen2 = ddifgreen2 * denom;
            mdifblue2 = ddifblue2 * denom;
            mnormx2 = dnormx2 * (double)denom;
            mnormy2 = dnormy2 * (double)denom;
            mnormz2 = dnormz2 * (double)denom;
            xend = x2;
            zend = z2;
            uend = u2;
            vend = v2;
            difredend = dif2.getRed();
            difgreenend = dif2.getGreen();
            difblueend = dif2.getBlue();
            normxend = norm2.x;
            normyend = norm2.y;
            normzend = norm2.z;
            if (y < 0) {
                xstart -= mx1 * (double)y;
                xend -= mx2 * (double)y;
                zstart -= mz1 * (float)y;
                zend -= mz2 * (float)y;
                ustart -= mu1 * (double)y;
                uend -= mu2 * (double)y;
                vstart -= mv1 * (double)y;
                vend -= mv2 * (double)y;
                difredstart -= mdifred1 * (float)y;
                difredend -= mdifred2 * (float)y;
                difgreenstart -= mdifgreen1 * (float)y;
                difgreenend -= mdifgreen2 * (float)y;
                difbluestart -= mdifblue1 * (float)y;
                difblueend -= mdifblue2 * (float)y;
                normxstart -= mnormx1 * (double)y;
                normxend -= mnormx2 * (double)y;
                normystart -= mnormy1 * (double)y;
                normyend -= mnormy2 * (double)y;
                normzstart -= mnormz1 * (double)y;
                normzend -= mnormz2 * (double)y;
                y = 0;
            }
            yend = FastMath.round((double)(y3 < (double)this.height ? y3 : (double)this.height));
            index = y * this.width;
            while (y < yend) {
                if (xstart < xend) {
                    left = FastMath.round((double)xstart);
                    right = FastMath.round((double)xend);
                    z = zstart;
                    dz = zend - zstart;
                    u = ustart;
                    du = uend - ustart;
                    v = vstart;
                    dv = vend - vstart;
                    difred = difredstart;
                    ddifred = difredend - difredstart;
                    difgreen = difgreenstart;
                    ddifgreen = difgreenend - difgreenstart;
                    difblue = difbluestart;
                    ddifblue = difblueend - difbluestart;
                    normx = normxstart;
                    dnormx = normxend - normxstart;
                    normy = normystart;
                    dnormy = normyend - normystart;
                    normz = normzstart;
                    dnormz = normzend - normzstart;
                } else {
                    left = FastMath.round((double)xend);
                    right = FastMath.round((double)xstart);
                    z = zend;
                    dz = zstart - zend;
                    u = uend;
                    du = ustart - uend;
                    v = vend;
                    dv = vstart - vend;
                    difred = difredend;
                    ddifred = difredstart - difredend;
                    difgreen = difgreenend;
                    ddifgreen = difgreenstart - difgreenend;
                    difblue = difblueend;
                    ddifblue = difbluestart - difblueend;
                    normx = normxend;
                    dnormx = normxstart - normxend;
                    normy = normyend;
                    dnormy = normystart - normyend;
                    normz = normzend;
                    dnormz = normzstart - normzend;
                }
                if (left != right) {
                    denom = xend == xstart ? 1.0f : (xend > xstart ? (float)(1.0 / (xend - xstart)) : (float)(1.0 / (xstart - xend)));
                    dz *= denom;
                    du *= (double)denom;
                    dv *= (double)denom;
                    ddifred *= denom;
                    ddifgreen *= denom;
                    ddifblue *= denom;
                    dnormx *= (double)denom;
                    dnormy *= (double)denom;
                    dnormz *= (double)denom;
                    if (left < 0) {
                        z -= dz * (float)left;
                        u -= du * (double)left;
                        v -= dv * (double)left;
                        difred -= ddifred * (float)left;
                        difgreen -= ddifgreen * (float)left;
                        difblue -= ddifblue * (float)left;
                        normx -= dnormx * (double)left;
                        normy -= dnormy * (double)left;
                        normz -= dnormz * (double)left;
                        left = 0;
                    }
                    if (right > this.width) {
                        right = this.width;
                    }
                    repeat = false;
                    for (i = left; i < right; ++i) {
                        zl = 1.0f / z;
                        if (zl < this.fragment[index + i].getOpaqueDepth() && (double)zl > clip) {
                            if (!repeat || i % this.subsample == 0) {
                                ul = u * (double)zl;
                                vl = v * (double)zl;
                                wl = 1.0 - ul - vl;
                                tri.getTextureSpec(surfSpec, viewdot, ul, vl, wl, this.smoothScale * (double)z, this.time);
                                if (surfSpec.hilight.getRed() == 0.0f && surfSpec.hilight.getGreen() == 0.0f && surfSpec.hilight.getBlue() == 0.0f && surfSpec.specular.getRed() == 0.0f && surfSpec.specular.getGreen() == 0.0f && surfSpec.specular.getBlue() == 0.0f) {
                                    context.tempColor[0].setRGB(surfSpec.diffuse.getRed() * difred + surfSpec.emissive.getRed(), surfSpec.diffuse.getGreen() * difgreen + surfSpec.emissive.getGreen(), surfSpec.diffuse.getBlue() * difblue + surfSpec.emissive.getBlue());
                                } else {
                                    if (this.positionNeeded) {
                                        context.tempVec[2].set(ul * vert1.x + vl * vert2.x + wl * vert3.x, ul * vert1.y + vl * vert2.y + wl * vert3.y, ul * vert1.z + vl * vert2.z + wl * vert3.z);
                                    }
                                    context.tempVec[3].set(normx, normy, normz);
                                    context.tempVec[3].normalize();
                                    this.calcLight(context.tempVec[2], context.tempVec[3], viewdir, faceNorm, surfSpec.roughness, null, specular, highlight, context);
                                    context.tempColor[0].setRGB(surfSpec.diffuse.getRed() * difred + surfSpec.hilight.getRed() * highlight.getRed() + surfSpec.specular.getRed() * specular.getRed() + surfSpec.emissive.getRed(), surfSpec.diffuse.getGreen() * difgreen + surfSpec.hilight.getGreen() * highlight.getGreen() + surfSpec.specular.getGreen() * specular.getGreen() + surfSpec.emissive.getGreen(), surfSpec.diffuse.getBlue() * difblue + surfSpec.hilight.getBlue() * highlight.getBlue() + surfSpec.specular.getBlue() * specular.getBlue() + surfSpec.emissive.getBlue());
                                }
                                lastAddColor = context.tempColor[0].getERGB();
                                lastMultColor = surfSpec.transparent.getERGB();
                            }
                            context.fragment[i] = this.createFragment(lastAddColor, lastMultColor, zl, material, isBackface);
                            repeat = doSubsample;
                        } else {
                            context.fragment[i] = null;
                            repeat = false;
                        }
                        z += dz;
                        u += du;
                        v += dv;
                        difred += ddifred;
                        difgreen += ddifgreen;
                        difblue += ddifblue;
                        normx += dnormx;
                        normy += dnormy;
                        normz += dnormz;
                    }
                    this.recordRow(y, left, right, context);
                }
                xstart += mx1;
                zstart += mz1;
                ustart += mu1;
                vstart += mv1;
                difredstart += mdifred1;
                difgreenstart += mdifgreen1;
                difbluestart += mdifblue1;
                normxstart += mnormx1;
                normystart += mnormy1;
                normzstart += mnormz1;
                xend += mx2;
                zend += mz2;
                uend += mu2;
                vend += mv2;
                difredend += mdifred2;
                difgreenend += mdifgreen2;
                difblueend += mdifblue2;
                normxend += mnormx2;
                normyend += mnormy2;
                normzend += mnormz2;
                index += this.width;
                ++y;
            }
        }
    }

    private void renderMeshPhong(RenderingMesh mesh, Vec3 viewdir, boolean cullBackfaces, boolean bumpMap, ObjectMaterialInfo material, RasterContext context) {
        int i;
        Vec3[] vert = mesh.vert;
        Vec3[] norm = mesh.norm;
        Vec3[] clipNorm = new Vec3[4];
        Vec2[] pos = new Vec2[vert.length];
        float[] z = new float[vert.length];
        float clip = (float)context.camera.getClipDistance();
        float[] clipz = new float[4];
        double[] clipu = new double[4];
        double[] clipv = new double[4];
        Mat4 toView = context.camera.getObjectToView();
        Mat4 toScreen = context.camera.getObjectToScreen();
        for (i = 0; i < 4; ++i) {
            clipNorm[i] = new Vec3();
        }
        for (i = vert.length - 1; i >= 0; --i) {
            pos[i] = toScreen.timesXY(vert[i]);
            z[i] = (float)toView.timesZ(vert[i]);
        }
        for (i = mesh.triangle.length - 1; i >= 0; --i) {
            boolean backface;
            RenderingTriangle tri = mesh.triangle[i];
            int v1 = tri.v1;
            int v2 = tri.v2;
            int v3 = tri.v3;
            int n1 = tri.n1;
            int n2 = tri.n2;
            int n3 = tri.n3;
            if (z[v1] < clip && z[v2] < clip && z[v3] < clip) continue;
            boolean bl = backface = (pos[v2].x - pos[v1].x) * (pos[v3].y - pos[v1].y) - (pos[v2].y - pos[v1].y) * (pos[v3].x - pos[v1].x) > 0.0;
            if (z[v1] < clip || z[v2] < clip || z[v3] < clip) {
                Vec3[] clipPos = this.clipTriangle(vert[v1], vert[v2], vert[v3], z[v1], z[v2], z[v3], clipz, clipu, clipv, context);
                Vec2[] clipPos2D = new Vec2[clipPos.length];
                for (int j = clipPos.length - 1; j >= 0; --j) {
                    clipPos2D[j] = toScreen.timesXY(clipPos[j]);
                    double u = clipu[j];
                    double v = clipv[j];
                    double w = 1.0 - u - v;
                    clipNorm[j].set(norm[n1].x * u + norm[n2].x * v + norm[n3].x * w, norm[n1].y * u + norm[n2].y * v + norm[n3].y * w, norm[n1].z * u + norm[n2].z * v + norm[n3].z * w);
                    clipNorm[j].normalize();
                }
                this.renderTrianglePhong(clipPos2D[0], clipz[0], clipPos[0], clipNorm[0], clipu[0], clipv[0], clipPos2D[1], clipz[1], clipPos[1], clipNorm[1], clipu[1], clipv[1], clipPos2D[2], clipz[2], clipPos[2], clipNorm[2], clipu[2], clipv[2], tri, viewdir, mesh.faceNorm[i], clip, bumpMap, backface, material, context);
                if (clipPos.length != 4) continue;
                this.renderTrianglePhong(clipPos2D[1], clipz[1], clipPos[1], clipNorm[1], clipu[1], clipv[1], clipPos2D[2], clipz[2], clipPos[2], clipNorm[2], clipu[2], clipv[2], clipPos2D[3], clipz[3], clipPos[3], clipNorm[3], clipu[3], clipv[3], tri, viewdir, mesh.faceNorm[i], clip, bumpMap, backface, material, context);
                continue;
            }
            if (cullBackfaces && backface) continue;
            this.renderTrianglePhong(pos[v1], z[v1], vert[v1], norm[n1], 1.0, 0.0, pos[v2], z[v2], vert[v2], norm[n2], 0.0, 1.0, pos[v3], z[v3], vert[v3], norm[n3], 0.0, 0.0, tri, viewdir, mesh.faceNorm[i], clip, bumpMap, backface, material, context);
        }
    }

    private void renderTrianglePhong(Vec2 pos1, float zf1, Vec3 vert1, Vec3 normf1, double uf1, double vf1, Vec2 pos2, float zf2, Vec3 vert2, Vec3 normf2, double uf2, double vf2, Vec2 pos3, float zf3, Vec3 vert3, Vec3 normf3, double uf3, double vf3, RenderingTriangle tri, Vec3 viewdir, Vec3 faceNorm, double clip, boolean bumpMap, boolean isBackface, ObjectMaterialInfo material, RasterContext context) {
        double wl;
        double vl;
        double ul;
        float zl;
        int i;
        boolean repeat;
        double dnormz;
        double normz;
        double dnormy;
        double normy;
        double dnormx;
        double normx;
        double dv;
        double v;
        double du;
        double u;
        float dz;
        float z;
        int right;
        int left;
        int index;
        int yend;
        double mnormz2;
        double mnormy2;
        double mnormx2;
        double mv2;
        double mu2;
        float mz2;
        double mx2;
        double normzend;
        double normyend;
        double normxend;
        double vend;
        double uend;
        float zend;
        double xend;
        Vec3 norm3;
        double v3;
        double u3;
        float z3;
        double y3;
        double x3;
        Vec3 norm2;
        double v2;
        double u2;
        float z2;
        double y2;
        double x2;
        Vec3 norm1;
        double v1;
        double u1;
        float z1;
        double y1;
        double x1;
        RGBColor diffuse = context.tempColor[1];
        RGBColor specular = context.tempColor[2];
        RGBColor highlight = context.tempColor[3];
        Vec3 normal = context.tempVec[3];
        int lastAddColor = 0;
        int lastMultColor = 0;
        boolean doSubsample = this.subsample > 1;
        TextureSpec surfSpec = context.surfSpec;
        if (pos1.y <= pos2.y && pos1.y <= pos3.y) {
            x1 = pos1.x;
            y1 = pos1.y;
            z1 = zf1;
            u1 = uf1;
            v1 = vf1;
            norm1 = normf1;
            if (pos2.y < pos3.y) {
                x2 = pos2.x;
                y2 = pos2.y;
                z2 = zf2;
                u2 = uf2;
                v2 = vf2;
                norm2 = normf2;
                x3 = pos3.x;
                y3 = pos3.y;
                z3 = zf3;
                u3 = uf3;
                v3 = vf3;
                norm3 = normf3;
            } else {
                x2 = pos3.x;
                y2 = pos3.y;
                z2 = zf3;
                u2 = uf3;
                v2 = vf3;
                norm2 = normf3;
                x3 = pos2.x;
                y3 = pos2.y;
                z3 = zf2;
                u3 = uf2;
                v3 = vf2;
                norm3 = normf2;
            }
        } else if (pos2.y <= pos1.y && pos2.y <= pos3.y) {
            x1 = pos2.x;
            y1 = pos2.y;
            z1 = zf2;
            u1 = uf2;
            v1 = vf2;
            norm1 = normf2;
            if (pos1.y < pos3.y) {
                x2 = pos1.x;
                y2 = pos1.y;
                z2 = zf1;
                u2 = uf1;
                v2 = vf1;
                norm2 = normf1;
                x3 = pos3.x;
                y3 = pos3.y;
                z3 = zf3;
                u3 = uf3;
                v3 = vf3;
                norm3 = normf3;
            } else {
                x2 = pos3.x;
                y2 = pos3.y;
                z2 = zf3;
                u2 = uf3;
                v2 = vf3;
                norm2 = normf3;
                x3 = pos1.x;
                y3 = pos1.y;
                z3 = zf1;
                u3 = uf1;
                v3 = vf1;
                norm3 = normf1;
            }
        } else {
            x1 = pos3.x;
            y1 = pos3.y;
            z1 = zf3;
            u1 = uf3;
            v1 = vf3;
            norm1 = normf3;
            if (pos1.y < pos2.y) {
                x2 = pos1.x;
                y2 = pos1.y;
                z2 = zf1;
                u2 = uf1;
                v2 = vf1;
                norm2 = normf1;
                x3 = pos2.x;
                y3 = pos2.y;
                z3 = zf2;
                u3 = uf2;
                v3 = vf2;
                norm3 = normf2;
            } else {
                x2 = pos2.x;
                y2 = pos2.y;
                z2 = zf2;
                u2 = uf2;
                v2 = vf2;
                norm2 = normf2;
                x3 = pos1.x;
                y3 = pos1.y;
                z3 = zf1;
                u3 = uf1;
                v3 = vf1;
                norm3 = normf1;
            }
        }
        x1 = FastMath.round((double)x1);
        y1 = FastMath.round((double)y1);
        x2 = FastMath.round((double)x2);
        y2 = FastMath.round((double)y2);
        x3 = FastMath.round((double)x3);
        y3 = FastMath.round((double)y3);
        z1 = 1.0f / z1;
        u1 *= (double)z1;
        v1 *= (double)z1;
        z2 = 1.0f / z2;
        u2 *= (double)z2;
        v2 *= (double)z2;
        z3 = 1.0f / z3;
        u3 *= (double)z3;
        v3 *= (double)z3;
        double dx1 = x3 - x1;
        double dy1 = y3 - y1;
        float dz1 = z3 - z1;
        if (dy1 == 0.0) {
            return;
        }
        double du1 = u3 - u1;
        double dv1 = v3 - v1;
        double dnormx1 = norm3.x - norm1.x;
        double dnormy1 = norm3.y - norm1.y;
        double dnormz1 = norm3.z - norm1.z;
        double dx2 = x2 - x1;
        double dy2 = y2 - y1;
        float dz2 = z2 - z1;
        double du2 = u2 - u1;
        double dv2 = v2 - v1;
        double dnormx2 = norm2.x - norm1.x;
        double dnormy2 = norm2.y - norm1.y;
        double dnormz2 = norm2.z - norm1.z;
        float denom = (float)(1.0 / dy1);
        double mx1 = dx1 * (double)denom;
        float mz1 = dz1 * denom;
        double mu1 = du1 * (double)denom;
        double mv1 = dv1 * (double)denom;
        double mnormx1 = dnormx1 * (double)denom;
        double mnormy1 = dnormy1 * (double)denom;
        double mnormz1 = dnormz1 * (double)denom;
        double xstart = xend = x1;
        float zstart = zend = z1;
        double ustart = uend = u1;
        double vstart = vend = v1;
        double normxstart = normxend = norm1.x;
        double normystart = normyend = norm1.y;
        double normzstart = normzend = norm1.z;
        int y = FastMath.round((double)y1);
        if (dy2 > 0.0) {
            denom = (float)(1.0 / dy2);
            mx2 = dx2 * (double)denom;
            mz2 = dz2 * denom;
            mu2 = du2 * (double)denom;
            mv2 = dv2 * (double)denom;
            mnormx2 = dnormx2 * (double)denom;
            mnormy2 = dnormy2 * (double)denom;
            mnormz2 = dnormz2 * (double)denom;
            if (y2 < 0.0) {
                xstart += mx1 * dy2;
                xend += mx2 * dy2;
                zstart = (float)((double)zstart + (double)mz1 * dy2);
                zend = (float)((double)zend + (double)mz2 * dy2);
                ustart += mu1 * dy2;
                uend += mu2 * dy2;
                vstart += mv1 * dy2;
                vend += mv2 * dy2;
                normxstart += mnormx1 * dy2;
                normxend += mnormx2 * dy2;
                normystart += mnormy1 * dy2;
                normyend += mnormy2 * dy2;
                normzstart += mnormz1 * dy2;
                normzend += mnormz2 * dy2;
                y = FastMath.round((double)y2);
            } else if (y < 0) {
                xstart -= mx1 * (double)y;
                xend -= mx2 * (double)y;
                zstart -= mz1 * (float)y;
                zend -= mz2 * (float)y;
                ustart -= mu1 * (double)y;
                uend -= mu2 * (double)y;
                vstart -= mv1 * (double)y;
                vend -= mv2 * (double)y;
                normxstart -= mnormx1 * (double)y;
                normxend -= mnormx2 * (double)y;
                normystart -= mnormy1 * (double)y;
                normyend -= mnormy2 * (double)y;
                normzstart -= mnormz1 * (double)y;
                normzend -= mnormz2 * (double)y;
                y = 0;
            }
            yend = FastMath.round((double)y2);
            if (yend > this.height) {
                yend = this.height;
            }
            index = y * this.width;
            while (y < yend) {
                if (xstart < xend) {
                    left = FastMath.round((double)xstart);
                    right = FastMath.round((double)xend);
                    z = zstart;
                    dz = zend - zstart;
                    u = ustart;
                    du = uend - ustart;
                    v = vstart;
                    dv = vend - vstart;
                    normx = normxstart;
                    dnormx = normxend - normxstart;
                    normy = normystart;
                    dnormy = normyend - normystart;
                    normz = normzstart;
                    dnormz = normzend - normzstart;
                } else {
                    left = FastMath.round((double)xend);
                    right = FastMath.round((double)xstart);
                    z = zend;
                    dz = zstart - zend;
                    u = uend;
                    du = ustart - uend;
                    v = vend;
                    dv = vstart - vend;
                    normx = normxend;
                    dnormx = normxstart - normxend;
                    normy = normyend;
                    dnormy = normystart - normyend;
                    normz = normzend;
                    dnormz = normzstart - normzend;
                }
                if (left != right) {
                    denom = xend == xstart ? 1.0f : (xend > xstart ? (float)(1.0 / (xend - xstart)) : (float)(1.0 / (xstart - xend)));
                    dz *= denom;
                    du *= (double)denom;
                    dv *= (double)denom;
                    dnormx *= (double)denom;
                    dnormy *= (double)denom;
                    dnormz *= (double)denom;
                    if (left < 0) {
                        z -= dz * (float)left;
                        u -= du * (double)left;
                        v -= dv * (double)left;
                        normx -= dnormx * (double)left;
                        normy -= dnormy * (double)left;
                        normz -= dnormz * (double)left;
                        left = 0;
                    }
                    if (right > this.width) {
                        right = this.width;
                    }
                    repeat = false;
                    for (i = left; i < right; ++i) {
                        zl = 1.0f / z;
                        if (zl < this.fragment[index + i].getOpaqueDepth() && (double)zl > clip) {
                            if (!repeat || i % this.subsample == 0) {
                                ul = u * (double)zl;
                                vl = v * (double)zl;
                                wl = 1.0 - ul - vl;
                                if (this.positionNeeded) {
                                    context.tempVec[2].set(ul * vert1.x + vl * vert2.x + wl * vert3.x, ul * vert1.y + vl * vert2.y + wl * vert3.y, ul * vert1.z + vl * vert2.z + wl * vert3.z);
                                }
                                normal.set(normx, normy, normz);
                                normal.normalize();
                                tri.getTextureSpec(surfSpec, viewdir.dot(normal), ul, vl, wl, this.smoothScale * (double)z, this.time);
                                if (bumpMap) {
                                    normal.scale(surfSpec.bumpGrad.dot(normal) + 1.0);
                                    normal.subtract(surfSpec.bumpGrad);
                                    normal.normalize();
                                }
                                if (surfSpec.hilight.getRed() == 0.0f && surfSpec.hilight.getGreen() == 0.0f && surfSpec.hilight.getBlue() == 0.0f && surfSpec.specular.getRed() == 0.0f && surfSpec.specular.getGreen() == 0.0f && surfSpec.specular.getBlue() == 0.0f) {
                                    this.calcLight(context.tempVec[2], normal, viewdir, faceNorm, surfSpec.roughness, diffuse, null, null, context);
                                    context.tempColor[0].setRGB(surfSpec.diffuse.getRed() * diffuse.getRed() + surfSpec.emissive.getRed(), surfSpec.diffuse.getGreen() * diffuse.getGreen() + surfSpec.emissive.getGreen(), surfSpec.diffuse.getBlue() * diffuse.getBlue() + surfSpec.emissive.getBlue());
                                } else {
                                    this.calcLight(context.tempVec[2], normal, viewdir, faceNorm, surfSpec.roughness, diffuse, specular, highlight, context);
                                    context.tempColor[0].setRGB(surfSpec.diffuse.getRed() * diffuse.getRed() + surfSpec.hilight.getRed() * highlight.getRed() + surfSpec.specular.getRed() * specular.getRed() + surfSpec.emissive.getRed(), surfSpec.diffuse.getGreen() * diffuse.getGreen() + surfSpec.hilight.getGreen() * highlight.getGreen() + surfSpec.specular.getGreen() * specular.getGreen() + surfSpec.emissive.getGreen(), surfSpec.diffuse.getBlue() * diffuse.getBlue() + surfSpec.hilight.getBlue() * highlight.getBlue() + surfSpec.specular.getBlue() * specular.getBlue() + surfSpec.emissive.getBlue());
                                }
                                lastAddColor = context.tempColor[0].getERGB();
                                lastMultColor = surfSpec.transparent.getERGB();
                            }
                            context.fragment[i] = this.createFragment(lastAddColor, lastMultColor, zl, material, isBackface);
                            repeat = doSubsample;
                        } else {
                            context.fragment[i] = null;
                            repeat = false;
                        }
                        z += dz;
                        u += du;
                        v += dv;
                        normx += dnormx;
                        normy += dnormy;
                        normz += dnormz;
                    }
                    this.recordRow(y, left, right, context);
                }
                xstart += mx1;
                zstart += mz1;
                ustart += mu1;
                vstart += mv1;
                normxstart += mnormx1;
                normystart += mnormy1;
                normzstart += mnormz1;
                xend += mx2;
                zend += mz2;
                uend += mu2;
                vend += mv2;
                normxend += mnormx2;
                normyend += mnormy2;
                normzend += mnormz2;
                index += this.width;
                ++y;
            }
        }
        dx2 = x3 - x2;
        dy2 = y3 - y2;
        dz2 = z3 - z2;
        du2 = u3 - u2;
        dv2 = v3 - v2;
        dnormx2 = norm3.x - norm2.x;
        dnormy2 = norm3.y - norm2.y;
        dnormz2 = norm3.z - norm2.z;
        if (dy2 > 0.0) {
            denom = (float)(1.0 / dy2);
            mx2 = dx2 * (double)denom;
            mz2 = dz2 * denom;
            mu2 = du2 * (double)denom;
            mv2 = dv2 * (double)denom;
            mnormx2 = dnormx2 * (double)denom;
            mnormy2 = dnormy2 * (double)denom;
            mnormz2 = dnormz2 * (double)denom;
            xend = x2;
            zend = z2;
            uend = u2;
            vend = v2;
            normxend = norm2.x;
            normyend = norm2.y;
            normzend = norm2.z;
            if (y < 0) {
                xstart -= mx1 * (double)y;
                xend -= mx2 * (double)y;
                zstart -= mz1 * (float)y;
                zend -= mz2 * (float)y;
                ustart -= mu1 * (double)y;
                uend -= mu2 * (double)y;
                vstart -= mv1 * (double)y;
                vend -= mv2 * (double)y;
                normxstart -= mnormx1 * (double)y;
                normxend -= mnormx2 * (double)y;
                normystart -= mnormy1 * (double)y;
                normyend -= mnormy2 * (double)y;
                normzstart -= mnormz1 * (double)y;
                normzend -= mnormz2 * (double)y;
                y = 0;
            }
            yend = FastMath.round((double)(y3 < (double)this.height ? y3 : (double)this.height));
            index = y * this.width;
            while (y < yend) {
                if (xstart < xend) {
                    left = FastMath.round((double)xstart);
                    right = FastMath.round((double)xend);
                    z = zstart;
                    dz = zend - zstart;
                    u = ustart;
                    du = uend - ustart;
                    v = vstart;
                    dv = vend - vstart;
                    normx = normxstart;
                    dnormx = normxend - normxstart;
                    normy = normystart;
                    dnormy = normyend - normystart;
                    normz = normzstart;
                    dnormz = normzend - normzstart;
                } else {
                    left = FastMath.round((double)xend);
                    right = FastMath.round((double)xstart);
                    z = zend;
                    dz = zstart - zend;
                    u = uend;
                    du = ustart - uend;
                    v = vend;
                    dv = vstart - vend;
                    normx = normxend;
                    dnormx = normxstart - normxend;
                    normy = normyend;
                    dnormy = normystart - normyend;
                    normz = normzend;
                    dnormz = normzstart - normzend;
                }
                if (left != right) {
                    denom = xend == xstart ? 1.0f : (xend > xstart ? (float)(1.0 / (xend - xstart)) : (float)(1.0 / (xstart - xend)));
                    dz *= denom;
                    du *= (double)denom;
                    dv *= (double)denom;
                    dnormx *= (double)denom;
                    dnormy *= (double)denom;
                    dnormz *= (double)denom;
                    if (left < 0) {
                        z -= dz * (float)left;
                        u -= du * (double)left;
                        v -= dv * (double)left;
                        normx -= dnormx * (double)left;
                        normy -= dnormy * (double)left;
                        normz -= dnormz * (double)left;
                        left = 0;
                    }
                    if (right > this.width) {
                        right = this.width;
                    }
                    repeat = false;
                    for (i = left; i < right; ++i) {
                        zl = 1.0f / z;
                        if (zl < this.fragment[index + i].getOpaqueDepth() && (double)zl > clip) {
                            if (!repeat || i % this.subsample == 0) {
                                ul = u * (double)zl;
                                vl = v * (double)zl;
                                wl = 1.0 - ul - vl;
                                if (this.positionNeeded) {
                                    context.tempVec[2].set(ul * vert1.x + vl * vert2.x + wl * vert3.x, ul * vert1.y + vl * vert2.y + wl * vert3.y, ul * vert1.z + vl * vert2.z + wl * vert3.z);
                                }
                                normal.set(normx, normy, normz);
                                normal.normalize();
                                tri.getTextureSpec(surfSpec, viewdir.dot(normal), ul, vl, wl, this.smoothScale * (double)z, this.time);
                                if (bumpMap) {
                                    normal.scale(surfSpec.bumpGrad.dot(normal) + 1.0);
                                    normal.subtract(surfSpec.bumpGrad);
                                    normal.normalize();
                                }
                                if (surfSpec.hilight.getRed() == 0.0f && surfSpec.hilight.getGreen() == 0.0f && surfSpec.hilight.getBlue() == 0.0f && surfSpec.specular.getRed() == 0.0f && surfSpec.specular.getGreen() == 0.0f && surfSpec.specular.getBlue() == 0.0f) {
                                    this.calcLight(context.tempVec[2], normal, viewdir, faceNorm, surfSpec.roughness, diffuse, null, null, context);
                                    context.tempColor[0].setRGB(surfSpec.diffuse.getRed() * diffuse.getRed() + surfSpec.emissive.getRed(), surfSpec.diffuse.getGreen() * diffuse.getGreen() + surfSpec.emissive.getGreen(), surfSpec.diffuse.getBlue() * diffuse.getBlue() + surfSpec.emissive.getBlue());
                                } else {
                                    this.calcLight(context.tempVec[2], normal, viewdir, faceNorm, surfSpec.roughness, diffuse, specular, highlight, context);
                                    context.tempColor[0].setRGB(surfSpec.diffuse.getRed() * diffuse.getRed() + surfSpec.hilight.getRed() * highlight.getRed() + surfSpec.specular.getRed() * specular.getRed() + surfSpec.emissive.getRed(), surfSpec.diffuse.getGreen() * diffuse.getGreen() + surfSpec.hilight.getGreen() * highlight.getGreen() + surfSpec.specular.getGreen() * specular.getGreen() + surfSpec.emissive.getGreen(), surfSpec.diffuse.getBlue() * diffuse.getBlue() + surfSpec.hilight.getBlue() * highlight.getBlue() + surfSpec.specular.getBlue() * specular.getBlue() + surfSpec.emissive.getBlue());
                                }
                                lastAddColor = context.tempColor[0].getERGB();
                                lastMultColor = surfSpec.transparent.getERGB();
                            }
                            context.fragment[i] = this.createFragment(lastAddColor, lastMultColor, zl, material, isBackface);
                            repeat = doSubsample;
                        } else {
                            context.fragment[i] = null;
                            repeat = false;
                        }
                        z += dz;
                        u += du;
                        v += dv;
                        normx += dnormx;
                        normy += dnormy;
                        normz += dnormz;
                    }
                    this.recordRow(y, left, right, context);
                }
                xstart += mx1;
                zstart += mz1;
                ustart += mu1;
                vstart += mv1;
                normxstart += mnormx1;
                normystart += mnormy1;
                normzstart += mnormz1;
                xend += mx2;
                zend += mz2;
                uend += mu2;
                vend += mv2;
                normxend += mnormx2;
                normyend += mnormy2;
                normzend += mnormz2;
                index += this.width;
                ++y;
            }
        }
    }

    private void renderMeshDisplaced(RenderingMesh mesh, Vec3 viewdir, double tol, boolean cullBackfaces, boolean bumpMap, ObjectMaterialInfo material, RasterContext context) {
        Vec3[] vert = mesh.vert;
        Vec3[] norm = mesh.norm;
        Mat4 toView = context.camera.getObjectToView();
        Mat4 toScreen = context.camera.getObjectToScreen();
        for (int i = mesh.triangle.length - 1; i >= 0; --i) {
            RenderingTriangle tri = mesh.triangle[i];
            int v1 = tri.v1;
            int v2 = tri.v2;
            int v3 = tri.v3;
            int n1 = tri.n1;
            int n2 = tri.n2;
            int n3 = tri.n3;
            double dist1 = vert[v1].distance(vert[v2]);
            double dist2 = vert[v2].distance(vert[v3]);
            double dist3 = vert[v3].distance(vert[v1]);
            context.tempVec[0].set(vert[v1].x - vert[v3].x, vert[v1].y - vert[v3].y, vert[v1].z - vert[v3].z);
            context.tempVec[1].set(vert[v3].x - vert[v2].x, vert[v3].y - vert[v2].y, vert[v3].z - vert[v2].z);
            Vec3 vgrad = context.tempVec[0].cross(mesh.faceNorm[i]);
            Vec3 ugrad = context.tempVec[1].cross(mesh.faceNorm[i]);
            vgrad.scale(-1.0 / vgrad.dot(context.tempVec[1]));
            ugrad.scale(1.0 / ugrad.dot(context.tempVec[0]));
            DisplacedVertex dv1 = new DisplacedVertex(tri, vert[v1], norm[n1], 1.0, 0.0, toView, toScreen, context);
            DisplacedVertex dv2 = new DisplacedVertex(tri, vert[v2], norm[n2], 0.0, 1.0, toView, toScreen, context);
            DisplacedVertex dv3 = new DisplacedVertex(tri, vert[v3], norm[n3], 0.0, 0.0, toView, toScreen, context);
            this.renderDisplacedTriangle(tri, dv1, dist1, dv2, dist2, dv3, dist3, viewdir, ugrad, vgrad, tol, cullBackfaces, bumpMap, material, context);
        }
    }

    private void renderDisplacedTriangle(RenderingTriangle tri, DisplacedVertex dv1, double dist1, DisplacedVertex dv2, double dist2, DisplacedVertex dv3, double dist3, Vec3 viewdir, Vec3 ugrad, Vec3 vgrad, double tol, boolean cullBackfaces, boolean bumpMap, ObjectMaterialInfo material, RasterContext context) {
        boolean backface;
        Mat4 toView = context.camera.getObjectToView();
        Mat4 toScreen = context.camera.getObjectToScreen();
        DisplacedVertex midv1 = null;
        DisplacedVertex midv2 = null;
        DisplacedVertex midv3 = null;
        double halfdist1 = 0.0;
        double halfdist2 = 0.0;
        double halfdist3 = 0.0;
        boolean split1 = dist1 > tol;
        boolean split2 = dist2 > tol;
        boolean split3 = dist3 > tol;
        int shading = bumpMap ? 2 : this.shadingMode;
        int count = 0;
        if (split1) {
            midv1 = new DisplacedVertex(tri, new Vec3(0.5 * (dv1.vert.x + dv2.vert.x), 0.5 * (dv1.vert.y + dv2.vert.y), 0.5 * (dv1.vert.z + dv2.vert.z)), new Vec3(0.5 * (dv1.norm.x + dv2.norm.x), 0.5 * (dv1.norm.y + dv2.norm.y), 0.5 * (dv1.norm.z + dv2.norm.z)), 0.5 * (dv1.u + dv2.u), 0.5 * (dv1.v + dv2.v), toView, toScreen, context);
            halfdist1 = 0.5 * dist1;
            ++count;
        }
        if (split2) {
            midv2 = new DisplacedVertex(tri, new Vec3(0.5 * (dv2.vert.x + dv3.vert.x), 0.5 * (dv2.vert.y + dv3.vert.y), 0.5 * (dv2.vert.z + dv3.vert.z)), new Vec3(0.5 * (dv2.norm.x + dv3.norm.x), 0.5 * (dv2.norm.y + dv3.norm.y), 0.5 * (dv2.norm.z + dv3.norm.z)), 0.5 * (dv2.u + dv3.u), 0.5 * (dv2.v + dv3.v), toView, toScreen, context);
            halfdist2 = 0.5 * dist2;
            ++count;
        }
        if (split3) {
            midv3 = new DisplacedVertex(tri, new Vec3(0.5 * (dv3.vert.x + dv1.vert.x), 0.5 * (dv3.vert.y + dv1.vert.y), 0.5 * (dv3.vert.z + dv1.vert.z)), new Vec3(0.5 * (dv3.norm.x + dv1.norm.x), 0.5 * (dv3.norm.y + dv1.norm.y), 0.5 * (dv3.norm.z + dv1.norm.z)), 0.5 * (dv3.u + dv1.u), 0.5 * (dv3.v + dv1.v), toView, toScreen, context);
            halfdist3 = 0.5 * dist3;
            ++count;
        }
        if (count == 1) {
            if (split1) {
                double d = dv3.vert.distance(midv1.vert);
                this.renderDisplacedTriangle(tri, dv1, halfdist1, midv1, d, dv3, dist3, viewdir, ugrad, vgrad, tol, cullBackfaces, bumpMap, material, context);
                this.renderDisplacedTriangle(tri, midv1, halfdist1, dv2, dist2, dv3, d, viewdir, ugrad, vgrad, tol, cullBackfaces, bumpMap, material, context);
            } else if (split2) {
                double d = dv1.vert.distance(midv2.vert);
                this.renderDisplacedTriangle(tri, dv2, halfdist2, midv2, d, dv1, dist1, viewdir, ugrad, vgrad, tol, cullBackfaces, bumpMap, material, context);
                this.renderDisplacedTriangle(tri, midv2, halfdist2, dv3, dist3, dv1, d, viewdir, ugrad, vgrad, tol, cullBackfaces, bumpMap, material, context);
            } else {
                double d = dv1.vert.distance(midv3.vert);
                this.renderDisplacedTriangle(tri, dv3, halfdist3, midv3, d, dv2, dist2, viewdir, ugrad, vgrad, tol, cullBackfaces, bumpMap, material, context);
                this.renderDisplacedTriangle(tri, midv3, halfdist3, dv1, dist1, dv2, d, viewdir, ugrad, vgrad, tol, cullBackfaces, bumpMap, material, context);
            }
            return;
        }
        if (count == 2) {
            if (!split1) {
                double d1 = midv2.vert.distance(dv1.vert);
                double d2 = midv2.vert.distance(midv3.vert);
                this.renderDisplacedTriangle(tri, dv1, dist1, dv2, halfdist2, midv2, d1, viewdir, ugrad, vgrad, tol, cullBackfaces, bumpMap, material, context);
                this.renderDisplacedTriangle(tri, dv1, d1, midv2, d2, midv3, halfdist3, viewdir, ugrad, vgrad, tol, cullBackfaces, bumpMap, material, context);
                this.renderDisplacedTriangle(tri, dv3, halfdist3, midv3, d2, midv2, halfdist2, viewdir, ugrad, vgrad, tol, cullBackfaces, bumpMap, material, context);
            } else if (!split2) {
                double d1 = midv3.vert.distance(dv2.vert);
                double d2 = midv3.vert.distance(midv1.vert);
                this.renderDisplacedTriangle(tri, dv2, dist2, dv3, halfdist3, midv3, d1, viewdir, ugrad, vgrad, tol, cullBackfaces, bumpMap, material, context);
                this.renderDisplacedTriangle(tri, dv2, d1, midv3, d2, midv1, halfdist1, viewdir, ugrad, vgrad, tol, cullBackfaces, bumpMap, material, context);
                this.renderDisplacedTriangle(tri, dv1, halfdist1, midv1, d2, midv3, halfdist3, viewdir, ugrad, vgrad, tol, cullBackfaces, bumpMap, material, context);
            } else {
                double d1 = midv1.vert.distance(dv3.vert);
                double d2 = midv1.vert.distance(midv2.vert);
                this.renderDisplacedTriangle(tri, dv3, dist3, dv1, halfdist1, midv1, d1, viewdir, ugrad, vgrad, tol, cullBackfaces, bumpMap, material, context);
                this.renderDisplacedTriangle(tri, dv3, d1, midv1, d2, midv2, halfdist2, viewdir, ugrad, vgrad, tol, cullBackfaces, bumpMap, material, context);
                this.renderDisplacedTriangle(tri, dv2, halfdist2, midv2, d2, midv1, halfdist1, viewdir, ugrad, vgrad, tol, cullBackfaces, bumpMap, material, context);
            }
            return;
        }
        if (count == 3) {
            double d1 = midv1.vert.distance(midv2.vert);
            double d2 = midv2.vert.distance(midv3.vert);
            double d3 = midv3.vert.distance(midv1.vert);
            this.renderDisplacedTriangle(tri, dv1, halfdist1, midv1, d3, midv3, halfdist3, viewdir, ugrad, vgrad, tol, cullBackfaces, bumpMap, material, context);
            this.renderDisplacedTriangle(tri, dv2, halfdist2, midv2, d1, midv1, halfdist1, viewdir, ugrad, vgrad, tol, cullBackfaces, bumpMap, material, context);
            this.renderDisplacedTriangle(tri, dv3, halfdist3, midv3, d2, midv2, halfdist2, viewdir, ugrad, vgrad, tol, cullBackfaces, bumpMap, material, context);
            this.renderDisplacedTriangle(tri, midv1, d1, midv2, d2, midv3, d3, viewdir, ugrad, vgrad, tol, cullBackfaces, bumpMap, material, context);
            return;
        }
        float clip = (float)context.camera.getClipDistance();
        if (dv1.z < clip && dv2.z < clip && dv3.z < clip) {
            return;
        }
        if (dv1.z <= 0.0f || dv2.z < 0.0f || dv3.z < 0.0f) {
            return;
        }
        boolean bl = backface = (dv2.pos.x - dv1.pos.x) * (dv3.pos.y - dv1.pos.y) - (dv2.pos.y - dv1.pos.y) * (dv3.pos.x - dv1.pos.x) > 0.0;
        if (cullBackfaces && backface) {
            return;
        }
        if (dv1.dispnorm == null) {
            dv1.prepareToRender(tri, viewdir, ugrad, vgrad, shading, context);
        }
        if (dv2.dispnorm == null) {
            dv2.prepareToRender(tri, viewdir, ugrad, vgrad, shading, context);
        }
        if (dv3.dispnorm == null) {
            dv3.prepareToRender(tri, viewdir, ugrad, vgrad, shading, context);
        }
        Vec3 closestNorm = dv1.z < dv2.z && dv1.z < dv3.z ? dv1.dispnorm : (dv2.z < dv1.z && dv2.z < dv3.z ? dv2.dispnorm : dv3.dispnorm);
        if (shading == 0) {
            this.renderTriangleGouraud(dv1.pos, dv1.z, dv1.u, dv1.v, dv1.diffuse, dv1.specular, dv2.pos, dv2.z, dv2.u, dv2.v, dv2.diffuse, dv2.specular, dv3.pos, dv3.z, dv3.u, dv3.v, dv3.diffuse, dv3.specular, tri, clip, viewdir.dot(closestNorm), backface, material, context);
        } else if (shading == 1) {
            this.renderTriangleHybrid(dv1.pos, dv1.z, dv1.dispvert, dv1.dispnorm, dv1.u, dv1.v, dv1.diffuse, dv2.pos, dv2.z, dv2.dispvert, dv2.dispnorm, dv2.u, dv2.v, dv2.diffuse, dv3.pos, dv3.z, dv3.dispvert, dv3.dispnorm, dv3.u, dv3.v, dv3.diffuse, tri, viewdir, closestNorm, clip, viewdir.dot(closestNorm), backface, material, context);
        } else {
            this.renderTrianglePhong(dv1.pos, dv1.z, dv1.dispvert, dv1.dispnorm, dv1.u, dv1.v, dv2.pos, dv2.z, dv2.dispvert, dv2.dispnorm, dv2.u, dv2.v, dv3.pos, dv3.z, dv3.dispvert, dv3.dispnorm, dv3.u, dv3.v, tri, viewdir, closestNorm, clip, bumpMap, backface, material, context);
        }
    }

    private static class RowLock {
        private RowLock() {
        }
    }

    private class DisplacedVertex {
        public Vec3 vert;
        public Vec3 norm;
        public Vec3 dispvert;
        public Vec3 dispnorm;
        public Vec2 pos;
        public double u;
        public double v;
        public double disp;
        public double tol;
        public float z;
        public float basez;
        public RGBColor diffuse;
        public RGBColor specular;
        public RGBColor highlight;

        public DisplacedVertex(RenderingTriangle tri, Vec3 vert, Vec3 norm, double u, double v, Mat4 toView, Mat4 toScreen, RasterContext context) {
            this.vert = vert;
            this.norm = norm;
            this.u = u;
            this.v = v;
            this.basez = (float)toView.timesZ(vert);
            this.tol = (double)this.basez > context.camera.getDistToScreen() ? Raster.this.smoothScale * (double)this.basez : Raster.this.smoothScale;
            this.disp = tri.getDisplacement(u, v, 1.0 - u - v, this.tol, 0.0);
            this.dispvert = new Vec3(vert.x + this.disp * norm.x, vert.y + this.disp * norm.y, vert.z + this.disp * norm.z);
            this.z = (float)toView.timesZ(this.dispvert);
            this.pos = toScreen.timesXY(this.dispvert);
        }

        public final void prepareToRender(RenderingTriangle tri, Vec3 viewdir, Vec3 ugrad, Vec3 vgrad, int shading, RasterContext context) {
            double w = 1.0 - this.u - this.v;
            double dhdu = (tri.getDisplacement(this.u + 1.0E-5, this.v, w - 1.0E-5, this.tol, 0.0) - this.disp) * 100000.0;
            double dhdv = (tri.getDisplacement(this.u, this.v + 1.0E-5, w - 1.0E-5, this.tol, 0.0) - this.disp) * 100000.0;
            this.dispnorm = new Vec3(this.norm);
            context.tempVec[0].set(dhdu * ugrad.x + dhdv * vgrad.x, dhdu * ugrad.y + dhdv * vgrad.y, dhdu * ugrad.z + dhdv * vgrad.z);
            this.dispnorm.scale(context.tempVec[0].dot(this.dispnorm) + 1.0);
            this.dispnorm.subtract(context.tempVec[0]);
            this.dispnorm.normalize();
            double d = this.tol = (double)this.z > context.camera.getDistToScreen() ? Raster.this.smoothScale * (double)this.z : Raster.this.smoothScale;
            if (shading == 0) {
                this.specular = new RGBColor();
                this.highlight = new RGBColor();
            }
            if (shading != 2) {
                this.diffuse = new RGBColor();
                tri.getTextureSpec(context.surfSpec, viewdir.dot(this.dispnorm), this.u, this.v, w, this.tol, Raster.this.time);
                Raster.this.calcLight(this.dispvert, this.dispnorm, viewdir, this.dispnorm, context.surfSpec.roughness, this.diffuse, this.specular, this.highlight, context);
                if (this.specular != null) {
                    this.specular.add(this.highlight);
                }
            }
        }
    }
}

