/*
 * Decompiled with CFR 0.152.
 */
package nik777.aoi;

import artofillusion.ApplicationPreferences;
import artofillusion.ArtOfIllusion;
import artofillusion.LayoutWindow;
import artofillusion.Plugin;
import artofillusion.PluginRegistry;
import artofillusion.ViewerCanvas;
import artofillusion.keystroke.KeystrokeManager;
import artofillusion.keystroke.KeystrokeRecord;
import artofillusion.ui.Translate;
import artofillusion.ui.UIUtilities;
import artofillusion.util.SearchlistClassLoader;
import buoy.event.MouseClickedEvent;
import buoy.event.WidgetEvent;
import buoy.widget.BFrame;
import buoy.widget.BLabel;
import buoy.widget.BMenu;
import buoy.widget.BMenuBar;
import buoy.widget.BMenuItem;
import buoy.widget.BOutline;
import buoy.widget.BPasswordField;
import buoy.widget.BTabbedPane;
import buoy.widget.BTextField;
import buoy.widget.BWindow;
import buoy.widget.MenuWidget;
import buoy.widget.Widget;
import buoy.widget.WindowWidget;
import buoyx.docking.DockableWidget;
import buoyx.docking.DockingContainer;
import com.jstatcom.component.JHelpAction;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Image;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Random;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.help.CSH;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import net.sourceforge.helpgui.gui.HelpFrame;
import net.sourceforge.helpgui.page.Page;
import net.sourceforge.helpgui.parser.DocSet;
import nik777.aoi.ComponentsWindow;
import nik777.chat.ChatFrame;
import nik777.chat.IRCConnector;

public class HelpPlugin
implements Plugin {
    static int helplib = 0;
    static boolean initialised = false;
    static boolean enabled = false;
    static HelpSet global;
    static HelpBroker broker;
    static DocSet docset;
    static String theme;
    protected static Properties helpprefs;
    static Writer map;
    static BWindow aboutWin;
    protected static BFrame curr;
    StringBuffer buff = null;
    protected static final int JAVAHELP_LIB = 1;
    protected static final int HELPGUI_LIB = 2;
    protected static final int MB = 0x100000;
    protected static final String mapHeader = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE map PUBLIC \"-//Sun Microsystems Inc.//DTD JavaHelp Map Version 1.0//EN\" \"http://java.sun.com/products/javahelp/map_2_0.dtd\"><!-- generated by ArtOfIllusion HelpPlugin Version: 1.0, see aoisp.sourceforge.net -->\n<map version=\"1.0\">\n";
    protected File prefdir;
    protected File AppDir;
    protected boolean inChat = false;
    static /* synthetic */ Class class$buoy$widget$Widget;
    static /* synthetic */ Class class$java$awt$Component;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void processMessage(int message, Object[] args) {
        if (this.AppDir == null) {
            this.AppDir = new File(ArtOfIllusion.APP_DIRECTORY);
        }
        switch (message) {
            case 0: {
                String script = this.load("/huh.bsh");
                if (script != null) {
                    KeystrokeManager.addRecord(new KeystrokeRecord(114, 0, "Huh Focus (HelpPlugin)", script));
                }
                if ((script = this.load("/help.bsh")) != null) {
                    KeystrokeManager.addRecord(new KeystrokeRecord(113, 0, "Help (HelpPlugin)", script));
                }
                if ((script = this.load("/what.bsh")) != null) {
                    KeystrokeManager.addRecord(new KeystrokeRecord(112, 0, "What's This? (HelpPlugin)", script));
                }
                this.init();
                break;
            }
            case 1: {
                if (map == null) break;
                map.write("\n</map>");
                map.flush();
                try {
                    map.close();
                }
                catch (IOException e1) {}
                break;
                catch (Exception e) {
                    try {
                        map.close();
                    }
                    catch (IOException e1) {}
                    break;
                    catch (Throwable throwable) {
                        try {
                            map.close();
                        }
                        catch (IOException e1) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                }
            }
            case 2: {
                int i;
                LayoutWindow win = (LayoutWindow)args[0];
                if (!initialised) {
                    initialised = true;
                    Locale local = Translate.getLocale();
                    Locale.setDefault(local);
                    SearchlistClassLoader loader = new SearchlistClassLoader(this.getClass().getClassLoader());
                    File dir = new File(ArtOfIllusion.PLUGIN_DIRECTORY, "Help");
                    try {
                        List<Object> list;
                        if (loader.getResource("helpset/AOIHelp.hs") == null) {
                            throw new RuntimeException("cannot load global helpset");
                        }
                        try {
                            JHelpAction.startHelpWorker("helpset/AOIHelp.hs");
                            Method getbroker = JHelpAction.class.getDeclaredMethod("getHelpBroker", null);
                            getbroker.setAccessible(true);
                            global = ((HelpBroker)getbroker.invoke(null, null)).getHelpSet();
                            helplib = 1;
                        }
                        catch (Throwable e) {
                            System.out.println("HelpPlugin: could not initialise JavaHelp");
                        }
                        if (helplib == 0) {
                            try {
                                docset = new DocSet(Translate.getLocale());
                                list = PluginRegistry.getPlugins(DocSet.Parser.class);
                                for (i = 0; i < list.size(); ++i) {
                                    DocSet.Parser parser = (DocSet.Parser)list.get(i);
                                    System.out.println("HelpPlugin.INIT: registering parser: " + parser.getClass().getName());
                                    DocSet.registerParser((DocSet.Parser)parser);
                                }
                                docset.setLoader((ClassLoader)loader);
                                docset.add("helpset/AOIHelp.hs", null);
                                helplib = 2;
                            }
                            catch (Throwable t) {
                                System.out.println("HelpPlugin: could not initialise HelpGUI");
                            }
                        }
                        HelpSet helpset = global;
                        Page parent = null;
                        enabled = helplib != 0;
                        File[] files = dir.listFiles();
                        ZipFile zf = null;
                        ZipEntry ze = null;
                        URL[] url = new URL[1];
                        for (i = 0; i < files.length; ++i) {
                            int subcount;
                            File[] subdir;
                            if (files[i].isDirectory()) {
                                subdir = files[i].listFiles();
                                subcount = subdir.length;
                                if (subcount > 0) {
                                    if (helplib == 1) {
                                        helpset = new HelpSet(loader);
                                        global.add(helpset);
                                    } else if (helplib == 2) {
                                        parent = docset.addSection(files[i].getName(), null);
                                    }
                                }
                            } else {
                                subdir = null;
                                subcount = 1;
                                helpset = global;
                                parent = null;
                            }
                            for (int k = 0; k < subcount; ++k) {
                                File helpfile = subdir != null ? subdir[k] : files[i];
                                try {
                                    zf = new ZipFile(helpfile);
                                    Enumeration<? extends ZipEntry> iter = zf.entries();
                                    while (iter.hasMoreElements()) {
                                        ze = iter.nextElement();
                                        if (ze.isDirectory()) continue;
                                        if (ze.getName().endsWith(".hs")) break;
                                        ze = null;
                                    }
                                    if (ze == null) continue;
                                    String basename = ze.getName();
                                    int cut = basename.lastIndexOf(46);
                                    if (cut > 0) {
                                        basename = basename.substring(0, cut);
                                    }
                                    System.out.println("HelpPlugin.ADD: " + basename);
                                    url[0] = helpfile.toURI().toURL();
                                    URLClassLoader ldr = new URLClassLoader(url);
                                    PluginRegistry.registerResource("help", basename, ldr, ze.getName(), null);
                                    continue;
                                }
                                catch (Exception e) {
                                    continue;
                                }
                                finally {
                                    if (zf != null) {
                                        zf.close();
                                        zf = null;
                                    }
                                }
                            }
                        }
                        HelpSet plugset = null;
                        if (helplib == 1) {
                            plugset = new HelpSet(loader);
                        }
                        list = PluginRegistry.getResources("help");
                        System.out.println("resources found=" + list.size());
                        if (list.size() > 0) {
                            if (docset != null) {
                                parent = docset.addSection("Plugins", null);
                            }
                            for (i = 0; i < list.size(); ++i) {
                                PluginRegistry.PluginResource resource = (PluginRegistry.PluginResource)list.get(i);
                                if (resource.getId().equals("helpset/AOIHelp")) continue;
                                System.out.println("Help: linking: " + resource.getURL().getPath());
                                loader.add(resource.getClassLoader());
                                System.out.println("loading: " + resource.getId() + " from " + resource.getURL().getPath());
                                if (plugset != null) {
                                    plugset.add(new HelpSet(loader, resource.getURL()));
                                    continue;
                                }
                                loader.add(resource.getClassLoader());
                                docset.add(resource.getURL().getPath(), parent);
                            }
                        }
                        if (helpset != null) {
                            helpset.add(plugset);
                        }
                    }
                    catch (Exception e) {
                        System.out.println("HelpPlugin.INIT: " + e);
                        e.printStackTrace(System.out);
                    }
                }
                try {
                    BMenuBar mbar = win.getMenuBar();
                    BMenu helpmenu = Translate.menu("HelpPlugin:Help");
                    mbar.add(helpmenu);
                    BMenuItem item = Translate.menuItem("HelpPlugin:AOIHelp", this, "show");
                    helpmenu.add((MenuWidget)item);
                    item.setEnabled(enabled);
                    item = Translate.menuItem("HelpPlugin:WhatsThis", this, "what");
                    helpmenu.add((MenuWidget)item);
                    item.setEnabled(enabled && helplib == 1);
                    item = Translate.menuItem("HelpPlugin:LiveHelp", this, "chat");
                    helpmenu.add((MenuWidget)item);
                    helpmenu.addSeparator();
                    item = Translate.menuItem("HelpPlugin:About", this, "about");
                    helpmenu.add((MenuWidget)item);
                }
                catch (Exception e) {
                    System.out.println("HelpPlugin: error adding menu: " + e);
                }
                catch (Throwable t) {
                    System.out.println("HelpPlugin: error adding menu: " + t);
                    t.printStackTrace(System.out);
                    return;
                }
                for (i = 0; i < 4; ++i) {
                    DockingContainer dock;
                    switch (i) {
                        case 0: {
                            dock = win.getDockingContainer(BTabbedPane.TOP);
                            break;
                        }
                        case 1: {
                            dock = win.getDockingContainer(BTabbedPane.BOTTOM);
                            break;
                        }
                        case 2: {
                            dock = win.getDockingContainer(BTabbedPane.LEFT);
                            break;
                        }
                        case 3: {
                            dock = win.getDockingContainer(BTabbedPane.RIGHT);
                            break;
                        }
                        default: {
                            return;
                        }
                    }
                    Iterator iter = dock.getChildren().iterator();
                    while (iter.hasNext()) {
                        Object obj = iter.next();
                        if (!(obj instanceof DockableWidget)) continue;
                        DockableWidget dockable = (DockableWidget)obj;
                        Component comp = dockable.getComponent();
                        if (helplib != 1 || CSH.getHelpIDString(comp) != null) continue;
                        HelpPlugin.register(comp, "Docking." + dockable.getLabel(), null);
                    }
                }
                HelpPlugin.register(args[0], "LayoutWindow", null);
                break;
            }
            case 3: {
                HelpPlugin.register(args[0], null, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        File helpflags;
        if (this.prefdir == null) {
            this.prefdir = ApplicationPreferences.getPreferencesDirectory();
        }
        if ((helpflags = new File(this.prefdir, "HelpPlugin.props")).exists()) {
            System.out.println("HelpPlugin.init: processing prefs");
            InputStream in = null;
            try {
                helpprefs = new Properties();
                in = new FileInputStream(helpflags);
                helpprefs.load(in);
                String mapfile = helpprefs.getProperty("MapFile");
                if (mapfile != null && mapfile.length() > 0) {
                    System.out.println("HelpPlugin.init: mapfile=" + mapfile);
                    map = new OutputStreamWriter((OutputStream)new FileOutputStream(mapfile), "UTF-8");
                    map.write(mapHeader);
                }
                theme = helpprefs.getProperty("Theme");
            }
            catch (IOException e) {
                System.out.println("HelpPlugin: reading HelpFlags: " + e);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        if (theme == null) {
            theme = "plastic";
        }
        try {
            PluginRegistry.registerResource("TranslateBundle", "HelpPlugin", this.getClass().getClassLoader(), "helpplugin", null);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            Locale local = Translate.getLocale();
            ClassLoader loader = this.getClass().getClassLoader();
            PluginRegistry.invokeExportedMethod("artofillusion.SPManager.registerResource", "TranslateBundle", "HelpPlugin", loader, "helpplugin", local);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public BFrame getContext() {
        return curr;
    }

    public void show(WidgetEvent ev) {
        if (ev != null) {
            curr = UIUtilities.findFrame(ev.getWidget());
        }
        System.out.println("Help.show: curr=" + curr);
        if (helplib == 1) {
            JHelpAction.showHelp();
        } else if (helplib == 2) {
            HelpFrame helpframe = new HelpFrame(docset, theme);
            try {
                URL url = this.getClass().getResource("/artofillusion/Icons/appIcon.png");
                if (url != null) {
                    helpframe.setIconImage((Image)ImageIO.read(url.openStream()));
                } else {
                    System.out.println("HelpPlugin.show: cannot find icon");
                }
            }
            catch (Exception e) {
                System.out.println("HelpPlugin.show: " + e);
            }
            helpframe.setVisible(true);
        }
    }

    public void huh(WidgetEvent ev) {
        if (ev != null) {
            curr = UIUtilities.findFrame(ev.getWidget());
        }
        if (helplib == 1) {
            JHelpAction.showHelpFromFocus();
        }
    }

    public void what(WidgetEvent ev) {
        if (ev != null) {
            curr = UIUtilities.findFrame(ev.getWidget());
        }
        if (helplib == 1) {
            JHelpAction.trackFieldHelp();
        }
    }

    public void chat(WidgetEvent ev) {
        File path = new File(this.AppDir, "Plugins");
        path = new File(path, "HelpPlugin.jar");
        try {
            String[] cmd = new String[]{"java", "-jar", path.getAbsolutePath(), "-c", "chat"};
            Runtime.getRuntime().exec(cmd);
        }
        catch (Throwable t) {
            System.out.println("Error invoking help: " + t);
        }
    }

    public void chat() {
        Color frameColour = null;
        Font font = null;
        String id = null;
        String chan = "#aoi";
        System.out.println("helpprefs=" + helpprefs);
        if (helpprefs != null) {
            String tmp;
            try {
                tmp = helpprefs.getProperty("chat.colour");
                if (tmp != null) {
                    frameColour = Color.decode(tmp);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                tmp = helpprefs.getProperty("chat.font");
                if (tmp != null) {
                    font = Font.decode(tmp);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            chan = helpprefs.getProperty("chat.channel");
            id = helpprefs.getProperty("chat.id");
        }
        if (frameColour == null) {
            frameColour = new Color(204, 204, 255);
        }
        if (font == null) {
            font = Font.decode("Arial-PLAIN-12");
        }
        if (chan == null) {
            chan = "#aoi";
        }
        BTextField chanField = new BTextField(chan, 15);
        BTextField idField = new BTextField(id, 15);
        BPasswordField pwField = new BPasswordField("", 15);
        pwField.setEchoChar('*');
        idField.requestFocus();
        Widget[] widgets = new Widget[]{chanField, idField, pwField};
        String[] labels = new String[]{Translate.text("HelpPlugin:channel"), Translate.text("HelpPlugin:name"), Translate.text("HelpPlugin:password")};
        this.inChat = false;
        ComponentsWindow dlg = new ComponentsWindow(Translate.text("HelpPlugin:login"), widgets, labels);
        System.out.println("window closed...");
        if (!dlg.clickedOk()) {
            return;
        }
        this.inChat = true;
        System.out.println("ok, connecting to IRC...");
        chan = chanField.getText();
        id = idField.getText();
        ChatFrame chat = new ChatFrame(frameColour, font, id, chan, true);
        if (theme != null) {
            ChatFrame.iconsPath = theme;
        }
        IRCConnector irc = new IRCConnector();
        chat.open(irc);
        chat.join(chan, id, pwField.getText());
        chat.semaphore(this);
        chat.setVisible(true);
        if (this.prefdir != null) {
            if (helpprefs == null) {
                helpprefs = new Properties();
            }
            helpprefs.setProperty("chat.channel", chan);
            helpprefs.setProperty("chat.id", id);
            helpprefs.setProperty("chat.font", font.getFontName() + " " + font.getSize());
            try {
                File helpprops = new File(this.prefdir, "HelpPlugin.props");
                FileOutputStream os = new FileOutputStream(helpprops);
                helpprefs.store(os, "# (re)generated by HelpPlugin");
                os.flush();
                ((OutputStream)os).close();
            }
            catch (Exception e) {
                System.out.println("HelpPlugin.chat: savinf prefs: " + e);
            }
        }
    }

    public void about() {
        try {
            aboutWin = new BWindow();
            aboutWin.addEventLink(MouseClickedEvent.class, new Object(){

                void processEvent() {
                    aboutWin.setVisible(false);
                    aboutWin.dispose();
                }
            });
            Runtime runtime = Runtime.getRuntime();
            int cpus = 1;
            try {
                cpus = runtime.availableProcessors();
            }
            catch (Exception e) {
                // empty catch block
            }
            String vname = ArtOfIllusion.getVersion();
            int imageNumber = new Random(System.currentTimeMillis()).nextInt(8);
            ImageIcon image = new ImageIcon(this.getClass().getResource("/artofillusion/titleImages/titleImage" + imageNumber + ".jpg"));
            String text = "<html><div align='center'>Art Of Illusion v" + vname + "<br>Copyright 1999-2012 by Peter Eastman and others" + "<br>(See the README file for details.)" + "<br>This program may be freely distributed under" + "<br>the terms of the accompanying license.</div>" + "<p><div align='left'><hr>" + Translate.text("HelpPlugin:java", System.getProperty("java.version"), System.getProperty("java.vendor")) + "<br>" + Translate.text("HelpPlugin:OS", new Object[]{System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("os.arch")}) + "<br>" + Translate.text("HelpPlugin:memory", new Object[]{new Long((runtime.totalMemory() - runtime.freeMemory()) / 0x100000L), new Long(runtime.totalMemory() / 0x100000L), new Long(runtime.maxMemory() / 0x100000L)}) + "<br>" + Translate.text("HelpPlugin:cpus", new Integer(cpus)) + "<br>" + Translate.text("HelpPlugin:opengl", ViewerCanvas.isOpenGLAvailable() ? Translate.text("HelpPlugin:available") : Translate.text("HelpPlugin:unavailable"), ArtOfIllusion.getPreferences().getUseOpenGL() ? Translate.text("HelpPlugin:enabled") : Translate.text("HelpPlugin:disabled")) + "</div></html>";
            BLabel label = new BLabel(text, (Icon)image, BLabel.NORTH, BLabel.SOUTH);
            label.setFont(new Font("Serif", 0, 12));
            BOutline content = BOutline.createLineBorder((Widget)new BOutline((Widget)label, BorderFactory.createEmptyBorder(0, 0, 5, 0)), (Color)Color.BLACK, (int)1);
            Color background = Color.white;
            if (imageNumber == 4) {
                background = new Color(204, 204, 255);
            } else if (imageNumber == 6) {
                background = new Color(232, 255, 232);
            }
            UIUtilities.applyBackground((Widget)content, background);
            aboutWin.setContent((Widget)content);
            aboutWin.pack();
            Rectangle bounds = aboutWin.getBounds();
            ++bounds.height;
            aboutWin.setBounds(bounds);
            UIUtilities.centerWindow((WindowWidget)aboutWin);
            aboutWin.setVisible(true);
        }
        catch (Exception e) {
            System.out.println("HelpPlugin.about: " + e);
        }
    }

    public static void register(Object obj, String id) {
        HelpPlugin.register(obj, id, null);
    }

    public static void unregister(Object obj) {
        HelpPlugin.register(obj, null, null);
    }

    public static void register(Object obj, String id, HelpSet helpset) {
        System.out.println(id != null ? "registering " + id : "unregistering");
        if (helplib != 1) {
            return;
        }
        Component component = null;
        if (obj instanceof Component) {
            component = (Component)obj;
        } else if (obj instanceof Widget) {
            component = ((Widget)obj).getComponent();
        }
        if (component != null) {
            System.out.println("component= " + component.getClass().getName());
            CSH.setHelpIDString(component, id);
            if (id != null) {
                if (global == null) {
                    System.out.println("global is null");
                }
                if (helpset != null) {
                    CSH.setHelpSet(component, helpset);
                } else if (global != null) {
                    CSH.setHelpSet(component, global);
                }
                System.out.println("Mapped ID=" + CSH.getHelpIDString(component));
                if (map != null) {
                    try {
                        map.write("\n<mapID target=\"");
                        map.write(id);
                        map.write("\" url=\"\" />");
                    }
                    catch (IOException e) {
                        System.out.println("HelpPlugin.register writing map: " + e);
                    }
                }
            }
        }
    }

    public static void makeMap_dont_use(String id, Object obj, Writer map) {
        Field fld;
        int i;
        Object parent;
        Field[] field = null;
        Object widget = null;
        Object component = null;
        if (obj instanceof Widget) {
            widget = (Widget)obj;
            parent = widget.getParent();
            try {
                while (parent != null) {
                    System.out.println("Help.makeMap: parent=" + parent.getClass().getName());
                    System.out.println("pop");
                    widget = parent;
                    parent = widget.getParent();
                }
            }
            catch (Exception e) {
                System.out.println("HelpPlugin.makeMap: finding top: " + e);
            }
            obj = widget;
        } else if (obj instanceof Component) {
            component = (Component)obj;
            parent = ((Component)component).getParent();
            try {
                while (parent != null) {
                    field = parent.getClass().getDeclaredFields();
                    System.out.println("Help.makeMap: parent=" + parent.getClass().getName());
                    System.out.println("pop");
                    component = parent;
                    parent = ((Component)component).getParent();
                    for (i = 0; i < field.length; ++i) {
                        fld = field[i];
                        fld.setAccessible(true);
                        if (fld.get(parent) != component) continue;
                        System.out.println("Help.makeMap: found top");
                        parent = null;
                        break;
                    }
                    if (i < field.length) continue;
                    System.out.println("pop...");
                    component = parent;
                    parent = ((Component)component).getParent();
                }
            }
            catch (Exception e) {
                System.out.println("HelpPlugin.makeMap: finding top: " + e);
            }
            obj = component;
        }
        System.out.println("HelpPlugin.makeMap: top level is a " + obj.getClass().getName());
        try {
            if (widget != null || component != null) {
                map.write("\n<mapID target='");
                map.write(id);
                map.write("' url='' />");
            }
            field = obj.getClass().getDeclaredFields();
            for (i = 0; i < field.length; ++i) {
                fld = field[i];
                String name = fld.getName();
                System.out.println("Help.makeMap: field=" + name);
                if (Modifier.isStatic(fld.getModifiers()) || name.length() == 0 || name.indexOf(36) >= 0) continue;
                try {
                    Class<?> type = fld.getType();
                    if (!(class$buoy$widget$Widget == null ? HelpPlugin.class$("buoy.widget.Widget") : class$buoy$widget$Widget).isAssignableFrom(type) && !(class$java$awt$Component == null ? HelpPlugin.class$("java.awt.Component") : class$java$awt$Component).isAssignableFrom(type)) continue;
                    fld.setAccessible(true);
                    Object child = fld.get(obj);
                    if (child == null || child == obj) continue;
                    HelpPlugin.makeMap_dont_use(id + "." + name, child, map);
                    continue;
                }
                catch (Exception e) {
                    System.out.println("HelpPlugin.makeMap (" + id + "): " + e);
                }
            }
        }
        catch (IOException e) {
            System.out.println("HelpPlugin.makeMap: " + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String load(String path) {
        if (this.buff == null) {
            this.buff = new StringBuffer(512);
        } else {
            this.buff.setLength(0);
        }
        InputStream is = null;
        try {
            int c;
            is = this.getClass().getResourceAsStream(path);
            if (is == null) {
                String string = null;
                return string;
            }
            InputStreamReader in = new InputStreamReader(is, "UTF-8");
            while ((c = in.read()) != -1) {
                this.buff.append((char)c);
            }
        }
        catch (IOException e) {
            System.out.println("HelpPlugin: unable to load resource: " + e);
        }
        finally {
            try {
                is.close();
            }
            catch (Exception exception) {}
        }
        return this.buff.length() > 0 ? this.buff.toString() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] argv) {
        char slash = File.separatorChar;
        String AppDir = System.getProperty("user.dir");
        try {
            int cut;
            URL url = HelpPlugin.class.getResource("/nik777/aoi/HelpPlugin.class");
            System.out.println("HelpPlugin.main: url=" + url);
            System.out.println("HelpPlugin.main: path=" + url.getPath());
            String furl = url.getPath();
            if (furl.indexOf(33) < 0) {
                furl = url.toString();
            }
            if ((cut = furl.indexOf(33)) > 0) {
                if ((cut = (furl = furl.substring(0, cut)).indexOf("jar:")) >= 0) {
                    furl = furl.substring(cut + "jar:".length());
                }
                if (!furl.startsWith("file:")) {
                    furl = "file:" + furl;
                }
                System.out.println("HelpPlugin.main: furl=" + furl);
                File dir = new File(new URL(furl).getPath()).getParentFile().getParentFile();
                System.out.println("HelpPlugin.main: dir=" + dir.getAbsolutePath());
                AppDir = dir.exists() ? dir.getAbsolutePath() : System.getProperty("user.dir");
                System.out.println("HelpPlugin.main: app_dir=" + AppDir);
            }
        }
        catch (Exception ex) {
            System.out.println("Error looking up app_dir: " + ex);
        }
        HelpPlugin help = new HelpPlugin();
        help.AppDir = new File(AppDir);
        help.init();
        String cmd = null;
        for (int i = 0; i < argv.length; ++i) {
            if (!argv[i].equalsIgnoreCase("-c")) continue;
            if (i >= argv.length - 1) break;
            cmd = argv[i + 1];
            break;
        }
        if (cmd.equalsIgnoreCase("chat")) {
            help.chat();
        } else if (cmd.equalsIgnoreCase("show")) {
            // empty if block
        }
        if (help.inChat) {
            HelpPlugin helpPlugin = help;
            synchronized (helpPlugin) {
                try {
                    help.wait();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        System.exit(0);
    }

    static {
        theme = null;
        map = null;
    }
}

