/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.view;

import artofillusion.RenderingMesh;
import artofillusion.RenderingTriangle;
import artofillusion.math.FastMath;
import artofillusion.math.RGBColor;
import artofillusion.math.Vec3;
import artofillusion.object.Object3D;
import artofillusion.texture.ConstantParameterValue;
import artofillusion.texture.ParameterValue;
import artofillusion.texture.TextureSpec;
import artofillusion.texture.UniformMapping;
import artofillusion.texture.VertexParameterValue;
import artofillusion.view.SmoothVertexShader;
import artofillusion.view.VertexShader;
import java.lang.ref.SoftReference;
import java.util.WeakHashMap;

public class TexturedVertexShader
implements VertexShader {
    private TextureSpec spec;
    private RenderingMesh mesh;
    private Vec3 viewDir;
    private double time;
    private double[] roughnessCache;
    private RGBColor[] diffuseCache;
    private RGBColor[] emissiveCache;
    private RGBColor[] hilightCache;
    private boolean cache;
    private int textureID;
    private static final WeakHashMap<RenderingMesh, SoftReference<TexturedVertexShader>> cachedShaderMap = new WeakHashMap();

    public TexturedVertexShader(RenderingMesh mesh, Object3D object, double time, Vec3 viewDir) {
        this.mesh = mesh;
        this.time = time;
        this.viewDir = viewDir;
        this.spec = new TextureSpec();
        this.textureID = mesh.mapping.getTexture().getID();
        this.cache = true;
        ParameterValue[] value = object.getParameterValues();
        for (int i = 0; i < value.length; ++i) {
            if (value[i] instanceof ConstantParameterValue || value[i] instanceof VertexParameterValue) continue;
            this.cache = false;
            return;
        }
    }

    public VertexShader optimize() {
        if (this.mesh.mapping instanceof UniformMapping && !this.mesh.mapping.getTexture().hasComponent(3)) {
            this.mesh.mapping.getTexture().getAverageSpec(this.spec, this.time, null);
            RGBColor color = new RGBColor((double)(this.spec.diffuse.getRed() + this.spec.emissive.getRed()) + 0.5 * (double)this.spec.specular.getRed(), (double)(this.spec.diffuse.getGreen() + this.spec.emissive.getGreen()) + 0.5 * (double)this.spec.specular.getGreen(), (double)(this.spec.diffuse.getBlue() + this.spec.emissive.getBlue()) + 0.5 * (double)this.spec.specular.getBlue());
            color.clip();
            return new SmoothVertexShader(this.mesh, color, this.viewDir);
        }
        if (this.cache) {
            TexturedVertexShader shader;
            SoftReference<TexturedVertexShader> ref = cachedShaderMap.get(this.mesh);
            if (ref != null && (shader = ref.get()) != null && shader.textureID == this.textureID) {
                shader.viewDir = this.viewDir;
                return shader;
            }
            cachedShaderMap.put(this.mesh, new SoftReference<TexturedVertexShader>(this));
        }
        return this;
    }

    public void getColor(int face, int vertex, RGBColor color) {
        double roughness;
        RGBColor hilight;
        RGBColor emissive;
        RGBColor diffuse;
        double dot;
        RenderingTriangle tri = this.mesh.triangle[face];
        if (this.cache) {
            int vert;
            if (this.diffuseCache == null) {
                this.diffuseCache = new RGBColor[this.mesh.vert.length];
                this.emissiveCache = new RGBColor[this.mesh.vert.length];
                this.hilightCache = new RGBColor[this.mesh.vert.length];
                this.roughnessCache = new double[this.mesh.vert.length];
            }
            switch (vertex) {
                case 0: {
                    vert = tri.v1;
                    dot = this.viewDir.dot(this.mesh.norm[tri.n1]);
                    if (this.diffuseCache[vert] != null) break;
                    tri.getTextureSpec(this.spec, dot, 1.0, 0.0, 0.0, 0.1, this.time);
                    this.diffuseCache[vert] = this.spec.diffuse.duplicate();
                    this.emissiveCache[vert] = this.spec.emissive.duplicate();
                    this.hilightCache[vert] = this.spec.hilight.duplicate();
                    this.roughnessCache[vert] = this.spec.roughness;
                    break;
                }
                case 1: {
                    vert = tri.v2;
                    dot = this.viewDir.dot(this.mesh.norm[tri.n2]);
                    if (this.diffuseCache[vert] != null) break;
                    tri.getTextureSpec(this.spec, dot, 0.0, 1.0, 0.0, 0.1, this.time);
                    this.diffuseCache[vert] = this.spec.diffuse.duplicate();
                    this.emissiveCache[vert] = this.spec.emissive.duplicate();
                    this.hilightCache[vert] = this.spec.hilight.duplicate();
                    this.roughnessCache[vert] = this.spec.roughness;
                    break;
                }
                default: {
                    vert = tri.v3;
                    dot = this.viewDir.dot(this.mesh.norm[tri.n3]);
                    if (this.diffuseCache[vert] != null) break;
                    tri.getTextureSpec(this.spec, dot, 0.0, 0.0, 1.0, 0.1, this.time);
                    this.diffuseCache[vert] = this.spec.diffuse.duplicate();
                    this.emissiveCache[vert] = this.spec.emissive.duplicate();
                    this.hilightCache[vert] = this.spec.hilight.duplicate();
                    this.roughnessCache[vert] = this.spec.roughness;
                }
            }
            diffuse = this.diffuseCache[vert];
            emissive = this.emissiveCache[vert];
            hilight = this.hilightCache[vert];
            roughness = this.roughnessCache[vert];
        } else {
            switch (vertex) {
                case 0: {
                    dot = this.viewDir.dot(this.mesh.norm[tri.n1]);
                    tri.getTextureSpec(this.spec, dot, 1.0, 0.0, 0.0, 0.01, this.time);
                    break;
                }
                case 1: {
                    dot = this.viewDir.dot(this.mesh.norm[tri.n2]);
                    tri.getTextureSpec(this.spec, dot, 0.0, 1.0, 0.0, 0.01, this.time);
                    break;
                }
                default: {
                    dot = this.viewDir.dot(this.mesh.norm[tri.n3]);
                    tri.getTextureSpec(this.spec, dot, 0.0, 0.0, 1.0, 0.01, this.time);
                }
            }
            diffuse = this.spec.diffuse;
            emissive = this.spec.emissive;
            hilight = this.spec.hilight;
            roughness = this.spec.roughness;
        }
        double absDot = dot > 0.0 ? dot : -dot;
        color.setRGB((double)diffuse.getRed() * absDot + (double)emissive.getRed(), (double)diffuse.getGreen() * absDot + (double)emissive.getGreen(), (double)diffuse.getBlue() * absDot + (double)emissive.getBlue());
        if ((double)(hilight.getRed() + hilight.getGreen() + hilight.getBlue()) > 0.0) {
            float intensity = (float)FastMath.pow(absDot, (int)((1.0 - roughness) * 128.0) + 1);
            color.add(hilight.getRed() * intensity, hilight.getGreen() * intensity, hilight.getBlue() * intensity);
        }
        color.clip();
    }

    public boolean isUniformFace(int face) {
        return false;
    }

    public boolean isUniformTexture() {
        return this.mesh.mapping instanceof UniformMapping;
    }

    public void getTextureSpec(TextureSpec spec) {
        this.mesh.mapping.getTexture().getAverageSpec(spec, this.time, null);
    }

    public static void clearCachedShaders(RenderingMesh mesh) {
        cachedShaderMap.remove(mesh);
    }
}

