/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.view;

import artofillusion.RenderingMesh;
import artofillusion.RenderingTriangle;
import artofillusion.math.RGBColor;
import artofillusion.math.Vec3;
import artofillusion.texture.ConstantParameterValue;
import artofillusion.texture.FaceParameterValue;
import artofillusion.texture.ParameterValue;
import artofillusion.texture.TextureSpec;
import artofillusion.view.VertexShader;

public class ParameterVertexShader
implements VertexShader {
    private ParameterValue param;
    private RGBColor lowColor;
    private RGBColor highColor;
    private double minValue;
    private double maxValue;
    private double rprimehigh;
    private double gprimehigh;
    private double bprimehigh;
    private double rprimelow;
    private double gprimelow;
    private double bprimelow;
    private RenderingMesh mesh;
    private Vec3 viewDir;
    private float[] light;

    public ParameterVertexShader(RenderingMesh mesh, ParameterValue param, RGBColor lowColor, RGBColor highColor, double minValue, double maxValue, Vec3 viewDir) {
        this.mesh = mesh;
        this.param = param;
        this.lowColor = lowColor;
        this.highColor = highColor;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.viewDir = viewDir;
        this.light = new float[mesh.norm.length];
        this.rprimehigh = Math.pow(highColor.getRed(), 2.2222222222222223);
        this.gprimehigh = Math.pow(highColor.getGreen(), 2.2222222222222223);
        this.bprimehigh = Math.pow(highColor.getBlue(), 2.2222222222222223);
        this.rprimelow = Math.pow(lowColor.getRed(), 2.2222222222222223);
        this.gprimelow = Math.pow(lowColor.getGreen(), 2.2222222222222223);
        this.bprimelow = Math.pow(lowColor.getBlue(), 2.2222222222222223);
        if (minValue == -1.7976931348623157E308 || maxValue == Double.MAX_VALUE) {
            double min = Double.MAX_VALUE;
            double max = -1.7976931348623157E308;
            for (int i = 0; i < mesh.triangle.length; ++i) {
                RenderingTriangle tri = mesh.triangle[i];
                double value = param.getValue(i, tri.v1, tri.v2, tri.v3, 1.0, 0.0, 0.0);
                min = Math.min(min, value);
                max = Math.max(max, value);
                value = param.getValue(i, tri.v1, tri.v2, tri.v3, 0.0, 1.0, 0.0);
                min = Math.min(min, value);
                max = Math.max(max, value);
                value = param.getValue(i, tri.v1, tri.v2, tri.v3, 0.0, 0.0, 1.0);
                min = Math.min(min, value);
                max = Math.max(max, value);
            }
            if (minValue == -1.7976931348623157E308) {
                minValue = min;
            }
            if (maxValue == Double.MAX_VALUE) {
                maxValue = max;
            }
        }
    }

    public void getColor(int face, int vertex, RGBColor color) {
        double value;
        int norm;
        RenderingTriangle tri = this.mesh.triangle[face];
        switch (vertex) {
            case 0: {
                norm = this.mesh.triangle[face].n1;
                value = this.param.getValue(face, tri.v1, tri.v2, tri.v3, 1.0, 0.0, 0.0);
                break;
            }
            case 1: {
                norm = this.mesh.triangle[face].n2;
                value = this.param.getValue(face, tri.v1, tri.v2, tri.v3, 0.0, 1.0, 0.0);
                break;
            }
            default: {
                norm = this.mesh.triangle[face].n3;
                value = this.param.getValue(face, tri.v1, tri.v2, tri.v3, 0.0, 0.0, 1.0);
            }
        }
        if (this.light[norm] == 0.0f) {
            float dot = (float)this.viewDir.dot(this.mesh.norm[norm]);
            this.light[norm] = 0.1f + 0.8f * (dot > 0.0f ? dot : -dot);
        }
        if (this.maxValue > this.minValue) {
            double fract1 = (value - this.minValue) / (this.maxValue - this.minValue);
            double fract2 = 1.0 - fract1;
            color.setRGB(Math.pow(fract1 * this.rprimehigh + fract2 * this.rprimelow, 0.45), Math.pow(fract1 * this.gprimehigh + fract2 * this.gprimelow, 0.45), Math.pow(fract1 * this.bprimehigh + fract2 * this.bprimelow, 0.45));
        } else {
            color.copy(this.lowColor);
        }
        color.scale(this.light[norm]);
    }

    public boolean isUniformFace(int face) {
        if (!(this.param instanceof ConstantParameterValue) && !(this.param instanceof FaceParameterValue)) {
            return false;
        }
        RenderingTriangle tri = this.mesh.triangle[face];
        return tri.n1 == tri.n2 && tri.n1 == tri.n3;
    }

    public boolean isUniformTexture() {
        return this.param instanceof ConstantParameterValue;
    }

    public void getTextureSpec(TextureSpec spec) {
        double value = this.param.getAverageValue();
        double fract1 = (value - this.minValue) / (this.maxValue - this.minValue);
        double fract2 = 1.0 - fract1;
        spec.diffuse.setRGB(fract1 * (double)this.highColor.getRed() + fract2 * (double)this.lowColor.getRed(), fract1 * (double)this.highColor.getGreen() + fract2 * (double)this.lowColor.getGreen(), fract1 * (double)this.highColor.getBlue() + fract2 * (double)this.lowColor.getBlue());
        spec.hilight.setRGB(0.0f, 0.0f, 0.0f);
        spec.emissive.setRGB(0.0f, 0.0f, 0.0f);
    }
}

