/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.util;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IconGenerator {
    public static final byte FEATHER_OUT_DIR = 1;
    public static final byte FEATHER_IN_DIR = 2;
    protected Instruction program = null;
    protected int imageWidth;
    protected int imageHeight;
    protected String[] delims;
    protected static final byte ARG_LIST = 0;
    protected static final byte ARG_RESOLVE = 1;
    protected static final byte ARG_NUMBER = 2;
    protected static final byte OP_NONE = 0;
    protected static final byte OP_COMPOSIT = 1;
    protected static final byte OP_OVERLAY = 2;
    protected static final byte OP_ADD = 3;
    protected static final byte OP_SUBTRACT = 4;
    protected static final byte OP_MULTIPLY = 5;
    protected static final byte OP_ASSIGN = 6;
    protected static final byte OP_SCALE = 7;
    protected static final byte OP_FEATHER = 8;
    protected static final byte OP_POSITION = 9;
    protected static final byte OP_RESIZE = 10;
    protected static final byte OP_CALL = 11;
    protected static final byte OP_COLOR = 12;
    protected static final byte OP_ARG = 13;
    protected static final byte OP_LIST = 13;
    protected static final byte OP_RESOLVE = 14;
    protected static final byte OP_NUMBER = 15;
    protected static final int OPS = 0;
    protected static final int ARG_DELIMS = 1;
    protected static final int OPEN_CLOSE = 2;
    protected static final String[] DEFAULT_DELIMS = new String[]{";|+-*=%~@[.#", ",{0", "()[]{}"};
    protected static final String QUOTES = "\"'";
    protected static final String WHITESPACE = " \t\r\n";
    protected static final String DEFAULT_TARGET = "{}";
    protected static final float SCALE_DOWN = 0.003921569f;
    protected static final Class[] NULL_SIG = new Class[0];
    protected static final Object[] NULL_ARGS = new Object[0];
    private static final String dots = "................................................................................";

    public IconGenerator(String macro) throws Exception {
        this.delims = DEFAULT_DELIMS;
        this.compile(macro);
    }

    public IconGenerator(String macro, String[] delims) throws Exception {
        this.delims = delims;
        this.compile(macro);
    }

    public void compile(String macro) throws Exception {
        int len = macro.length();
        this.program = new Instruction(this.imageWidth, this.imageHeight);
        this.program.compile(macro, 0, this.delims);
        Instruction instr = this.program;
        int pos = this.program.end + 1;
        while (pos < len) {
            instr = instr.compileNext(this.delims);
            pos = instr.end + 1;
        }
    }

    public void setSize(int width, int height) {
        this.imageWidth = width;
        this.imageHeight = height;
        if (this.program != null) {
            this.program.setSize(width, height);
        }
    }

    public Image execute(Map<String, Object> namespace, ClassLoader loader) throws Exception {
        if (this.program == null) {
            throw new Exception("IconGenerator has no compiled program");
        }
        return this.program.execute(null, namespace, loader);
    }

    public static Image apply(String macro, String[] delims, Map<String, Object> namespace, ClassLoader loader, int width, int height) throws Exception {
        int len = macro.length();
        Instruction instr = new Instruction(width, height);
        BufferedImage result = null;
        int pos = 0;
        while (pos < len) {
            instr.compile(macro, pos, delims);
            result = instr.execute(result, namespace, loader);
            pos = instr.end + 1;
        }
        return result;
    }

    public static Image apply(String macro, String[] delims, Map<String, Object> namespace, ClassLoader loader) throws Exception {
        return IconGenerator.apply(macro, delims, namespace, loader, -1, -1);
    }

    public static Image apply(String macro, Map<String, Object> namespace, ClassLoader loader) throws Exception {
        return IconGenerator.apply(macro, DEFAULT_DELIMS, namespace, loader, -1, -1);
    }

    public static BufferedImage copy(Image orig) {
        return IconGenerator.copy(orig, -1, -1, 0.0f);
    }

    public static BufferedImage copy(Image orig, int width, int height, float scale) {
        int w = orig.getWidth(null);
        int h = orig.getHeight(null);
        if (width <= 0) {
            width = w;
        } else if (scale > 0.0f) {
            w = (int)((float)width * scale);
        } else if (scale < 0.0f) {
            w = (int)((float)width + scale);
        }
        if (height <= 0) {
            height = h;
        } else if (scale > 0.0f) {
            h = (int)((float)height * scale);
        } else if (scale < 0.0f) {
            h = (int)((float)height + scale);
        }
        int x = (width - w) / 2;
        int y = (height - h) / 2;
        BufferedImage result = new BufferedImage(width, height, 7);
        Graphics2D graphics = (Graphics2D)result.getGraphics();
        if (scale != 0.0f) {
            graphics.drawImage(orig, x, y, w, h, null);
        } else {
            graphics.drawImage(orig, x, y, null);
        }
        graphics.dispose();
        return result;
    }

    public static void bevel3D(BufferedImage image, int depth) {
        IconGenerator.bevel3D(image, depth, null);
    }

    public static void bevel3D(BufferedImage image, int depth, Rectangle clip) {
        int height;
        Graphics2D graphics = (Graphics2D)image.getGraphics();
        int x = clip != null ? clip.x : 0;
        int y = clip != null ? clip.y : 0;
        int width = clip != null ? clip.width : -1;
        int n = height = clip != null ? clip.height : -1;
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        if (width <= 0) {
            width = image.getWidth();
        }
        if (height <= 0) {
            height = image.getHeight();
        }
        float alpha = 0.65f;
        float feather = 0.85f;
        int max = depth < 0 ? -depth : depth;
        Color light = Color.WHITE;
        Color dark = Color.BLACK;
        int w = width - 1;
        int h = height - 1;
        for (int i = 0; i < max; ++i) {
            graphics.setComposite(AlphaComposite.getInstance(AlphaComposite.SrcOver.getRule(), alpha * feather));
            graphics.setColor(dark);
            if (depth > 0) {
                graphics.drawLine(x + i + w, y + i, x + i + w, y + i + h);
                graphics.drawLine(x + i, y + i + h, x + i + w - 1, y + i + h);
            } else {
                graphics.drawLine(x + i, y + i, x + i + w, y + i);
                graphics.drawLine(x + i, y + i + 1, x + i, y + i + h);
            }
            graphics.setComposite(AlphaComposite.getInstance(AlphaComposite.SrcOver.getRule(), alpha));
            graphics.setColor(light);
            if (depth > 0) {
                graphics.drawLine(x + i, y + i, x + i + w, y + i);
                graphics.drawLine(x + i, y + i + 1, x + i, y + i + h);
            } else {
                graphics.drawLine(x + i + w, y + i, x + i + w, y + i + h);
                graphics.drawLine(x + i, y + i + h, x + i + w - 1, y + i + h);
            }
            w -= 2;
            h -= 2;
            alpha *= (feather *= 0.9f);
        }
        graphics.dispose();
    }

    public static void add(BufferedImage image, int red, int green, int blue) {
        IconGenerator.add(image, red, green, blue, null);
    }

    public static void add(BufferedImage image, int red, int green, int blue, Rectangle clip) {
        int height;
        int x = clip != null ? clip.x : 0;
        int y = clip != null ? clip.y : 0;
        int width = clip != null ? clip.width : -1;
        int n = height = clip != null ? clip.height : -1;
        if (width <= 0) {
            width = image.getWidth();
        }
        if (height <= 0) {
            height = image.getHeight();
        }
        int[] pix = new int[width];
        int max = height + y;
        for (int i = y; i < max; ++i) {
            pix = image.getRGB(x, i, width, 1, pix, 0, width);
            for (int j = 0; j < width; ++j) {
                int p = pix[j];
                int r = Math.min(255, (p >> 16 & 0xFF) + red);
                int g = Math.min(255, (p >> 8 & 0xFF) + green);
                int b = Math.min(255, (p & 0xFF) + blue);
                pix[j] = (p & 0xFF000000) + (r << 16) + (g << 8) + b;
            }
            image.setRGB(x, i, width, 1, pix, 0, width);
        }
    }

    public static void subtract(BufferedImage image, int red, int green, int blue) {
        IconGenerator.subtract(image, red, green, blue, null);
    }

    public static void subtract(BufferedImage image, int red, int green, int blue, Rectangle clip) {
        int height;
        int x = clip != null ? clip.x : 0;
        int y = clip != null ? clip.y : 0;
        int width = clip != null ? clip.width : -1;
        int n = height = clip != null ? clip.height : -1;
        if (width <= 0) {
            width = image.getWidth();
        }
        if (height <= 0) {
            height = image.getHeight();
        }
        int[] pix = new int[width];
        int max = height + y;
        for (int i = y; i < max; ++i) {
            pix = image.getRGB(x, i, width, 1, pix, 0, width);
            for (int j = 0; j < width; ++j) {
                int p = pix[j];
                int r = Math.max(0, (p >> 16 & 0xFF) - red);
                int g = Math.max(0, (p >> 8 & 0xFF) - green);
                int b = Math.max(0, (p & 0xFF) - blue);
                pix[j] = (p & 0xFF000000) + (r << 16) + (g << 8) + b;
            }
            image.setRGB(x, i, width, 1, pix, 0, width);
        }
    }

    public static void multiply(BufferedImage image, float alpha, float red, float green, float blue) {
        IconGenerator.multiply(image, alpha, red, green, blue, null);
    }

    public static void multiply(BufferedImage image, float alpha, float red, float green, float blue, Rectangle clip) {
        int height;
        int x = clip != null ? clip.x : 0;
        int y = clip != null ? clip.y : 0;
        int width = clip != null ? clip.width : -1;
        int n = height = clip != null ? clip.height : -1;
        if (width <= 0) {
            width = image.getWidth();
        }
        if (height <= 0) {
            height = image.getHeight();
        }
        int[] pix = new int[width];
        int max = height + y;
        for (int i = y; i < max; ++i) {
            pix = image.getRGB(x, i, width, 1, pix, 0, width);
            for (int j = 0; j < width; ++j) {
                int p = pix[j];
                int a = (int)Math.min(255.0f, alpha * (float)(p >> 24 & 0xFF));
                int r = (int)Math.min(255.0f, red * (float)(p >> 16 & 0xFF));
                int g = (int)Math.min(255.0f, green * (float)(p >> 8 & 0xFF));
                int b = (int)Math.min(255.0f, blue * (float)(p & 0xFF));
                pix[j] = (a << 24) + (r << 16) + (g << 8) + b;
            }
            image.setRGB(x, i, width, 1, pix, 0, width);
        }
    }

    public static void assign(BufferedImage image, int alpha, int red, int green, int blue) {
        IconGenerator.assign(image, alpha, red, green, blue, null);
    }

    public static void assign(BufferedImage image, int alpha, int red, int green, int blue, Rectangle clip) {
        int height;
        int x = clip != null ? clip.x : 0;
        int y = clip != null ? clip.y : 0;
        int width = clip != null ? clip.width : -1;
        int n = height = clip != null ? clip.height : -1;
        if (width <= 0) {
            width = image.getWidth();
        }
        if (height <= 0) {
            height = image.getHeight();
        }
        int[] pix = new int[width];
        int max = height + y;
        for (int i = y; i < max; ++i) {
            pix = image.getRGB(x, i, width, 1, pix, 0, width);
            for (int j = 0; j < width; ++j) {
                int p = pix[j];
                int a = alpha >= 0 ? Math.min(255, Math.max(0, alpha)) : p >> 24 & 0xFF;
                int r = red >= 0 ? Math.min(255, Math.max(0, red)) : p >> 16 & 0xFF;
                int g = green >= 0 ? Math.min(255, Math.max(0, green)) : p >> 8 & 0xFF;
                int b = blue >= 0 ? Math.min(255, Math.max(0, blue)) : p & 0xFF;
                pix[j] = (a << 24) + (r << 16) + (g << 8) + b;
            }
            image.setRGB(x, i, width, 1, pix, 0, width);
        }
    }

    public static void overlay(BufferedImage image, int alpha, int red, int green, int blue) {
        IconGenerator.overlay(image, alpha, red, green, blue, null);
    }

    public static void overlay(BufferedImage image, int alpha, int red, int green, int blue, Rectangle clip) {
        int height;
        System.out.println("overlay: a=" + alpha + "; r=" + red + "; g=" + green + "; b=" + blue);
        int x = clip != null ? clip.x : 0;
        int y = clip != null ? clip.y : 0;
        int width = clip != null ? clip.width : -1;
        int n = height = clip != null ? clip.height : -1;
        if (width <= 0) {
            width = image.getWidth();
        }
        if (height <= 0) {
            height = image.getHeight();
        }
        Graphics2D overlay = (Graphics2D)image.getGraphics();
        overlay.setComposite(AlphaComposite.DstOver);
        overlay.setColor(new Color(red, green, blue, alpha));
        overlay.fillRect(x, y, width, height);
        overlay.dispose();
    }

    public static void overlay(BufferedImage image, Image overlay) {
        IconGenerator.overlay(image, overlay, null);
    }

    public static void overlay(BufferedImage image, Image overlay, Rectangle clip) {
        int x = 0;
        int y = 0;
        if (clip == null) {
            int width = image.getWidth();
            int height = image.getHeight();
            int w = overlay.getWidth(null);
            int h = overlay.getHeight(null);
            if (w != width || h != height) {
                x = (width - w) / 2;
                y = (height - h) / 2;
                clip = new Rectangle(x, y, Math.min(width, width - 2 * x), Math.min(height, height - 2 * y));
            }
        } else {
            x = clip.x;
            y = clip.y;
        }
        Graphics2D graphics = (Graphics2D)image.getGraphics();
        if (clip != null) {
            graphics.setClip(clip);
        }
        graphics.setComposite(AlphaComposite.SrcOver);
        graphics.drawImage(overlay, x, y, null);
        graphics.dispose();
    }

    public static void antialias(BufferedImage image, float dark) {
        IconGenerator.antialias(image, dark, -1.0f, null);
    }

    public static void antialias(BufferedImage image, float alpha, float attenuate, Rectangle clip) {
        int height;
        int x = clip != null ? clip.x : 0;
        int y = clip != null ? clip.y : 0;
        int width = clip != null ? clip.width : -1;
        int n = height = clip != null ? clip.height : -1;
        if (width <= 0) {
            width = image.getWidth();
        }
        if (height <= 0) {
            height = image.getHeight();
        }
        int[][] pix = new int[3][width];
        if (alpha <= 0.0f || alpha >= 1.0f) {
            alpha = 0.5f;
        }
        if (attenuate <= 0.0f) {
            attenuate = 0.66f;
        }
        int dark = Math.max(0, Math.min(255, (int)(alpha * 255.0f))) << 24;
        int light = Math.max(0, Math.min(255, (int)(alpha * attenuate * 255.0f))) << 24;
        pix[1] = image.getRGB(x, y, width, 1, pix[1], 0, width);
        int max = y + height;
        for (int i = y; i < max; ++i) {
            pix[2] = (int[])(i < max - 1 ? image.getRGB(x, i + 1, width, 1, pix[2], 0, width) : null);
            for (int j = x; j < width; ++j) {
                int b;
                int g;
                int r;
                int a;
                int br = -1;
                int bm = -1;
                int bl = -1;
                int rt = -1;
                int lt = -1;
                int tr = -1;
                int tp = -1;
                int tl = -1;
                int p = pix[1][j];
                if ((p >> 24 & 0xFF) > 0) continue;
                if (pix[0] != null) {
                    if (j > 0) {
                        tl = pix[0][j - 1] >> 24 & 0xFF;
                    }
                    tp = pix[0][j] >> 24 & 0xFF;
                    if (j < width - 1) {
                        tr = pix[0][j + 1] >> 24 & 0xFF;
                    }
                }
                if (j > 0) {
                    lt = pix[1][j - 1] >> 24 & 0xFF;
                }
                if (j < width - 1) {
                    rt = pix[1][j + 1] >> 24 & 0xFF;
                }
                if (pix[2] != null) {
                    if (j > 0) {
                        bl = pix[2][j - 1] >> 24 & 0xFF;
                    }
                    bm = pix[2][j] >> 24 & 0xFF;
                    if (j < width - 1) {
                        br = pix[2][j + 1] >> 24 & 0xFF;
                    }
                }
                if (tp == 255 && bm <= 0) {
                    if (lt == 255 && tl == 255 && rt <= 0 && br <= 0) {
                        a = tr == 255 || bl == 255 ? dark : light;
                        r = pix[0][j - 1] >> 16 & 0xFF;
                        r += pix[0][j] >> 16 & 0xFF;
                        r += pix[1][j - 1] >> 16 & 0xFF;
                        r /= 3;
                        g = pix[0][j - 1] >> 8 & 0xFF;
                        g += pix[0][j] >> 8 & 0xFF;
                        g += pix[1][j - 1] >> 8 & 0xFF;
                        b = pix[0][j - 1] & 0xFF;
                        b += pix[0][j] & 0xFF;
                        b += pix[1][j - 1] & 0xFF;
                        pix[1][j] = a + (r << 16) + ((g /= 3) << 8) + (b /= 3);
                        continue;
                    }
                    if (rt != 255 || tr != 255 || lt > 0 || bl > 0) continue;
                    a = tl == 255 || br == 255 ? dark : light;
                    r = pix[0][j] >> 16 & 0xFF;
                    r += pix[0][j + 1] >> 16 & 0xFF;
                    r += pix[1][j + 1] >> 16 & 0xFF;
                    r /= 3;
                    g = pix[0][j] >> 8 & 0xFF;
                    g += pix[0][j + 1] >> 8 & 0xFF;
                    g += pix[1][j + 1] >> 8 & 0xFF;
                    b = pix[0][j] & 0xFF;
                    b += pix[0][j + 1] & 0xFF;
                    b += pix[1][j + 1] & 0xFF;
                    pix[1][j] = a + (r << 16) + ((g /= 3) << 8) + (b /= 3);
                    continue;
                }
                if (tp > 0 || bm != 255) continue;
                if (lt == 255 && bl == 255 && rt <= 0 && tr <= 0) {
                    a = tl == 255 || br == 255 ? dark : light;
                    r = pix[1][j - 1] >> 16 & 0xFF;
                    r += pix[2][j] >> 16 & 0xFF;
                    r += pix[2][j - 1] >> 16 & 0xFF;
                    r /= 3;
                    g = pix[1][j - 1] >> 8 & 0xFF;
                    g += pix[2][j] >> 8 & 0xFF;
                    g += pix[2][j - 1] >> 8 & 0xFF;
                    b = pix[1][j - 1] & 0xFF;
                    b += pix[2][j] & 0xFF;
                    b += pix[2][j - 1] & 0xFF;
                    pix[1][j] = a + (r << 16) + ((g /= 3) << 8) + (b /= 3);
                    continue;
                }
                if (rt != 255 || br != 255 || lt > 0 || tl > 0) continue;
                a = tr == 255 || bl == 255 ? dark : light;
                r = pix[1][j + 1] >> 16 & 0xFF;
                r += pix[2][j] >> 16 & 0xFF;
                r += pix[2][j + 1] >> 16 & 0xFF;
                r /= 3;
                g = pix[1][j + 1] >> 8 & 0xFF;
                g += pix[2][j] >> 8 & 0xFF;
                g += pix[2][j + 1] >> 8 & 0xFF;
                b = pix[1][j + 1] & 0xFF;
                b += pix[2][j] & 0xFF;
                b += pix[2][j + 1] & 0xFF;
                pix[1][j] = a + (r << 16) + ((g /= 3) << 8) + (b /= 3);
            }
            image.setRGB(x, i, width, 1, pix[1], 0, width);
            int[] tmp = pix[0];
            pix[0] = pix[1];
            pix[1] = pix[2];
            pix[2] = tmp;
        }
    }

    public static void feather(BufferedImage image, int xsize, int ysize, byte dir) {
        IconGenerator.feather(image, xsize, ysize, dir, null);
    }

    public static void feather(BufferedImage image, int xsize, int ysize, byte dir, Rectangle clip) {
        int height;
        int x = clip != null ? clip.x : 0;
        int y = clip != null ? clip.y : 0;
        int width = clip != null ? clip.width : -1;
        int n = height = clip != null ? clip.height : -1;
        if (width <= 0) {
            width = image.getWidth();
        }
        if (height <= 0) {
            height = image.getHeight();
        }
        if (xsize >= width && ysize >= height) {
            return;
        }
        int[] pix1 = new int[width];
        int[] pix2 = new int[width];
        float transy = 1.0f;
        float atten = 0.8f;
        int opaque = -16777216;
        int cy = height / 2;
        int cx = width / 2;
        int firstx = xsize;
        int mitre = Math.min(xsize, ysize > 0 ? ysize : xsize);
        for (int i = y; i <= cy; ++i) {
            int j;
            int a;
            int pa;
            if (dir == 1) {
                pix1 = image.getRGB(0, i, width, 1, pix1, 0, width);
                pix2 = image.getRGB(0, height - i - 1, width, 1, pix2, 0, width);
                float transx = atten;
                pa = (int)((1.0f - transx) * 255.0f);
                a = pa << 24;
                firstx = Math.min(i, mitre);
                for (j = x; j <= firstx; ++j) {
                    pa = (int)((1.0f - transx) * 255.0f);
                    a = pa << 24;
                    if (pa < (pix1[j] >> 24 & 0xFF)) {
                        pix1[j] = a + (pix1[j] & 0xFFFFFF);
                    }
                    if (pa < (pix1[width - j - 1] >> 24 & 0xFF)) {
                        pix1[width - j - 1] = a + (pix1[width - j - 1] & 0xFFFFFF);
                    }
                    if (pa < (pix2[j] >> 24 & 0xFF)) {
                        pix2[j] = a + (pix2[j] & 0xFFFFFF);
                    }
                    if (pa < (pix2[width - j - 1] >> 24 & 0xFF)) {
                        pix2[width - j - 1] = a + (pix2[width - j - 1] & 0xFFFFFF);
                    }
                    transx *= atten;
                }
                if (i < ysize) {
                    for (j = firstx + 1; j < width - firstx - 1; ++j) {
                        if (pa < (pix1[j] >> 24 & 0xFF)) {
                            pix1[j] = a + (pix1[j] & 0xFFFFFF);
                        }
                        if (pa >= (pix2[j] >> 24 & 0xFF)) continue;
                        pix2[j] = a + (pix2[j] & 0xFFFFFF);
                    }
                }
                image.setRGB(0, i, width, 1, pix1, 0, width);
                image.setRGB(0, height - i - 1, width, 1, pix2, 0, width);
                transy *= atten;
                continue;
            }
            if (dir != 2) continue;
            pix1 = image.getRGB(0, i, width, 1, pix1, 0, width);
            pix2 = image.getRGB(0, height - i - 1, width, 1, pix2, 0, width);
            if (i < ysize) continue;
            float alpha = 0.6f;
            pa = (int)(alpha * 255.0f);
            a = pa << 24;
            for (j = xsize; j <= cx; ++j) {
                if (j < i) {
                    pa = (int)((alpha *= atten) * 255.0f);
                    a = pa << 24;
                }
                if (pa < (pix1[j] >> 24 & 0xFF)) {
                    pix1[j] = a + (pix1[j] & 0xFFFFFF);
                }
                if (pa < (pix1[width - j - 1] >> 24 & 0xFF)) {
                    pix1[width - j - 1] = a + (pix1[width - j - 1] & 0xFFFFFF);
                }
                if (pa < (pix2[j] >> 24 & 0xFF)) {
                    pix2[j] = a + (pix2[j] & 0xFFFFFF);
                }
                if (pa >= (pix2[width - j - 1] >> 24 & 0xFF)) continue;
                pix2[width - j - 1] = a + (pix2[width - j - 1] & 0xFFFFFF);
            }
            image.setRGB(0, i, width, 1, pix1, 0, width);
            image.setRGB(0, height - i - 1, width, 1, pix2, 0, width);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class Instruction {
        String source;
        int start = -1;
        int end = 0;
        String[] delims;
        byte opcode;
        int imageWidth;
        int imageHeight;
        float alpha;
        float red;
        float green;
        float blue;
        float scale;
        String target;
        ArrayList<String> method;
        ArgList antialias = null;
        ArgList offset = null;
        ArgList resize = null;
        Color background;
        Instruction next;

        public Instruction() {
            this.imageWidth = -1;
            this.imageHeight = -1;
        }

        public Instruction(int width, int height) {
            this.imageWidth = width;
            this.imageHeight = height;
        }

        public void setSize(int width, int height) {
            this.imageWidth = width;
            this.imageHeight = height;
            if (this.next != null) {
                this.next.setSize(width, height);
            }
        }

        public Instruction compileNext(String[] delims) throws Exception {
            if (this.next == null) {
                this.next = new Instruction(this.imageWidth, this.imageHeight);
            }
            this.next.compile(this.source, this.end, delims);
            return this.next;
        }

        public void compile(String macro, int pos, String[] delims) throws Exception {
            this.source = macro;
            this.delims = delims;
            this.start = pos;
            while (IconGenerator.WHITESPACE.indexOf(macro.charAt(pos)) >= 0) {
                ++pos;
            }
            this.alpha = 1.0f;
            this.blue = -1.0f;
            this.green = -1.0f;
            this.red = -1.0f;
            this.scale = 1.0f;
            this.opcode = 0;
            this.target = null;
            this.method = null;
            if (this.antialias != null) {
                this.antialias.length = 0;
            }
            if (this.resize != null) {
                this.resize.length = 0;
            }
            if (this.offset != null) {
                this.offset.length = 0;
            }
            this.background = null;
            this.next = null;
            int valid = 0;
            String[] stringArray = this.delims = delims != null ? (String[])delims.clone() : DEFAULT_DELIMS;
            if (this.delims[0] == null) {
                this.delims[0] = DEFAULT_DELIMS[0];
            }
            if (this.delims[1] == null) {
                this.delims[1] = DEFAULT_DELIMS[1];
            }
            if (this.delims[2] == null) {
                this.delims[2] = DEFAULT_DELIMS[2];
            }
            String ops = this.delims[0];
            String tokens = this.delims[1];
            String openclose = this.delims[2];
            String close = ops.substring(0, 1);
            for (int i = 1; i < openclose.length(); i += 2) {
                close = close + openclose.charAt(i);
            }
            String optok = ops + tokens;
            int len = macro.length();
            while (pos >= 0 && (this.end = this.parseToken(macro, pos)) >= pos) {
                int validop;
                char c = macro.charAt(pos);
                int opval = optok.indexOf(c) + 1;
                if (valid != 0 && (valid & (validop = opval > 0 ? 1 << opval : 0)) == 0) {
                    this.error("Syntax error: invalid operand: " + c, pos);
                }
                valid = 0;
                if (opval == 1) {
                    if (this.opcode == 0) {
                        this.opcode = opval;
                    }
                    ++this.end;
                    break;
                }
                block0 : switch (opval) {
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        valid = 36864;
                        if (this.target == null || this.target.length() == 0) {
                            this.target = IconGenerator.DEFAULT_TARGET;
                        }
                        this.opcode = opval;
                        break;
                    }
                    case 7: {
                        valid = 32768;
                        if (this.target == null || this.target.length() == 0) {
                            this.target = IconGenerator.DEFAULT_TARGET;
                        }
                        this.opcode = opval;
                        if (pos >= this.end) break;
                        this.scale = Float.parseFloat(macro.substring(pos, this.end).trim()) / 100.0f;
                        break;
                    }
                    case 8: {
                        if (pos < len && macro.charAt(pos + 1) == '(') {
                            this.end = this.find(macro, pos + 1, len, close);
                            this.antialias = this.parseArgs(this.antialias, 2, pos + 2, this.end);
                            break;
                        }
                        if (this.opcode == 12) {
                            this.opcode = (byte)8;
                        }
                        valid = 37888;
                        break;
                    }
                    case 10: {
                        if (pos == this.end) {
                            this.end = this.find(macro, this.end, len, close);
                        }
                        this.resize = this.parseArgs(this.resize, 4, pos + 1, this.end);
                        break;
                    }
                    case 9: {
                        if (pos == this.end) {
                            this.end = this.find(macro, this.end + 1, len, close);
                        }
                        this.offset = this.parseArgs(this.offset, 3, pos + 2, this.end);
                        break;
                    }
                    case 12: {
                        if (pos == this.end) {
                            this.end = this.find(macro, this.end + 1, len, close);
                        }
                        ArgList comps = this.parseArgs(null, 4, pos + 2, this.end);
                        if (comps.length > 0 && comps.value[0] != null) {
                            this.alpha = Float.parseFloat(comps.value[0]);
                        }
                        if (comps.length > 1 && comps.value[1] != null) {
                            this.red = Float.parseFloat(comps.value[1]);
                        }
                        if (comps.length > 2 && comps.value[2] != null) {
                            this.green = Float.parseFloat(comps.value[2]);
                        }
                        if (comps.length <= 3 || comps.value[3] == null) break;
                        this.blue = Float.parseFloat(comps.value[3]);
                        break;
                    }
                    case 11: {
                        if (pos == this.end) {
                            this.end = this.find(macro, this.end + 1, len, ")");
                        }
                        if (this.end > pos) {
                            if (this.method == null) {
                                this.method = new ArrayList(4);
                            }
                            this.method.add(macro.substring(pos + 1, this.end + 1).trim());
                            break;
                        }
                        this.error("Invalid method syntax: closing paren ')' missing", pos);
                        break;
                    }
                    case 15: {
                        String arg;
                        int arglen = macro.indexOf(ops.charAt(0), pos);
                        if (arglen > 0 && arglen < this.end) {
                            this.end = arglen - 1;
                        }
                        if ((arg = macro.substring(pos, this.end).trim()).startsWith("0x") || arg.startsWith("0X")) {
                            Color color = null;
                            arglen = arg.length();
                            if (arglen == 4) {
                                this.alpha = 0.003921569f * (float)Integer.decode(arg).intValue();
                            } else if (arg.length() == 8) {
                                color = Color.decode(arg);
                            } else if (arglen == 10) {
                                this.alpha = 0.003921569f * (float)Integer.decode(arg.substring(0, 4)).intValue();
                                color = Color.decode("0x" + arg.substring(4));
                            }
                            if (color == null) break;
                            opval = 12;
                            this.red = 0.003921569f * (float)color.getRed();
                            this.green = 0.003921569f * (float)color.getGreen();
                            this.blue = 0.003921569f * (float)color.getBlue();
                            break;
                        }
                        switch (this.opcode) {
                            case 7: {
                                this.scale = Float.parseFloat(arg) / 100.0f;
                                break block0;
                            }
                            case 8: {
                                this.antialias = this.parseArgs(this.antialias, 1, pos, this.end);
                                break block0;
                            }
                            case 3: 
                            case 4: {
                                this.green = this.blue = Float.parseFloat(arg);
                                this.red = this.blue;
                                break block0;
                            }
                            case 5: {
                                this.alpha = Float.parseFloat(arg);
                                break block0;
                            }
                        }
                        this.error("Unexpected numeric value: " + arg, pos);
                        break;
                    }
                    case 14: {
                        this.target = macro.substring(pos, this.end + 1).trim();
                        break;
                    }
                    default: {
                        if (this.end < len && macro.charAt(this.end) == '(') {
                            if (this.method == null) {
                                this.method = new ArrayList(4);
                            }
                            this.method.add(macro.substring(pos, this.end - 1).trim());
                            break;
                        }
                        this.target = macro.substring(pos, this.end).trim();
                    }
                }
                if (pos == this.end) {
                    ++this.end;
                }
                pos = this.parseToken(macro, this.end);
                if (this.opcode == 0 && opval < 13) {
                    this.opcode = opval;
                }
                if (opval != 12) continue;
                switch (this.opcode) {
                    case 3: 
                    case 4: {
                        this.red = this.red >= 0.0f ? this.red * 255.0f : 0.0f;
                        this.green = this.green >= 0.0f ? this.green * 255.0f : 0.0f;
                        this.blue = this.blue >= 0.0f ? this.blue * 255.0f : 0.0f;
                        break;
                    }
                    case 5: {
                        if (this.alpha < 0.0f) {
                            this.alpha = 1.0f;
                        }
                        if (this.red < 0.0f) {
                            this.red = 1.0f;
                        }
                        if (this.green < 0.0f) {
                            this.green = 1.0f;
                        }
                        if (!(this.blue < 0.0f)) break;
                        this.blue = 1.0f;
                        break;
                    }
                    case 6: {
                        if (this.alpha >= 0.0f) {
                            this.alpha *= 255.0f;
                        }
                        if (this.red >= 0.0f) {
                            this.red *= 255.0f;
                        }
                        if (this.green >= 0.0f) {
                            this.green *= 255.0f;
                        }
                        if (!(this.blue >= 0.0f)) break;
                        this.blue *= 255.0f;
                        break;
                    }
                    case 2: {
                        this.alpha = this.alpha >= 0.0f ? this.alpha * 255.0f : 1.0f;
                        this.red = this.red >= 0.0f ? this.red * 255.0f : 0.0f;
                        this.green = this.green >= 0.0f ? this.green * 255.0f : 0.0f;
                        this.blue = this.blue >= 0.0f ? this.blue * 255.0f : 0.0f;
                    }
                }
            }
        }

        public BufferedImage execute(BufferedImage lhs, Map<String, Object> namespace, ClassLoader loader) throws Exception {
            int z;
            int tb;
            int h;
            int w;
            Object obj;
            int height;
            int width;
            boolean centreX = true;
            boolean centreY = true;
            BufferedImage rhs = null;
            if (lhs != null) {
                width = lhs.getWidth();
                height = lhs.getHeight();
            } else if (this.resize != null && this.opcode != 8) {
                width = this.resize.getInt(0);
                height = this.resize.getInt(1);
            } else if (this.imageWidth > 0 && this.imageHeight > 0) {
                width = this.imageWidth;
                height = this.imageHeight;
            } else {
                width = -1;
                height = -1;
            }
            if (this.target != null) {
                rhs = this.target.equals(IconGenerator.DEFAULT_TARGET) ? lhs : this.getImage(this.target, width, height, namespace, loader);
            }
            if (width < 0 && height < 0) {
                if (rhs != null) {
                    width = rhs.getWidth();
                    height = rhs.getHeight();
                } else {
                    throw new Exception("IconGenerator: cannot determine initial image size. Source: " + this.source.substring(this.start, this.end));
                }
            }
            if (this.opcode == 11 && (obj = this.target.equals(IconGenerator.DEFAULT_TARGET) ? lhs : this.resolve(this.target, this.method, namespace)) != null) {
                if (obj instanceof Color) {
                    this.background = (Color)obj;
                } else if (rhs == null && obj instanceof BufferedImage) {
                    rhs = (BufferedImage)obj;
                } else {
                    throw new Exception("Unusable result of call (" + obj.getClass().getName() + "): " + obj.toString());
                }
            }
            if (rhs == null) {
                Color color = null;
                if (this.background != null) {
                    color = this.background;
                } else if (this.red >= 0.0f || this.green >= 0.0f || this.blue >= 0.0f) {
                    if (this.alpha < 0.0f) {
                        this.alpha = 1.0f;
                    }
                    if (this.red < 0.0f) {
                        this.red = 0.0f;
                    }
                    if (this.green < 0.0f) {
                        this.green = 0.0f;
                    }
                    if (this.blue < 0.0f) {
                        this.blue = 0.0f;
                    }
                    color = new Color(this.red, this.blue, this.green, this.alpha);
                }
                if (color != null) {
                    rhs = new BufferedImage(width, height, 7);
                    Graphics2D overlay = (Graphics2D)rhs.getGraphics();
                    overlay.setColor(color);
                    overlay.fillRect(0, 0, width, height);
                    overlay.dispose();
                }
            }
            Graphics2D graphics = (Graphics2D)(lhs != null ? lhs.getGraphics() : null);
            int x = width / 2;
            int y = height / 2;
            if (rhs != null) {
                w = rhs.getWidth();
                h = rhs.getHeight();
            } else {
                w = width;
                h = height;
            }
            if (this.offset != null) {
                if (this.offset.length > 0) {
                    x = this.offset.calc(x, 0);
                    if (this.offset.opcode[0] == 6) {
                        centreX = false;
                    }
                }
                if (this.offset.length > 1) {
                    y = this.offset.calc(y, 1);
                    if (this.offset.opcode[1] == 6) {
                        centreY = false;
                    }
                }
            }
            if (this.resize != null && this.opcode != 8) {
                BufferedImage tmp;
                String ref;
                if (this.resize.length > 0) {
                    ref = this.resize.ref[0];
                    if (ref != null) {
                        tmp = this.getImage(ref, -1, -1, namespace, loader);
                        w = tmp.getWidth();
                    }
                    w = this.resize.calc(w, 0);
                }
                if (this.resize.length > 1) {
                    ref = this.resize.ref[1];
                    if (ref != null) {
                        tmp = this.getImage(ref, -1, -1, namespace, loader);
                        h = tmp.getHeight();
                    }
                    h = this.resize.calc(h, 1);
                }
                if (centreX) {
                    x -= w / 2;
                }
                if (centreY) {
                    y -= h / 2;
                }
                if (rhs != null && graphics != null) {
                    graphics.setClip(x, y, w, h);
                }
            } else {
                if (centreX) {
                    x -= w / 2;
                }
                if (centreY) {
                    y -= h / 2;
                }
            }
            if (rhs != null && (this.alpha >= 0.0f || this.red >= 0.0f || this.green >= 0.0f || this.blue >= 0.0f)) {
                int ired = (int)this.red;
                int igreen = (int)this.green;
                int iblue = (int)this.blue;
                int[] pix = new int[w];
                Rectangle clip = rhs == lhs ? new Rectangle(x, y, w, h) : null;
                switch (this.opcode) {
                    case 3: {
                        IconGenerator.add(rhs, ired, igreen, iblue, clip);
                        break;
                    }
                    case 4: {
                        IconGenerator.subtract(rhs, ired, igreen, iblue, clip);
                        break;
                    }
                    case 5: {
                        IconGenerator.multiply(rhs, this.alpha, this.red, this.green, this.blue, clip);
                        break;
                    }
                    case 6: {
                        IconGenerator.assign(rhs, (int)this.alpha, ired, igreen, iblue, clip);
                        break;
                    }
                    case 2: {
                        IconGenerator.overlay(rhs, (int)this.alpha, ired, igreen, iblue, clip);
                    }
                }
            }
            if (rhs != null && this.opcode == 8) {
                if (this.antialias != null && this.antialias.length > 0) {
                    float a = this.antialias.getFloat(0);
                    float atten = this.antialias.length > 1 ? (float)this.antialias.getFloat(1) : -1.0f;
                    IconGenerator.antialias(rhs, a, atten, null);
                } else if (this.resize != null && this.resize.length > 0) {
                    byte dir;
                    int lr = 0;
                    lr = this.resize.calc(lr, 0);
                    tb = 0;
                    tb = this.resize.calc(tb, 1);
                    byte by = dir = lr < 0 || tb < 0 ? (byte)2 : 1;
                    if (lr < 0) {
                        lr = -lr;
                    }
                    if (tb < 0) {
                        tb = -tb;
                    }
                    IconGenerator.feather(rhs, lr, tb, dir, null);
                }
            }
            if (rhs != null && this.resize != null && this.resize.length > 2 && this.resize.opcode[2] == 8) {
                int lr = this.resize.getInt(2);
                tb = this.resize.length > 3 ? this.resize.getInt(3) : lr;
                IconGenerator.feather(rhs, lr, tb, (byte)1, new Rectangle(0, 0, w, h));
            }
            if (this.offset != null && this.opcode != 9 && rhs != null && (z = this.offset.getInt(2)) != 0) {
                IconGenerator.bevel3D(rhs, z, new Rectangle(0, 0, w, h));
            }
            if (lhs == null) {
                lhs = IconGenerator.copy(rhs, width, height, 0.0f);
            } else if (rhs != null && rhs != lhs) {
                graphics.setComposite(AlphaComposite.SrcOver);
                graphics.drawImage((Image)rhs, x, y, null);
            }
            if (this.opcode == 10 && rhs == null && lhs != null && (w != width || h != height)) {
                float factor = this.resize.length > 2 && this.resize.opcode[2] == 7 ? this.resize.getFloat(2) : 0;
                lhs = IconGenerator.copy(lhs, w, h, factor);
            }
            if (this.opcode == 9 && lhs != null && this.offset != null && this.offset.length > 2 && (z = this.offset.getInt(2)) != 0) {
                IconGenerator.bevel3D(lhs, z);
            }
            if (graphics != null) {
                graphics.dispose();
            }
            return this.next != null ? this.next.execute(lhs, namespace, loader) : lhs;
        }

        protected void error(String message, int pos) throws Exception {
            int first = Math.max(0, pos - 10);
            int last = Math.min(this.source.length(), pos + 10);
            int max = IconGenerator.dots.length() - 1;
            String intro = "\nsource: ";
            message = message + intro + this.source.substring(first, last) + "\n" + IconGenerator.dots.substring(0, Math.min(max, intro.length() + first)) + "^";
            throw new Exception(message);
        }

        protected ArgList parseArgs(ArgList vec, int maxArgs, int first, int last) {
            if (vec == null) {
                vec = new ArgList();
            }
            vec.parse(maxArgs, this.source, first, last);
            return vec;
        }

        protected BufferedImage getImage(String name, int width, int height, Map<String, Object> namespace, ClassLoader loader) throws IOException {
            Object obj = namespace.get(name);
            if (obj != null && obj.getClass() == String.class && this.delims[1].indexOf(name.charAt(0)) == 1) {
                name = obj.toString();
                obj = namespace.get(name);
            }
            if (obj != null && !(obj instanceof Image)) {
                return null;
            }
            int w = 0;
            int h = 0;
            if (obj == null) {
                if (Character.isLetter(name.charAt(0))) {
                    URL url = loader.getResource(name);
                    if (url == null) {
                        url = loader.getResource(name + ".png");
                    }
                    if (url == null) {
                        url = loader.getResource(name + ".gif");
                    }
                    if (url != null) {
                        ImageIcon icon = new ImageIcon(url);
                        w = icon.getIconWidth();
                        h = icon.getIconHeight();
                        obj = icon.getImage();
                    }
                }
                if (obj == null) {
                    throw new FileNotFoundException(name);
                }
            } else {
                Image img = (Image)obj;
                w = img.getWidth(null);
                h = img.getHeight(null);
            }
            namespace.put(name, obj);
            return IconGenerator.copy((Image)obj, width, height, this.scale);
        }

        protected Object resolve(String target, List method, Map namespace) throws Exception {
            Object obj = namespace.get(target);
            if (obj != null && obj.getClass() == String.class && this.delims[1].indexOf(target.toString().charAt(0)) == 1) {
                target = obj.toString();
                obj = namespace.get(target);
            }
            if (obj == null) {
                return obj;
            }
            try {
                for (int i = 0; i < method.size(); ++i) {
                    String methName = method.get(i).toString();
                    int cut = methName.indexOf(40);
                    if (cut > 0) {
                        methName = methName.substring(0, cut);
                    }
                    Method meth = obj.getClass().getMethod(methName, NULL_SIG);
                    obj = meth.invoke(obj, NULL_ARGS);
                }
                return obj;
            }
            catch (Exception e) {
                throw new Exception("Could not resolve call: " + target + "." + method + "\n" + e);
            }
        }

        protected int parseToken(String macro, int pos) {
            int len = macro.length();
            if (pos < 0 || pos >= len) {
                return -1;
            }
            if (IconGenerator.QUOTES.indexOf(macro.charAt(pos)) >= 0) {
                ++pos;
            }
            if (pos >= len) {
                return -1;
            }
            String ops = this.delims[0];
            String openclose = this.delims[2];
            char c = macro.charAt(pos);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    while (++pos < len && IconGenerator.WHITESPACE.indexOf(macro.charAt(pos)) >= 0) {
                    }
                    return IconGenerator.QUOTES.indexOf(macro.charAt(pos)) >= 0 ? pos + 1 : pos;
                }
                case ')': 
                case ']': 
                case '}': {
                    while (++pos < len && " )]}\t\r\n".indexOf(macro.charAt(pos)) >= 0) {
                    }
                    return pos < len ? pos : -1;
                }
            }
            if (pos > 0 && IconGenerator.QUOTES.indexOf(macro.charAt(pos - 1)) >= 0) {
                return macro.indexOf(c, pos);
            }
            while (pos < len && ops.indexOf(macro.charAt(pos)) < 0 && openclose.indexOf(macro.charAt(pos)) % 2 != 1) {
                ++pos;
            }
            return pos < len ? pos : len;
        }

        protected int skip(String macro, int start, int end, String skipchars) {
            while (start < end && skipchars.indexOf(macro.charAt(start)) >= 0) {
                ++start;
            }
            return start;
        }

        protected int find(String macro, int start, int end, String findchars) {
            while (start < end && findchars.indexOf(macro.charAt(start)) < 0) {
                ++start;
            }
            return start;
        }

        protected class ArgList {
            int length = 0;
            byte[] opcode = null;
            String[] ref = null;
            String[] value = null;

            protected ArgList() {
            }

            protected void parse(int maxArgs, String macro, int start, int end) {
                if (this.opcode == null || this.opcode.length < maxArgs) {
                    this.opcode = new byte[maxArgs];
                    this.ref = new String[maxArgs];
                    this.value = new String[maxArgs];
                }
                char listDelim = Instruction.this.delims[1].charAt(0);
                int pos1 = start;
                int index = 0;
                boolean max = false;
                int i = 0;
                while (pos1 < end) {
                    index = i;
                    int pos2 = macro.indexOf(listDelim, pos1);
                    if (pos2 < 0 || pos2 > end) {
                        pos2 = end;
                    }
                    if (pos2 - pos1 > 1 && "+-=".indexOf(macro.charAt(pos1 + 1)) >= 0) {
                        switch (macro.charAt(pos1)) {
                            case 'A': 
                            case 'X': 
                            case 'a': 
                            case 'x': {
                                index = 0;
                                ++pos1;
                                break;
                            }
                            case 'R': 
                            case 'Y': 
                            case 'r': 
                            case 'y': {
                                index = 1;
                                ++pos1;
                                break;
                            }
                            case 'G': 
                            case 'Z': 
                            case 'g': 
                            case 'z': {
                                index = 2;
                                ++pos1;
                                break;
                            }
                            case 'B': 
                            case 'b': {
                                index = 3;
                                ++pos1;
                            }
                        }
                    }
                    if (pos2 > pos1) {
                        byte opval = (byte)(Instruction.this.delims[0].indexOf(macro.charAt(pos1)) + 1);
                        switch (opval) {
                            case 3: 
                            case 4: 
                            case 6: 
                            case 7: 
                            case 8: {
                                ++pos1;
                                this.opcode[index] = opval;
                                break;
                            }
                            default: {
                                this.opcode[index] = 6;
                            }
                        }
                    }
                    this.value[index] = pos2 > pos1 ? macro.substring(pos1, pos2).trim() : macro.substring(pos1).trim();
                    this.length = Math.max(index + 1, this.length);
                    pos1 = pos2 + 1;
                    ++i;
                }
            }

            protected int getInt(int index) {
                return this.calc(0, index);
            }

            protected int getFloat(int index) {
                return this.calc(0, index);
            }

            protected int calc(int lhs, int index) {
                byte op = this.opcode[index < this.length ? index : 0];
                String val = index < this.length ? this.value[index] : null;
                float rhs = val != null ? Float.parseFloat(val) : 0.0f;
                switch (op) {
                    case 3: {
                        return (int)((float)lhs + rhs);
                    }
                    case 4: {
                        return (int)((float)lhs - rhs);
                    }
                    case 5: {
                        return (int)((float)lhs * rhs);
                    }
                    case 6: 
                    case 8: {
                        return (int)rhs;
                    }
                }
                return lhs;
            }

            protected float calc(float lhs, int index) {
                byte op = this.opcode[index < this.length ? index : 0];
                String val = index < this.length ? this.value[index] : null;
                float rhs = val != null ? Float.parseFloat(val) : 0.0f;
                switch (op) {
                    case 3: {
                        return lhs + rhs;
                    }
                    case 4: {
                        return lhs - rhs;
                    }
                    case 5: {
                        return lhs * rhs;
                    }
                    case 6: 
                    case 8: {
                        return rhs;
                    }
                }
                return lhs;
            }
        }
    }
}

