/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.ui;

import buoy.event.EventSource;
import buoy.event.MouseDraggedEvent;
import buoy.event.MousePressedEvent;
import buoy.event.MouseReleasedEvent;
import buoy.widget.Widget;
import java.awt.Point;
import java.awt.Robot;
import javax.swing.SwingUtilities;

public class InfiniteDragListener
extends EventSource {
    private final Widget source;
    private Robot robot;
    private Point startPoint;
    private Point startScreenPoint;
    private int dx;
    private int dy;
    private boolean enabled;

    public InfiniteDragListener(Widget source) {
        this.source = source;
        this.enabled = true;
        source.addEventLink(MousePressedEvent.class, (Object)this, "mousePressed");
        source.addEventLink(MouseReleasedEvent.class, (Object)this, "mouseReleased");
        source.addEventLink(MouseDraggedEvent.class, (Object)this, "mouseDragged");
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    private void mousePressed(MousePressedEvent ev) {
        if (!this.enabled) {
            return;
        }
        this.startPoint = ev.getPoint();
        this.startScreenPoint = new Point(this.startPoint);
        SwingUtilities.convertPointToScreen(this.startScreenPoint, this.source.getComponent());
        this.dx = 0;
        this.dy = 0;
        try {
            this.robot = new Robot(this.source.getComponent().getGraphicsConfiguration().getDevice());
        }
        catch (Exception ex) {
            this.robot = null;
        }
        this.dispatchEvent(ev);
    }

    private void mouseDragged(MouseDraggedEvent ev) {
        if (!this.enabled) {
            return;
        }
        this.dispatchEvent(new MouseDraggedEvent(this.source, ev.getWhen(), ev.getModifiersEx(), ev.getX() + this.dx, ev.getY() + this.dy));
        if ((Math.abs(ev.getX() - this.startPoint.x) > 5 || Math.abs(ev.getY() - this.startPoint.y) > 5) && this.robot != null) {
            this.dx += ev.getX() - this.startPoint.x;
            this.dy += ev.getY() - this.startPoint.y;
            this.robot.mouseMove(this.startScreenPoint.x, this.startScreenPoint.y);
        }
    }

    private void mouseReleased(MouseReleasedEvent ev) {
        this.robot = null;
        if (!this.enabled) {
            return;
        }
        this.dispatchEvent(new MouseReleasedEvent(this.source, ev.getWhen(), ev.getModifiersEx(), ev.getX() + this.dx, ev.getY() + this.dy, ev.getClickCount(), ev.isPopupTrigger(), ev.getButton()));
    }
}

