/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.ui;

import artofillusion.Camera;
import artofillusion.ViewerCanvas;
import artofillusion.math.BoundingBox;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.Mat4;
import artofillusion.math.Vec2;
import artofillusion.math.Vec3;
import artofillusion.ui.Manipulator;
import artofillusion.ui.NinePointManipulator;
import buoy.event.EventSource;
import buoy.event.WidgetMouseEvent;
import java.awt.Color;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.io.IOException;
import javax.imageio.ImageIO;

public class Compound3DManipulator
extends EventSource
implements Manipulator {
    private Rectangle bounds;
    private Rectangle[] boxes;
    private Rectangle extraUVBox;
    private Axis[] boxAxis;
    private HandleType[] boxHandleType;
    private BoundingBox selectionBounds;
    private Axis dragAxis;
    private HandleType dragHandleType;
    private boolean dragging;
    private Point baseClick;
    private Vec3 dragStartPosition;
    private Vec3 xaxis = Vec3.vx();
    private Vec3 yaxis = Vec3.vy();
    private Vec3 zaxis = Vec3.vz();
    private Vec2 x2DaxisNormed;
    private Vec2 y2DaxisNormed;
    private Vec2 z2DaxisNormed;
    private Vec3[] npqModeAxes;
    private int rotSegment;
    private double rotAngle;
    private Point centerPoint;
    private Vec3 center;
    private double axisLength;
    private double orAxisLength;
    private RotationHandle[] xyzRotHandles = new RotationHandle[3];
    private RotationHandle[] npqRotHandles;
    private RotationHandle[] uvRotationHandle;
    private RotationHandle[] activeRotationHandleSet;
    private RotationHandle currentRotationHandle;
    private ViewMode viewMode;
    private boolean rotateAroundSelectionCenter = true;
    public static final ViewMode XYZ_MODE = new ViewMode();
    public static final ViewMode UV_MODE = new ViewMode();
    public static final ViewMode NPQ_MODE = new ViewMode();
    private static final int HANDLE_SIZE = 12;
    public static final short X_MOVE_INDEX = 0;
    public static final short X_SCALE_INDEX = 1;
    public static final short Y_MOVE_INDEX = 2;
    public static final short Y_SCALE_INDEX = 3;
    public static final short Z_MOVE_INDEX = 4;
    public static final short Z_SCALE_INDEX = 5;
    public static final short CENTER_INDEX = 6;
    public static final short ROTATE_INDEX = 7;
    public static final short TOOL_HANDLE = 8;
    public static final short UV_EXTRA_INDEX = 9;
    public static final Axis X = new Axis("x");
    public static final Axis Y = new Axis("y");
    public static final Axis Z = new Axis("z");
    public static final Axis U = new Axis("u");
    public static final Axis V = new Axis("v");
    public static final Axis W = new Axis("v");
    public static final Axis UV = new Axis("uv");
    public static final Axis N = new Axis("n");
    public static final Axis P = new Axis("p");
    public static final Axis Q = new Axis("q");
    public static final Axis ALL = new Axis("all");
    public static final HandleType MOVE = new HandleType();
    public static final HandleType ROTATE = new HandleType();
    public static final HandleType SCALE = new HandleType();
    private static final Image centerhandle;
    private static final Image[] xyzHandleImages;
    private static final Image[] uvHandleImages;
    private static final Image[] npqHandleImages;

    private static Image loadImage(String name) {
        try {
            return ImageIO.read(NinePointManipulator.class.getResource("/artofillusion/ui/manipulatorIcons/" + name));
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public Compound3DManipulator() {
        this.boxes = new Rectangle[7];
        this.extraUVBox = new Rectangle();
        for (int i = 0; i < this.boxes.length; ++i) {
            this.boxes[i] = new Rectangle(0, 0, 12, 12);
        }
        this.extraUVBox = new Rectangle(0, 0, 12, 12);
        this.boxHandleType = new HandleType[]{MOVE, SCALE, MOVE, SCALE, MOVE, SCALE, MOVE};
        this.xyzRotHandles[0] = new RotationHandle(64, X, Color.blue);
        this.xyzRotHandles[1] = new RotationHandle(64, Y, Color.green);
        this.xyzRotHandles[2] = new RotationHandle(64, Z, Color.red);
        this.uvRotationHandle = new RotationHandle[1];
        this.uvRotationHandle[0] = new RotationHandle(64, U, Color.orange);
        this.npqRotHandles = new RotationHandle[3];
        this.npqRotHandles[0] = new RotationHandle(64, N, Color.blue);
        this.npqRotHandles[1] = new RotationHandle(64, P, Color.green);
        this.npqRotHandles[2] = new RotationHandle(64, Q, Color.red);
        this.axisLength = 80.0;
        this.setViewMode(XYZ_MODE);
    }

    public ViewMode getViewMode() {
        return this.viewMode;
    }

    public void setViewMode(ViewMode mode) {
        this.viewMode = mode;
        this.boxAxis = mode == XYZ_MODE ? new Axis[]{X, X, Y, Y, Z, Z, ALL} : (mode == UV_MODE ? new Axis[]{U, U, V, V, null, null, ALL} : new Axis[]{N, N, P, P, Q, Q, ALL});
    }

    public boolean getRotateAroundSelectionCenter() {
        return this.rotateAroundSelectionCenter;
    }

    public void setRotateAroundSelectionCenter(boolean rotateAroundSelectionCenter) {
        this.rotateAroundSelectionCenter = rotateAroundSelectionCenter;
    }

    public void setNPQAxes(Vec3 nDir, Vec3 pDir, Vec3 qDir) {
        this.npqModeAxes = new Vec3[]{new Vec3(pDir), new Vec3(qDir), new Vec3(nDir)};
        this.npqRotHandles[0].setAxis(nDir, pDir);
        this.npqRotHandles[1].setAxis(pDir, qDir);
        this.npqRotHandles[2].setAxis(qDir, nDir);
    }

    public Vec3 getAxisDirection(Axis axis, ViewerCanvas view) {
        if (axis == X) {
            return Vec3.vx();
        }
        if (axis == Y) {
            return Vec3.vy();
        }
        if (axis == Z) {
            return Vec3.vz();
        }
        if (axis == U) {
            CoordinateSystem coords = view.getCamera().getCameraCoordinates();
            return coords.getUpDirection().cross(coords.getZDirection());
        }
        if (axis == V) {
            CoordinateSystem coords = view.getCamera().getCameraCoordinates();
            return coords.getUpDirection();
        }
        if (axis == N) {
            return this.npqModeAxes[0];
        }
        if (axis == P) {
            return this.npqModeAxes[1];
        }
        if (axis == Q) {
            return this.npqModeAxes[2];
        }
        throw new IllegalArgumentException("Axis " + axis.getName() + " does not have a fixed direction");
    }

    public HandleType getHandleTypeAtLocation(Point location, ViewerCanvas view, BoundingBox selectionBounds) {
        if (selectionBounds == null) {
            return null;
        }
        Vec3 center = view.getCamera().getViewToWorld().times(selectionBounds.getCenter());
        this.findHandleLocations(center, view);
        for (int i = 0; i < this.boxes.length; ++i) {
            if (this.viewMode == UV_MODE && (i == 4 || i == 5) || !this.boxes[i].contains(location)) continue;
            return this.boxHandleType[i];
        }
        RotationHandle[] rotHandles = null;
        if (this.viewMode == XYZ_MODE) {
            rotHandles = this.xyzRotHandles;
        } else if (this.viewMode == UV_MODE) {
            rotHandles = this.uvRotationHandle;
        } else if (this.viewMode == NPQ_MODE) {
            rotHandles = this.npqRotHandles;
        }
        for (int i = 0; i < rotHandles.length; ++i) {
            this.rotSegment = rotHandles[i].findClickTarget(location, view.getCamera());
            if (this.rotSegment == -1) continue;
            return ROTATE;
        }
        if (this.viewMode == UV_MODE && this.extraUVBox.contains(location)) {
            return SCALE;
        }
        return null;
    }

    private void findHandleLocations(Vec3 center, ViewerCanvas view) {
        int i;
        if (this.viewMode == XYZ_MODE) {
            this.xaxis = Vec3.vx();
            this.yaxis = Vec3.vy();
            this.zaxis = Vec3.vz();
        } else if (this.viewMode == UV_MODE) {
            CoordinateSystem coords = view.getCamera().getCameraCoordinates();
            this.xaxis = coords.getUpDirection().cross(coords.getZDirection());
            this.yaxis = coords.getUpDirection();
            this.zaxis = coords.getZDirection();
        } else {
            this.xaxis = this.npqModeAxes[0];
            this.yaxis = this.npqModeAxes[1];
            this.zaxis = this.npqModeAxes[2];
        }
        double handleSize = 12.0 / view.getScale();
        double len = this.axisLength / view.getScale();
        Vec3 xpos = center.plus(this.xaxis.times(len));
        Vec3 ypos = center.plus(this.yaxis.times(len));
        Vec3 zpos = center.plus(this.zaxis.times(len));
        Vec3 xHandlePos = center.plus(this.xaxis.times(len + handleSize / 2.0));
        Vec3 yHandlePos = center.plus(this.yaxis.times(len + handleSize / 2.0));
        Vec3 zHandlePos = center.plus(this.zaxis.times(len + handleSize / 2.0));
        Vec3 xHandleOffset = center.plus(this.xaxis.times(len + handleSize * 1.5));
        Vec3 yHandleOffset = center.plus(this.yaxis.times(len + handleSize * 1.5));
        Vec3 zHandleOffset = center.plus(this.zaxis.times(len + handleSize * 1.5));
        Mat4 worldToScreen = view.getCamera().getWorldToScreen();
        Vec2 x2DHandleOffset = worldToScreen.timesXY(xHandleOffset);
        Vec2 y2DHandleOffset = worldToScreen.timesXY(yHandleOffset);
        Vec2 z2DHandleOffset = worldToScreen.timesXY(zHandleOffset);
        Vec2 axisCenter = worldToScreen.timesXY(center);
        Vec2 screenX = worldToScreen.timesXY(xpos);
        Vec2 screenY = worldToScreen.timesXY(ypos);
        Vec2 screenZ = worldToScreen.timesXY(zpos);
        Vec2 screenXHandle = worldToScreen.timesXY(xHandlePos);
        Vec2 screenYHandle = worldToScreen.timesXY(yHandlePos);
        Vec2 screenZHandle = worldToScreen.timesXY(zHandlePos);
        x2DHandleOffset.subtract(screenX);
        y2DHandleOffset.subtract(screenY);
        z2DHandleOffset.subtract(screenZ);
        Vec2 x2Daxis = screenX.minus(axisCenter);
        Vec2 y2Daxis = screenY.minus(axisCenter);
        Vec2 z2Daxis = screenZ.minus(axisCenter);
        this.x2DaxisNormed = new Vec2(x2Daxis);
        this.y2DaxisNormed = new Vec2(y2Daxis);
        this.z2DaxisNormed = new Vec2(z2Daxis);
        this.x2DaxisNormed.normalize();
        this.y2DaxisNormed.normalize();
        this.z2DaxisNormed.normalize();
        this.centerPoint = new Point((int)Math.round(axisCenter.x), (int)Math.round(axisCenter.y));
        this.boxes[6].x = this.centerPoint.x - 6;
        this.boxes[6].y = this.centerPoint.y - 6;
        view.drawImage(centerhandle, this.boxes[6].x, this.boxes[6].y);
        for (i = 0; i < 2; ++i) {
            this.boxes[0 + i].x = (int)(screenXHandle.x - 6.0 + (double)i * x2DHandleOffset.x);
            this.boxes[0 + i].y = (int)(screenXHandle.y - 6.0 + (double)i * x2DHandleOffset.y);
        }
        for (i = 0; i < 2; ++i) {
            this.boxes[2 + i].x = (int)(screenYHandle.x - 6.0 + (double)i * y2DHandleOffset.x);
            this.boxes[2 + i].y = (int)(screenYHandle.y - 6.0 + (double)i * y2DHandleOffset.y);
        }
        if (this.viewMode != UV_MODE) {
            for (i = 0; i < 2; ++i) {
                this.boxes[4 + i].x = (int)(screenZHandle.x - 6.0 + (double)i * z2DHandleOffset.x);
                this.boxes[4 + i].y = (int)(screenZHandle.y - 6.0 + (double)i * z2DHandleOffset.y);
            }
        } else {
            Vec3 handlePos = center.plus(this.xaxis.times(len + handleSize * 2.0)).plus(this.yaxis.times(len + handleSize * 2.0));
            Vec2 screenHandle = worldToScreen.timesXY(handlePos);
            this.extraUVBox.x = (int)screenHandle.x - 6;
            this.extraUVBox.y = (int)screenHandle.y - 6;
        }
        if (this.viewMode == XYZ_MODE) {
            this.activeRotationHandleSet = this.xyzRotHandles;
        } else if (this.viewMode == UV_MODE) {
            this.activeRotationHandleSet = this.uvRotationHandle;
            this.activeRotationHandleSet[0].setAxis(this.zaxis, this.xaxis);
        } else if (this.viewMode == NPQ_MODE) {
            this.activeRotationHandleSet = this.npqRotHandles;
        }
        for (int i2 = 0; i2 < this.activeRotationHandleSet.length; ++i2) {
            RotationHandle rotHandle = this.activeRotationHandleSet[i2];
            for (int j = 0; j < rotHandle.points3d.length; ++j) {
                rotHandle.points2d[j] = worldToScreen.timesXY(center.plus(rotHandle.points3d[j].times(len)));
            }
        }
    }

    public void draw(ViewerCanvas view, BoundingBox selectionBounds) {
        int i;
        Color zColor;
        Color yColor;
        Color xColor;
        boolean freezeManipulator;
        if (selectionBounds == null) {
            return;
        }
        this.bounds = this.findScreenBounds(selectionBounds, view.getCamera());
        boolean bl = freezeManipulator = this.dragging && (this.dragHandleType == ROTATE || this.dragHandleType == SCALE);
        if (!freezeManipulator) {
            this.center = view.getCamera().getViewToWorld().times(selectionBounds.getCenter());
        }
        this.findHandleLocations(this.center, view);
        double handleSize = 12.0 / view.getScale();
        double len = this.axisLength / view.getScale();
        Vec3 xpos = this.center.plus(this.xaxis.times(len));
        Vec3 ypos = this.center.plus(this.yaxis.times(len));
        Vec3 zpos = this.center.plus(this.zaxis.times(len));
        Vec3 xHandleOffset = this.center.plus(this.xaxis.times(len + handleSize * 1.5));
        Vec3 yHandleOffset = this.center.plus(this.yaxis.times(len + handleSize * 1.5));
        Vec3 zHandleOffset = this.center.plus(this.zaxis.times(len + handleSize * 1.5));
        Mat4 worldToScreen = view.getCamera().getWorldToScreen();
        Vec2 x2DHandleOffset = worldToScreen.timesXY(xHandleOffset);
        Vec2 y2DHandleOffset = worldToScreen.timesXY(yHandleOffset);
        Vec2 z2DHandleOffset = worldToScreen.timesXY(zHandleOffset);
        Vec2 screenX = worldToScreen.timesXY(xpos);
        Vec2 screenY = worldToScreen.timesXY(ypos);
        Vec2 screenZ = worldToScreen.timesXY(zpos);
        x2DHandleOffset.subtract(screenX);
        y2DHandleOffset.subtract(screenY);
        z2DHandleOffset.subtract(screenZ);
        if (this.dragging && this.dragHandleType == ROTATE) {
            Vec3[] pt = this.currentRotationHandle.getRotationFeedback(this.rotAngle);
            int[] x = new int[pt.length];
            int[] y = new int[pt.length];
            for (int j = 0; j < pt.length; ++j) {
                Vec2 pt2d = worldToScreen.timesXY(this.center.plus(pt[j].times(len)));
                x[j] = (int)pt2d.x;
                y[j] = (int)pt2d.y;
            }
            Polygon p = new Polygon(x, y, x.length);
            view.drawShape(p, Color.darkGray);
            view.fillShape(p, Color.gray);
        }
        Image[] handles = null;
        if (this.viewMode == XYZ_MODE) {
            xColor = Color.blue;
            yColor = Color.green;
            zColor = Color.red;
            handles = xyzHandleImages;
        } else if (this.viewMode == UV_MODE) {
            xColor = Color.orange;
            yColor = Color.orange;
            zColor = Color.red;
            handles = uvHandleImages;
        } else {
            xColor = Color.blue;
            yColor = Color.green;
            zColor = Color.red;
            handles = npqHandleImages;
        }
        view.drawLine(this.centerPoint, new Point((int)screenX.x, (int)screenX.y), xColor);
        view.drawLine(this.centerPoint, new Point((int)screenY.x, (int)screenY.y), yColor);
        view.drawLine(this.centerPoint, new Point((int)screenZ.x, (int)screenZ.y), zColor);
        view.drawImage(centerhandle, this.boxes[6].x, this.boxes[6].y);
        for (i = 0; i < 2; ++i) {
            view.drawImage(handles[0 + i], this.boxes[0 + i].x, this.boxes[0 + i].y);
        }
        for (i = 0; i < 2; ++i) {
            view.drawImage(handles[2 + i], this.boxes[2 + i].x, this.boxes[2 + i].y);
        }
        if (this.viewMode != UV_MODE) {
            for (i = 0; i < 2; ++i) {
                view.drawImage(handles[4 + i], this.boxes[4 + i].x, this.boxes[4 + i].y);
            }
        } else {
            int udeltax = this.boxes[1].x + 6 - this.centerPoint.x;
            int udeltay = this.boxes[1].y + 6 - this.centerPoint.y;
            int vdeltax = this.boxes[3].x + 6 - this.centerPoint.x;
            int vdeltay = this.boxes[3].y + 6 - this.centerPoint.y;
            this.extraUVBox.x = udeltax + vdeltax + this.centerPoint.x - 6;
            this.extraUVBox.y = udeltay + vdeltay + this.centerPoint.y - 6;
            Vec3 handlePos = this.center.plus(this.xaxis.times(len + handleSize * 2.0)).plus(this.yaxis.times(len + handleSize * 2.0));
            Vec2 screenHandle = worldToScreen.timesXY(handlePos);
            this.extraUVBox.x = (int)screenHandle.x - 6;
            this.extraUVBox.y = (int)screenHandle.y - 6;
            view.drawImage(handles[1], this.extraUVBox.x, this.extraUVBox.y);
        }
        for (i = 0; i < this.activeRotationHandleSet.length; ++i) {
            RotationHandle rotHandle = this.activeRotationHandleSet[i];
            for (int j = 0; j < rotHandle.points3d.length - 1; ++j) {
                view.drawLine(new Point((int)rotHandle.points2d[j].x, (int)rotHandle.points2d[j].y), new Point((int)rotHandle.points2d[j + 1].x, (int)rotHandle.points2d[j + 1].y), rotHandle.color);
            }
        }
    }

    public boolean mousePressed(WidgetMouseEvent ev, ViewerCanvas view, BoundingBox selectionBounds) {
        Rectangle r = this.findScreenBounds(selectionBounds, view.getCamera());
        if (r == null) {
            return false;
        }
        this.bounds = r;
        this.selectionBounds = selectionBounds;
        this.center = view.getCamera().getViewToWorld().times(selectionBounds.getCenter());
        this.findHandleLocations(this.center, view);
        Point p = ev.getPoint();
        for (int i = 6; i >= 0; --i) {
            if (this.viewMode == UV_MODE && (i == 4 || i == 5) || !this.boxes[i].contains(p)) continue;
            if (i == 6) {
                this.dragAxis = ALL;
                this.dragHandleType = MOVE;
                this.dragStartPosition = this.center;
            } else {
                this.dragHandleType = this.boxHandleType[i];
                this.dragAxis = this.boxAxis[i];
            }
            this.orAxisLength = this.axisLength;
            this.dragging = true;
            this.baseClick = new Point(ev.getPoint());
            this.dispatchEvent(new HandlePressedEvent(view, this.dragHandleType, this.dragAxis, this.bounds, selectionBounds, ev));
            return true;
        }
        RotationHandle[] rotHandles = null;
        if (this.viewMode == XYZ_MODE) {
            rotHandles = this.xyzRotHandles;
        } else if (this.viewMode == UV_MODE) {
            rotHandles = this.uvRotationHandle;
        } else if (this.viewMode == NPQ_MODE) {
            rotHandles = this.npqRotHandles;
        }
        for (int i = 0; i < rotHandles.length; ++i) {
            this.rotSegment = rotHandles[i].findClickTarget(p, view.getCamera());
            if (this.rotSegment == -1) continue;
            this.currentRotationHandle = rotHandles[i];
            this.dragHandleType = ROTATE;
            this.dragAxis = this.currentRotationHandle.axis;
            this.dragging = true;
            this.baseClick = new Point(ev.getPoint());
            this.dispatchEvent(new HandlePressedEvent(view, this.dragHandleType, this.dragAxis, this.bounds, selectionBounds, ev));
            this.rotAngle = 0.0;
            return true;
        }
        if (this.viewMode == UV_MODE && this.extraUVBox.contains(p)) {
            this.dragHandleType = SCALE;
            this.dragAxis = UV;
            this.orAxisLength = this.axisLength;
            this.dragging = true;
            this.baseClick = new Point(ev.getPoint());
            this.dispatchEvent(new HandlePressedEvent(view, this.dragHandleType, this.dragAxis, this.bounds, selectionBounds, ev));
            return true;
        }
        return false;
    }

    public void mousePressedOnHandle(WidgetMouseEvent ev, ViewerCanvas view, BoundingBox selectionBounds, Vec3 handleLocation) {
        this.center = view.getCamera().getViewToWorld().times(selectionBounds.getCenter());
        this.dragHandleType = MOVE;
        this.dragAxis = ALL;
        this.dragStartPosition = handleLocation;
        this.dragging = true;
        this.baseClick = new Point(ev.getPoint());
        this.dispatchEvent(new HandlePressedEvent(view, this.dragHandleType, this.dragAxis, this.bounds, selectionBounds, ev));
    }

    public void mouseDragged(WidgetMouseEvent ev, ViewerCanvas view) {
        if (!this.dragging) {
            return;
        }
        this.findHandleLocations(this.center, view);
        if (this.dragHandleType == MOVE) {
            this.moveDragged(ev, view);
        } else if (this.dragHandleType == ROTATE) {
            this.rotateDragged(ev, view);
        } else {
            this.scaleDragged(ev, view);
        }
    }

    private void moveDragged(WidgetMouseEvent ev, ViewerCanvas view) {
        Vec3 axis;
        boolean isShiftDown = ev.isShiftDown();
        double gridSize = view.getGridSpacing() / (double)view.getSnapToSubdivisions();
        Vec2 disp = new Vec2(ev.getPoint().x - this.baseClick.x, ev.getPoint().y - this.baseClick.y);
        if (this.dragAxis == ALL) {
            Vec3 drag = ev.isControlDown() ? view.getCamera().getCameraCoordinates().getZDirection().times(-disp.y * 0.01) : view.getCamera().findDragVector(this.dragStartPosition, disp.x, disp.y);
            if (isShiftDown) {
                drag.x = gridSize * (double)Math.round(drag.x / gridSize);
                drag.y = gridSize * (double)Math.round(drag.y / gridSize);
                drag.z = gridSize * (double)Math.round(drag.z / gridSize);
            }
            Mat4 transform = Mat4.translation(drag.x, drag.y, drag.z);
            this.dispatchEvent(new HandleDraggedEvent(view, this.dragHandleType, this.dragAxis, this.bounds, this.selectionBounds, ev, transform));
            return;
        }
        double amplitude = 0.0;
        if (this.dragAxis == X || this.dragAxis == U || this.dragAxis == N) {
            axis = this.xaxis;
            amplitude = disp.dot(this.x2DaxisNormed);
        } else if (this.dragAxis == Y || this.dragAxis == V || this.dragAxis == P) {
            axis = this.yaxis;
            amplitude = disp.dot(this.y2DaxisNormed);
        } else {
            axis = this.zaxis;
            amplitude = disp.dot(this.z2DaxisNormed);
        }
        amplitude /= view.getScale();
        if (isShiftDown) {
            amplitude /= gridSize;
            amplitude = Math.round(amplitude);
            amplitude *= gridSize;
        }
        Vec3 drag = axis.times(amplitude);
        Mat4 transform = Mat4.translation(drag.x, drag.y, drag.z);
        this.dispatchEvent(new HandleDraggedEvent(view, this.dragHandleType, this.dragAxis, this.bounds, this.selectionBounds, ev, transform));
    }

    private void rotateDragged(WidgetMouseEvent ev, ViewerCanvas view) {
        boolean isShiftDown = ev.isShiftDown();
        Vec2 disp = new Vec2(ev.getPoint().x - this.baseClick.x, ev.getPoint().y - this.baseClick.y);
        Vec2 vector = this.currentRotationHandle.points2d[this.rotSegment + 1].minus(this.currentRotationHandle.points2d[this.rotSegment]);
        vector.normalize();
        this.rotAngle = vector.dot(disp) / 70.0;
        if (isShiftDown) {
            this.rotAngle *= 11.459155902616464;
            this.rotAngle = Math.round(this.rotAngle);
            this.rotAngle *= 0.08726646259971647;
        }
        Mat4 mat = Mat4.axisRotation(this.currentRotationHandle.rotAxis, this.rotAngle);
        if (this.rotateAroundSelectionCenter) {
            mat = Mat4.translation(this.center.x, this.center.y, this.center.z).times(mat.times(Mat4.translation(-this.center.x, -this.center.y, -this.center.z)));
        }
        this.dispatchEvent(new HandleDraggedEvent(view, this.dragHandleType, this.dragAxis, this.bounds, this.selectionBounds, ev, mat, this.rotAngle));
    }

    private void scaleDragged(WidgetMouseEvent ev, ViewerCanvas view) {
        Point p = ev.getPoint();
        boolean isShiftDown = ev.isShiftDown();
        boolean isCtrlDown = (ev.getModifiers() & 2) != 0;
        Vec2 base = new Vec2(this.baseClick.x - this.centerPoint.x, this.baseClick.y - this.centerPoint.y);
        Vec2 current = new Vec2(p.x - this.centerPoint.x, p.y - this.centerPoint.y);
        double scale = base.dot(current);
        scale = base.length() < 1.0 ? 1.0 : (scale /= base.length() * base.length());
        if (isCtrlDown) {
            this.axisLength = this.orAxisLength * scale;
            scale = 1.0;
            view.repaint();
        } else {
            double scaleZ = 1.0;
            double scaleY = 1.0;
            double scaleX = 1.0;
            if (this.dragAxis == X || this.dragAxis == U || this.dragAxis == N) {
                scaleX = scale;
                if (isShiftDown) {
                    scaleY = scaleZ = scaleX;
                }
            } else if (this.dragAxis == Y || this.dragAxis == V || this.dragAxis == P) {
                scaleY = scale;
                if (isShiftDown) {
                    scaleX = scaleZ = scaleY;
                }
            } else if (this.dragAxis == Z || this.dragAxis == Q) {
                scaleZ = scale;
                if (isShiftDown) {
                    scaleY = scaleX = scaleZ;
                }
            } else if (this.dragAxis == UV) {
                scaleX = this.x2DaxisNormed.dot(current) / this.x2DaxisNormed.dot(base);
                scaleY = this.y2DaxisNormed.dot(current) / this.y2DaxisNormed.dot(base);
                if (isShiftDown) {
                    if (scaleX < 1.0 && scaleY < 1.0) {
                        scaleZ = scaleY = Math.min(scaleX, scaleY);
                        scaleX = scaleY;
                    } else {
                        scaleZ = scaleY = Math.max(scaleX, scaleY);
                        scaleX = scaleY;
                    }
                }
            }
            CoordinateSystem coords = new CoordinateSystem(this.center, this.zaxis, this.yaxis);
            Mat4 m = Mat4.scale(scaleX, scaleY, scaleZ).times(coords.toLocal());
            m = coords.fromLocal().times(m);
            if (this.dragAxis == UV) {
                this.dispatchEvent(new HandleDraggedEvent(view, this.dragHandleType, this.dragAxis, this.bounds, this.selectionBounds, ev, m, scaleX, scaleY));
            } else {
                this.dispatchEvent(new HandleDraggedEvent(view, this.dragHandleType, this.dragAxis, this.bounds, this.selectionBounds, ev, m, scale, 0.0));
            }
        }
    }

    public void mouseReleased(WidgetMouseEvent ev, ViewerCanvas view) {
        if (!this.dragging) {
            return;
        }
        this.dispatchEvent(new HandleReleasedEvent(view, this.dragHandleType, this.dragAxis, this.bounds, this.selectionBounds, ev));
        this.dragging = false;
        this.dragAxis = null;
        this.dragHandleType = null;
    }

    public Rectangle findScreenBounds(BoundingBox b, Camera cam) {
        Mat4 m = cam.getObjectToWorld();
        cam.setObjectTransform(cam.getViewToWorld());
        Rectangle r = cam.findScreenBounds(b);
        cam.setObjectTransform(m);
        if (r != null) {
            r.setBounds(r.x - 12, r.y - 12, r.width + 24, r.height + 24);
        }
        return r;
    }

    static {
        xyzHandleImages = new Image[6];
        uvHandleImages = new Image[4];
        npqHandleImages = new Image[6];
        Compound3DManipulator.xyzHandleImages[0] = Compound3DManipulator.loadImage("xhandle.gif");
        Compound3DManipulator.xyzHandleImages[1] = Compound3DManipulator.loadImage("xscale.gif");
        Compound3DManipulator.xyzHandleImages[2] = Compound3DManipulator.loadImage("yhandle.gif");
        Compound3DManipulator.xyzHandleImages[3] = Compound3DManipulator.loadImage("yscale.gif");
        Compound3DManipulator.xyzHandleImages[4] = Compound3DManipulator.loadImage("zhandle.gif");
        Compound3DManipulator.xyzHandleImages[5] = Compound3DManipulator.loadImage("zscale.gif");
        Compound3DManipulator.uvHandleImages[0] = Compound3DManipulator.loadImage("uhandle.gif");
        Compound3DManipulator.uvHandleImages[1] = Compound3DManipulator.loadImage("uvscale.gif");
        Compound3DManipulator.uvHandleImages[2] = Compound3DManipulator.loadImage("vhandle.gif");
        Compound3DManipulator.uvHandleImages[3] = Compound3DManipulator.loadImage("uvscale.gif");
        centerhandle = Compound3DManipulator.loadImage("centerhandle.gif");
        Compound3DManipulator.npqHandleImages[0] = Compound3DManipulator.loadImage("phandle.gif");
        Compound3DManipulator.npqHandleImages[1] = Compound3DManipulator.loadImage("xscale.gif");
        Compound3DManipulator.npqHandleImages[2] = Compound3DManipulator.loadImage("qhandle.gif");
        Compound3DManipulator.npqHandleImages[3] = Compound3DManipulator.loadImage("yscale.gif");
        Compound3DManipulator.npqHandleImages[4] = Compound3DManipulator.loadImage("nhandle.gif");
        Compound3DManipulator.npqHandleImages[5] = Compound3DManipulator.loadImage("zscale.gif");
    }

    public class HandleReleasedEvent
    extends HandleEvent {
        public HandleReleasedEvent(ViewerCanvas view, HandleType handleType, Axis axis, Rectangle screenBounds, BoundingBox selectionBounds, WidgetMouseEvent event) {
            super(view, handleType, axis, screenBounds, selectionBounds, event);
        }
    }

    public class HandleDraggedEvent
    extends HandleEvent {
        private Mat4 transform;
        private double angle;
        private double scale1;
        private double scale2;

        public HandleDraggedEvent(ViewerCanvas view, HandleType handleType, Axis axis, Rectangle screenBounds, BoundingBox selectionBounds, WidgetMouseEvent event, Mat4 transform) {
            super(view, handleType, axis, screenBounds, selectionBounds, event);
            this.transform = transform;
        }

        public HandleDraggedEvent(ViewerCanvas view, HandleType handleType, Axis axis, Rectangle screenBounds, BoundingBox selectionBounds, WidgetMouseEvent event, Mat4 transform, double angle) {
            this(view, handleType, axis, screenBounds, selectionBounds, event, transform);
            this.angle = angle;
        }

        public HandleDraggedEvent(ViewerCanvas view, HandleType handleType, Axis axis, Rectangle screenBounds, BoundingBox selectionBounds, WidgetMouseEvent event, Mat4 transform, double scale1, double scale2) {
            this(view, handleType, axis, screenBounds, selectionBounds, event, transform);
            this.scale1 = scale1;
            this.scale2 = scale2;
        }

        public Mat4 getTransform() {
            return this.transform;
        }

        public double getRotationAngle() {
            return this.angle;
        }

        public double getPrimaryScale() {
            return this.scale1;
        }

        public double getSecondaryScale() {
            return this.scale2;
        }
    }

    public class HandlePressedEvent
    extends HandleEvent {
        public HandlePressedEvent(ViewerCanvas view, HandleType handleType, Axis axis, Rectangle screenBounds, BoundingBox selectionBounds, WidgetMouseEvent event) {
            super(view, handleType, axis, screenBounds, selectionBounds, event);
        }
    }

    public class HandleEvent {
        private ViewerCanvas view;
        private Axis axis;
        private HandleType handleType;
        private Rectangle screenBounds;
        private BoundingBox selectionBounds;
        private WidgetMouseEvent event;

        private HandleEvent(ViewerCanvas view, HandleType handleType, Axis axis, Rectangle screenBounds, BoundingBox selectionBounds, WidgetMouseEvent event) {
            this.view = view;
            this.handleType = handleType;
            this.axis = axis;
            this.screenBounds = screenBounds;
            this.selectionBounds = selectionBounds;
            this.event = event;
        }

        public ViewerCanvas getView() {
            return this.view;
        }

        public HandleType getHandleType() {
            return this.handleType;
        }

        public Axis getAxis() {
            return this.axis;
        }

        public Rectangle getScreenBounds() {
            return new Rectangle(this.screenBounds);
        }

        public BoundingBox getSelectionBounds() {
            return new BoundingBox(this.selectionBounds);
        }

        public WidgetMouseEvent getMouseEvent() {
            return this.event;
        }

        public Compound3DManipulator getManipulator() {
            return Compound3DManipulator.this;
        }
    }

    public static class HandleType {
        private HandleType() {
        }
    }

    public static class Axis {
        private String name;

        private Axis(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    private class RotationHandle {
        private Axis axis;
        private int segments;
        protected Color color;
        protected Vec3[] points3d;
        protected Vec2[] points2d;
        protected Vec3 rotAxis;
        protected Vec3 refAxis;

        public RotationHandle(int segments, Axis axis, Color color) {
            this.segments = segments;
            this.color = color;
            this.axis = axis;
            this.points3d = new Vec3[segments + 1];
            this.points2d = new Vec2[segments + 1];
            if (axis == X || axis == U || axis == N) {
                this.setAxis(Compound3DManipulator.this.xaxis, Compound3DManipulator.this.yaxis);
            } else if (axis == Y || axis == V || axis == P) {
                this.setAxis(Compound3DManipulator.this.yaxis, Compound3DManipulator.this.zaxis);
            } else {
                this.setAxis(Compound3DManipulator.this.zaxis, Compound3DManipulator.this.xaxis);
            }
        }

        public void setAxis(Vec3 rotAxis, Vec3 refAxis) {
            this.rotAxis = rotAxis;
            this.refAxis = refAxis;
            Mat4 m = Mat4.axisRotation(rotAxis, Math.PI * 2 / (double)this.segments);
            Vec3 v = new Vec3(refAxis);
            for (int i = 0; i <= this.segments; ++i) {
                this.points3d[i] = v = m.times(v);
            }
        }

        public Vec3[] getRotationFeedback(double angle) {
            Vec3[] points = new Vec3[this.segments + 1];
            points[0] = new Vec3();
            Mat4 m = null;
            Vec3 v = null;
            m = Mat4.axisRotation(this.rotAxis, angle / (double)this.segments);
            points[1] = v = new Vec3(this.refAxis);
            for (int i = 1; i < this.segments; ++i) {
                points[i + 1] = v = m.times(v);
            }
            return points;
        }

        public int findClickTarget(Point pos, Camera camera) {
            double closestz = Double.MAX_VALUE;
            int which = -1;
            for (int i = 0; i < this.points2d.length - 1; ++i) {
                double z;
                double w;
                double u;
                double v;
                Vec2 v1 = this.points2d[i];
                Vec2 v2 = this.points2d[i + 1];
                if ((double)pos.x < v1.x - 3.0 && (double)pos.x < v2.x - 3.0 || (double)pos.x > v1.x + 3.0 && (double)pos.x > v2.x + 3.0 || (double)pos.y < v1.y - 3.0 && (double)pos.y < v2.y - 3.0 || (double)pos.y > v1.y + 3.0 && (double)pos.y > v2.y + 3.0) continue;
                if (Math.abs(v1.x - v2.x) > Math.abs(v1.y - v2.y)) {
                    if (v2.x > v1.x) {
                        v = ((double)pos.x - v1.x) / (v2.x - v1.x);
                        u = 1.0 - v;
                    } else {
                        u = ((double)pos.x - v2.x) / (v1.x - v2.x);
                        v = 1.0 - u;
                    }
                    w = u * v1.y + v * v2.y - (double)pos.y;
                } else {
                    if (v2.y > v1.y) {
                        v = ((double)pos.y - v1.y) / (v2.y - v1.y);
                        u = 1.0 - v;
                    } else {
                        u = ((double)pos.y - v2.y) / (v1.y - v2.y);
                        v = 1.0 - u;
                    }
                    w = u * v1.x + v * v2.x - (double)pos.x;
                }
                if (Math.abs(w) > 6.0 || !((z = u * camera.getObjectToView().timesZ(this.points3d[i]) + v * camera.getObjectToView().timesZ(this.points3d[i + 1])) < closestz)) continue;
                closestz = z;
                which = i;
            }
            return which;
        }
    }

    public static class ViewMode {
        private ViewMode() {
        }
    }
}

