/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.texture;

import artofillusion.MaterialPreviewer;
import artofillusion.RenderingMesh;
import artofillusion.RenderingTriangle;
import artofillusion.TextureParameter;
import artofillusion.animation.Actor;
import artofillusion.math.BoundingBox;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.Mat4;
import artofillusion.math.RGBColor;
import artofillusion.math.Vec2;
import artofillusion.math.Vec3;
import artofillusion.object.Mesh;
import artofillusion.object.MeshVertex;
import artofillusion.object.Object3D;
import artofillusion.texture.Linear2DTriangle;
import artofillusion.texture.Mapping2D;
import artofillusion.texture.ParameterValue;
import artofillusion.texture.Texture;
import artofillusion.texture.TextureMapping;
import artofillusion.texture.TextureSpec;
import artofillusion.texture.UVMappedTriangle;
import artofillusion.texture.VertexParameterValue;
import artofillusion.ui.Translate;
import artofillusion.ui.ValueField;
import buoy.event.ValueChangedEvent;
import buoy.widget.BCheckBox;
import buoy.widget.BComboBox;
import buoy.widget.BLabel;
import buoy.widget.FormContainer;
import buoy.widget.LayoutInfo;
import buoy.widget.RowContainer;
import buoy.widget.Widget;
import java.awt.Insets;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;

public class ProjectionMapping
extends Mapping2D {
    protected CoordinateSystem coords;
    protected double ax;
    protected double bx;
    protected double cx;
    protected double dx;
    protected double ay;
    protected double by;
    protected double cy;
    protected double dy;
    protected double xscale;
    protected double yscale;
    protected boolean coordsFromParams;
    protected boolean scaleToObject;
    protected int numTextureParams;
    protected TextureParameter xparam;
    protected TextureParameter yparam;
    protected TextureParameter zparam;

    public ProjectionMapping(Object3D theObject, Texture theTexture) {
        super(theObject, theTexture);
        this.coords = new CoordinateSystem(new Vec3(), new Vec3(0.0, 0.0, 1.0), new Vec3(0.0, 1.0, 0.0));
        this.yscale = 1.0;
        this.xscale = 1.0;
        this.dy = -0.5;
        this.dx = -0.5;
        this.scaleToObject = true;
        this.findCoefficients();
    }

    public static String getName() {
        return "Projection";
    }

    private void findCoefficients() {
        Vec3 zdir = this.coords.getZDirection();
        Vec3 ydir = this.coords.getUpDirection();
        Vec3 xdir = ydir.cross(zdir);
        this.ax = xdir.x / this.xscale;
        this.bx = xdir.y / this.xscale;
        this.cx = xdir.z / this.xscale;
        this.ay = ydir.x / this.yscale;
        this.by = ydir.y / this.yscale;
        this.cy = ydir.z / this.yscale;
    }

    public Vec2 getCenter() {
        return new Vec2(this.dx, this.dy);
    }

    public void setCenter(Vec2 center) {
        this.dx = center.x;
        this.dy = center.y;
        this.findCoefficients();
    }

    public Vec2 getScale() {
        return new Vec2(this.xscale, this.yscale);
    }

    public void setScale(Vec2 scale) {
        this.xscale = scale.x;
        this.yscale = scale.y;
        this.findCoefficients();
    }

    public Vec3 getRotations() {
        double[] angles = this.coords.getRotationAngles();
        return new Vec3(angles[0], angles[1], angles[2]);
    }

    public void setRotations(Vec3 angles) {
        this.coords.setOrientation(angles.x, angles.y, angles.z);
        this.findCoefficients();
    }

    public boolean isBoundToSurface() {
        return this.coordsFromParams;
    }

    public void setBoundToSurface(boolean bound) {
        this.coordsFromParams = bound;
    }

    public boolean isScaledToObject() {
        return this.scaleToObject;
    }

    public void setScaledToObject(boolean scaled) {
        this.scaleToObject = scaled;
    }

    public Mat4 getTransform() {
        double xscale = 1.0;
        double yscale = 1.0;
        double zscale = 1.0;
        if (this.scaleToObject) {
            BoundingBox bounds = this.getObject().getBounds();
            if (bounds.maxx > bounds.minx) {
                xscale = 1.0 / (bounds.maxx - bounds.minx);
            }
            if (bounds.maxy > bounds.miny) {
                yscale = 1.0 / (bounds.maxy - bounds.miny);
            }
            if (bounds.maxz > bounds.minz) {
                zscale = 1.0 / (bounds.maxz - bounds.minz);
            }
        }
        return new Mat4(xscale * this.ax, yscale * this.bx, zscale * this.cx, -this.dx, xscale * this.ay, yscale * this.by, zscale * this.cy, -this.dy, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0);
    }

    public RenderingTriangle mapTriangle(int v1, int v2, int v3, int n1, int n2, int n3, Vec3[] vert) {
        Vec3 c1 = vert[v1];
        Vec3 c2 = vert[v2];
        Vec3 c3 = vert[v3];
        if (this.coordsFromParams) {
            return new UVMappedTriangle(v1, v2, v3, n1, n2, n3);
        }
        double x1 = c1.x;
        double y1 = c1.y;
        double z1 = c1.z;
        double x2 = c2.x;
        double y2 = c2.y;
        double z2 = c2.z;
        double x3 = c3.x;
        double y3 = c3.y;
        double z3 = c3.z;
        if (this.scaleToObject) {
            double scale;
            BoundingBox bounds = this.getObject().getBounds();
            if (bounds.maxx > bounds.minx) {
                scale = 1.0 / (bounds.maxx - bounds.minx);
                x1 *= scale;
                x2 *= scale;
                x3 *= scale;
            }
            if (bounds.maxy > bounds.miny) {
                scale = 1.0 / (bounds.maxy - bounds.miny);
                y1 *= scale;
                y2 *= scale;
                y3 *= scale;
            }
            if (bounds.maxz > bounds.minz) {
                scale = 1.0 / (bounds.maxz - bounds.minz);
                z1 *= scale;
                z2 *= scale;
                z3 *= scale;
            }
        }
        return new Linear2DTriangle(v1, v2, v3, n1, n2, n3, (float)(x1 * this.ax + y1 * this.bx + z1 * this.cx - this.dx), (float)(x1 * this.ay + y1 * this.by + z1 * this.cy - this.dy), (float)(x2 * this.ax + y2 * this.bx + z2 * this.cx - this.dx), (float)(x2 * this.ay + y2 * this.by + z2 * this.cy - this.dy), (float)(x3 * this.ax + y3 * this.bx + z3 * this.cx - this.dx), (float)(x3 * this.ay + y3 * this.by + z3 * this.cy - this.dy));
    }

    public void setParameters(RenderingTriangle tri, double[] p1, double[] p2, double[] p3, RenderingMesh mesh) {
        if (!(tri instanceof UVMappedTriangle)) {
            return;
        }
        UVMappedTriangle uv = (UVMappedTriangle)tri;
        double x1 = p1[this.numTextureParams];
        double y1 = p1[this.numTextureParams + 1];
        double z1 = p1[this.numTextureParams + 2];
        double x2 = p2[this.numTextureParams];
        double y2 = p2[this.numTextureParams + 1];
        double z2 = p2[this.numTextureParams + 2];
        double x3 = p3[this.numTextureParams];
        double y3 = p3[this.numTextureParams + 1];
        double z3 = p3[this.numTextureParams + 2];
        if (this.scaleToObject) {
            double scale;
            BoundingBox bounds = this.getObject().getBounds();
            if (bounds.maxx > bounds.minx) {
                scale = 1.0 / (bounds.maxx - bounds.minx);
                x1 *= scale;
                x2 *= scale;
                x3 *= scale;
            }
            if (bounds.maxy > bounds.miny) {
                scale = 1.0 / (bounds.maxy - bounds.miny);
                y1 *= scale;
                y2 *= scale;
                y3 *= scale;
            }
            if (bounds.maxz > bounds.minz) {
                scale = 1.0 / (bounds.maxz - bounds.minz);
                z1 *= scale;
                z2 *= scale;
                z3 *= scale;
            }
        }
        uv.setTextureCoordinates((float)(x1 * this.ax + y1 * this.bx + z1 * this.cx - this.dx), (float)(x1 * this.ay + y1 * this.by + z1 * this.cy - this.dy), (float)(x2 * this.ax + y2 * this.bx + z2 * this.cx - this.dx), (float)(x2 * this.ay + y2 * this.by + z2 * this.cy - this.dy), (float)(x3 * this.ax + y3 * this.bx + z3 * this.cx - this.dx), (float)(x3 * this.ay + y3 * this.by + z3 * this.cy - this.dy), mesh.vert[uv.v1], mesh.vert[uv.v2], mesh.vert[uv.v3]);
    }

    public void getTextureSpec(Vec3 pos, TextureSpec spec, double angle, double size, double time, double[] param) {
        double z;
        double y;
        double x;
        if (!this.appliesToFace(angle > 0.0)) {
            spec.diffuse.setRGB(0.0f, 0.0f, 0.0f);
            spec.specular.setRGB(0.0f, 0.0f, 0.0f);
            spec.transparent.setRGB(1.0f, 1.0f, 1.0f);
            spec.emissive.setRGB(0.0f, 0.0f, 0.0f);
            spec.cloudiness = 0.0;
            spec.roughness = 0.0;
            spec.bumpGrad.set(0.0, 0.0, 0.0);
            return;
        }
        double sizex = size;
        double sizey = size;
        double sizez = size;
        if (this.coordsFromParams && this.numTextureParams < param.length && param[this.numTextureParams] != Double.MAX_VALUE) {
            x = param[this.numTextureParams];
            y = param[this.numTextureParams + 1];
            z = param[this.numTextureParams + 2];
        } else {
            x = pos.x;
            y = pos.y;
            z = pos.z;
        }
        if (this.scaleToObject) {
            double scale;
            BoundingBox bounds = this.getObject().getBounds();
            if (bounds.maxx > bounds.minx) {
                scale = 1.0 / (bounds.maxx - bounds.minx);
                x *= scale;
                sizex = size * scale;
            }
            if (bounds.maxy > bounds.miny) {
                scale = 1.0 / (bounds.maxy - bounds.miny);
                y *= scale;
                sizey = size * scale;
            }
            if (bounds.maxz > bounds.minz) {
                scale = 1.0 / (bounds.maxz - bounds.minz);
                z *= scale;
                sizez = size * scale;
            }
        }
        this.texture.getTextureSpec(spec, x * this.ax + y * this.bx + z * this.cx - this.dx, x * this.ay + y * this.by + z * this.cy - this.dy, this.length(this.ax * sizex, this.bx * sizey, this.cx * sizez), this.length(this.ay * sizex, this.by * sizey, this.cy * sizez), angle, time, param);
        if (this.texture.hasComponent(5)) {
            double s = spec.bumpGrad.x;
            double t = spec.bumpGrad.y;
            spec.bumpGrad.set(s * this.ax + t * this.ay, s * this.bx + t * this.by, s * this.cx + t * this.cy);
        }
    }

    public void getTransparency(Vec3 pos, RGBColor trans, double angle, double size, double time, double[] param) {
        double z;
        double y;
        double x;
        if (!this.appliesToFace(angle > 0.0)) {
            trans.setRGB(1.0f, 1.0f, 1.0f);
            return;
        }
        double sizex = size;
        double sizey = size;
        double sizez = size;
        if (this.coordsFromParams && this.numTextureParams < param.length && param[this.numTextureParams] != Double.MAX_VALUE) {
            x = param[this.numTextureParams];
            y = param[this.numTextureParams + 1];
            z = param[this.numTextureParams + 2];
        } else {
            x = pos.x;
            y = pos.y;
            z = pos.z;
        }
        if (this.scaleToObject) {
            double scale;
            BoundingBox bounds = this.getObject().getBounds();
            if (bounds.maxx > bounds.minx) {
                scale = 1.0 / (bounds.maxx - bounds.minx);
                x *= scale;
                sizex = size * scale;
            }
            if (bounds.maxy > bounds.miny) {
                scale = 1.0 / (bounds.maxy - bounds.miny);
                y *= scale;
                sizey = size * scale;
            }
            if (bounds.maxz > bounds.minz) {
                scale = 1.0 / (bounds.maxz - bounds.minz);
                z *= scale;
                sizez = size * scale;
            }
        }
        this.texture.getTransparency(trans, x * this.ax + y * this.bx + z * this.cx - this.dx, x * this.ay + y * this.by + z * this.cy - this.dy, this.length(this.ax * sizex, this.bx * sizey, this.cx * sizez), this.length(this.ay * sizex, this.by * sizey, this.cy * sizez), angle, time, param);
    }

    public double getDisplacement(Vec3 pos, double size, double time, double[] param) {
        double z;
        double y;
        double x;
        double sizex = size;
        double sizey = size;
        double sizez = size;
        if (this.coordsFromParams && this.numTextureParams < param.length && param[this.numTextureParams] != Double.MAX_VALUE) {
            x = param[this.numTextureParams];
            y = param[this.numTextureParams + 1];
            z = param[this.numTextureParams + 2];
        } else {
            x = pos.x;
            y = pos.y;
            z = pos.z;
        }
        if (this.scaleToObject) {
            double scale;
            BoundingBox bounds = this.getObject().getBounds();
            if (bounds.maxx > bounds.minx) {
                scale = 1.0 / (bounds.maxx - bounds.minx);
                x *= scale;
                sizex = size * scale;
            }
            if (bounds.maxy > bounds.miny) {
                scale = 1.0 / (bounds.maxy - bounds.miny);
                y *= scale;
                sizey = size * scale;
            }
            if (bounds.maxz > bounds.minz) {
                scale = 1.0 / (bounds.maxz - bounds.minz);
                z *= scale;
                sizez = size * scale;
            }
        }
        return this.texture.getDisplacement(x * this.ax + y * this.bx + z * this.cx - this.dx, x * this.ay + y * this.by + z * this.cy - this.dy, this.length(this.ax * sizex, this.bx * sizey, this.cx * sizez), this.length(this.ay * sizex, this.by * sizey, this.cy * sizez), time, param);
    }

    private double length(double x, double y, double z) {
        return Math.sqrt(x * x + y * y + z * z);
    }

    public Vec2[] findTextureCoordinates(Mesh mesh) {
        TextureParameter[] param = mesh.getParameters();
        ParameterValue[] paramValue = mesh.getParameterValues();
        Mat4 transform = this.getTransform();
        VertexParameterValue xval = null;
        VertexParameterValue yval = null;
        VertexParameterValue zval = null;
        if (this.coordsFromParams) {
            for (int i = 0; i < param.length; ++i) {
                if (param[i].equals(this.xparam)) {
                    xval = (VertexParameterValue)paramValue[i];
                    continue;
                }
                if (param[i].equals(this.yparam)) {
                    yval = (VertexParameterValue)paramValue[i];
                    continue;
                }
                if (!param[i].equals(this.zparam)) continue;
                zval = (VertexParameterValue)paramValue[i];
            }
        }
        MeshVertex[] vert = mesh.getVertices();
        Vec2[] uv = new Vec2[vert.length];
        for (int i = 0; i < vert.length; ++i) {
            double z;
            double y;
            double x;
            if (xval == null) {
                x = vert[i].r.x;
                y = vert[i].r.y;
                z = vert[i].r.z;
            } else {
                x = xval.getValue()[i];
                y = yval.getValue()[i];
                z = zval.getValue()[i];
            }
            uv[i] = transform.timesXY(new Vec3(x, y, z));
        }
        return uv;
    }

    public TextureMapping duplicate() {
        return this.duplicate(this.object, this.texture);
    }

    public TextureMapping duplicate(Object3D obj, Texture tex) {
        ProjectionMapping map = new ProjectionMapping(obj, tex);
        map.coords = this.coords.duplicate();
        map.dx = this.dx;
        map.dy = this.dy;
        map.xscale = this.xscale;
        map.yscale = this.yscale;
        map.findCoefficients();
        map.coordsFromParams = this.coordsFromParams;
        map.numTextureParams = this.numTextureParams;
        map.scaleToObject = this.scaleToObject;
        map.setAppliesTo(this.appliesTo());
        map.xparam = this.xparam;
        map.yparam = this.yparam;
        map.zparam = this.zparam;
        return map;
    }

    public void copy(TextureMapping mapping) {
        ProjectionMapping map = (ProjectionMapping)mapping;
        this.coords = map.coords.duplicate();
        this.dx = map.dx;
        this.dy = map.dy;
        this.xscale = map.xscale;
        this.yscale = map.yscale;
        this.findCoefficients();
        this.coordsFromParams = map.coordsFromParams;
        this.numTextureParams = map.numTextureParams;
        this.scaleToObject = map.scaleToObject;
        this.setAppliesTo(map.appliesTo());
        this.xparam = map.xparam;
        this.yparam = map.yparam;
        this.zparam = map.zparam;
    }

    public TextureParameter[] getParameters() {
        if (!this.coordsFromParams) {
            return this.getTexture().getParameters();
        }
        TextureParameter[] tp = this.getTexture().getParameters();
        this.numTextureParams = tp.length;
        TextureParameter[] p = new TextureParameter[this.numTextureParams + 3];
        System.arraycopy(tp, 0, p, 0, this.numTextureParams);
        if (this.xparam == null) {
            this.xparam = new TextureParameter(this, "X", -1.7976931348623157E308, Double.MAX_VALUE, Double.MAX_VALUE);
            this.yparam = new TextureParameter(this, "Y", -1.7976931348623157E308, Double.MAX_VALUE, Double.MAX_VALUE);
            this.zparam = new TextureParameter(this, "Z", -1.7976931348623157E308, Double.MAX_VALUE, Double.MAX_VALUE);
            this.xparam.type = 1;
            this.yparam.type = 2;
            this.zparam.type = 3;
            this.xparam.assignNewID();
            this.yparam.assignNewID();
            this.zparam.assignNewID();
        }
        p[this.numTextureParams] = this.xparam;
        p[this.numTextureParams + 1] = this.yparam;
        p[this.numTextureParams + 2] = this.zparam;
        return p;
    }

    public Widget getEditingPanel(Object3D obj, MaterialPreviewer preview) {
        return new Editor(obj, preview);
    }

    public ProjectionMapping(DataInputStream in, Object3D theObject, Texture theTexture) throws IOException, InvalidObjectException {
        super(theObject, theTexture);
        short version = in.readShort();
        if (version < 0 || version > 2) {
            throw new InvalidObjectException("");
        }
        this.coords = new CoordinateSystem(in);
        this.dx = in.readDouble();
        this.dy = in.readDouble();
        this.xscale = in.readDouble();
        this.yscale = in.readDouble();
        this.findCoefficients();
        this.coordsFromParams = in.readBoolean();
        if (version > 0) {
            this.setAppliesTo(in.readShort());
        }
        this.scaleToObject = version > 1 ? in.readBoolean() : false;
    }

    public void writeToFile(DataOutputStream out) throws IOException {
        out.writeShort(2);
        this.coords.writeToFile(out);
        out.writeDouble(this.dx);
        out.writeDouble(this.dy);
        out.writeDouble(this.xscale);
        out.writeDouble(this.yscale);
        out.writeBoolean(this.coordsFromParams);
        out.writeShort(this.appliesTo());
        out.writeBoolean(this.scaleToObject);
    }

    class Editor
    extends FormContainer {
        ValueField xrotField;
        ValueField yrotField;
        ValueField zrotField;
        ValueField xscaleField;
        ValueField yscaleField;
        ValueField xtransField;
        ValueField ytransField;
        BCheckBox coordsFromParamsBox;
        BCheckBox scaleToObjectBox;
        BComboBox applyToChoice;
        Object3D theObject;
        MaterialPreviewer preview;

        public Editor(Object3D obj, MaterialPreviewer preview) {
            super(6, 9);
            this.theObject = obj;
            this.preview = preview;
            this.setDefaultLayout(new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.NONE, new Insets(0, 0, 0, 5), null));
            this.add(new BLabel(Translate.text("Scale") + ":"), 0, 0, 6, 1);
            this.add(new BLabel("X"), 0, 1);
            this.xscaleField = new ValueField(ProjectionMapping.this.xscale, 2, 5);
            this.add(this.xscaleField, 1, 1);
            this.add(new BLabel("Y"), 2, 1);
            this.yscaleField = new ValueField(ProjectionMapping.this.yscale, 2, 5);
            this.add(this.yscaleField, 3, 1);
            this.add(new BLabel(Translate.text("Center") + ":"), 0, 2, 6, 1);
            this.add(new BLabel("X"), 0, 3);
            this.xtransField = new ValueField(ProjectionMapping.this.dx, 0, 5);
            this.add(this.xtransField, 1, 3);
            this.add(new BLabel("Y"), 2, 3);
            this.ytransField = new ValueField(ProjectionMapping.this.dy, 0, 5);
            this.add(this.ytransField, 3, 3);
            double[] angles = ProjectionMapping.this.coords.getRotationAngles();
            this.add(new BLabel(Translate.text("Rotation") + ":"), 0, 4, 6, 1);
            this.add(new BLabel("X"), 0, 5);
            this.xrotField = new ValueField(angles[0], 0, 5);
            this.add(this.xrotField, 1, 5);
            this.add(new BLabel("Y"), 2, 5);
            this.yrotField = new ValueField(angles[1], 0, 5);
            this.add(this.yrotField, 3, 5);
            this.add(new BLabel("Z"), 4, 5);
            this.zrotField = new ValueField(angles[2], 0, 5);
            this.add(this.zrotField, 5, 5);
            RowContainer applyRow = new RowContainer();
            applyRow.add(new BLabel(Translate.text("applyTo") + ":"));
            this.applyToChoice = new BComboBox(new String[]{Translate.text("frontAndBackFaces"), Translate.text("frontFacesOnly"), Translate.text("backFacesOnly")});
            applyRow.add(this.applyToChoice);
            this.add(applyRow, 0, 6, 6, 1);
            this.applyToChoice.setSelectedIndex(ProjectionMapping.this.appliesTo());
            this.coordsFromParamsBox = new BCheckBox(Translate.text("bindTexToSurface"), ProjectionMapping.this.coordsFromParams);
            this.add(this.coordsFromParamsBox, 0, 7, 6, 1);
            this.scaleToObjectBox = new BCheckBox(Translate.text("scaleTexToObject"), ProjectionMapping.this.scaleToObject);
            this.add(this.scaleToObjectBox, 0, 8, 6, 1);
            this.coordsFromParamsBox.setEnabled(this.theObject instanceof Mesh || this.theObject instanceof Actor);
            this.xscaleField.addEventLink(ValueChangedEvent.class, this);
            this.yscaleField.addEventLink(ValueChangedEvent.class, this);
            this.xtransField.addEventLink(ValueChangedEvent.class, this);
            this.ytransField.addEventLink(ValueChangedEvent.class, this);
            this.xrotField.addEventLink(ValueChangedEvent.class, this);
            this.yrotField.addEventLink(ValueChangedEvent.class, this);
            this.zrotField.addEventLink(ValueChangedEvent.class, this);
            this.coordsFromParamsBox.addEventLink(ValueChangedEvent.class, this);
            this.scaleToObjectBox.addEventLink(ValueChangedEvent.class, this);
            this.applyToChoice.addEventLink(ValueChangedEvent.class, this);
        }

        private void processEvent() {
            ProjectionMapping.this.xscale = this.xscaleField.getValue();
            ProjectionMapping.this.yscale = this.yscaleField.getValue();
            ProjectionMapping.this.dx = this.xtransField.getValue();
            ProjectionMapping.this.dy = this.ytransField.getValue();
            ProjectionMapping.this.coords.setOrientation(this.xrotField.getValue(), this.yrotField.getValue(), this.zrotField.getValue());
            ProjectionMapping.this.findCoefficients();
            ProjectionMapping.this.coordsFromParams = this.coordsFromParamsBox.getState();
            ProjectionMapping.this.scaleToObject = this.scaleToObjectBox.getState();
            ProjectionMapping.this.setAppliesTo((short)this.applyToChoice.getSelectedIndex());
            this.preview.setTexture(ProjectionMapping.this.getTexture(), ProjectionMapping.this);
            this.preview.render();
        }
    }
}

