/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.script;

import artofillusion.PluginRegistry;
import artofillusion.script.ObjectScript;
import artofillusion.script.ScriptOutputWindow;
import artofillusion.script.ToolScript;
import artofillusion.util.SearchlistClassLoader;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.TargetError;
import buoy.widget.BStandardDialog;
import java.io.PrintStream;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.List;
import java.util.Vector;

public class ScriptRunner {
    static Interpreter interp;

    public static Interpreter getInterpreter() {
        if (interp == null) {
            interp = new Interpreter();
            try {
                interp.eval("import artofillusion.*");
                interp.eval("import artofillusion.image.*");
                interp.eval("import artofillusion.material.*");
                interp.eval("import artofillusion.math.*");
                interp.eval("import artofillusion.object.*");
                interp.eval("import artofillusion.script.*");
                interp.eval("import artofillusion.texture.*");
                interp.eval("import artofillusion.ui.*");
                interp.eval("import buoy.event.*");
                interp.eval("import buoy.widget.*");
            }
            catch (EvalError e) {
                e.printStackTrace();
            }
            PrintStream out = new PrintStream(new ScriptOutputWindow());
            interp.setOut(out);
            interp.setErr(out);
            SearchlistClassLoader loader = new SearchlistClassLoader(ScriptRunner.class.getClassLoader());
            List<ClassLoader> plugins = PluginRegistry.getPluginClassLoaders();
            for (int i = 0; i < plugins.size(); ++i) {
                loader.add(plugins.get(i));
            }
            interp.setClassLoader((ClassLoader)loader);
        }
        return interp;
    }

    public static Object executeScript(String script) {
        try {
            return ScriptRunner.getInterpreter().eval(script);
        }
        catch (EvalError e) {
            System.out.println("Error in line " + e.getErrorLineNumber() + ": " + e.getErrorText());
            return null;
        }
    }

    public static ToolScript parseToolScript(String script) throws Exception {
        String prefix = "return new ToolScript() {void execute(LayoutWindow window) {\n";
        String suffix = "\n;}}";
        return (ToolScript)ScriptRunner.getInterpreter().eval(prefix + script + suffix);
    }

    public static ObjectScript parseObjectScript(String script) throws Exception {
        String prefix = "return new ObjectScript() {void execute(ScriptedObjectController script) {\n";
        String suffix = "\n;}}";
        return (ObjectScript)ScriptRunner.getInterpreter().eval(prefix + script + suffix);
    }

    public static int displayError(Exception ex, int lineOffset) {
        if (ex instanceof UndeclaredThrowableException) {
            ex = (Exception)((UndeclaredThrowableException)ex).getUndeclaredThrowable();
        }
        String head = "An error occurred while executing the script:";
        String message = null;
        String errorText = null;
        String column = null;
        int line = -1;
        try {
            if (ex instanceof TargetError) {
                TargetError t = (TargetError)ex;
                message = t.getMessage();
                errorText = t.getErrorText();
                if (t.getErrorLineNumber() > -1) {
                    line = t.getErrorLineNumber() - lineOffset;
                }
                t.getTarget().printStackTrace(interp.getOut());
            } else if (ex instanceof EvalError) {
                EvalError e = (EvalError)((Object)ex);
                head = "An error occurred while parsing the script:";
                message = e.getMessage();
                errorText = e.getErrorText();
                if (e.getErrorLineNumber() > -1) {
                    line = e.getErrorLineNumber() - lineOffset;
                }
                e.printStackTrace(interp.getOut());
            } else {
                message = ex.getMessage();
                ex.printStackTrace(interp.getOut());
            }
        }
        catch (Exception ex2) {
            ex2.printStackTrace();
        }
        Vector<String> v = new Vector<String>();
        v.addElement(head);
        if (message != null) {
            if (message.indexOf("Inline eval of") == -1) {
                v.addElement(message);
            } else {
                int j;
                int i = message.lastIndexOf("> Encountered");
                if (i > -1 && (j = message.lastIndexOf(", column")) > i) {
                    column = message.substring(j);
                }
            }
        }
        if (line > -1 && errorText != null) {
            if (column == null) {
                v.addElement("Encountered \"" + errorText + "\" at line " + line + ".");
            } else {
                v.addElement("Encountered \"" + errorText + "\" at line " + line + column);
            }
        }
        Object[] msg = new String[v.size()];
        v.copyInto(msg);
        new BStandardDialog("Error", msg, BStandardDialog.ERROR).showMessageDialog(null);
        return line;
    }
}

