/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.procedural;

import artofillusion.Scene;
import artofillusion.math.FastMath;
import artofillusion.math.RGBColor;
import artofillusion.procedural.IOPort;
import artofillusion.procedural.Module;
import artofillusion.procedural.PointInfo;
import artofillusion.procedural.ProcedureEditor;
import artofillusion.ui.ColorChooser;
import artofillusion.ui.Translate;
import artofillusion.ui.UIUtilities;
import artofillusion.ui.ValueChecker;
import artofillusion.ui.ValueField;
import buoy.event.KeyPressedEvent;
import buoy.event.MouseClickedEvent;
import buoy.event.MouseDraggedEvent;
import buoy.event.MousePressedEvent;
import buoy.event.MouseReleasedEvent;
import buoy.event.RepaintEvent;
import buoy.event.ValueChangedEvent;
import buoy.widget.BButton;
import buoy.widget.BCheckBox;
import buoy.widget.BDialog;
import buoy.widget.BFrame;
import buoy.widget.BLabel;
import buoy.widget.BOutline;
import buoy.widget.CustomWidget;
import buoy.widget.FormContainer;
import buoy.widget.LayoutInfo;
import buoy.widget.RowContainer;
import buoy.widget.Widget;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class SpectrumModule
extends Module {
    RGBColor[] color = new RGBColor[]{new RGBColor(0.0f, 0.0f, 0.0f), new RGBColor(1.0f, 1.0f, 1.0f)};
    RGBColor outputColor;
    float[][] a1;
    float[][] b1;
    float[][] c1;
    double[] index = new double[]{0.0, 1.0};
    double lastBlur;
    boolean repeat;
    boolean colorOk;

    public SpectrumModule(Point position) {
        super("Spectrum", new IOPort[]{new IOPort(0, 0, 2, new String[]{"Index", "(0)"})}, new IOPort[]{new IOPort(1, 1, 3, new String[]{"Color"})}, position);
        this.outputColor = new RGBColor(0.0f, 0.0f, 0.0f);
        this.calcCoefficients();
    }

    public RGBColor[] getColors() {
        return this.color;
    }

    public double[] getColorPositions() {
        return this.index;
    }

    public void setColors(RGBColor[] color, double[] position) {
        this.color = color;
        this.index = position;
        this.calcCoefficients();
    }

    public boolean getRepeat() {
        return this.repeat;
    }

    public void setRepeat(boolean repeat) {
        this.repeat = repeat;
    }

    public void init(PointInfo p) {
        this.colorOk = false;
    }

    private void calcCoefficients() {
        int i;
        this.a1 = new float[this.color.length][3];
        this.b1 = new float[this.color.length][3];
        this.c1 = new float[this.color.length][3];
        for (i = 0; i < this.color.length - 1; ++i) {
            float d = (float)(this.index[i + 1] - this.index[i]);
            if (d == 0.0f) {
                this.b1[i][2] = 0.0f;
                this.b1[i][1] = 0.0f;
                this.b1[i][0] = 0.0f;
                this.a1[i][2] = 0.0f;
                this.a1[i][1] = 0.0f;
                this.a1[i][0] = 0.0f;
                continue;
            }
            this.a1[i][0] = 0.5f * (this.color[i + 1].getRed() - this.color[i].getRed()) / d;
            this.a1[i][1] = 0.5f * (this.color[i + 1].getGreen() - this.color[i].getGreen()) / d;
            this.a1[i][2] = 0.5f * (this.color[i + 1].getBlue() - this.color[i].getBlue()) / d;
            this.b1[i][0] = this.color[i].getRed() - 2.0f * this.a1[i][0] * (float)this.index[i];
            this.b1[i][1] = this.color[i].getGreen() - 2.0f * this.a1[i][1] * (float)this.index[i];
            this.b1[i][2] = this.color[i].getBlue() - 2.0f * this.a1[i][2] * (float)this.index[i];
            this.c1[i + 1][0] = (float)((double)this.c1[i][0] + this.index[i + 1] * ((double)this.a1[i][0] * this.index[i + 1] + (double)this.b1[i][0]) - this.index[i] * ((double)this.a1[i][0] * this.index[i] + (double)this.b1[i][0]));
            this.c1[i + 1][1] = (float)((double)this.c1[i][1] + this.index[i + 1] * ((double)this.a1[i][1] * this.index[i + 1] + (double)this.b1[i][1]) - this.index[i] * ((double)this.a1[i][1] * this.index[i] + (double)this.b1[i][1]));
            this.c1[i + 1][2] = (float)((double)this.c1[i][2] + this.index[i + 1] * ((double)this.a1[i][2] * this.index[i + 1] + (double)this.b1[i][2]) - this.index[i] * ((double)this.a1[i][2] * this.index[i] + (double)this.b1[i][2]));
        }
        if (!this.repeat) {
            this.b1[i][0] = this.color[i].getRed();
            this.b1[i][1] = this.color[i].getGreen();
            this.b1[i][2] = this.color[i].getBlue();
        }
        for (i = 1; i < this.color.length; ++i) {
            float[] fArray = this.c1[i];
            fArray[0] = fArray[0] - (float)(this.index[i] * ((double)this.a1[i][0] * this.index[i] + (double)this.b1[i][0]));
            float[] fArray2 = this.c1[i];
            fArray2[1] = fArray2[1] - (float)(this.index[i] * ((double)this.a1[i][1] * this.index[i] + (double)this.b1[i][1]));
            float[] fArray3 = this.c1[i];
            fArray3[2] = fArray3[2] - (float)(this.index[i] * ((double)this.a1[i][2] * this.index[i] + (double)this.b1[i][2]));
        }
    }

    private void calcColor(double value, RGBColor c) {
        int i;
        if (value <= 0.0 || value >= 1.0) {
            if (this.repeat) {
                value -= (double)FastMath.floor(value);
            } else {
                if (value <= 0.0) {
                    c.copy(this.color[0]);
                    return;
                }
                c.copy(this.color[this.color.length - 1]);
                return;
            }
        }
        for (i = 1; i < this.index.length && value > this.index[i]; ++i) {
        }
        int i2 = i;
        int i1 = i - 1;
        float d = (float)(this.index[i2] - this.index[i1]);
        float fract = d > 0.0f ? (float)(value - this.index[i1]) / d : 0.0f;
        float fract2 = 1.0f - fract;
        c.setRGB(fract * this.color[i2].getRed() + fract2 * this.color[i1].getRed(), fract * this.color[i2].getGreen() + fract2 * this.color[i1].getGreen(), fract * this.color[i2].getBlue() + fract2 * this.color[i1].getBlue());
    }

    private void integrateColor(double value, RGBColor c) {
        int i;
        float vf;
        if (!this.repeat) {
            if (value <= 0.0) {
                c.setRGB((float)value * this.b1[0][0], (float)value * this.b1[0][1], (float)value * this.b1[0][2]);
                return;
            }
            if (value >= 1.0) {
                int i2 = this.color.length - 1;
                c.setRGB(this.c1[i2][0] + (float)value * this.b1[i2][0], this.c1[i2][1] + (float)value * this.b1[i2][1], this.c1[i2][2] + (float)value * this.b1[i2][2]);
                return;
            }
            vf = (float)value;
            c.setRGB(0.0f, 0.0f, 0.0f);
        } else {
            float vi = FastMath.floor(value);
            vf = (float)value - vi;
            c.setRGB(vi * this.c1[this.color.length - 1][0], vi * this.c1[this.color.length - 1][1], vi * this.c1[this.color.length - 1][2]);
        }
        if ((double)vf == 0.0) {
            return;
        }
        for (i = 1; i < this.index.length && (double)vf > this.index[i]; ++i) {
        }
        c.add(this.c1[--i][0] + vf * (vf * this.a1[i][0] + this.b1[i][0]), this.c1[i][1] + vf * (vf * this.a1[i][1] + this.b1[i][1]), this.c1[i][2] + vf * (vf * this.a1[i][2] + this.b1[i][2]));
    }

    public void getColor(int which, RGBColor c, double blur) {
        double error;
        if (this.colorOk && blur == this.lastBlur) {
            c.copy(this.outputColor);
            return;
        }
        this.colorOk = true;
        this.lastBlur = blur;
        double value = this.linkFrom[0] == null ? 0.0 : this.linkFrom[0].getAverageValue(this.linkFromIndex[0], blur);
        double d = error = this.linkFrom[0] == null ? 0.0 : this.linkFrom[0].getValueError(this.linkFromIndex[0], blur);
        if (error == 0.0) {
            this.calcColor(value, c);
        } else {
            this.integrateColor(value + 0.5 * error, c);
            this.integrateColor(value - 0.5 * error, this.outputColor);
            c.subtract(this.outputColor);
            c.scale(1.0 / error);
            this.outputColor.copy(c);
        }
    }

    public Module duplicate() {
        SpectrumModule mod = new SpectrumModule(new Point(this.bounds.x, this.bounds.y));
        mod.repeat = this.repeat;
        mod.color = new RGBColor[this.color.length];
        mod.index = new double[this.index.length];
        for (int i = 0; i < this.color.length; ++i) {
            mod.color[i] = this.color[i].duplicate();
            mod.index[i] = this.index[i];
        }
        mod.calcCoefficients();
        return mod;
    }

    public void writeToStream(DataOutputStream out, Scene theScene) throws IOException {
        out.writeInt(this.color.length);
        for (int i = 0; i < this.color.length; ++i) {
            out.writeDouble(this.index[i]);
            this.color[i].writeToFile(out);
        }
        out.writeBoolean(this.repeat);
    }

    public void readFromStream(DataInputStream in, Scene theScene) throws IOException {
        int num = in.readInt();
        this.color = new RGBColor[num];
        this.index = new double[num];
        for (int i = 0; i < this.color.length; ++i) {
            this.index[i] = in.readDouble();
            this.color[i] = new RGBColor(in);
        }
        this.repeat = in.readBoolean();
        this.calcCoefficients();
    }

    public void calcSize() {
        this.bounds.width = 50;
        this.bounds.height = 30;
    }

    protected void drawContents(Graphics2D g) {
        int x1 = this.bounds.x + 5;
        int y1 = this.bounds.y + 5;
        RGBColor temp = new RGBColor(0.0f, 0.0f, 0.0f);
        for (int i = 0; i < 40; ++i) {
            this.calcColor((double)i / 40.0, temp);
            g.setColor(temp.getColor());
            g.drawLine(x1 + i, y1, x1 + i, y1 + 20);
        }
    }

    public boolean edit(ProcedureEditor editor, Scene theScene) {
        EditingDialog dlg = new EditingDialog(editor);
        this.calcCoefficients();
        return dlg.clickedOk;
    }

    private class EditingDialog
    extends BDialog {
        ProcedureEditor editor;
        CustomWidget canvas;
        ValueField indexField;
        Widget preview;
        BCheckBox repeatBox;
        BButton deleteButton;
        Point clickPoint;
        Point[] handlePos;
        int selected;
        int rows;
        boolean clickedOk;
        static final int HANDLE_SIZE = 5;
        static final int INSET = 3;

        public EditingDialog(ProcedureEditor editor) {
            super(editor.getParentFrame(), "Function", true);
            this.rows = 1;
            this.editor = editor;
            FormContainer content = new FormContainer(1, 5);
            this.setContent(BOutline.createEmptyBorder(content, UIUtilities.getStandardDialogInsets()));
            content.add(Translate.label("functionModuleInstructions"), 0, 0);
            this.canvas = new CustomWidget();
            content.add(this.canvas, 0, 1, new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.BOTH, null, null));
            this.canvas.setPreferredSize(new Dimension(200, 30 + this.rows * 5));
            this.canvas.addEventLink(RepaintEvent.class, (Object)this, "paintCanvas");
            this.canvas.addEventLink(KeyPressedEvent.class, (Object)this, "keyPressed");
            this.canvas.addEventLink(MousePressedEvent.class, (Object)this, "mousePressed");
            this.canvas.addEventLink(MouseReleasedEvent.class, (Object)this, "mouseReleased");
            this.canvas.addEventLink(MouseDraggedEvent.class, (Object)this, "mouseDragged");
            RowContainer row = new RowContainer();
            content.add(row, 0, 2);
            row.add(new BLabel(Translate.text("Value") + ":"));
            this.indexField = new ValueField(Double.NaN, 0);
            row.add(this.indexField);
            this.indexField.setValueChecker(new ValueChecker(){

                public boolean isValid(double val) {
                    return val >= 0.0 && val <= 1.0;
                }
            });
            this.indexField.addEventLink(ValueChangedEvent.class, (Object)this, "indexChanged");
            row.add(new BLabel(Translate.text("Color") + ":"));
            this.preview = SpectrumModule.this.color[0].getSample(30, 20);
            row.add(this.preview);
            this.preview.addEventLink(MouseClickedEvent.class, (Object)this, "selectColor");
            row.add(Translate.button("add", this, "doAdd"));
            this.deleteButton = Translate.button("delete", this, "doDelete");
            row.add(this.deleteButton);
            this.repeatBox = new BCheckBox(Translate.text("functionIsPeriodic"), SpectrumModule.this.repeat);
            content.add(this.repeatBox, 0, 3);
            this.repeatBox.addEventLink(ValueChangedEvent.class, (Object)this, "repeatChanged");
            RowContainer buttons = new RowContainer();
            content.add(buttons, 0, 4);
            buttons.add(Translate.button("ok", this, "doOk"));
            buttons.add(Translate.button("cancel", this, "doCancel"));
            this.adjustComponents();
            this.handlePos = new Point[SpectrumModule.this.index.length];
            for (int i = 0; i < SpectrumModule.this.index.length; ++i) {
                this.handlePos[i] = new Point(0, 0);
            }
            this.pack();
            UIUtilities.centerDialog(this, editor.getParentFrame());
            this.setVisible(true);
        }

        private void adjustComponents() {
            this.indexField.setText(Double.toString(SpectrumModule.this.index[this.selected]));
            this.preview.setBackground(SpectrumModule.this.color[this.selected].getColor());
            this.preview.repaint();
            boolean movable = this.selected > 0 && this.selected < SpectrumModule.this.index.length - 1;
            this.indexField.setEnabled(movable);
            this.deleteButton.setEnabled(movable);
        }

        private void positionHandles() {
            int i;
            Rectangle bounds = this.canvas.getBounds();
            int oldrows = this.rows;
            bounds.x += 3;
            bounds.width -= 6;
            for (i = 0; i < SpectrumModule.this.index.length; ++i) {
                this.handlePos[i].x = (int)((double)bounds.x + SpectrumModule.this.index[i] * (double)bounds.width);
            }
            if (this.clickPoint != null) {
                return;
            }
            this.rows = 1;
            for (i = 1; i < SpectrumModule.this.index.length; ++i) {
                int row = 0;
                boolean overlap = true;
                while (overlap) {
                    int j;
                    overlap = false;
                    for (j = 0; j < i && (row != this.handlePos[j].y || this.handlePos[i].x - this.handlePos[j].x > 5); ++j) {
                    }
                    if (j >= i) continue;
                    ++row;
                    overlap = true;
                }
                this.handlePos[i].y = row;
                if (row < this.rows) continue;
                this.rows = row + 1;
            }
            if (oldrows != this.rows) {
                this.pack();
            }
        }

        private void paintCanvas(RepaintEvent ev) {
            int i;
            Graphics2D g = ev.getGraphics();
            Rectangle bounds = this.canvas.getBounds();
            bounds.x += 3;
            bounds.width -= 6;
            RGBColor temp = new RGBColor(0.0f, 0.0f, 0.0f);
            double scale = 1.0 / (double)bounds.width;
            for (i = 0; i < bounds.width; ++i) {
                SpectrumModule.this.calcColor((double)i * scale, temp);
                g.setColor(temp.getColor());
                g.drawLine(bounds.x + i, 0, bounds.x + i, 30);
            }
            g.setColor(this.getBackground());
            g.fillRect(0, 30, bounds.width, bounds.height);
            g.setColor(Color.black);
            this.positionHandles();
            for (i = 0; i < SpectrumModule.this.index.length; ++i) {
                if (i == this.selected) {
                    g.setColor(Color.red);
                }
                int x = this.handlePos[i].x;
                int y = 30 + this.handlePos[i].y * 5;
                g.fillPolygon(new int[]{x, x + 5, x - 5}, new int[]{y, y + 5, y + 5}, 3);
                g.setColor(Color.black);
                g.drawLine(x, y, x, 30);
            }
        }

        private void addHandle(double where) {
            int i;
            double[] newindex = new double[SpectrumModule.this.index.length + 1];
            RGBColor[] newcolor = new RGBColor[SpectrumModule.this.color.length + 1];
            for (i = 0; i < SpectrumModule.this.index.length && SpectrumModule.this.index[i] < where; ++i) {
                newindex[i] = SpectrumModule.this.index[i];
                newcolor[i] = SpectrumModule.this.color[i];
            }
            newindex[i] = where;
            newcolor[i] = new RGBColor(1.0f, 1.0f, 1.0f);
            SpectrumModule.this.calcColor(newindex[i], newcolor[i]);
            this.selected = i;
            while (i < SpectrumModule.this.index.length) {
                newindex[i + 1] = SpectrumModule.this.index[i];
                newcolor[i + 1] = SpectrumModule.this.color[i];
                ++i;
            }
            SpectrumModule.this.index = newindex;
            SpectrumModule.this.color = newcolor;
            this.handlePos = new Point[SpectrumModule.this.index.length + 1];
            for (i = 0; i < this.handlePos.length; ++i) {
                this.handlePos[i] = new Point(0, 0);
            }
            SpectrumModule.this.calcCoefficients();
            this.adjustComponents();
            this.canvas.repaint();
            this.editor.updatePreview();
        }

        private void doDelete() {
            int i;
            if (this.selected == 0 || this.selected == SpectrumModule.this.index.length - 1) {
                return;
            }
            double[] newindex = new double[SpectrumModule.this.index.length - 1];
            RGBColor[] newcolor = new RGBColor[SpectrumModule.this.color.length - 1];
            for (i = 0; i < SpectrumModule.this.index.length - 1; ++i) {
                if (i < this.selected) {
                    newindex[i] = SpectrumModule.this.index[i];
                    newcolor[i] = SpectrumModule.this.color[i];
                    continue;
                }
                newindex[i] = SpectrumModule.this.index[i + 1];
                newcolor[i] = SpectrumModule.this.color[i + 1];
            }
            this.selected = 0;
            SpectrumModule.this.index = newindex;
            SpectrumModule.this.color = newcolor;
            this.handlePos = new Point[SpectrumModule.this.index.length];
            for (i = 0; i < this.handlePos.length; ++i) {
                this.handlePos[i] = new Point(0, 0);
            }
            SpectrumModule.this.calcCoefficients();
            this.adjustComponents();
            this.canvas.repaint();
            this.editor.updatePreview();
        }

        private void doAdd() {
            this.addHandle(0.5);
        }

        private void doOk() {
            this.clickedOk = true;
            this.dispose();
        }

        private void doCancel() {
            this.dispose();
        }

        private void keyPressed(KeyPressedEvent ev) {
            if (ev.getKeyCode() == 10) {
                this.doOk();
            } else if (ev.getKeyCode() == 27) {
                this.doCancel();
            }
            if (ev.getWidget() != this.canvas) {
                return;
            }
            if (ev.getKeyCode() == 8 || ev.getKeyCode() == 127) {
                this.doDelete();
            }
        }

        private void selectColor() {
            new ColorChooser((BFrame)this.getParent(), Translate.text("selectColor"), SpectrumModule.this.color[this.selected]);
            this.preview.setBackground(SpectrumModule.this.color[this.selected].getColor());
            this.canvas.repaint();
            this.preview.repaint();
            this.editor.updatePreview();
        }

        private void mousePressed(MousePressedEvent ev) {
            this.clickPoint = ev.getPoint();
            this.canvas.requestFocus();
            if (ev.isControlDown()) {
                Rectangle bounds = this.canvas.getBounds();
                double ind = (double)this.clickPoint.x / ((double)bounds.width - 1.0);
                this.addHandle(0.001 * (double)((int)(ind * 1000.0)));
                return;
            }
            for (int i = 0; i < this.handlePos.length; ++i) {
                int x = this.handlePos[i].x;
                int y = 30 + this.handlePos[i].y * 5;
                if (this.clickPoint.x < x - 5 || this.clickPoint.x > x + 5 || this.clickPoint.y < y || this.clickPoint.y > y + 5) continue;
                this.selected = i;
                this.adjustComponents();
                this.canvas.repaint();
                return;
            }
            this.clickPoint = null;
        }

        private void mouseDragged(MouseDraggedEvent ev) {
            Point tempPos;
            RGBColor tempcolor;
            double temp;
            if (this.clickPoint == null || this.selected == 0 || this.selected == SpectrumModule.this.index.length - 1) {
                return;
            }
            Rectangle bounds = this.canvas.getBounds();
            Point pos = ev.getPoint();
            this.handlePos[this.selected].x = pos.x;
            double ind = (double)pos.x / ((double)bounds.width - 1.0);
            if (ind < 0.0) {
                ind = 0.0;
            }
            if (ind > 1.0) {
                ind = 1.0;
            }
            SpectrumModule.this.index[this.selected] = 0.001 * (double)((int)(1000.0 * ind));
            while (SpectrumModule.this.index[this.selected] < SpectrumModule.this.index[this.selected - 1]) {
                temp = SpectrumModule.this.index[this.selected];
                SpectrumModule.this.index[this.selected] = SpectrumModule.this.index[this.selected - 1];
                SpectrumModule.this.index[this.selected - 1] = temp;
                tempcolor = SpectrumModule.this.color[this.selected];
                SpectrumModule.this.color[this.selected] = SpectrumModule.this.color[this.selected - 1];
                SpectrumModule.this.color[this.selected - 1] = tempcolor;
                tempPos = this.handlePos[this.selected];
                this.handlePos[this.selected] = this.handlePos[this.selected - 1];
                this.handlePos[this.selected - 1] = tempPos;
                --this.selected;
            }
            while (SpectrumModule.this.index[this.selected] > SpectrumModule.this.index[this.selected + 1]) {
                temp = SpectrumModule.this.index[this.selected];
                SpectrumModule.this.index[this.selected] = SpectrumModule.this.index[this.selected + 1];
                SpectrumModule.this.index[this.selected + 1] = temp;
                tempcolor = SpectrumModule.this.color[this.selected];
                SpectrumModule.this.color[this.selected] = SpectrumModule.this.color[this.selected + 1];
                SpectrumModule.this.color[this.selected + 1] = tempcolor;
                tempPos = this.handlePos[this.selected];
                this.handlePos[this.selected] = this.handlePos[this.selected + 1];
                this.handlePos[this.selected + 1] = tempPos;
                ++this.selected;
            }
            this.adjustComponents();
            this.canvas.repaint();
        }

        private void mouseReleased(MouseReleasedEvent ev) {
            this.clickPoint = null;
            SpectrumModule.this.calcCoefficients();
            this.canvas.repaint();
            this.editor.updatePreview();
        }

        private void indexChanged() {
            SpectrumModule.this.index[this.selected] = this.indexField.getValue();
            SpectrumModule.this.calcCoefficients();
            this.canvas.repaint();
            this.editor.updatePreview();
        }

        private void repeatChanged() {
            SpectrumModule.this.repeat = this.repeatBox.getState();
            this.editor.updatePreview();
        }
    }
}

