/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.procedural;

import artofillusion.Scene;
import artofillusion.TextureParameter;
import artofillusion.procedural.IOPort;
import artofillusion.procedural.Module;
import artofillusion.procedural.PointInfo;
import artofillusion.procedural.ProcedureEditor;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.Translate;
import artofillusion.ui.ValueField;
import buoy.event.ValueChangedEvent;
import buoy.widget.BStandardDialog;
import buoy.widget.BTextField;
import buoy.widget.Widget;
import java.awt.Point;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ParameterModule
extends Module {
    double minVal = 0.0;
    double maxVal = 1.0;
    double defaultVal = 0.0;
    int index;
    int id = TextureParameter.getUniqueID();
    PointInfo point;

    public ParameterModule(Point position) {
        super(Translate.text("menu.parameterModule"), new IOPort[0], new IOPort[]{new IOPort(0, 1, 3, new String[]{"Value"})}, position);
    }

    public String getParameterName() {
        return this.name;
    }

    public void setParameterName(String name) {
        this.name = name;
    }

    public double getMinimum() {
        return this.minVal;
    }

    public void setMinimum(double val) {
        this.minVal = val;
    }

    public double getMaximum() {
        return this.maxVal;
    }

    public void setMaximum(double val) {
        this.maxVal = val;
    }

    public double getDefaultValue() {
        return this.defaultVal;
    }

    public void setDefaultValue(double val) {
        this.defaultVal = val;
    }

    public void init(PointInfo p) {
        this.point = p;
    }

    public double getAverageValue(int which, double blur) {
        if (this.point.param == null || this.point.param.length <= which) {
            return this.defaultVal;
        }
        return this.point.param[this.index];
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public TextureParameter getParameter(Object owner) {
        TextureParameter param = new TextureParameter(owner, this.name, this.minVal, this.maxVal, this.defaultVal);
        param.setID(this.id);
        return param;
    }

    public boolean edit(final ProcedureEditor editor, Scene theScene) {
        BTextField nameField = new BTextField(this.name);
        ValueField minField = new ValueField(this.minVal, 0);
        ValueField maxField = new ValueField(this.maxVal, 0);
        final ValueField defaultField = new ValueField(this.defaultVal, 0);
        defaultField.addEventLink(ValueChangedEvent.class, new Object(){

            void processEvent() {
                ParameterModule.this.defaultVal = defaultField.getValue();
                editor.updatePreview();
            }
        });
        ComponentsDialog dlg = new ComponentsDialog(editor.getParentFrame(), Translate.text("selectParameterProperties"), new Widget[]{nameField, minField, maxField, defaultField}, new String[]{Translate.text("Name"), Translate.text("Minimum"), Translate.text("Maximum"), Translate.text("Default")});
        if (!dlg.clickedOk()) {
            return false;
        }
        this.name = nameField.getText();
        this.minVal = minField.getValue();
        this.maxVal = maxField.getValue();
        this.defaultVal = defaultField.getValue();
        if (this.minVal > this.maxVal) {
            new BStandardDialog("", Translate.text("minimumAboveMaxError"), BStandardDialog.ERROR).showMessageDialog(editor.getParentFrame());
            return this.edit(editor, theScene);
        }
        if (this.minVal > this.defaultVal || this.maxVal < this.defaultVal) {
            new BStandardDialog("", Translate.text("defaultOutOfRangeError"), BStandardDialog.ERROR).showMessageDialog(editor.getParentFrame());
            return this.edit(editor, theScene);
        }
        this.layout();
        return true;
    }

    public Module duplicate() {
        ParameterModule mod = new ParameterModule(new Point(this.bounds.x, this.bounds.y));
        mod.name = this.name;
        mod.minVal = this.minVal;
        mod.maxVal = this.maxVal;
        mod.defaultVal = this.defaultVal;
        mod.index = this.index;
        mod.id = this.id;
        mod.layout();
        return mod;
    }

    public void writeToStream(DataOutputStream out, Scene theScene) throws IOException {
        out.writeUTF(this.name);
        out.writeDouble(this.minVal);
        out.writeDouble(this.maxVal);
        out.writeDouble(this.defaultVal);
    }

    public void readFromStream(DataInputStream in, Scene theScene) throws IOException {
        this.name = in.readUTF();
        this.minVal = in.readDouble();
        this.maxVal = in.readDouble();
        this.defaultVal = in.readDouble();
        this.layout();
    }
}

