/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.procedural;

import artofillusion.math.Vec3;
import artofillusion.procedural.IOPort;
import artofillusion.procedural.Module;
import artofillusion.procedural.PointInfo;
import java.awt.Point;

public class MinModule
extends Module {
    double lastBlur;
    double value;
    double error;
    int which;
    boolean valueOk;

    public MinModule(Point position) {
        super("Min", new IOPort[]{new IOPort(0, 0, 0, new String[]{"Value 1", "(0)"}), new IOPort(0, 0, 1, new String[]{"Value 2", "(0)"})}, new IOPort[]{new IOPort(0, 1, 3, new String[]{"Minimum"})}, position);
    }

    public void init(PointInfo p) {
        this.valueOk = false;
    }

    public double getAverageValue(int which, double blur) {
        if (this.valueOk && blur == this.lastBlur) {
            return this.value;
        }
        this.valueOk = true;
        double value1 = this.linkFrom[0] == null ? 0.0 : this.linkFrom[0].getAverageValue(this.linkFromIndex[0], blur);
        double value2 = this.linkFrom[1] == null ? 0.0 : this.linkFrom[1].getAverageValue(this.linkFromIndex[1], blur);
        double error1 = this.linkFrom[0] == null ? 0.0 : this.linkFrom[0].getValueError(this.linkFromIndex[0], blur);
        double error2 = this.linkFrom[1] == null ? 0.0 : this.linkFrom[1].getValueError(this.linkFromIndex[1], blur);
        double min1 = value1 - error1;
        double max1 = value1 + error1;
        double min2 = value2 - error2;
        double max2 = value2 + error2;
        if (max1 < min2) {
            this.value = value1;
            this.error = error1;
            which = 0;
        } else if (max2 < min1) {
            this.value = value2;
            this.error = error2;
            which = 1;
        } else if (value1 < value2) {
            this.value = value1;
            double minmax = max1 < max2 ? max1 : max2;
            this.error = Math.abs(minmax - this.value);
            which = 0;
        } else {
            this.value = value2;
            double minmax = max1 < max2 ? max1 : max2;
            this.error = Math.abs(minmax - this.value);
            which = 1;
        }
        return this.value;
    }

    public double getValueError(int which, double blur) {
        if (!this.valueOk || blur != this.lastBlur) {
            this.getAverageValue(which, blur);
        }
        return this.error;
    }

    public void getValueGradient(int which, Vec3 grad, double blur) {
        if (!this.valueOk || blur != this.lastBlur) {
            this.getAverageValue(which, blur);
        }
        if (this.linkFrom[which] == null) {
            grad.set(0.0, 0.0, 0.0);
        } else {
            this.linkFrom[which].getValueGradient(this.linkFromIndex[which], grad, blur);
        }
    }
}

