/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.procedural;

import artofillusion.Scene;
import artofillusion.image.ImageMap;
import artofillusion.image.ImagesDialog;
import artofillusion.math.FastMath;
import artofillusion.math.RGBColor;
import artofillusion.math.Vec2;
import artofillusion.math.Vec3;
import artofillusion.procedural.IOPort;
import artofillusion.procedural.Module;
import artofillusion.procedural.PointInfo;
import artofillusion.procedural.ProcedureEditor;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.Translate;
import artofillusion.ui.ValueField;
import buoy.event.MouseClickedEvent;
import buoy.event.ValueChangedEvent;
import buoy.widget.BCheckBox;
import buoy.widget.BComboBox;
import buoy.widget.BLabel;
import buoy.widget.BOutline;
import buoy.widget.Widget;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;

public class ImageModule
extends Module {
    private ImageMap map;
    private boolean tilex = true;
    private boolean tiley = true;
    private boolean mirrorx;
    private boolean mirrory;
    private boolean wrapx;
    private boolean wrapy;
    private boolean pointOk;
    private boolean colorOk;
    private boolean[] valueOk;
    private boolean[] gradOk;
    private boolean outside;
    private double xscale = 1.0;
    private double yscale = 1.0;
    private double xinv = 1.0;
    private double yinv = 1.0;
    private double[] componentValue;
    private double x;
    private double y;
    private double xsize;
    private double ysize;
    private double lastBlur;
    private int maxComponent;
    private int colorModel = 0;
    private PointInfo point;
    private RGBColor color = new RGBColor(0.0f, 0.0f, 0.0f);
    private RGBColor tempColor = new RGBColor();
    private Vec2 tempGrad = new Vec2();
    private Vec3[] gradient = new Vec3[]{new Vec3(), new Vec3(), new Vec3(), new Vec3()};
    public static final int RGB_MODEL = 0;
    public static final int HSV_MODEL = 1;
    public static final int HLS_MODEL = 2;

    public ImageModule(Point position) {
        super("(" + Translate.text("menu.imageModule") + ")", new IOPort[]{new IOPort(0, 0, 2, new String[]{"X", "(X)"}), new IOPort(0, 0, 2, new String[]{"Y", "(Y)"})}, new IOPort[]{new IOPort(1, 1, 3, new String[]{Translate.text("Color")}), new IOPort(0, 1, 3, new String[]{Translate.text("Red")}), new IOPort(0, 1, 3, new String[]{Translate.text("Green")}), new IOPort(0, 1, 3, new String[]{Translate.text("Blue")}), new IOPort(0, 1, 3, new String[]{Translate.text("Mask")})}, position);
        this.componentValue = new double[4];
        this.valueOk = new boolean[4];
        this.gradOk = new boolean[4];
    }

    public ImageMap getMap() {
        return this.map;
    }

    public void setMap(ImageMap map) {
        this.map = map;
        this.maxComponent = map == null ? 0 : map.getComponentCount() - 1;
    }

    public double getXScale() {
        return this.xscale;
    }

    public void setXScale(double scale) {
        this.xscale = scale;
        this.xinv = 1.0 / scale;
    }

    public double getYScale() {
        return this.yscale;
    }

    public void setYScale(double scale) {
        this.yscale = scale;
        this.yinv = 1.0 / scale;
    }

    public boolean getTileX() {
        return this.tilex;
    }

    public void setTileX(boolean b) {
        this.tilex = b;
    }

    public boolean getTileY() {
        return this.tiley;
    }

    public void setTileY(boolean b) {
        this.tiley = b;
    }

    public boolean getMirrorX() {
        return this.mirrorx;
    }

    public void setMirrorX(boolean b) {
        this.mirrorx = b;
    }

    public boolean getMirrorY() {
        return this.mirrory;
    }

    public void setMirrorY(boolean b) {
        this.mirrory = b;
    }

    public int getColorModel() {
        return this.colorModel;
    }

    public void setColorModel(int model) {
        this.colorModel = model;
    }

    public void init(PointInfo p) {
        this.point = p;
        this.colorOk = false;
        this.pointOk = false;
        this.valueOk[3] = false;
        this.valueOk[2] = false;
        this.valueOk[1] = false;
        this.valueOk[0] = false;
        this.gradOk[3] = false;
        this.gradOk[2] = false;
        this.gradOk[1] = false;
        this.gradOk[0] = false;
    }

    private void findPoint(double blur) {
        double f;
        this.pointOk = true;
        this.valueOk[3] = false;
        this.valueOk[2] = false;
        this.valueOk[1] = false;
        this.valueOk[0] = false;
        this.colorOk = false;
        this.x = this.linkFrom[0] == null ? this.point.x : this.linkFrom[0].getAverageValue(this.linkFromIndex[0], blur);
        this.y = this.linkFrom[1] == null ? this.point.y : this.linkFrom[1].getAverageValue(this.linkFromIndex[1], blur);
        this.x *= this.xinv;
        this.y *= this.yinv;
        boolean bl = this.outside = !this.tilex && (this.x < 0.0 || this.x > 1.0) || !this.tiley && (this.y < 0.0 || this.y > 1.0);
        if (this.outside) {
            return;
        }
        this.x = this.mirrorx ? (((int)(f = (double)FastMath.floor(this.x)) & 1) == 0 ? 1.0 + f - this.x : (this.x -= f)) : (this.x -= (double)FastMath.floor(this.x));
        this.y = this.mirrory ? (((int)(f = (double)FastMath.floor(this.y)) & 1) == 0 ? 1.0 + f - this.y : (this.y -= f)) : (this.y -= (double)FastMath.floor(this.y));
        this.xsize = this.linkFrom[0] == null ? 0.5 * this.point.xsize + blur : this.linkFrom[0].getValueError(this.linkFromIndex[0], blur);
        this.ysize = this.linkFrom[1] == null ? 0.5 * this.point.ysize + blur : this.linkFrom[1].getValueError(this.linkFromIndex[1], blur);
        this.xsize *= this.xinv;
        this.ysize *= this.yinv;
        this.wrapx = this.tilex && !this.mirrorx;
        this.wrapy = this.tiley && !this.mirrory;
    }

    public void getColor(int which, RGBColor c, double blur) {
        if (this.colorOk && blur == this.lastBlur) {
            c.copy(this.color);
            return;
        }
        if (this.map == null) {
            this.color.setRGB(0.0f, 0.0f, 0.0f);
            c.copy(this.color);
            return;
        }
        if (!this.pointOk || blur != this.lastBlur) {
            this.findPoint(blur);
        }
        this.colorOk = true;
        this.lastBlur = blur;
        if (this.outside) {
            this.color.setRGB(0.0f, 0.0f, 0.0f);
            c.copy(this.color);
            return;
        }
        this.map.getColor(this.color, this.wrapx, this.wrapy, this.x, this.y, this.xsize, this.ysize);
        c.copy(this.color);
    }

    public double getAverageValue(int which, double blur) {
        int component = which - 1;
        if (component > this.maxComponent) {
            if (component == 3) {
                return 0.0;
            }
            component = 0;
        }
        if (this.valueOk[component] && blur == this.lastBlur) {
            return this.componentValue[component];
        }
        if (this.map == null) {
            return 0.0;
        }
        if (!this.pointOk || blur != this.lastBlur) {
            this.findPoint(blur);
        }
        if (this.outside) {
            return 0.0;
        }
        if (this.colorModel == 0 || component == 3) {
            this.valueOk[component] = true;
            this.componentValue[component] = this.map.getComponent(component, this.wrapx, this.wrapy, this.x, this.y, this.xsize, this.ysize);
        } else {
            this.colorOk = true;
            this.valueOk[2] = true;
            this.valueOk[1] = true;
            this.valueOk[0] = true;
            this.lastBlur = blur;
            this.map.getColor(this.color, this.wrapx, this.wrapy, this.x, this.y, this.xsize, this.ysize);
            float[] components = this.colorModel == 1 ? this.color.getHSV() : this.color.getHLS();
            this.componentValue[0] = (double)components[0] / 360.0;
            this.componentValue[1] = components[1];
            this.componentValue[2] = components[2];
        }
        return this.componentValue[component];
    }

    public void getValueGradient(int which, Vec3 grad, double blur) {
        int component = which - 1;
        if (component > this.maxComponent) {
            if (component == 3) {
                grad.set(0.0, 0.0, 0.0);
                return;
            }
            component = 0;
        }
        if (this.gradOk[component] && blur == this.lastBlur) {
            grad.set(this.gradient[component]);
            return;
        }
        if (this.map == null) {
            grad.set(0.0, 0.0, 0.0);
            return;
        }
        if (!this.pointOk || blur != this.lastBlur) {
            this.findPoint(blur);
        }
        if (this.outside) {
            grad.set(0.0, 0.0, 0.0);
            return;
        }
        if (this.colorModel == 0 || component == 3) {
            this.map.getGradient(this.tempGrad, component, this.wrapx, this.wrapy, this.x, this.y, this.xsize, this.ysize);
        } else {
            float[] components;
            double value = this.getAverageValue(which, blur);
            if (this.x >= 1.0) {
                this.tempGrad.x = 0.0;
            } else {
                double dx = this.xsize;
                if (this.x + dx > 1.0) {
                    dx = 1.0 - this.x;
                }
                this.map.getColor(this.tempColor, this.wrapx, this.wrapy, this.x + dx, this.y, this.xsize, this.ysize);
                components = this.colorModel == 1 ? this.tempColor.getHSV() : this.tempColor.getHLS();
                components[0] = (float)((double)components[0] / 360.0);
                this.tempGrad.x = ((double)components[component] - value) / dx;
            }
            if (this.y >= 1.0) {
                this.tempGrad.y = 0.0;
            } else {
                double dy = this.ysize;
                if (this.y + dy > 1.0) {
                    dy = 1.0 - this.y;
                }
                this.map.getColor(this.tempColor, this.wrapx, this.wrapy, this.x, this.y + dy, this.xsize, this.ysize);
                components = this.colorModel == 1 ? this.tempColor.getHSV() : this.tempColor.getHLS();
                components[0] = (float)((double)components[0] / 360.0);
                this.tempGrad.y = -((double)components[component] - value) / dy;
            }
        }
        this.calcGradient(component, grad, blur);
        grad.set(this.gradient[component]);
    }

    private void calcGradient(int component, Vec3 grad, double blur) {
        double dx = this.tempGrad.x * this.xinv;
        double dy = this.tempGrad.y * this.yinv;
        Vec3 g = this.gradient[component];
        if (dx != 0.0) {
            if (this.linkFrom[0] == null) {
                g.set(dx, 0.0, 0.0);
            } else {
                this.linkFrom[0].getValueGradient(this.linkFromIndex[0], grad, blur);
                g.x = dx * grad.x;
                g.y = dx * grad.y;
                g.z = dx * grad.z;
            }
        } else {
            g.set(0.0, 0.0, 0.0);
        }
        if (dy != 0.0) {
            if (this.linkFrom[1] == null) {
                g.y += dy;
            } else {
                this.linkFrom[1].getValueGradient(this.linkFromIndex[1], grad, blur);
                g.x += dy * grad.x;
                g.y += dy * grad.y;
                g.z += dy * grad.z;
            }
        }
        this.gradOk[component] = true;
    }

    public void calcSize() {
        this.bounds.width = 60;
        this.bounds.height = 60;
        if (this.output.length * 5 * 3 > this.bounds.height) {
            this.bounds.height = this.output.length * 5 * 3;
        }
    }

    protected void drawContents(Graphics2D g) {
        if (this.map == null) {
            super.drawContents(g);
            return;
        }
        g.drawImage(this.map.getPreview(), this.bounds.x + this.bounds.width / 2 - 25, this.bounds.y + this.bounds.height / 2 - 25, null);
    }

    public Module duplicate() {
        ImageModule mod = new ImageModule(new Point(this.bounds.x, this.bounds.y));
        mod.map = this.map;
        mod.xscale = this.xscale;
        mod.yscale = this.yscale;
        mod.xinv = this.xinv;
        mod.yinv = this.yinv;
        mod.color.copy(this.color);
        mod.tilex = this.tilex;
        mod.tiley = this.tiley;
        mod.mirrorx = this.mirrorx;
        mod.mirrory = this.mirrory;
        mod.wrapx = this.wrapx;
        mod.wrapy = this.wrapy;
        mod.maxComponent = this.maxComponent;
        mod.colorModel = this.colorModel;
        return mod;
    }

    private void setupOutputs() {
        if (this.colorModel == 0) {
            this.output[1].setDescription(new String[]{Translate.text("Red")});
            this.output[2].setDescription(new String[]{Translate.text("Green")});
            this.output[3].setDescription(new String[]{Translate.text("Blue")});
        } else if (this.colorModel == 1) {
            this.output[1].setDescription(new String[]{Translate.text("Hue")});
            this.output[2].setDescription(new String[]{Translate.text("Saturation")});
            this.output[3].setDescription(new String[]{Translate.text("Value")});
        } else if (this.colorModel == 2) {
            this.output[1].setDescription(new String[]{Translate.text("Hue")});
            this.output[2].setDescription(new String[]{Translate.text("Lightness")});
            this.output[3].setDescription(new String[]{Translate.text("Saturation")});
        }
    }

    public boolean edit(final ProcedureEditor editor, final Scene theScene) {
        ImageMap oldMap = this.map;
        final ValueField xField = new ValueField(this.xscale, 0, 10);
        final ValueField yField = new ValueField(this.yscale, 0, 10);
        final BCheckBox tilexBox = new BCheckBox("X", this.tilex);
        final BCheckBox tileyBox = new BCheckBox("Y", this.tiley);
        final BCheckBox mirrorxBox = new BCheckBox("X", this.mirrorx);
        final BCheckBox mirroryBox = new BCheckBox("Y", this.mirrory);
        final BComboBox modelChoice = new BComboBox(new String[]{"RGB", "HSV", "HLS"});
        Object listener = new Object(){

            void processEvent() {
                ImageModule.this.xscale = xField.getValue();
                ImageModule.this.yscale = yField.getValue();
                ImageModule.this.xinv = 1.0 / ImageModule.this.xscale;
                ImageModule.this.yinv = 1.0 / ImageModule.this.yscale;
                ImageModule.this.tilex = tilexBox.getState();
                ImageModule.this.tiley = tileyBox.getState();
                ImageModule.this.mirrorx = mirrorxBox.getState();
                ImageModule.this.mirrory = mirroryBox.getState();
                ImageModule.this.colorModel = modelChoice.getSelectedIndex();
                if (ImageModule.this.map == null) {
                    ImageModule.this.maxComponent = 0;
                } else if (ImageModule.this.colorModel == 0) {
                    ImageModule.this.maxComponent = ImageModule.this.map.getComponentCount() - 1;
                } else if (ImageModule.this.map.getComponentCount() > 3) {
                    ImageModule.this.maxComponent = 3;
                } else {
                    ImageModule.this.maxComponent = 2;
                }
                editor.updatePreview();
            }
        };
        xField.addEventLink(ValueChangedEvent.class, listener);
        yField.addEventLink(ValueChangedEvent.class, listener);
        tilexBox.addEventLink(ValueChangedEvent.class, listener);
        tileyBox.addEventLink(ValueChangedEvent.class, listener);
        mirrorxBox.addEventLink(ValueChangedEvent.class, listener);
        mirroryBox.addEventLink(ValueChangedEvent.class, listener);
        modelChoice.addEventLink(ValueChangedEvent.class, listener);
        modelChoice.setSelectedIndex(this.colorModel);
        final BLabel preview = new BLabel(){

            public Dimension getPreferredSize() {
                return new Dimension(50, 50);
            }
        };
        if (this.map != null) {
            preview.setIcon(new ImageIcon(this.map.getPreview()));
        }
        preview.setAlignment(BLabel.CENTER);
        BOutline outline = new BOutline(preview, BorderFactory.createLineBorder(Color.black)){

            public Dimension getMaximumSize() {
                return new Dimension(52, 52);
            }
        };
        preview.addEventLink(MouseClickedEvent.class, new Object(){

            void processEvent() {
                ImagesDialog dlg = new ImagesDialog(editor.getParentFrame(), theScene, ImageModule.this.map);
                if (dlg.getSelection() != ImageModule.this.map && dlg.getSelection() != null) {
                    int h;
                    int w = dlg.getSelection().getWidth();
                    if (w > (h = dlg.getSelection().getHeight())) {
                        xField.setValue(1.0);
                        yField.setValue((double)h / (double)w);
                    } else {
                        xField.setValue((double)w / (double)h);
                        yField.setValue(1.0);
                    }
                }
                ImageModule.this.map = dlg.getSelection();
                if (ImageModule.this.map == null) {
                    ImageModule.this.maxComponent = 0;
                } else if (ImageModule.this.colorModel == 0) {
                    ImageModule.this.maxComponent = ImageModule.this.map.getComponentCount() - 1;
                } else if (ImageModule.this.map.getComponentCount() > 3) {
                    ImageModule.this.maxComponent = 3;
                } else {
                    ImageModule.this.maxComponent = 2;
                }
                preview.setIcon(ImageModule.this.map == null ? null : new ImageIcon(ImageModule.this.map.getPreview()));
                editor.updatePreview();
            }
        });
        ComponentsDialog dlg = new ComponentsDialog(editor.getParentFrame(), "Click to Set Image:", new Widget[]{outline, xField, yField, tilexBox, tileyBox, mirrorxBox, mirroryBox, modelChoice}, new String[]{null, "X Size", "Y Size", "Tile", "", "Mirror", "", "Outputs"});
        if (!dlg.clickedOk()) {
            return false;
        }
        this.setupOutputs();
        return true;
    }

    public void writeToStream(DataOutputStream out, Scene theScene) throws IOException {
        out.writeInt(-2);
        if (this.map == null) {
            out.writeInt(-1);
        } else {
            out.writeInt(theScene.indexOf(this.map));
        }
        out.writeDouble(this.xscale);
        out.writeDouble(this.yscale);
        out.writeBoolean(this.tilex);
        out.writeBoolean(this.tiley);
        out.writeBoolean(this.mirrorx);
        out.writeBoolean(this.mirrory);
        out.writeInt(this.colorModel);
    }

    public void readFromStream(DataInputStream in, Scene theScene) throws IOException {
        int version = in.readInt();
        if (version < -2) {
            throw new InvalidObjectException("");
        }
        int index = version > -2 ? version : in.readInt();
        this.map = index > -1 ? theScene.getImage(index) : null;
        this.xscale = in.readDouble();
        this.yscale = in.readDouble();
        this.xinv = 1.0 / this.xscale;
        this.yinv = 1.0 / this.yscale;
        this.tilex = in.readBoolean();
        this.tiley = in.readBoolean();
        this.mirrorx = in.readBoolean();
        this.mirrory = in.readBoolean();
        int n = this.colorModel = version == -2 ? in.readInt() : 0;
        this.maxComponent = this.map == null ? 0 : (this.colorModel == 0 ? this.map.getComponentCount() - 1 : (this.map.getComponentCount() > 3 ? 3 : 2));
        this.setupOutputs();
    }
}

