/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.procedural;

import artofillusion.Scene;
import artofillusion.procedural.IOPort;
import artofillusion.procedural.Module;
import artofillusion.procedural.ProcedureEditor;
import artofillusion.ui.PanelDialog;
import artofillusion.ui.Translate;
import buoy.widget.BOutline;
import buoy.widget.BScrollPane;
import buoy.widget.BTextArea;
import buoy.widget.WindowWidget;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class CommentModule
extends Module {
    public CommentModule(Point position) {
        this(position, "Double-click to set comment");
    }

    public CommentModule(Point position, String text) {
        super(text, new IOPort[0], new IOPort[0], position);
    }

    public boolean edit(ProcedureEditor editor, Scene theScene) {
        BTextArea ta = new BTextArea(this.name, 10, 40);
        PanelDialog dlg = new PanelDialog((WindowWidget)editor.getParentFrame(), Translate.text("editComment"), BOutline.createBevelBorder(new BScrollPane(ta), false));
        if (!dlg.clickedOk()) {
            return false;
        }
        this.name = ta.getText();
        this.layout();
        return true;
    }

    public Module duplicate() {
        CommentModule mod = new CommentModule(new Point(this.bounds.x, this.bounds.y), this.name);
        return mod;
    }

    public void writeToStream(DataOutputStream out, Scene theScene) throws IOException {
        out.writeUTF(this.name);
    }

    public void readFromStream(DataInputStream in, Scene theScene) throws IOException {
        this.name = in.readUTF();
        this.layout();
    }

    public void calcSize() {
        String[] lines = this.name.split("\n");
        this.bounds.width = 0;
        for (int i = 0; i < lines.length; ++i) {
            int len = defaultMetrics.stringWidth(lines[i]);
            if (len <= this.bounds.width) continue;
            this.bounds.width = len;
        }
        this.bounds.width += 20;
        this.bounds.height = lines.length * (defaultMetrics.getMaxAscent() + defaultMetrics.getMaxDescent()) + 20;
    }

    protected void drawContents(Graphics2D g) {
        g.setColor(Color.black);
        g.setFont(defaultFont);
        int lineHeight = defaultMetrics.getMaxAscent() + defaultMetrics.getMaxDescent();
        int offset = defaultMetrics.getAscent();
        String[] lines = this.name.split("\n");
        for (int i = 0; i < lines.length; ++i) {
            g.drawString(lines[i], this.bounds.x + 10, this.bounds.y + 10 + offset + i * lineHeight);
        }
    }
}

