/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.procedural;

import artofillusion.Scene;
import artofillusion.math.RGBColor;
import artofillusion.procedural.IOPort;
import artofillusion.procedural.Module;
import artofillusion.procedural.ProcedureEditor;
import artofillusion.ui.ColorChooser;
import buoy.event.ValueChangedEvent;
import java.awt.Graphics2D;
import java.awt.Point;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ColorModule
extends Module {
    RGBColor color;

    public ColorModule(Point position) {
        this(position, new RGBColor(1.0f, 1.0f, 1.0f));
    }

    public ColorModule(Point position, RGBColor color) {
        super("", new IOPort[0], new IOPort[]{new IOPort(1, 1, 3, new String[]{"Color"})}, position);
        this.color = color;
    }

    public RGBColor getColor() {
        return this.color;
    }

    public void setColor(RGBColor c) {
        this.color = c;
    }

    public boolean edit(final ProcedureEditor editor, Scene theScene) {
        final ColorChooser cc = new ColorChooser(editor.getParentFrame(), "Select Color", this.color, false);
        cc.addEventLink(ValueChangedEvent.class, new Object(){

            void processEvent() {
                ColorModule.this.color.copy(cc.getColor());
                editor.updatePreview();
            }
        });
        cc.setVisible(true);
        return cc.clickedOk();
    }

    public void getColor(int which, RGBColor c, double blur) {
        c.copy(this.color);
    }

    public void calcSize() {
        this.bounds.height = 30;
        this.bounds.width = 30;
    }

    protected void drawContents(Graphics2D g) {
        g.setColor(this.color.getColor());
        g.fillRect(this.bounds.x + 5, this.bounds.y + 5, 20, 20);
    }

    public Module duplicate() {
        ColorModule mod = new ColorModule(new Point(this.bounds.x, this.bounds.y));
        mod.color.copy(this.color);
        return mod;
    }

    public void writeToStream(DataOutputStream out, Scene theScene) throws IOException {
        this.color.writeToFile(out);
    }

    public void readFromStream(DataInputStream in, Scene theScene) throws IOException {
        this.color = new RGBColor(in);
    }
}

