/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.procedural;

import artofillusion.Scene;
import artofillusion.math.Cells;
import artofillusion.math.FastRandom;
import artofillusion.math.Vec3;
import artofillusion.procedural.IOPort;
import artofillusion.procedural.Module;
import artofillusion.procedural.PointInfo;
import artofillusion.procedural.ProcedureEditor;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.Translate;
import buoy.event.SelectionChangedEvent;
import buoy.widget.BRadioButton;
import buoy.widget.RadioButtonGroup;
import buoy.widget.Widget;
import java.awt.Point;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Random;

public class CellsModule
extends Module {
    private boolean[] valueOk;
    private boolean[] gradOk;
    private boolean used2ThisTime;
    private boolean used2LastTime;
    private double[] value;
    private double[] value1;
    private double error;
    private double cell;
    private double lastBlur;
    private Vec3[] gradient = new Vec3[]{new Vec3(), new Vec3()};
    private Vec3[] gradient1 = new Vec3[]{this.gradient[0]};
    private Vec3 tempVec;
    private int[] id;
    private int[] id1;
    private PointInfo point;
    private Cells cells;
    private Random random;

    public CellsModule(Point position) {
        super(Translate.text("menu.cellsModule"), new IOPort[]{new IOPort(0, 0, 2, new String[]{"X", "(X)"}), new IOPort(0, 0, 2, new String[]{"Y", "(Y)"}), new IOPort(0, 0, 2, new String[]{"Z", "(Z)"})}, new IOPort[]{new IOPort(0, 1, 3, new String[]{"Cell"}), new IOPort(0, 1, 3, new String[]{"Distance 1"}), new IOPort(0, 1, 3, new String[]{"Distance 2"})}, position);
        this.value = new double[2];
        this.value1 = new double[1];
        this.id = new int[2];
        this.id1 = new int[1];
        this.valueOk = new boolean[3];
        this.gradOk = new boolean[3];
        this.tempVec = new Vec3();
        this.cells = new Cells();
        this.random = new FastRandom(0L);
    }

    public int getMetric() {
        return this.cells.getMetric();
    }

    public void setMetric(int m) {
        this.cells.setMetric(m);
    }

    public void init(PointInfo p) {
        if (this.valueOk[0]) {
            this.used2LastTime = this.used2ThisTime;
        }
        this.point = p;
        this.gradOk[2] = false;
        this.gradOk[1] = false;
        this.valueOk[2] = false;
        this.valueOk[1] = false;
        this.valueOk[0] = false;
        this.used2ThisTime = false;
    }

    private void calcValues(int which, double blur) {
        double xsize = this.linkFrom[0] == null ? 0.5 * this.point.xsize + blur : this.linkFrom[0].getValueError(this.linkFromIndex[0], blur);
        double ysize = this.linkFrom[1] == null ? 0.5 * this.point.ysize + blur : this.linkFrom[1].getValueError(this.linkFromIndex[1], blur);
        double zsize = this.linkFrom[2] == null ? 0.5 * this.point.zsize + blur : this.linkFrom[2].getValueError(this.linkFromIndex[2], blur);
        this.tempVec.x = this.linkFrom[0] == null ? this.point.x : this.linkFrom[0].getAverageValue(this.linkFromIndex[0], blur);
        this.tempVec.y = this.linkFrom[1] == null ? this.point.y : this.linkFrom[1].getAverageValue(this.linkFromIndex[1], blur);
        double d = this.tempVec.z = this.linkFrom[2] == null ? this.point.z : this.linkFrom[2].getAverageValue(this.linkFromIndex[2], blur);
        if (which == 0 || which == 2 || this.used2LastTime) {
            this.cells.calcFunctions(this.tempVec, this.value, this.gradient, this.id);
            this.valueOk[2] = true;
            this.valueOk[1] = true;
            this.valueOk[0] = true;
        } else {
            this.cells.calcFunctions(this.tempVec, this.value1, this.gradient1, this.id1);
            this.value[0] = this.value1[0];
            this.id[0] = this.id1[0];
            this.gradient[0].set(this.gradient1[0]);
            this.valueOk[1] = true;
        }
        this.gradOk[2] = false;
        this.gradOk[1] = false;
        this.error = Math.max(Math.max(xsize, ysize), zsize);
        this.random.setSeed(this.id[0]);
        this.random.nextDouble();
        this.cell = this.random.nextDouble();
        this.lastBlur = blur;
        if (which == 0 || which == 2) {
            this.used2ThisTime = true;
        }
    }

    public double getAverageValue(int which, double blur) {
        if (!this.valueOk[which] || blur != this.lastBlur) {
            this.calcValues(which, blur);
        }
        if (which > 0) {
            return this.value[which - 1];
        }
        double diff = this.value[1] - this.value[0];
        if (diff >= this.error) {
            return this.cell;
        }
        this.random.setSeed(this.id[1]);
        this.random.nextDouble();
        double cell2 = this.random.nextDouble();
        double weight = 0.5 + 0.5 * diff / this.error;
        return weight * this.cell + (1.0 - weight) * cell2;
    }

    public double getValueError(int which, double blur) {
        if (!this.valueOk[which] || blur != this.lastBlur) {
            this.calcValues(which, blur);
        }
        if (which == 0) {
            double diff = this.value[1] - this.value[0];
            if (diff >= this.error) {
                return 0.0;
            }
            this.random.setSeed(this.id[1]);
            this.random.nextDouble();
            double cell2 = this.random.nextDouble();
            return 0.5 * Math.abs(this.cell - cell2);
        }
        return this.error;
    }

    public void getValueGradient(int which, Vec3 grad, double blur) {
        if (which == 0) {
            grad.set(0.0, 0.0, 0.0);
            return;
        }
        if (!this.valueOk[which] || blur != this.lastBlur) {
            this.calcValues(which, blur);
        }
        if (this.gradOk[which]) {
            grad.set(this.gradient[which - 1]);
            return;
        }
        Vec3 g = this.gradient[which - 1];
        double dx = g.x;
        double dy = g.y;
        double dz = g.z;
        if (dx != 0.0) {
            if (this.linkFrom[0] == null) {
                g.set(dx, 0.0, 0.0);
            } else {
                this.linkFrom[0].getValueGradient(this.linkFromIndex[0], grad, blur);
                g.x = dx * grad.x;
                g.y = dx * grad.y;
                g.z = dx * grad.z;
            }
        } else {
            g.set(0.0, 0.0, 0.0);
        }
        if (dy != 0.0) {
            if (this.linkFrom[1] == null) {
                g.y += dy;
            } else {
                this.linkFrom[1].getValueGradient(this.linkFromIndex[1], grad, blur);
                g.x += dy * grad.x;
                g.y += dy * grad.y;
                g.z += dy * grad.z;
            }
        }
        if (dz != 0.0) {
            if (this.linkFrom[2] == null) {
                g.z += dz;
            } else {
                this.linkFrom[2].getValueGradient(this.linkFromIndex[2], grad, blur);
                g.x += dz * grad.x;
                g.y += dz * grad.y;
                g.z += dz * grad.z;
            }
        }
        this.gradOk[which] = true;
        grad.set(g);
    }

    public boolean edit(final ProcedureEditor editor, Scene theScene) {
        final RadioButtonGroup metricGroup = new RadioButtonGroup();
        int metric = this.cells.getMetric();
        final BRadioButton euclidBox = new BRadioButton("Euclidean", metric == 0, metricGroup);
        final BRadioButton cityBox = new BRadioButton("City Block", metric == 1, metricGroup);
        final BRadioButton chessBox = new BRadioButton("Chess Board", metric == 2, metricGroup);
        metricGroup.addEventLink(SelectionChangedEvent.class, new Object(){

            void processEvent() {
                if (metricGroup.getSelection() == euclidBox) {
                    CellsModule.this.cells.setMetric(0);
                } else if (metricGroup.getSelection() == cityBox) {
                    CellsModule.this.cells.setMetric(1);
                } else if (metricGroup.getSelection() == chessBox) {
                    CellsModule.this.cells.setMetric(2);
                }
                editor.updatePreview();
            }
        });
        ComponentsDialog dlg = new ComponentsDialog(editor.getParentFrame(), "Select which distance metric to use:", new Widget[]{euclidBox, cityBox, chessBox}, new String[]{"", "", ""});
        if (!dlg.clickedOk()) {
            return false;
        }
        if (metricGroup.getSelection() == euclidBox) {
            this.cells.setMetric(0);
        } else if (metricGroup.getSelection() == cityBox) {
            this.cells.setMetric(1);
        } else if (metricGroup.getSelection() == chessBox) {
            this.cells.setMetric(2);
        }
        return true;
    }

    public Module duplicate() {
        CellsModule module = new CellsModule(new Point(this.bounds.x, this.bounds.y));
        module.setMetric(this.cells.getMetric());
        return module;
    }

    public void writeToStream(DataOutputStream out, Scene theScene) throws IOException {
        out.writeInt(this.cells.getMetric());
    }

    public void readFromStream(DataInputStream in, Scene theScene) throws IOException {
        this.cells.setMetric(in.readInt());
    }
}

