/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.math;

public class FastMath {
    public static int floor(double d) {
        if (d < 0.0) {
            int f = (int)d;
            if ((double)f != d) {
                --f;
            }
            return f;
        }
        return (int)d;
    }

    public static int ceil(double d) {
        if (d > 0.0) {
            int f = (int)d;
            if ((double)f != d) {
                ++f;
            }
            return f;
        }
        return (int)d;
    }

    public static int round(double d) {
        return FastMath.floor(d + 0.5);
    }

    public static double pow(double base, int exponent) {
        if (exponent < 0) {
            exponent = -exponent;
            base = 1.0 / base;
        }
        double result = 1.0;
        while (exponent != 0) {
            if ((exponent & 1) == 1) {
                result *= base;
            }
            base *= base;
            exponent >>= 1;
        }
        return result;
    }

    public static double atan(double d) {
        if (d >= 1.0) {
            return 1.5707963267948966 - d / (d * d + 0.28);
        }
        if (d <= -1.0) {
            return -1.5707963267948966 - d / (d * d + 0.28);
        }
        return d / (1.0 + 0.28 * d * d);
    }
}

