/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.animation.distortion;

import artofillusion.MeshEditorWindow;
import artofillusion.MeshViewer;
import artofillusion.MoveViewTool;
import artofillusion.RotateViewTool;
import artofillusion.UndoRecord;
import artofillusion.ViewerCanvas;
import artofillusion.animation.Actor;
import artofillusion.animation.ActorEditorWindow;
import artofillusion.animation.Gesture;
import artofillusion.animation.Joint;
import artofillusion.animation.Skeleton;
import artofillusion.animation.SkeletonTool;
import artofillusion.animation.Smoothness;
import artofillusion.animation.Timecourse;
import artofillusion.animation.distortion.SkeletonShapeKeyframe;
import artofillusion.animation.distortion.SkeletonShapeTrack;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.Vec3;
import artofillusion.object.Mesh;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectInfo;
import artofillusion.object.ObjectWrapper;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.MeshEditController;
import artofillusion.ui.ToolPalette;
import artofillusion.ui.Translate;
import artofillusion.ui.UIUtilities;
import artofillusion.ui.ValueField;
import artofillusion.ui.ValueSlider;
import buoy.event.ValueChangedEvent;
import buoy.widget.BCheckBox;
import buoy.widget.BLabel;
import buoy.widget.BMenu;
import buoy.widget.BMenuItem;
import buoy.widget.FormContainer;
import buoy.widget.LayoutInfo;
import buoy.widget.RowContainer;
import buoy.widget.Widget;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;

public class SkeletonShapeEditorWindow
extends MeshEditorWindow
implements MeshEditController {
    private SkeletonShapeTrack track;
    private SkeletonShapeKeyframe keyframe;
    private int keyIndex;
    private double keyTime;
    private Smoothness keySmoothness;
    private BMenu editMenu;
    private BMenu skeletonMenu;
    private BMenuItem[] skeletonMenuItem;
    private boolean[] selected;
    private Runnable onClose;

    public SkeletonShapeEditorWindow(EditingWindow parent, String title, SkeletonShapeTrack track, int keyIndex, Runnable onClose) {
        super(parent, title, new ObjectInfo((Object3D)((Object)SkeletonShapeEditorWindow.getEditMesh(((ObjectInfo)track.getParent()).getObject())), new CoordinateSystem(), ""));
        this.track = track;
        this.keyIndex = keyIndex;
        this.onClose = onClose;
        Timecourse tc = track.getTimecourse();
        this.keyframe = (SkeletonShapeKeyframe)tc.getValues()[keyIndex];
        this.keySmoothness = tc.getSmoothness()[keyIndex].duplicate();
        this.keyTime = tc.getTimes()[keyIndex];
        ObjectInfo obj = (ObjectInfo)track.getParent();
        this.selected = new boolean[this.oldMesh.getVertices().length];
        FormContainer content = new FormContainer(new double[]{0.0, 1.0}, new double[]{1.0, 0.0, 0.0});
        this.setContent(content);
        content.setDefaultLayout(new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.BOTH, null, null));
        this.helpText = new BLabel();
        content.add(this.helpText, 0, 1, 2, 1);
        content.add(this.viewsContainer, 1, 0);
        RowContainer buttons = new RowContainer();
        buttons.add(Translate.button("ok", this, "doOk"));
        buttons.add(Translate.button("cancel", this, "doCancel"));
        content.add(buttons, 0, 2, 2, 1, new LayoutInfo());
        this.tools = new ToolPalette(1, 3);
        content.add(this.tools, 0, 0, new LayoutInfo(LayoutInfo.NORTH, LayoutInfo.NONE, null, null));
        this.defaultTool = new SkeletonTool(this, false){

            protected void adjustMesh(Mesh newMesh) {
                SkeletonShapeEditorWindow.this.adjustMeshForSkeleton();
            }
        };
        this.tools.addTool(this.defaultTool);
        MoveViewTool metaTool = new MoveViewTool(this);
        this.tools.addTool(metaTool);
        RotateViewTool altTool = new RotateViewTool(this);
        this.tools.addTool(altTool);
        this.tools.selectTool(this.defaultTool);
        for (int i = 0; i < this.theView.length; ++i) {
            MeshViewer view = (MeshViewer)this.theView[i];
            view.setMetaTool(metaTool);
            view.setAltTool(altTool);
            view.setScene(parent.getScene(), obj);
        }
        this.createEditMenu();
        this.createSkeletonMenu();
        this.createViewMenu();
        this.recursivelyAddListeners(this);
        UIUtilities.applyDefaultFont(content);
        UIUtilities.applyDefaultBackground(content);
        Rectangle screenBounds = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
        Dimension windowDim = new Dimension(screenBounds.width * 3 / 4, screenBounds.height * 3 / 4);
        this.setBounds(new Rectangle((screenBounds.width - windowDim.width) / 2, (screenBounds.height - windowDim.height) / 2, windowDim.width, windowDim.height));
        this.tools.requestFocus();
        this.updateMenus();
        this.objInfo.getObject().getSkeleton().copy(this.keyframe.getSkeleton());
        this.adjustMeshForSkeleton();
    }

    private static Mesh getEditMesh(Object3D object) {
        while (object instanceof ObjectWrapper) {
            object = ((ObjectWrapper)object).getWrappedObject();
        }
        if (object instanceof Mesh) {
            return (Mesh)((Object)object);
        }
        return object.convertToTriangleMesh(Double.MAX_VALUE);
    }

    void createEditMenu() {
        this.editMenu = Translate.menu("edit");
        this.menubar.add(this.editMenu);
        this.undoItem = Translate.menuItem("undo", this, "undoCommand");
        this.editMenu.add(this.undoItem);
        this.redoItem = Translate.menuItem("redo", this, "redoCommand");
        this.editMenu.add(this.redoItem);
        this.editMenu.addSeparator();
        this.editMenu.add(Translate.menuItem("properties", this, "editProperties"));
    }

    void createSkeletonMenu() {
        this.skeletonMenu = Translate.menu("skeleton");
        this.menubar.add(this.skeletonMenu);
        this.skeletonMenuItem = new BMenuItem[1];
        this.skeletonMenuItem[0] = Translate.menuItem("editBone", this, "editJointCommand");
        this.skeletonMenu.add(this.skeletonMenuItem[0]);
        this.skeletonMenu.add(Translate.menuItem("resetToDefaultPose", this, "resetCommand"));
        BMenuItem item = Translate.menuItem("createPoseFromGestures", this, "createFromGesturesCommand");
        this.skeletonMenu.add(item);
        Object3D obj = ((ObjectInfo)this.track.getParent()).getObject();
        item.setEnabled(Actor.getActor(obj) != null);
    }

    public void updateMenus() {
        super.updateMenus();
        MeshViewer view = (MeshViewer)this.theView[this.currentView];
        Skeleton s = this.keyframe.getSkeleton();
        Joint selJoint = s.getJoint(view.getSelectedJoint());
        this.skeletonMenuItem[0].setEnabled(selJoint != null);
    }

    public ObjectInfo getObject() {
        return this.objInfo;
    }

    public void setObject(Object3D obj) {
        this.objInfo.setObject(obj);
        this.objInfo.clearCachedMeshes();
    }

    public void setMesh(Mesh mesh) {
        this.setObject((Object3D)((Object)mesh));
    }

    public int getSelectionMode() {
        return 0;
    }

    public void setSelectionMode(int mode) {
    }

    public boolean[] getSelection() {
        return this.selected;
    }

    public void setSelection(boolean[] selected) {
        this.selected = selected;
        for (ViewerCanvas view : this.theView) {
            view.repaint();
        }
    }

    public int[] getSelectionDistance() {
        int[] dist = new int[this.selected.length];
        for (int i = 0; i < this.selected.length; ++i) {
            if (this.selected[i]) continue;
            dist[i] = -1;
        }
        return dist;
    }

    protected void doOk() {
        this.parentWindow.setUndoRecord(new UndoRecord(this.parentWindow, false, 12, new Object[]{this.track, this.track.duplicate(this.track.getParent())}));
        this.keyframe.getSkeleton().copy(this.getObject().getSkeleton());
        this.track.moveKeyframe(this.keyIndex, this.keyTime);
        this.track.getTimecourse().getSmoothness()[this.keyIndex] = this.keySmoothness;
        this.oldMesh = null;
        this.dispose();
        if (this.onClose != null) {
            this.onClose.run();
        }
    }

    protected void doCancel() {
        this.oldMesh = null;
        this.dispose();
    }

    private void adjustMeshForSkeleton() {
        Object3D obj = ((ObjectInfo)this.track.getParent()).getObject();
        Actor actor = Actor.getActor(obj);
        Mesh mesh = (Mesh)((Object)this.getObject().getObject());
        if (this.track.getUseGestures() && actor != null) {
            actor.shapeMeshFromGestures((Object3D)((Object)mesh));
        } else {
            Skeleton.adjustMesh(this.oldMesh, mesh);
        }
    }

    protected void resetCommand() {
        Object3D obj = ((ObjectInfo)this.track.getParent()).getObject();
        Actor actor = Actor.getActor(obj);
        Skeleton defaultSkeleton = actor != null ? actor.getGesture(0).getSkeleton() : obj.getSkeleton();
        Object3D editObj = this.getObject().getObject();
        this.setUndoRecord(new UndoRecord(this, false, 0, new Object[]{editObj, editObj.duplicate()}));
        editObj.getSkeleton().copy(defaultSkeleton);
        this.adjustMeshForSkeleton();
        this.objectChanged();
        this.updateImage();
    }

    protected void createFromGesturesCommand() {
        ObjectInfo info = (ObjectInfo)this.track.getParent();
        final Actor actor = Actor.getActor(info.getObject());
        final Actor.ActorKeyframe key = new Actor.ActorKeyframe();
        new ActorEditorWindow(this, info, actor, key, new Runnable(){

            public void run() {
                Skeleton newSkeleton = ((Gesture)key.createObjectKeyframe(actor)).getSkeleton();
                Object3D editObj = SkeletonShapeEditorWindow.this.getObject().getObject();
                SkeletonShapeEditorWindow.this.setUndoRecord(new UndoRecord(SkeletonShapeEditorWindow.this, false, 0, new Object[]{editObj, editObj.duplicate()}));
                editObj.getSkeleton().copy(newSkeleton);
                SkeletonShapeEditorWindow.this.adjustMeshForSkeleton();
                SkeletonShapeEditorWindow.this.objectChanged();
                SkeletonShapeEditorWindow.this.updateImage();
            }
        });
    }

    protected void editProperties() {
        ValueField timeField = new ValueField(this.keyTime, 0, 5);
        ValueSlider s1Slider = new ValueSlider(0.0, 1.0, 100, this.keySmoothness.getLeftSmoothness());
        final ValueSlider s2Slider = new ValueSlider(0.0, 1.0, 100, this.keySmoothness.getRightSmoothness());
        final BCheckBox sameBox = new BCheckBox(Translate.text("separateSmoothness"), !this.keySmoothness.isForceSame());
        sameBox.addEventLink(ValueChangedEvent.class, new Object(){

            void processEvent() {
                s2Slider.setEnabled(sameBox.getState());
            }
        });
        s2Slider.setEnabled(sameBox.getState());
        ComponentsDialog dlg = new ComponentsDialog(this, Translate.text("editKeyframe"), new Widget[]{timeField, sameBox, new BLabel(Translate.text("Smoothness") + ':'), s1Slider, s2Slider}, new String[]{Translate.text("Time"), null, null, "(" + Translate.text("left") + ")", "(" + Translate.text("right") + ")"});
        if (!dlg.clickedOk()) {
            return;
        }
        if (sameBox.getState()) {
            this.keySmoothness.setSmoothness(s1Slider.getValue(), s2Slider.getValue());
        } else {
            this.keySmoothness.setSmoothness(s1Slider.getValue());
        }
        this.keyTime = timeField.getValue();
    }

    public void adjustDeltas(Vec3[] delta) {
    }

    public void deleteCommand() {
    }
}

