/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.animation.distortion;

import artofillusion.animation.Actor;
import artofillusion.animation.IKSolver;
import artofillusion.animation.Skeleton;
import artofillusion.animation.distortion.Distortion;
import artofillusion.math.Vec3;
import artofillusion.object.Mesh;
import artofillusion.object.Object3D;

public class IKDistortion
extends Distortion {
    private boolean[] locked;
    private boolean[] moving;
    private Vec3[] target;
    private double weight;
    private Actor actor;

    public IKDistortion(boolean[] locked, Vec3[] target, double weight, Actor actor) {
        this.locked = locked;
        this.target = target;
        this.weight = weight;
        this.actor = actor;
        this.moving = new boolean[target.length];
        for (int i = 0; i < this.moving.length; ++i) {
            this.moving[i] = target[i] != null;
        }
    }

    public boolean isIdenticalTo(Distortion d) {
        if (!(d instanceof IKDistortion)) {
            return false;
        }
        IKDistortion s = (IKDistortion)d;
        if (this.previous != null && !this.previous.isIdenticalTo(s.previous)) {
            return false;
        }
        if (this.previous == null && s.previous != null) {
            return false;
        }
        if (this.actor != s.actor) {
            return false;
        }
        if (this.weight != s.weight) {
            return false;
        }
        if (this.locked.length != s.locked.length) {
            return false;
        }
        for (int i = 0; i < this.locked.length; ++i) {
            if (this.locked[i] != s.locked[i] || this.moving[i] != s.moving[i]) {
                return false;
            }
            if (this.target[i] == null || this.target[i].equals(s.target[i])) continue;
            return false;
        }
        return true;
    }

    public Distortion duplicate() {
        IKDistortion d = new IKDistortion(this.locked, this.target, this.weight, this.actor);
        if (this.previous != null) {
            d.previous = this.previous.duplicate();
        }
        return d;
    }

    public Mesh transform(Mesh obj) {
        if (this.previous != null) {
            obj = this.previous.transform(obj);
        }
        Mesh newmesh = (Mesh)((Object)obj.duplicate());
        Skeleton skeleton = newmesh.getSkeleton();
        IKSolver ik = new IKSolver(skeleton, this.locked, this.moving);
        ik.solve(this.target, 1500);
        if (this.weight < 1.0) {
            Skeleton targetSkeleton = skeleton.duplicate();
            obj.getSkeleton().blend(skeleton, new Skeleton[]{targetSkeleton}, new double[]{this.weight});
        }
        if (this.actor != null) {
            this.actor.shapeMeshFromGestures((Object3D)((Object)newmesh));
        } else {
            Skeleton.adjustMesh(obj, newmesh);
        }
        return newmesh;
    }
}

