/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.animation;

import artofillusion.animation.Keyframe;
import artofillusion.animation.Smoothness;

public class Timecourse {
    private double[] time;
    private Smoothness[] smoothness;
    private Keyframe[] value;
    private boolean subdivideAdaptively;
    public static final int DISCONTINUOUS = 0;
    public static final int LINEAR = 1;
    public static final int INTERPOLATING = 2;
    public static final int APPROXIMATING = 3;
    private static final int FIXED_SUBDIVISION_LEVELS = 3;

    public Timecourse(Keyframe[] value, double[] time, Smoothness[] smoothness) {
        this.value = value;
        this.time = time;
        this.smoothness = smoothness;
        this.subdivideAdaptively = true;
    }

    public void setTimepoints(Keyframe[] value, double[] time, Smoothness[] smoothness) {
        this.value = value;
        this.time = time;
        this.smoothness = smoothness;
    }

    public int addTimepoint(Keyframe v, double t, Smoothness s) {
        int i;
        for (int i2 = 0; i2 < this.time.length; ++i2) {
            if (!(Math.abs(this.time[i2] - t) < 1.0E-10)) continue;
            this.value[i2] = v;
            this.time[i2] = t;
            this.smoothness[i2] = s;
            return i2;
        }
        Keyframe[] newv = new Keyframe[this.value.length + 1];
        double[] newt = new double[this.time.length + 1];
        Smoothness[] news = new Smoothness[this.smoothness.length + 1];
        for (i = 0; i < this.time.length && this.time[i] < t; ++i) {
        }
        for (int j = 0; j < newv.length; ++j) {
            if (j < i) {
                newv[j] = this.value[j];
                newt[j] = this.time[j];
                news[j] = this.smoothness[j];
                continue;
            }
            if (j == i) {
                newv[j] = v;
                newt[j] = t;
                news[j] = s;
                continue;
            }
            newv[j] = this.value[j - 1];
            newt[j] = this.time[j - 1];
            news[j] = this.smoothness[j - 1];
        }
        this.value = newv;
        this.time = newt;
        this.smoothness = news;
        return i;
    }

    public void removeTimepoint(double t) {
        int i;
        for (i = 0; i < this.time.length && this.time[i] != t; ++i) {
        }
        if (i < this.time.length) {
            this.removeTimepoint(i);
        }
    }

    public void removeTimepoint(int which) {
        Keyframe[] newv = new Keyframe[this.value.length - 1];
        double[] newt = new double[this.time.length - 1];
        Smoothness[] news = new Smoothness[this.smoothness.length - 1];
        for (int j = 0; j < newv.length; ++j) {
            if (j < which) {
                newv[j] = this.value[j];
                newt[j] = this.time[j];
                news[j] = this.smoothness[j];
                continue;
            }
            newv[j] = this.value[j + 1];
            newt[j] = this.time[j + 1];
            news[j] = this.smoothness[j + 1];
        }
        this.value = newv;
        this.time = newt;
        this.smoothness = news;
    }

    public void removeAllTimepoints() {
        this.value = new Keyframe[0];
        this.time = new double[0];
        this.smoothness = new Smoothness[0];
    }

    public int moveTimepoint(int which, double t) {
        int newpos;
        for (newpos = 0; newpos < this.time.length && this.time[newpos] < t; ++newpos) {
        }
        Keyframe tempv = this.value[which];
        Smoothness temps = this.smoothness[which];
        if (newpos > which) {
            --newpos;
            for (int i = which; i < newpos; ++i) {
                this.value[i] = this.value[i + 1];
                this.time[i] = this.time[i + 1];
                this.smoothness[i] = this.smoothness[i + 1];
            }
        } else {
            for (int i = which; i > newpos; --i) {
                this.value[i] = this.value[i - 1];
                this.time[i] = this.time[i - 1];
                this.smoothness[i] = this.smoothness[i - 1];
            }
        }
        this.value[newpos] = tempv;
        this.time[newpos] = t;
        this.smoothness[newpos] = temps;
        return newpos;
    }

    public double[] getTimes() {
        return this.time;
    }

    public Keyframe[] getValues() {
        return this.value;
    }

    public Smoothness[] getSmoothness() {
        return this.smoothness;
    }

    public boolean getSubdivideAdaptively() {
        return this.subdivideAdaptively;
    }

    public void setSubdivideAdaptively(boolean adaptive) {
        this.subdivideAdaptively = adaptive;
    }

    public Timecourse duplicate(Object owner) {
        double[] newt = new double[this.time.length];
        Smoothness[] news = new Smoothness[this.smoothness.length];
        Keyframe[] newv = new Keyframe[this.value.length];
        for (int i = 0; i < newt.length; ++i) {
            newt[i] = this.time[i];
            news[i] = this.smoothness[i].duplicate();
            newv[i] = this.value[i].duplicate(owner);
        }
        Timecourse tc = new Timecourse(newv, newt, news);
        tc.subdivideAdaptively = this.subdivideAdaptively;
        return tc;
    }

    public Timecourse subdivide(int method) {
        int i;
        if (this.time.length < 2) {
            return this;
        }
        double[] t = new double[this.time.length * 2 - 1];
        Keyframe[] v = new Keyframe[this.value.length * 2 - 1];
        Smoothness[] s = new Smoothness[this.smoothness.length * 2 - 1];
        if (method == 0) {
            for (i = 0; i < this.value.length; ++i) {
                v[i * 2] = this.value[i];
                t[i * 2] = this.time[i];
            }
            for (i = 0; i < this.value.length - 1; ++i) {
                v[i * 2 + 1] = this.value[i].blend(this.value[i], 1.0, 0.0);
                t[i * 2 + 1] = (this.time[i] + this.time[i + 1]) * 0.5;
            }
        } else if (method == 1) {
            for (i = 0; i < this.value.length; ++i) {
                v[i * 2] = this.value[i];
                t[i * 2] = this.time[i];
            }
            for (i = 0; i < this.value.length - 1; ++i) {
                v[i * 2 + 1] = this.value[i].blend(this.value[i + 1], 0.5, 0.5);
                t[i * 2 + 1] = (this.time[i] + this.time[i + 1]) * 0.5;
            }
        } else if (method == 2) {
            int j = 0;
            for (i = 0; i < v.length; ++i) {
                if ((i & 1) == 0) {
                    v[i] = this.value[j];
                    t[i] = this.time[j];
                    continue;
                }
                TimePoint p1 = Timecourse.getPoint(this.time, this.value, this.smoothness, j - 1);
                TimePoint p2 = Timecourse.getPoint(this.time, this.value, this.smoothness, j);
                TimePoint p3 = Timecourse.getPoint(this.time, this.value, this.smoothness, j + 1);
                TimePoint p4 = Timecourse.getPoint(this.time, this.value, this.smoothness, j + 2);
                TimePoint interp = Timecourse.calcInterpPoint(p1, p2, p3, p4);
                v[i] = interp.value;
                t[i] = interp.time;
                ++j;
            }
        } else {
            for (i = 0; i < this.value.length; ++i) {
                if (i > 0) {
                    v[i * 2 - 1] = this.value[i].blend(this.value[i - 1], 0.5, 0.5);
                    t[i * 2 - 1] = (this.time[i] + this.time[i - 1]) * 0.5;
                }
                TimePoint p1 = Timecourse.getPoint(this.time, this.value, this.smoothness, i - 1);
                TimePoint p2 = Timecourse.getPoint(this.time, this.value, this.smoothness, i);
                TimePoint p3 = Timecourse.getPoint(this.time, this.value, this.smoothness, i + 1);
                TimePoint approx = Timecourse.calcApproxPoint(p1, p2, p3);
                v[i * 2] = approx.value;
                t[i * 2] = approx.time;
            }
        }
        for (i = 0; i < this.smoothness.length - 1; ++i) {
            s[i * 2] = this.smoothness[i].getSmoother();
            s[i * 2 + 1] = new Smoothness();
        }
        s[(this.smoothness.length - 1) * 2] = this.smoothness[this.smoothness.length - 1].getSmoother();
        Timecourse tc = new Timecourse(v, t, s);
        tc.subdivideAdaptively = this.subdivideAdaptively;
        return tc;
    }

    private static TimePoint calcInterpPoint(TimePoint p1, TimePoint p2, TimePoint p3, TimePoint p4) {
        double w1 = -0.0625 * p2.smoothness.getRightSmoothness();
        double w2 = 0.5 - w1;
        double w4 = -0.0625 * p3.smoothness.getLeftSmoothness();
        double w3 = 0.5 - w4;
        return new TimePoint(0.5 * p2.time + 0.5 * p3.time, p1.value.blend(p2.value, p3.value, p4.value, w1, w2, w3, w4), new Smoothness());
    }

    private static TimePoint calcApproxPoint(TimePoint p1, TimePoint p2, TimePoint p3) {
        double w1 = 0.125 * p2.smoothness.getRightSmoothness();
        double w3 = 0.125 * p2.smoothness.getLeftSmoothness();
        double w2 = 1.0 - w1 - w3;
        return new TimePoint(w1 * p1.time + w2 * p2.time + w3 * p3.time, p1.value.blend(p2.value, p3.value, w1, w2, w3), p2.smoothness.getSmoother());
    }

    private static TimePoint getPoint(double[] time, Keyframe[] value, Smoothness[] smoothness, int index) {
        if (index >= 0 && index < time.length) {
            return new TimePoint(time[index], value[index], smoothness[index]);
        }
        if (index == -1) {
            return new TimePoint(time[0] - (time[1] - time[0]), value[1], smoothness[1]);
        }
        if (index == -2) {
            if (time.length > 2) {
                return new TimePoint(time[0] - (time[2] - time[0]), value[2], smoothness[2]);
            }
            return new TimePoint(time[0] - 2.0 * (time[1] - time[0]), value[0], smoothness[0]);
        }
        int last = time.length - 1;
        if (index == time.length) {
            return new TimePoint(time[last] + (time[last] - time[last - 1]), value[last - 1], smoothness[last - 1]);
        }
        if (index == time.length + 1) {
            if (time.length > 2) {
                return new TimePoint(time[last] + (time[last] - time[last - 2]), value[last - 2], smoothness[last - 2]);
            }
            return new TimePoint(time[last] - 2.0 * (time[last] - time[last - 1]), value[last], smoothness[last]);
        }
        return null;
    }

    public Keyframe evaluate(double t, int method) {
        int minSubdivisions;
        if (this.time.length == 0) {
            return null;
        }
        if (this.time.length == 1) {
            return this.value[0];
        }
        if (t <= this.time[0]) {
            t = this.time[0];
        }
        if (t >= this.time[this.time.length - 1]) {
            t = this.time[this.time.length - 1];
        }
        if (method == 0) {
            int i;
            for (i = 1; i < this.time.length && t > this.time[i]; ++i) {
            }
            return this.value[i - 1];
        }
        if (method == 1) {
            int i;
            for (i = 1; i < this.time.length && t > this.time[i]; ++i) {
            }
            if (this.time[i - 1] == this.time[i]) {
                return this.value[i];
            }
            double fract = (t - this.time[i - 1]) / (this.time[i] - this.time[i - 1]);
            return this.value[i - 1].blend(this.value[i], 1.0 - fract, fract);
        }
        if (this.time.length < 7) {
            return this.subdivide(method).evaluate(t, method);
        }
        Keyframe[] v1 = new Keyframe[7];
        Keyframe[] v2 = new Keyframe[7];
        double[] t1 = new double[7];
        double[] t2 = new double[7];
        Smoothness[] s1 = new Smoothness[7];
        Smoothness[] s2 = new Smoothness[7];
        if (method == 2) {
            this.subdivideLocalInterp(t, this.value, this.time, this.smoothness, v1, t1, s1);
        } else {
            this.subdivideLocalApprox(t, this.value, this.time, this.smoothness, v1, t1, s1);
        }
        int numSubdivisions = 1;
        int n = minSubdivisions = method == 2 ? 1 : 3;
        if (!this.subdivideAdaptively) {
            minSubdivisions = 3;
        }
        while (true) {
            if (numSubdivisions >= minSubdivisions) {
                int i;
                for (i = 1; i < t1.length && t > t1[i]; ++i) {
                }
                if (t1[i - 1] == t1[i]) {
                    return v1[i];
                }
                double delta = t - t1[i - 1];
                if (delta < 0.03333333333333333 || !this.subdivideAdaptively) {
                    double fract = delta / (t1[i] - t1[i - 1]);
                    return v1[i - 1].blend(v1[i], 1.0 - fract, fract);
                }
            }
            if (method == 2) {
                this.subdivideLocalInterp(t, v1, t1, s1, v2, t2, s2);
                this.subdivideLocalInterp(t, v2, t2, s2, v1, t1, s1);
            } else {
                this.subdivideLocalApprox(t, v1, t1, s1, v2, t2, s2);
                this.subdivideLocalApprox(t, v2, t2, s2, v1, t1, s1);
            }
            numSubdivisions += 2;
        }
    }

    private void subdivideLocalInterp(double t, Keyframe[] v1, double[] t1, Smoothness[] s1, Keyframe[] v2, double[] t2, Smoothness[] s2) {
        int i;
        for (i = 1; i < t1.length && t > t1[i]; ++i) {
        }
        TimePoint p1 = Timecourse.getPoint(t1, v1, s1, i - 3);
        TimePoint p2 = Timecourse.getPoint(t1, v1, s1, i - 2);
        TimePoint p3 = Timecourse.getPoint(t1, v1, s1, i - 1);
        TimePoint p4 = Timecourse.getPoint(t1, v1, s1, i);
        TimePoint p5 = Timecourse.getPoint(t1, v1, s1, i + 1);
        TimePoint p6 = Timecourse.getPoint(t1, v1, s1, i + 2);
        v2[0] = p2.value;
        t2[0] = p2.time;
        s2[0] = p2.smoothness.getSmoother();
        TimePoint interp = Timecourse.calcInterpPoint(p1, p2, p3, p4);
        v2[1] = interp.value;
        t2[1] = interp.time;
        s2[1] = interp.smoothness;
        v2[2] = p3.value;
        t2[2] = p3.time;
        s2[2] = p3.smoothness.getSmoother();
        interp = Timecourse.calcInterpPoint(p2, p3, p4, p5);
        v2[3] = interp.value;
        t2[3] = interp.time;
        s2[3] = interp.smoothness;
        v2[4] = p4.value;
        t2[4] = p4.time;
        s2[4] = p4.smoothness.getSmoother();
        interp = Timecourse.calcInterpPoint(p3, p4, p5, p6);
        v2[5] = interp.value;
        t2[5] = interp.time;
        s2[5] = interp.smoothness;
        v2[6] = p5.value;
        t2[6] = p5.time;
        s2[6] = p5.smoothness.getSmoother();
    }

    private void subdivideLocalApprox(double t, Keyframe[] v1, double[] t1, Smoothness[] s1, Keyframe[] v2, double[] t2, Smoothness[] s2) {
        int i;
        for (i = 1; i < t1.length && t > t1[i]; ++i) {
        }
        TimePoint p1 = Timecourse.getPoint(t1, v1, s1, i - 3);
        TimePoint p2 = Timecourse.getPoint(t1, v1, s1, i - 2);
        TimePoint p3 = Timecourse.getPoint(t1, v1, s1, i - 1);
        TimePoint p4 = Timecourse.getPoint(t1, v1, s1, i);
        TimePoint p5 = Timecourse.getPoint(t1, v1, s1, i + 1);
        TimePoint p6 = Timecourse.getPoint(t1, v1, s1, i + 2);
        TimePoint approx = Timecourse.calcApproxPoint(p1, p2, p3);
        v2[0] = approx.value;
        t2[0] = approx.time;
        s2[0] = approx.smoothness;
        v2[1] = p2.value.blend(p3.value, 0.5, 0.5);
        t2[1] = 0.5 * (p2.time + p3.time);
        s2[1] = new Smoothness();
        approx = Timecourse.calcApproxPoint(p2, p3, p4);
        v2[2] = approx.value;
        t2[2] = approx.time;
        s2[2] = approx.smoothness;
        v2[3] = p3.value.blend(p4.value, 0.5, 0.5);
        t2[3] = 0.5 * (p3.time + p4.time);
        s2[3] = new Smoothness();
        approx = Timecourse.calcApproxPoint(p3, p4, p5);
        v2[4] = approx.value;
        t2[4] = approx.time;
        s2[4] = approx.smoothness;
        v2[5] = p4.value.blend(p5.value, 0.5, 0.5);
        t2[5] = 0.5 * (p4.time + p5.time);
        s2[5] = new Smoothness();
        approx = Timecourse.calcApproxPoint(p4, p5, p6);
        v2[6] = approx.value;
        t2[6] = approx.time;
        s2[6] = approx.smoothness;
    }

    private static class TimePoint {
        public double time;
        public Keyframe value;
        public Smoothness smoothness;

        public TimePoint(double time, Keyframe value, Smoothness smoothness) {
            this.time = time;
            this.value = value;
            this.smoothness = smoothness;
        }
    }
}

