/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.animation;

import artofillusion.Camera;
import artofillusion.MeshEditorWindow;
import artofillusion.MeshViewer;
import artofillusion.ObjectViewer;
import artofillusion.UndoRecord;
import artofillusion.ViewerCanvas;
import artofillusion.animation.IKSolver;
import artofillusion.animation.Joint;
import artofillusion.animation.Skeleton;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.Mat4;
import artofillusion.math.Vec2;
import artofillusion.math.Vec3;
import artofillusion.object.Mesh;
import artofillusion.ui.ActionProcessor;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.EditingTool;
import artofillusion.ui.Translate;
import buoy.event.WidgetMouseEvent;
import buoy.widget.BComboBox;
import buoy.widget.Widget;
import java.awt.Color;
import java.awt.Point;
import java.text.NumberFormat;

public class SkeletonTool
extends EditingTool {
    private static final int CLICK_TOL = 6;
    private static final int HANDLE_SIZE = 4;
    private static final int NO_HANDLES = 0;
    private static final int UNLOCKED_HANDLES = 1;
    private static final int ALL_HANDLES = 2;
    private static int whichHandles = 1;
    private Point clickPoint;
    private Vec3 clickPos;
    private Vec3[] handlePos;
    private boolean[] hideHandle;
    private boolean invertDragDir;
    private int clickedHandle;
    private IKSolver ik;
    private Mesh oldMesh;
    private Mesh mesh;
    private UndoRecord undo;
    private boolean allowCreating;
    private String helpText;

    public SkeletonTool(MeshEditorWindow fr, boolean allowCreating) {
        super(fr);
        this.allowCreating = allowCreating;
        this.initButton("skeleton");
        this.clickedHandle = -1;
        this.helpText = Translate.text(allowCreating ? "skeletonTool.helpText" : "skeletonTool.helpTextNoCreate");
    }

    public void activate() {
        super.activate();
        this.theWindow.setHelpText(this.helpText);
    }

    public int whichClicks() {
        return 1;
    }

    public String getToolTipText() {
        return Translate.text("skeletonTool.tipText");
    }

    private void findHandlePositions(Mat4 objToScreen, Joint j, ViewerCanvas view) {
        this.hideHandle = j.parent == null || whichHandles == 0 ? new boolean[]{true, true, true, true} : (whichHandles == 1 ? new boolean[]{j.angle1.fixed, j.angle2.fixed, j.length.fixed, j.twist.fixed} : new boolean[4]);
        double scale = 70.0 / view.getScale();
        this.handlePos = new Vec3[]{new Vec3(0.0, scale, 0.0), new Vec3(scale, 0.0, 0.0), new Vec3(0.0, 0.0, scale), new Vec3(-scale * 0.6, -scale * 0.6, scale * 0.4)};
        Vec3 jointPos = new Vec3(j.coords.getOrigin());
        objToScreen.transform(jointPos);
        int jointX = (int)jointPos.x;
        int jointY = (int)jointPos.y;
        for (int i = 0; i < this.hideHandle.length; ++i) {
            if (this.hideHandle[i]) continue;
            j.coords.fromLocal().transformDirection(this.handlePos[i]);
            this.handlePos[i].add(j.coords.getOrigin());
            objToScreen.transform(this.handlePos[i]);
            int x = (int)this.handlePos[i].x;
            int y = (int)this.handlePos[i].y;
            if (x != jointX || y != jointY) continue;
            this.hideHandle[i] = true;
        }
    }

    public void drawOverlay(ViewerCanvas view) {
        if (this.ik != null) {
            return;
        }
        MeshViewer mv = (MeshViewer)view;
        int selected = mv.getSelectedJoint();
        this.mesh = this.oldMesh == null ? (Mesh)((Object)mv.getController().getObject().getObject()) : this.oldMesh;
        Skeleton s = this.mesh.getSkeleton();
        Joint j = s.getJoint(selected);
        if (j == null) {
            return;
        }
        Camera cam = mv.getCamera();
        CoordinateSystem objCoords = mv.getDisplayCoordinates();
        Mat4 objToScreen = cam.getWorldToScreen().times(objCoords.fromLocal());
        if (this.clickedHandle == -1) {
            this.findHandlePositions(objToScreen, j, view);
            Vec3 jointPos = new Vec3(j.coords.getOrigin());
            objToScreen.transform(jointPos);
            int jointX = (int)jointPos.x;
            int jointY = (int)jointPos.y;
            for (int i = 0; i < this.hideHandle.length; ++i) {
                if (this.hideHandle[i]) continue;
                int x = (int)this.handlePos[i].x;
                int y = (int)this.handlePos[i].y;
                view.drawLine(new Point(jointX, jointY), new Point(x, y), Color.darkGray);
                view.drawBox(x - 2, y - 2, 4, 4, ViewerCanvas.handleColor);
            }
        } else if (this.clickedHandle < 2) {
            int i;
            Mat4 m2;
            Mat4 m1;
            double len = j.length.pos;
            if (this.clickedHandle == 0) {
                m1 = Mat4.zrotation(j.twist.pos * Math.PI / 180.0);
                m2 = j.parent.coords.fromLocal().times(Mat4.yrotation(j.angle2.pos * Math.PI / 180.0));
            } else {
                m1 = Mat4.xrotation(j.angle1.pos * Math.PI / 180.0).times(Mat4.zrotation(j.twist.pos * Math.PI / 180.0));
                m2 = j.parent.coords.fromLocal();
            }
            m2 = objToScreen.times(m2);
            Point[] pos = new Point[64];
            for (i = 0; i < pos.length; ++i) {
                double angle = (double)i * 2.0 * Math.PI / (double)pos.length;
                Vec3 p = new Vec3(0.0, 0.0, len);
                p = m1.timesDirection(p);
                p = this.clickedHandle == 0 ? m2.times(Mat4.xrotation(angle).timesDirection(p)) : m2.times(Mat4.yrotation(angle).timesDirection(p));
                pos[i] = new Point((int)p.x, (int)p.y);
            }
            for (i = 1; i < pos.length; ++i) {
                view.drawLine(new Point(pos[i - 1].x, pos[i - 1].y), new Point(pos[i].x, pos[i].y), Color.darkGray);
            }
            view.drawLine(new Point(pos[0].x, pos[0].y), new Point(pos[pos.length - 1].x, pos[pos.length - 1].y), Color.darkGray);
        }
    }

    public void mousePressed(WidgetMouseEvent e, ViewerCanvas view) {
        int i;
        MeshViewer mv = (MeshViewer)view;
        ViewerCanvas[] allViews = ((MeshEditorWindow)this.theWindow).getAllViews();
        this.mesh = (Mesh)((Object)mv.getController().getObject().getObject());
        Skeleton s = this.mesh.getSkeleton();
        Joint selectedJoint = s.getJoint(mv.getSelectedJoint());
        Camera cam = mv.getCamera();
        CoordinateSystem objCoords = mv.getDisplayCoordinates();
        Mat4 objToScreen = cam.getWorldToScreen().times(objCoords.fromLocal());
        this.clickPoint = e.getPoint();
        if (e.isControlDown() && this.allowCreating) {
            Joint j;
            double distToJoint;
            this.undo = new UndoRecord(this.theWindow, false, 0, new Object[]{this.mesh, this.mesh.duplicate()});
            Joint parent = s.getJoint(mv.getSelectedJoint());
            if (parent == null) {
                distToJoint = cam.getDistToScreen();
                this.clickPos = cam.convertScreenToWorld(this.clickPoint, distToJoint);
                objCoords.toLocal().transform(this.clickPos);
                j = new Joint(new CoordinateSystem(this.clickPos, Vec3.vz(), Vec3.vy()), null, "Root " + s.getNextJointID());
                j.angle2.fixed = true;
                j.angle1.fixed = true;
                s.addJoint(j, -1);
            } else {
                distToJoint = cam.getWorldToView().timesZ(parent.coords.getOrigin());
                this.clickPos = cam.convertScreenToWorld(this.clickPoint, distToJoint);
                objCoords.toLocal().transform(this.clickPos);
                Vec3 zdir = this.clickPos.minus(parent.coords.getOrigin());
                zdir.normalize();
                Vec3 ydir = cam.getCameraCoordinates().getZDirection().cross(zdir);
                ydir.normalize();
                j = new Joint(new CoordinateSystem(this.clickPos, zdir, ydir), parent, "Bone " + s.getNextJointID());
                s.addJoint(j, parent.id);
            }
            for (int k = 0; k < allViews.length; ++k) {
                ((MeshViewer)allViews[k]).setSelectedJoint(j.id);
            }
            boolean[] moving = new boolean[s.getNumJoints()];
            moving[s.findJointIndex((int)j.id)] = true;
            this.ik = new IKSolver(s, mv.getLockedJoints(), moving);
            this.theWindow.updateImage();
            this.theWindow.updateMenus();
            this.oldMesh = (Mesh)((Object)this.mesh.duplicate());
            return;
        }
        if (selectedJoint != null) {
            this.findHandlePositions(objToScreen, selectedJoint, view);
            for (int i2 = 0; i2 < this.hideHandle.length; ++i2) {
                if (this.hideHandle[i2] || !(Math.abs(this.handlePos[i2].x - (double)this.clickPoint.x) <= 3.0) || !(Math.abs(this.handlePos[i2].y - (double)this.clickPoint.y) <= 3.0)) continue;
                this.clickedHandle = i2;
                this.oldMesh = (Mesh)((Object)this.mesh.duplicate());
                Vec2 jointPos = objToScreen.timesXY(selectedJoint.coords.getOrigin());
                this.invertDragDir = this.handlePos[i2].x < jointPos.x;
                this.theWindow.updateImage();
                return;
            }
        }
        Joint[] joint = s.getJoints();
        for (i = 0; i < joint.length; ++i) {
            Vec2 pos = objToScreen.timesXY(joint[i].coords.getOrigin());
            if ((double)this.clickPoint.x > pos.x - 6.0 && (double)this.clickPoint.x < pos.x + 6.0 && (double)this.clickPoint.y > pos.y - 6.0 && (double)this.clickPoint.y < pos.y + 6.0) break;
        }
        if (i == joint.length) {
            for (int j = 0; j < allViews.length; ++j) {
                ((MeshViewer)allViews[j]).setSelectedJoint(-1);
            }
            this.theWindow.updateImage();
            this.theWindow.updateMenus();
            return;
        }
        if (e.isShiftDown()) {
            for (int j = 0; j < allViews.length; ++j) {
                MeshViewer v = (MeshViewer)allViews[j];
                if (v.isJointLocked(joint[i].id)) {
                    v.unlockJoint(joint[i].id);
                    continue;
                }
                v.lockJoint(joint[i].id);
            }
            this.theWindow.updateImage();
            return;
        }
        for (int j = 0; j < allViews.length; ++j) {
            ((MeshViewer)allViews[j]).setSelectedJoint(joint[i].id);
        }
        this.clickPos = joint[i].coords.getOrigin();
        this.theWindow.updateImage();
        this.theWindow.updateMenus();
        boolean[] moving = new boolean[s.getNumJoints()];
        moving[s.findJointIndex((int)joint[i].id)] = true;
        this.ik = new IKSolver(s, mv.getLockedJoints(), moving);
        this.oldMesh = (Mesh)((Object)this.mesh.duplicate());
    }

    public void mouseDragged(WidgetMouseEvent e, ViewerCanvas view) {
        MeshViewer mv = (MeshViewer)view;
        CoordinateSystem objCoords = mv.getDisplayCoordinates();
        Camera cam = mv.getCamera();
        Mesh mesh = (Mesh)((Object)mv.getController().getObject().getObject());
        Skeleton s = mesh.getSkeleton();
        Joint selectedJoint = s.getJoint(mv.getSelectedJoint());
        if (this.clickedHandle > -1) {
            if (this.undo == null) {
                this.undo = new UndoRecord(this.getWindow(), false, 0, new Object[]{mesh, mesh.duplicate()});
            }
            double dist = this.clickPoint.x - e.getPoint().x;
            if (this.invertDragDir) {
                dist = -dist;
            }
            Joint origJoint = this.oldMesh.getSkeleton().getJoint(mv.getSelectedJoint());
            Joint.DOF dof = null;
            Joint.DOF origDof = null;
            String name = null;
            switch (this.clickedHandle) {
                case 0: {
                    dof = selectedJoint.angle1;
                    origDof = origJoint.angle1;
                    dist *= 0.5729577951308232;
                    name = "X Bend";
                    break;
                }
                case 1: {
                    dof = selectedJoint.angle2;
                    origDof = origJoint.angle2;
                    dist *= -0.5729577951308232;
                    name = "Y Bend";
                    break;
                }
                case 2: {
                    dof = selectedJoint.length;
                    origDof = origJoint.length;
                    dist /= -view.getScale();
                    name = "Length";
                    break;
                }
                case 3: {
                    dof = selectedJoint.twist;
                    origDof = origJoint.twist;
                    dist *= 0.5729577951308232;
                    name = "Twist";
                }
            }
            dof.set(origDof.pos + dist);
            selectedJoint.recalcCoords(true);
            if (!mv.getSkeletonDetached()) {
                this.adjustMesh(mesh);
            }
            mv.getController().objectChanged();
            this.theWindow.updateImage();
            NumberFormat nf = NumberFormat.getNumberInstance();
            nf.setMaximumFractionDigits(3);
            this.theWindow.setHelpText(name + ": " + nf.format(dof.pos));
            return;
        }
        if (this.ik == null) {
            return;
        }
        boolean converged = false;
        Vec3[] target = new Vec3[s.getNumJoints()];
        int jointIndex = s.findJointIndex(selectedJoint.id);
        ActionProcessor process = view.getActionProcessor();
        do {
            Vec3 jointPos = objCoords.fromLocal().times(selectedJoint.coords.getOrigin());
            double distToJoint = cam.getWorldToView().timesZ(jointPos);
            Vec3 goal = cam.convertScreenToWorld(e.getPoint(), distToJoint);
            objCoords.toLocal().transform(goal);
            if (this.undo == null) {
                this.undo = new UndoRecord(this.getWindow(), false, 0, new Object[]{mesh, mesh.duplicate()});
            }
            target[jointIndex] = goal;
            converged = this.ik.solve(target, 100);
            if (!mv.getSkeletonDetached()) {
                this.adjustMesh(mesh);
            }
            ((ObjectViewer)view).getController().objectChanged();
            this.theWindow.updateImage();
        } while (!converged && (process == null || !process.hasEvent() && !process.hasBeenStopped()));
    }

    public void mouseReleased(WidgetMouseEvent e, ViewerCanvas view) {
        if (this.undo == null && e.getClickCount() == 2 && !e.isShiftDown() && !e.isControlDown()) {
            ((MeshEditorWindow)this.theWindow).editJointCommand();
        }
        this.ik = null;
        this.oldMesh = null;
        this.mesh = null;
        this.clickedHandle = -1;
        if (this.undo != null) {
            this.theWindow.setUndoRecord(this.undo);
        }
        this.undo = null;
        this.theWindow.setHelpText(this.helpText);
    }

    public void iconDoubleClicked() {
        BComboBox dofChoice = new BComboBox(new String[]{Translate.text("noDOF"), Translate.text("unlockedDOF"), Translate.text("allDOF")});
        dofChoice.setSelectedIndex(whichHandles);
        ComponentsDialog dlg = new ComponentsDialog(this.theFrame, Translate.text("skeletonToolTitle"), new Widget[]{dofChoice}, new String[]{null});
        if (!dlg.clickedOk()) {
            return;
        }
        whichHandles = dofChoice.getSelectedIndex();
        this.theWindow.updateImage();
    }

    protected void adjustMesh(Mesh newMesh) {
        Skeleton.adjustMesh(this.oldMesh, newMesh);
    }
}

