/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.animation;

import artofillusion.ArtOfIllusion;
import artofillusion.Scene;
import artofillusion.animation.Joint;
import artofillusion.animation.Skeleton;
import artofillusion.math.CoordinateSystem;
import artofillusion.object.ObjectInfo;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ObjectRef {
    private ObjectInfo object;
    private int objectID;
    private int jointID;
    private Scene theScene;

    public ObjectRef() {
        this.jointID = -1;
        this.objectID = -1;
    }

    public ObjectRef(ObjectInfo info) {
        this.object = info;
        this.objectID = info.getId();
        this.jointID = -1;
    }

    public ObjectRef(ObjectInfo info, Joint j) {
        this.object = info;
        this.objectID = info.getId();
        this.jointID = j.id;
    }

    public ObjectRef(int objectID, int jointID, Scene sc) {
        this.objectID = objectID;
        this.jointID = jointID;
        this.theScene = sc;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ObjectRef)) {
            return false;
        }
        ObjectRef ref = (ObjectRef)obj;
        return ref.objectID == this.objectID && ref.jointID == this.jointID;
    }

    public ObjectInfo getObject() {
        if (this.object == null) {
            if (this.theScene == null) {
                return null;
            }
            for (int i = this.theScene.getNumObjects() - 1; i >= 0; --i) {
                ObjectInfo info = this.theScene.getObject(i);
                if (info.getId() != this.objectID) continue;
                this.object = info;
                break;
            }
        }
        return this.object;
    }

    public Joint getJoint() {
        if (this.jointID == -1) {
            return null;
        }
        ObjectInfo info = this.getObject();
        if (info == null) {
            return null;
        }
        Skeleton s = info.getObject().getSkeleton();
        if (s != null) {
            return s.getJoint(this.jointID);
        }
        return null;
    }

    public CoordinateSystem getCoords() {
        Skeleton ds;
        ObjectInfo info = this.getObject();
        if (info == null) {
            return null;
        }
        if (this.jointID == -1) {
            return info.getCoords();
        }
        Skeleton s = info.getObject().getSkeleton();
        if (s != null && (ds = info.getDistortedObject(ArtOfIllusion.getPreferences().getInteractiveSurfaceError()).getSkeleton()) != null) {
            s = ds;
        }
        if (s == null) {
            return info.getCoords();
        }
        Joint j = s.getJoint(this.jointID);
        if (j == null) {
            return info.getCoords();
        }
        CoordinateSystem coords = j.coords.duplicate();
        coords.transformCoordinates(info.getCoords().fromLocal());
        return coords;
    }

    public ObjectRef duplicate() {
        ObjectRef ref = new ObjectRef();
        ref.objectID = this.objectID;
        ref.jointID = this.jointID;
        ref.object = this.object;
        ref.theScene = this.theScene;
        return ref;
    }

    public void copy(ObjectRef ref) {
        this.objectID = ref.objectID;
        this.jointID = ref.jointID;
        this.object = ref.object;
        this.theScene = ref.theScene;
    }

    public void writeToStream(DataOutputStream out) throws IOException {
        out.writeInt(this.objectID);
        out.writeInt(this.jointID);
    }

    public ObjectRef(DataInputStream in, Scene theScene) throws IOException {
        this.objectID = in.readInt();
        this.jointID = in.readInt();
        this.theScene = theScene;
    }

    public String toString() {
        ObjectInfo info = this.getObject();
        if (info == null) {
            return "(no object selected)";
        }
        Joint j = this.getJoint();
        if (j == null) {
            return info.getName();
        }
        return info.getName() + " (" + j.name + ")";
    }
}

