/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.animation;

import artofillusion.LayoutWindow;
import artofillusion.Scene;
import artofillusion.UndoRecord;
import artofillusion.animation.Keyframe;
import artofillusion.animation.Smoothness;
import artofillusion.animation.Timecourse;
import artofillusion.animation.Track;
import artofillusion.object.ObjectInfo;
import artofillusion.ui.PanelDialog;
import artofillusion.ui.Translate;
import artofillusion.ui.UIUtilities;
import artofillusion.ui.ValueField;
import buoy.widget.BButton;
import buoy.widget.BComboBox;
import buoy.widget.BLabel;
import buoy.widget.BStandardDialog;
import buoy.widget.ColumnContainer;
import buoy.widget.RowContainer;
import buoy.widget.WindowWidget;
import java.text.NumberFormat;
import java.util.Vector;

public class EditKeyframesDialog {
    LayoutWindow window;
    Scene theScene;
    BComboBox tracksChoice;
    ValueField startField;
    ValueField endField;
    ValueField extraField;
    BButton okButton;
    BButton cancelButton;
    int operation;
    public static final int MOVE = 0;
    public static final int COPY = 1;
    public static final int RESCALE = 2;
    public static final int LOOP = 3;
    public static final int DELETE = 4;
    private static final String[] opTitle = new String[]{Translate.text("Move"), Translate.text("Copy"), Translate.text("Rescale"), Translate.text("Loop"), Translate.text("Delete")};

    public EditKeyframesDialog(LayoutWindow win, int operation) {
        this.window = win;
        this.operation = operation;
        this.theScene = this.window.getScene();
        ColumnContainer content = new ColumnContainer();
        RowContainer row = new RowContainer();
        content.add(row);
        row.add(Translate.label("applyTo"));
        this.tracksChoice = new BComboBox(new String[]{Translate.text("allTracks"), Translate.text("allTracksSelectedObjects"), Translate.text("selectedTracks")});
        row.add(this.tracksChoice);
        if (this.window.getScore().getSelectedTracks().length > 0) {
            this.tracksChoice.setSelectedIndex(2);
        } else if (this.theScene.getSelection().length > 0) {
            this.tracksChoice.setSelectedIndex(1);
        }
        row = new RowContainer();
        content.add(row);
        row.add(new BLabel(opTitle[operation] + " " + Translate.text("keyframesBetweenTime")));
        this.startField = new ValueField(0.0, 0, 5);
        row.add(this.startField);
        row = new RowContainer();
        content.add(row);
        row.add(Translate.label("andTime"));
        this.endField = new ValueField(0.0, 0, 5);
        row.add(this.endField);
        row = new RowContainer();
        content.add(row);
        if (operation == 0 || operation == 1) {
            row.add(Translate.label("to time"));
        } else if (operation == 2) {
            row.add(Translate.label("byFactorOf"));
        } else if (operation == 3) {
            row.add(Translate.label("numLoopTimes"));
        }
        this.extraField = operation == 3 ? new ValueField(2.0, 7, 5) : new ValueField(1.0, 0, 5);
        if (operation != 4) {
            row.add(this.extraField);
        }
        do {
            PanelDialog dlg;
            if ((dlg = new PanelDialog((WindowWidget)win, opTitle[operation] + " " + Translate.text("Keyframes"), content)).clickedOk()) continue;
            return;
        } while (!this.doEdit());
    }

    private boolean doEdit() {
        int i;
        double targetEnd;
        double targetStart;
        Track[] track;
        int whichTracks = this.tracksChoice.getSelectedIndex();
        double fps = this.theScene.getFramesPerSecond();
        if (whichTracks == 0) {
            int i2;
            Vector tracks = new Vector();
            for (i2 = 0; i2 < this.theScene.getNumObjects(); ++i2) {
                ObjectInfo info = this.theScene.getObject(i2);
                for (int j = 0; j < info.getTracks().length; ++j) {
                    this.addToVector(info.getTracks()[j], tracks);
                }
            }
            track = new Track[tracks.size()];
            for (i2 = 0; i2 < track.length; ++i2) {
                track[i2] = (Track)tracks.elementAt(i2);
            }
        } else if (whichTracks == 1) {
            int i3;
            int[] sel = this.theScene.getSelection();
            Vector tracks = new Vector();
            for (i3 = 0; i3 < sel.length; ++i3) {
                ObjectInfo info = this.theScene.getObject(sel[i3]);
                for (int j = 0; j < info.getTracks().length; ++j) {
                    this.addToVector(info.getTracks()[j], tracks);
                }
            }
            track = new Track[tracks.size()];
            for (i3 = 0; i3 < track.length; ++i3) {
                track[i3] = (Track)tracks.elementAt(i3);
            }
        } else {
            track = this.window.getScore().getSelectedTracks();
        }
        double start = this.startField.getValue();
        double end = this.endField.getValue();
        double extra = this.extraField.getValue();
        double scaleStart = 0.0;
        double scaleFactor = 0.0;
        int numLoops = 0;
        if (start > end) {
            double temp = start;
            start = end;
            end = temp;
        }
        if (this.operation == 0 || this.operation == 1) {
            targetStart = extra;
            targetEnd = targetStart + (end - start);
            if (targetStart > start && targetStart < end) {
                targetStart = end;
            }
            if (targetEnd > start && targetEnd < end) {
                targetEnd = start;
            }
        } else if (this.operation == 2) {
            scaleFactor = extra;
            targetStart = end;
            targetEnd = start + Math.abs(scaleFactor) * (end - start);
            scaleStart = scaleFactor < 0.0 ? targetEnd : start;
            if (targetEnd < targetStart) {
                targetEnd = targetStart;
            }
        } else if (this.operation == 3) {
            numLoops = (int)extra;
            targetStart = end;
            targetEnd = start + (double)numLoops * (end - start);
        } else {
            targetStart = targetEnd = start;
        }
        boolean any = false;
        for (int i4 = 0; !any && i4 < track.length; ++i4) {
            double[] t = track[i4].getKeyTimes();
            for (int j = 0; !any && j < t.length; ++j) {
                if (!(t[j] > targetStart) || !(t[j] < targetEnd)) continue;
                any = true;
            }
        }
        if (any) {
            NumberFormat nf = NumberFormat.getNumberInstance();
            nf.setMaximumFractionDigits(3);
            String[] options = new String[]{Translate.text("Yes"), Translate.text("No")};
            int choice = new BStandardDialog("", UIUtilities.breakString(Translate.text("existingKeyframesError", nf.format(targetStart), nf.format(targetEnd))), BStandardDialog.QUESTION).showOptionDialog(this.window, options, options[0]);
            if (choice == 1) {
                return false;
            }
        }
        UndoRecord undo = new UndoRecord(this.window, false);
        for (i = 0; i < track.length; ++i) {
            Object parent = track[i].getParent();
            Track dup = parent instanceof ObjectInfo ? track[i].duplicate((ObjectInfo)parent) : track[i].duplicate(null);
            undo.addCommand(12, new Object[]{track[i], dup});
        }
        for (i = 0; i < track.length; ++i) {
            int j;
            double[] t = track[i].getKeyTimes();
            for (int j2 = t.length - 1; j2 >= 0; --j2) {
                if (!(t[j2] > targetStart) || !(t[j2] < targetEnd)) continue;
                track[i].deleteKeyframe(j2);
            }
            Timecourse tc = track[i].getTimecourse();
            if (tc == null) continue;
            Keyframe[] key = tc.getValues();
            Smoothness[] s = tc.getSmoothness();
            t = track[i].getKeyTimes();
            if (this.operation == 0 || this.operation == 2 || this.operation == 4) {
                for (j = t.length - 1; j >= 0; --j) {
                    if (!(t[j] >= start) || !(t[j] <= end)) continue;
                    track[i].deleteKeyframe(j);
                }
            }
            if (this.operation == 0 || this.operation == 1) {
                for (j = 0; j < t.length; ++j) {
                    if (!(t[j] >= start) || !(t[j] <= end)) continue;
                    track[i].setKeyframe(this.roundTime(t[j] - start + extra, fps), key[j].duplicate(), s[j]);
                }
            }
            if (this.operation == 2) {
                for (j = 0; j < t.length; ++j) {
                    if (!(t[j] >= start) || !(t[j] <= end)) continue;
                    track[i].setKeyframe(this.roundTime(scaleStart + scaleFactor * (t[j] - start), fps), key[j].duplicate(), s[j]);
                }
            }
            if (this.operation != 3) continue;
            for (j = 0; j < t.length; ++j) {
                if (!(t[j] >= start) || !(t[j] <= end)) continue;
                for (int k = 1; k < numLoops; ++k) {
                    track[i].setKeyframe(this.roundTime(t[j] + (double)k * (end - start), fps), key[j].duplicate(), s[j]);
                }
            }
        }
        this.window.getScore().rebuildList();
        this.window.setTime(this.window.getScene().getTime());
        this.window.setUndoRecord(undo);
        return true;
    }

    private void addToVector(Track tr, Vector v) {
        Track[] sub = tr.getSubtracks();
        v.addElement(tr);
        for (int i = 0; i < sub.length; ++i) {
            this.addToVector(sub[i], v);
        }
    }

    private double roundTime(double t, double fps) {
        return (double)Math.round(t * fps) / fps;
    }
}

