/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.ArtOfIllusion;
import artofillusion.CurveEditorWindow;
import artofillusion.MeshViewer;
import artofillusion.MoveScaleRotateMeshTool;
import artofillusion.MoveViewTool;
import artofillusion.ReshapeMeshTool;
import artofillusion.RotateMeshTool;
import artofillusion.RotateViewTool;
import artofillusion.ScaleMeshTool;
import artofillusion.SkewMeshTool;
import artofillusion.TaperMeshTool;
import artofillusion.UndoRecord;
import artofillusion.object.MeshVertex;
import artofillusion.object.ObjectInfo;
import artofillusion.object.SplineMesh;
import artofillusion.object.Tube;
import artofillusion.texture.ParameterValue;
import artofillusion.texture.VertexParameterValue;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.ToolPalette;
import artofillusion.ui.Translate;
import artofillusion.ui.UIUtilities;
import artofillusion.ui.ValueField;
import buoy.event.WidgetEvent;
import buoy.widget.BCheckBoxMenuItem;
import buoy.widget.BLabel;
import buoy.widget.BMenu;
import buoy.widget.BMenuItem;
import buoy.widget.BStandardDialog;
import buoy.widget.FormContainer;
import buoy.widget.LayoutInfo;
import buoy.widget.RowContainer;
import buoy.widget.Widget;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;

public class TubeEditorWindow
extends CurveEditorWindow {
    private BCheckBoxMenuItem[] endsItem;
    private boolean topology;

    public TubeEditorWindow(EditingWindow parent, String title, ObjectInfo obj, Runnable onClose, boolean allowTopology) {
        super(parent, title, obj);
        this.onClose = onClose;
        this.topology = allowTopology;
        FormContainer content = new FormContainer(new double[]{0.0, 1.0}, new double[]{1.0, 0.0, 0.0});
        this.setContent(content);
        content.setDefaultLayout(new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.BOTH, null, null));
        this.helpText = new BLabel();
        content.add(this.helpText, 0, 1, 2, 1);
        content.add(this.viewsContainer, 1, 0);
        RowContainer buttons = new RowContainer();
        buttons.add(Translate.button("ok", this, "doOk"));
        buttons.add(Translate.button("cancel", this, "doCancel"));
        content.add(buttons, 0, 2, 2, 1, new LayoutInfo());
        this.tools = new ToolPalette(1, 7);
        content.add(this.tools, 0, 0, new LayoutInfo(LayoutInfo.NORTH, LayoutInfo.NONE, null, null));
        this.defaultTool = new ReshapeMeshTool(this, this);
        this.tools.addTool(this.defaultTool);
        this.tools.addTool(new ScaleMeshTool(this, this));
        this.tools.addTool(new RotateMeshTool(this, this, false));
        this.tools.addTool(new SkewMeshTool(this, this));
        this.tools.addTool(new TaperMeshTool(this, this));
        MoveScaleRotateMeshTool compoundTool = new MoveScaleRotateMeshTool(this, this);
        this.tools.addTool(compoundTool);
        if (ArtOfIllusion.getPreferences().getUseCompoundMeshTool()) {
            this.defaultTool = compoundTool;
        }
        MoveViewTool metaTool = new MoveViewTool(this);
        this.tools.addTool(metaTool);
        RotateViewTool altTool = new RotateViewTool(this);
        this.tools.addTool(altTool);
        this.tools.setDefaultTool(this.defaultTool);
        this.tools.selectTool(this.defaultTool);
        for (int i = 0; i < this.theView.length; ++i) {
            MeshViewer view = (MeshViewer)this.theView[i];
            view.setMetaTool(metaTool);
            view.setAltTool(altTool);
            view.setScene(parent.getScene(), obj);
        }
        this.createEditMenu();
        this.createMeshMenu((Tube)obj.getObject());
        this.createViewMenu();
        this.recursivelyAddListeners(this);
        UIUtilities.applyDefaultFont(content);
        UIUtilities.applyDefaultBackground(content);
        Rectangle screenBounds = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
        Dimension windowDim = new Dimension(screenBounds.width * 3 / 4, screenBounds.height * 3 / 4);
        this.setBounds(new Rectangle((screenBounds.width - windowDim.width) / 2, (screenBounds.height - windowDim.height) / 2, windowDim.width, windowDim.height));
        this.tools.requestFocus();
        this.selected = new boolean[((Tube)obj.getObject()).getVertices().length];
        this.findSelectionDistance();
        this.updateMenus();
    }

    void createMeshMenu(Tube obj) {
        this.meshMenu = Translate.menu("tube");
        this.menubar.add(this.meshMenu);
        this.meshMenuItem = new BMenuItem[8];
        this.meshMenuItem[0] = Translate.menuItem("deletePoints", this, "deleteCommand");
        if (this.topology) {
            this.meshMenu.add(this.meshMenuItem[0]);
        }
        this.meshMenuItem[1] = Translate.menuItem("subdivide", this, "subdivideCommand");
        if (this.topology) {
            this.meshMenu.add(this.meshMenuItem[1]);
        }
        this.meshMenuItem[2] = Translate.menuItem("editPoints", this, "setPointsCommand");
        this.meshMenu.add(this.meshMenuItem[2]);
        this.meshMenuItem[3] = Translate.menuItem("transformPoints", this, "transformPointsCommand");
        this.meshMenu.add(this.meshMenuItem[3]);
        this.meshMenuItem[4] = Translate.menuItem("randomize", this, "randomizeCommand");
        this.meshMenu.add(this.meshMenuItem[4]);
        this.meshMenuItem[5] = Translate.menuItem("parameters", this, "setParametersCommand");
        this.meshMenu.add(this.meshMenuItem[5]);
        this.meshMenuItem[6] = Translate.menuItem("thickness", this, "setThicknessCommand");
        this.meshMenu.add(this.meshMenuItem[6]);
        this.meshMenu.add(Translate.menuItem("centerTube", this, "centerCommand"));
        this.meshMenu.addSeparator();
        this.meshMenuItem[7] = Translate.menuItem("smoothness", this, "setSmoothnessCommand");
        this.meshMenu.add(this.meshMenuItem[7]);
        this.smoothMenu = Translate.menu("smoothingMethod");
        this.meshMenu.add(this.smoothMenu);
        this.smoothItem = new BCheckBoxMenuItem[3];
        this.smoothItem[0] = Translate.checkboxMenuItem("none", this, "smoothingChanged", obj.getSmoothingMethod() == 0);
        this.smoothMenu.add(this.smoothItem[0]);
        this.smoothItem[1] = Translate.checkboxMenuItem("interpolating", this, "smoothingChanged", obj.getSmoothingMethod() == 2);
        this.smoothMenu.add(this.smoothItem[1]);
        this.smoothItem[2] = Translate.checkboxMenuItem("approximating", this, "smoothingChanged", obj.getSmoothingMethod() == 3);
        this.smoothMenu.add(this.smoothItem[2]);
        this.endsItem = new BCheckBoxMenuItem[3];
        BMenu endsMenu = Translate.menu("endsStyle");
        this.meshMenu.add(endsMenu);
        this.endsItem[0] = Translate.checkboxMenuItem("openEnds", this, "endsStyleChanged", obj.getEndsStyle() == 0);
        endsMenu.add(this.endsItem[0]);
        this.endsItem[1] = Translate.checkboxMenuItem("closedEnds", this, "endsStyleChanged", obj.getEndsStyle() == 1);
        endsMenu.add(this.endsItem[1]);
        this.endsItem[2] = Translate.checkboxMenuItem("flatEnds", this, "endsStyleChanged", obj.getEndsStyle() == 2);
        endsMenu.add(this.endsItem[2]);
    }

    protected BMenu createShowMenu() {
        BMenu menu = Translate.menu("show");
        MeshViewer view = (MeshViewer)this.theView[this.currentView];
        this.showItem = new BCheckBoxMenuItem[4];
        this.showItem[0] = Translate.checkboxMenuItem("curve", this, "shownItemChanged", view.getMeshVisible());
        menu.add(this.showItem[0]);
        this.showItem[1] = Translate.checkboxMenuItem("surface", this, "shownItemChanged", view.getSurfaceVisible());
        menu.add(this.showItem[1]);
        this.showItem[3] = Translate.checkboxMenuItem("entireScene", this, "shownItemChanged", view.getSceneVisible());
        menu.add(this.showItem[3]);
        return menu;
    }

    public void updateMenus() {
        int i;
        super.updateMenus();
        for (i = 0; i < this.selected.length && !this.selected[i]; ++i) {
        }
        if (i < this.selected.length) {
            this.editMenuItem[0].setEnabled(true);
            for (i = 0; i < this.meshMenuItem.length; ++i) {
                this.meshMenuItem[i].setEnabled(true);
            }
        } else {
            this.editMenuItem[0].setEnabled(false);
            for (i = 0; i < this.meshMenuItem.length; ++i) {
                this.meshMenuItem[i].setEnabled(false);
            }
        }
    }

    private void endsStyleChanged(WidgetEvent ev) {
        Widget source = ev.getWidget();
        for (int i = 0; i < this.endsItem.length; ++i) {
            if (source != this.endsItem[i]) continue;
            for (int j = 0; j < this.endsItem.length; ++j) {
                this.endsItem[j].setState(false);
            }
            this.endsItem[i].setState(true);
            ((Tube)this.objInfo.getObject()).setEndsStyle(i);
            this.objectChanged();
            this.updateImage();
        }
    }

    protected void doOk() {
        Tube theMesh = (Tube)this.objInfo.getObject();
        if (((Tube)this.oldMesh).getMaterial() != null) {
            if (!theMesh.isClosed()) {
                String[] options = new String[]{Translate.text("button.ok"), Translate.text("button.cancel")};
                BStandardDialog dlg = new BStandardDialog("", UIUtilities.breakString(Translate.text("surfaceNoLongerClosed")), BStandardDialog.WARNING);
                int choice = dlg.showOptionDialog(this, options, options[0]);
                if (choice == 1) {
                    return;
                }
                theMesh.setMaterial(null, null);
            } else {
                theMesh.setMaterial(((Tube)this.oldMesh).getMaterial(), ((Tube)this.oldMesh).getMaterialMapping());
            }
        }
        this.oldMesh.copyObject(theMesh);
        this.oldMesh = null;
        this.dispose();
        this.onClose.run();
    }

    protected void doCancel() {
        this.oldMesh = null;
        this.dispose();
    }

    public void deleteCommand() {
        int i;
        if (!this.topology) {
            return;
        }
        int num = 0;
        Tube theTube = (Tube)this.objInfo.getObject();
        MeshVertex[] vt = theTube.getVertices();
        double[] t = theTube.getThickness();
        float[] s = theTube.getSmoothness();
        for (i = 0; i < this.selected.length; ++i) {
            if (!this.selected[i]) continue;
            ++num;
        }
        if (num == 0) {
            return;
        }
        if (theTube.getEndsStyle() != 1 && this.selected.length - num < 2) {
            new BStandardDialog("", Translate.text("tubeNeeds2Points"), BStandardDialog.INFORMATION).showMessageDialog(this);
            return;
        }
        if (theTube.getEndsStyle() == 1 && this.selected.length - num < 3) {
            new BStandardDialog("", Translate.text("tubeNeeds3Points"), BStandardDialog.INFORMATION).showMessageDialog(this);
            return;
        }
        this.setUndoRecord(new UndoRecord(this, false, 0, new Object[]{theTube, theTube.duplicate()}));
        MeshVertex[] newv = new MeshVertex[vt.length - num];
        double[] newt = new double[vt.length - num];
        float[] news = new float[vt.length - num];
        boolean[] newsel = new boolean[vt.length - num];
        int j = 0;
        for (i = 0; i < vt.length; ++i) {
            if (this.selected[i]) continue;
            newsel[j] = this.selected[i];
            newt[j] = t[i];
            news[j] = s[i];
            newv[j++] = vt[i];
        }
        theTube.setShape(newv, news, newt);
        this.setSelection(newsel);
        this.objectChanged();
        this.updateImage();
    }

    public void subdivideCommand() {
        int j;
        int i;
        Tube theTube = (Tube)this.objInfo.getObject();
        MeshVertex[] vt = theTube.getVertices();
        float[] s = theTube.getSmoothness();
        double[] t = theTube.getThickness();
        int numParam = theTube.getParameters() == null ? 0 : theTube.getParameters().length;
        double[] paramTemp = new double[numParam];
        int splitcount = 0;
        int method = theTube.getSmoothingMethod();
        double[][] param = new double[vt.length][numParam];
        ParameterValue[] paramValue = theTube.getParameterValues();
        for (i = 0; i < numParam; ++i) {
            if (!(paramValue[i] instanceof VertexParameterValue)) continue;
            double[] val = ((VertexParameterValue)paramValue[i]).getValue();
            for (j = 0; j < val.length; ++j) {
                param[j][i] = val[j];
            }
        }
        boolean[] split = theTube.getEndsStyle() == 1 ? new boolean[vt.length] : new boolean[vt.length - 1];
        for (i = 0; i < split.length; ++i) {
            if (!this.selected[i] || !this.selected[(i + 1) % this.selected.length]) continue;
            split[i] = true;
            ++splitcount;
        }
        MeshVertex[] newpos = new MeshVertex[vt.length + splitcount];
        float[] news = new float[vt.length + splitcount];
        double[] newt = new double[vt.length + splitcount];
        double[][] newparam = new double[vt.length + splitcount][numParam];
        boolean[] newsel = new boolean[vt.length + splitcount];
        j = 0;
        for (i = 0; i < split.length; ++i) {
            int k;
            newsel[j] = this.selected[i];
            int p1 = i - 1;
            if (p1 < 0) {
                p1 = theTube.getEndsStyle() == 1 ? vt.length - 1 : 0;
            }
            int p3 = i < vt.length - 1 ? i + 1 : (theTube.getEndsStyle() == 1 ? 0 : vt.length - 1);
            if (this.selected[i] && method == 3) {
                newpos[j] = SplineMesh.calcApproxPoint(vt, s, param, paramTemp, p1, i, p3);
                newt[j] = Tube.calcApproxThickness(t, s, p1, i, p3);
                for (k = 0; k < numParam; ++k) {
                    newparam[j][k] = paramTemp[k];
                }
            } else {
                newpos[j] = vt[i];
                newt[j] = t[i];
                newparam[j] = param[i];
            }
            news[j] = this.selected[i] ? Math.min(s[i] * 2.0f, 1.0f) : s[i];
            if (!split[i]) {
                ++j;
                continue;
            }
            if (method == 0) {
                newpos[j + 1] = MeshVertex.blend(vt[i], vt[p3], 0.5, 0.5);
                for (k = 0; k < numParam; ++k) {
                    newparam[j + 1][k] = 0.5 * (param[i][k] + param[p3][k]);
                }
            } else if (method == 2) {
                int p4 = i < vt.length - 2 ? i + 2 : (theTube.getEndsStyle() == 1 ? (i + 2) % vt.length : vt.length - 1);
                newpos[j + 1] = SplineMesh.calcInterpPoint(vt, s, param, paramTemp, p1, i, p3, p4);
                newt[j + 1] = Tube.calcInterpThickness(t, s, p1, i, p3, p4);
                for (k = 0; k < numParam; ++k) {
                    newparam[j + 1][k] = paramTemp[k];
                }
            } else {
                newpos[j + 1] = MeshVertex.blend(vt[i], vt[p3], 0.5, 0.5);
                newt[j + 1] = 0.5 * (t[i] + t[p3]);
                for (k = 0; k < numParam; ++k) {
                    newparam[j + 1][k] = 0.5 * (param[i][k] + param[p3][k]);
                }
            }
            news[j + 1] = 1.0f;
            newsel[j + 1] = true;
            j += 2;
        }
        if (theTube.getEndsStyle() != 1) {
            newpos[0] = vt[0];
            newpos[j] = vt[i];
            newt[0] = t[0];
            newt[j] = t[i];
            news[j] = s[i];
            newparam[0] = param[0];
            newparam[j] = param[i];
            newsel[j] = this.selected[i];
        }
        this.setUndoRecord(new UndoRecord(this, false, 0, new Object[]{theTube, theTube.duplicate()}));
        theTube.setShape(newpos, news, newt);
        for (i = 0; i < numParam; ++i) {
            if (!(paramValue[i] instanceof VertexParameterValue)) continue;
            double[] val = new double[newpos.length];
            for (j = 0; j < val.length; ++j) {
                val[j] = newparam[j][i];
            }
            paramValue[i] = new VertexParameterValue(val);
        }
        theTube.setParameterValues(paramValue);
        this.setSelection(newsel);
        this.objectChanged();
        this.updateImage();
    }

    public void setThicknessCommand() {
        Tube theTube = (Tube)this.objInfo.getObject();
        double[] thickness = theTube.getThickness();
        double initial = -1.0;
        int[] selectDist = this.getSelectionDistance();
        for (int i = 0; i < selectDist.length; ++i) {
            if (selectDist[i] != 0) continue;
            if (initial == -1.0) {
                initial = thickness[i];
                continue;
            }
            if (initial == thickness[i]) continue;
            initial = Double.NaN;
        }
        if (initial == -1.0) {
            return;
        }
        ValueField thicknessField = new ValueField(initial, 1, 5);
        ComponentsDialog dlg = new ComponentsDialog(this, Translate.text("setThicknessTitle"), new Widget[]{thicknessField}, new String[]{Translate.text("Thickness")});
        if (!dlg.clickedOk() || Double.isNaN(thicknessField.getValue())) {
            return;
        }
        this.setUndoRecord(new UndoRecord(this, false, 0, new Object[]{theTube, theTube.duplicate()}));
        for (int i = 0; i < selectDist.length; ++i) {
            if (selectDist[i] != 0) continue;
            thickness[i] = thicknessField.getValue();
        }
        theTube.setThickness(thickness);
        this.objectChanged();
        this.updateImage();
    }
}

