/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.ArtOfIllusion;
import artofillusion.BevelExtrudeTool;
import artofillusion.CreateVertexTool;
import artofillusion.LayoutWindow;
import artofillusion.MeshEditorWindow;
import artofillusion.MeshViewer;
import artofillusion.MoveScaleRotateMeshTool;
import artofillusion.MoveViewTool;
import artofillusion.ObjectPreviewCanvas;
import artofillusion.RenderingMesh;
import artofillusion.ReshapeMeshTool;
import artofillusion.RotateMeshTool;
import artofillusion.RotateViewTool;
import artofillusion.ScaleMeshTool;
import artofillusion.SkewMeshTool;
import artofillusion.TaperMeshTool;
import artofillusion.TextureParameter;
import artofillusion.ThickenMeshTool;
import artofillusion.TriMeshBeveler;
import artofillusion.TriMeshSelectionUtilities;
import artofillusion.TriMeshSimplifier;
import artofillusion.TriMeshViewer;
import artofillusion.UndoRecord;
import artofillusion.ViewerCanvas;
import artofillusion.animation.Joint;
import artofillusion.animation.Skeleton;
import artofillusion.animation.SkeletonTool;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.Vec3;
import artofillusion.object.Curve;
import artofillusion.object.Mesh;
import artofillusion.object.MeshVertex;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectInfo;
import artofillusion.object.TriangleMesh;
import artofillusion.texture.FaceParameterValue;
import artofillusion.texture.FaceVertexParameterValue;
import artofillusion.texture.ParameterValue;
import artofillusion.texture.VertexParameterValue;
import artofillusion.ui.ActionProcessor;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.EditingTool;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.GenericTool;
import artofillusion.ui.PanelDialog;
import artofillusion.ui.ToolPalette;
import artofillusion.ui.Translate;
import artofillusion.ui.UIUtilities;
import artofillusion.ui.ValueField;
import artofillusion.ui.ValueSlider;
import buoy.event.CommandEvent;
import buoy.event.ValueChangedEvent;
import buoy.widget.BCheckBox;
import buoy.widget.BCheckBoxMenuItem;
import buoy.widget.BComboBox;
import buoy.widget.BLabel;
import buoy.widget.BMenu;
import buoy.widget.BMenuItem;
import buoy.widget.BStandardDialog;
import buoy.widget.FormContainer;
import buoy.widget.LayoutInfo;
import buoy.widget.RowContainer;
import buoy.widget.Widget;
import buoy.widget.WindowWidget;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.TreeSet;
import java.util.Vector;

public class TriMeshEditorWindow
extends MeshEditorWindow
implements EditingWindow {
    private ToolPalette modes;
    private BMenuItem[] editMenuItem;
    private BMenuItem[] selectMenuItem;
    private BMenuItem[] meshMenuItem;
    private BMenuItem[] skeletonMenuItem;
    private BCheckBoxMenuItem[] smoothItem;
    private Runnable onClose;
    private TriangleMesh mesh;
    private TriangleMesh divMesh;
    private RenderingMesh lastPreview;
    private boolean topology;
    private boolean projectOntoSurface;
    boolean[] hideVert;
    boolean[] hideFace;
    boolean[] hideEdge;
    boolean[] selected;
    boolean showQuads;
    boolean tolerant;
    private int[] selectionDistance;
    private int maxDistance;
    private int selectMode;
    private int[][] boundary;
    private int[] projectedEdge;
    private int lastSelectedJoint;
    private TextureParameter faceIndexParam;
    private TextureParameter jointWeightParam;
    protected static boolean lastProjectOntoSurface;
    protected static boolean lastTolerant;
    protected static boolean lastShowQuads;

    public TriMeshEditorWindow(EditingWindow parent, String title, ObjectInfo obj, Runnable onClose, boolean allowTopology) {
        super(parent, title, obj);
        this.mesh = (TriangleMesh)this.objInfo.getObject();
        this.hideVert = new boolean[this.mesh.getVertices().length];
        this.onClose = onClose;
        this.topology = allowTopology;
        FormContainer content = new FormContainer(new double[]{0.0, 1.0}, new double[]{1.0, 0.0, 0.0});
        this.setContent(content);
        content.setDefaultLayout(new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.BOTH, null, null));
        this.helpText = new BLabel();
        content.add(this.helpText, 0, 1, 2, 1);
        content.add(this.viewsContainer, 1, 0);
        RowContainer buttons = new RowContainer();
        buttons.add(Translate.button("ok", this, "doOk"));
        buttons.add(Translate.button("cancel", this, "doCancel"));
        content.add(buttons, 0, 2, 2, 1, new LayoutInfo());
        FormContainer toolsContainer = new FormContainer(new double[]{1.0}, new double[]{1.0, 0.0});
        toolsContainer.setDefaultLayout(new LayoutInfo(LayoutInfo.NORTH, LayoutInfo.BOTH));
        content.add(toolsContainer, 0, 0);
        this.tools = new ToolPalette(1, allowTopology ? 11 : 9);
        toolsContainer.add(this.tools, 0, 0);
        this.defaultTool = new ReshapeMeshTool(this, this);
        this.tools.addTool(this.defaultTool);
        this.tools.addTool(new ScaleMeshTool(this, this));
        this.tools.addTool(new RotateMeshTool(this, this, false));
        this.tools.addTool(new SkewMeshTool(this, this));
        this.tools.addTool(new TaperMeshTool(this, this));
        this.tools.addTool(new ThickenMeshTool(this, this));
        MoveScaleRotateMeshTool compoundTool = new MoveScaleRotateMeshTool(this, this);
        this.tools.addTool(compoundTool);
        if (ArtOfIllusion.getPreferences().getUseCompoundMeshTool()) {
            this.defaultTool = compoundTool;
        }
        if (allowTopology) {
            this.tools.addTool(new BevelExtrudeTool(this, this));
            this.tools.addTool(new CreateVertexTool(this, this));
        }
        this.tools.addTool(new SkeletonTool(this, true));
        MoveViewTool metaTool = new MoveViewTool(this);
        this.tools.addTool(metaTool);
        RotateViewTool altTool = new RotateViewTool(this);
        this.tools.addTool(altTool);
        this.tools.setDefaultTool(this.defaultTool);
        this.tools.selectTool(this.defaultTool);
        for (int i = 0; i < this.theView.length; ++i) {
            MeshViewer view = (MeshViewer)this.theView[i];
            view.setMetaTool(metaTool);
            view.setAltTool(altTool);
            view.setScene(parent.getScene(), obj);
            view.setFreehandSelection(lastFreehand);
        }
        this.tolerant = lastTolerant;
        this.projectOntoSurface = lastProjectOntoSurface;
        this.showQuads = lastShowQuads;
        this.modes = new ToolPalette(1, 3);
        toolsContainer.add(this.modes, 0, 1);
        this.modes.addTool(new GenericTool(this, "point", Translate.text("pointSelectionModeTool.tipText")));
        this.modes.addTool(new GenericTool(this, "edge", Translate.text("edgeSelectionModeTool.tipText")));
        this.modes.addTool(new GenericTool(this, "face", Translate.text("faceSelectionModeTool.tipText")));
        this.setSelectionMode(this.modes.getSelection());
        this.createEditMenu((TriangleMesh)obj.getObject());
        this.createMeshMenu((TriangleMesh)obj.getObject());
        this.createSkeletonMenu((TriangleMesh)obj.getObject());
        this.createViewMenu();
        this.recursivelyAddListeners(this);
        UIUtilities.applyDefaultFont(content);
        UIUtilities.applyDefaultBackground(content);
        Rectangle screenBounds = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
        Dimension windowDim = new Dimension(screenBounds.width * 3 / 4, screenBounds.height * 3 / 4);
        this.setBounds(new Rectangle((screenBounds.width - windowDim.width) / 2, (screenBounds.height - windowDim.height) / 2, windowDim.width, windowDim.height));
        this.tools.requestFocus();
        this.selected = new boolean[this.mesh.getVertices().length];
        this.findQuads();
        this.findSelectionDistance();
        this.addExtraParameters();
        this.updateMenus();
    }

    void createEditMenu(TriangleMesh obj) {
        BMenu editMenu = Translate.menu("edit");
        this.menubar.add(editMenu);
        this.editMenuItem = new BMenuItem[7];
        this.undoItem = Translate.menuItem("undo", this, "undoCommand");
        editMenu.add(this.undoItem);
        this.redoItem = Translate.menuItem("redo", this, "redoCommand");
        editMenu.add(this.redoItem);
        editMenu.addSeparator();
        this.editMenuItem[0] = Translate.menuItem("clear", this, "deleteCommand");
        if (this.topology) {
            editMenu.add(this.editMenuItem[0]);
            editMenu.addSeparator();
        }
        editMenu.add(Translate.menuItem("selectAll", this, "selectAllCommand"));
        this.editMenuItem[1] = Translate.menuItem("extendSelection", this, "extendSelectionCommand");
        editMenu.add(this.editMenuItem[1]);
        editMenu.add(Translate.menuItem("invertSelection", this, "invertSelectionCommand"));
        BMenu selectSpecialMenu = Translate.menu("selectSpecial");
        this.selectMenuItem = new BMenuItem[4];
        this.selectMenuItem[0] = Translate.menuItem("selectBoundary", this, "selectObjectBoundaryCommand");
        selectSpecialMenu.add(this.selectMenuItem[0]);
        this.selectMenuItem[1] = Translate.menuItem("selectSelectionBoundary", this, "selectSelectionBoundaryCommand");
        selectSpecialMenu.add(this.selectMenuItem[1]);
        this.selectMenuItem[2] = Translate.menuItem("selectEdgeLoop", this, "selectEdgeLoopCommand");
        selectSpecialMenu.add(this.selectMenuItem[2]);
        this.selectMenuItem[3] = Translate.menuItem("selectEdgeStrip", this, "selectEdgeStripCommand");
        selectSpecialMenu.add(this.selectMenuItem[3]);
        editMenu.add(selectSpecialMenu);
        editMenu.addSeparator();
        this.editMenuItem[2] = Translate.checkboxMenuItem("tolerantSelection", this, "tolerantModeChanged", lastTolerant);
        editMenu.add(this.editMenuItem[2]);
        this.editMenuItem[3] = Translate.checkboxMenuItem("freehandSelection", this, "freehandModeChanged", lastFreehand);
        editMenu.add(this.editMenuItem[3]);
        this.editMenuItem[4] = Translate.checkboxMenuItem("displayAsQuads", this, "quadModeChanged", lastShowQuads);
        editMenu.add(this.editMenuItem[4]);
        this.editMenuItem[5] = Translate.checkboxMenuItem("projectOntoSurface", this, "projectModeChanged", lastProjectOntoSurface);
        editMenu.add(this.editMenuItem[5]);
        editMenu.addSeparator();
        this.editMenuItem[6] = Translate.menuItem("hideSelection", this, "hideSelectionCommand");
        editMenu.add(this.editMenuItem[6]);
        editMenu.add(Translate.menuItem("showAll", this, "showAllCommand"));
        editMenu.addSeparator();
        editMenu.add(Translate.menuItem("meshTension", this, "setTensionCommand"));
    }

    void createMeshMenu(TriangleMesh obj) {
        BMenu meshMenu = Translate.menu("mesh");
        this.menubar.add(meshMenu);
        this.meshMenuItem = new BMenuItem[12];
        this.meshMenuItem[0] = Translate.menuItem("subdivideEdges", this, "subdivideCommand");
        if (this.topology) {
            meshMenu.add(this.meshMenuItem[0]);
        }
        this.meshMenuItem[1] = Translate.menuItem("simplify", this, "simplifyCommand");
        if (this.topology) {
            meshMenu.add(this.meshMenuItem[1]);
        }
        this.meshMenuItem[2] = Translate.menuItem("editPoints", this, "setPointsCommand");
        meshMenu.add(this.meshMenuItem[2]);
        this.meshMenuItem[3] = Translate.menuItem("transformPoints", this, "transformPointsCommand");
        meshMenu.add(this.meshMenuItem[3]);
        this.meshMenuItem[4] = Translate.menuItem("randomize", this, "randomizeCommand");
        meshMenu.add(this.meshMenuItem[4]);
        this.meshMenuItem[5] = Translate.menuItem("bevel", this, "bevelCommand");
        if (this.topology) {
            meshMenu.add(this.meshMenuItem[5]);
        }
        this.meshMenuItem[6] = Translate.menuItem("parameters", this, "setParametersCommand");
        meshMenu.add(this.meshMenuItem[6]);
        if (this.topology) {
            meshMenu.add(Translate.menuItem("optimize", this, "optimizeCommand"));
        }
        meshMenu.add(Translate.menuItem("centerMesh", this, "centerCommand"));
        meshMenu.addSeparator();
        this.meshMenuItem[7] = Translate.menuItem("closeBoundary", this, "closeBoundaryCommand");
        if (this.topology) {
            meshMenu.add(this.meshMenuItem[7]);
        }
        this.meshMenuItem[8] = Translate.menuItem("joinBoundaries", this, "joinBoundariesCommand");
        if (this.topology) {
            meshMenu.add(this.meshMenuItem[8]);
        }
        this.meshMenuItem[9] = Translate.menuItem("extractFaces", this, "extractFacesCommand");
        meshMenu.add(this.meshMenuItem[9]);
        this.meshMenuItem[10] = Translate.menuItem("extractCurve", this, "extractCurveCommand");
        meshMenu.add(this.meshMenuItem[10]);
        meshMenu.addSeparator();
        this.meshMenuItem[11] = Translate.menuItem("smoothness", this, "setSmoothnessCommand");
        meshMenu.add(this.meshMenuItem[11]);
        BMenu smoothMenu = Translate.menu("smoothingMethod");
        meshMenu.add(smoothMenu);
        this.smoothItem = new BCheckBoxMenuItem[4];
        this.smoothItem[0] = Translate.checkboxMenuItem("none", this, "smoothingChanged", obj.getSmoothingMethod() == 0);
        smoothMenu.add(this.smoothItem[0]);
        this.smoothItem[1] = Translate.checkboxMenuItem("shading", this, "smoothingChanged", obj.getSmoothingMethod() == 1);
        smoothMenu.add(this.smoothItem[1]);
        this.smoothItem[2] = Translate.checkboxMenuItem("interpolating", this, "smoothingChanged", obj.getSmoothingMethod() == 2);
        smoothMenu.add(this.smoothItem[2]);
        this.smoothItem[3] = Translate.checkboxMenuItem("approximating", this, "smoothingChanged", obj.getSmoothingMethod() == 3);
        smoothMenu.add(this.smoothItem[3]);
        if (this.topology) {
            meshMenu.add(Translate.menuItem("invertNormals", this, "reverseNormalsCommand"));
        }
    }

    void createSkeletonMenu(TriangleMesh obj) {
        BMenu skeletonMenu = Translate.menu("skeleton");
        this.menubar.add(skeletonMenu);
        this.skeletonMenuItem = new BMenuItem[6];
        this.skeletonMenuItem[0] = Translate.menuItem("editBone", this, "editJointCommand");
        skeletonMenu.add(this.skeletonMenuItem[0]);
        this.skeletonMenuItem[1] = Translate.menuItem("deleteBone", this, "deleteJointCommand");
        skeletonMenu.add(this.skeletonMenuItem[1]);
        this.skeletonMenuItem[2] = Translate.menuItem("setParentBone", this, "setJointParentCommand");
        skeletonMenu.add(this.skeletonMenuItem[2]);
        this.skeletonMenuItem[3] = Translate.menuItem("importSkeleton", this, "importSkeletonCommand");
        skeletonMenu.add(this.skeletonMenuItem[3]);
        skeletonMenu.addSeparator();
        this.skeletonMenuItem[4] = Translate.menuItem("bindSkeleton", this, "bindSkeletonCommand");
        skeletonMenu.add(this.skeletonMenuItem[4]);
        this.skeletonMenuItem[5] = Translate.checkboxMenuItem("detachSkeleton", this, "skeletonDetachedChanged", false);
        skeletonMenu.add(this.skeletonMenuItem[5]);
    }

    protected void loadPreferences() {
        super.loadPreferences();
        lastTolerant = this.preferences.getBoolean("tolerantSelection", lastTolerant);
        lastShowQuads = this.preferences.getBoolean("displayAsQuads", lastShowQuads);
        lastProjectOntoSurface = this.preferences.getBoolean("projectOntoSurface", lastProjectOntoSurface);
    }

    protected void savePreferences() {
        super.savePreferences();
        this.preferences.putBoolean("tolerantSelection", lastTolerant);
        this.preferences.putBoolean("displayAsQuads", lastShowQuads);
        this.preferences.putBoolean("projectOntoSurface", lastProjectOntoSurface);
    }

    public ObjectInfo getObject() {
        return this.objInfo;
    }

    public void setObject(Object3D obj) {
        this.objInfo.setObject(obj);
        this.objInfo.clearCachedMeshes();
    }

    public void setMesh(Mesh mesh) {
        TriangleMesh obj = (TriangleMesh)mesh;
        this.setObject(obj);
        this.mesh = obj;
        this.hideVert = new boolean[mesh.getVertices().length];
        for (int i = 0; i < this.theView.length; ++i) {
            if (this.getSelectionMode() == 0 && this.selected.length != obj.getVertices().length) {
                this.selected = new boolean[obj.getVertices().length];
                ((TriMeshViewer)this.theView[i]).visible = new boolean[obj.getVertices().length];
            }
            if (this.getSelectionMode() == 1 && this.selected.length != obj.getEdges().length) {
                this.selected = new boolean[obj.getEdges().length];
                ((TriMeshViewer)this.theView[i]).visible = new boolean[obj.getEdges().length];
            }
            if (this.getSelectionMode() != 2 || this.selected.length == obj.getFaces().length) continue;
            this.selected = new boolean[obj.getFaces().length];
            ((TriMeshViewer)this.theView[i]).visible = new boolean[obj.getFaces().length];
        }
        if (this.hideFace != null) {
            boolean[] oldHideFace = this.hideFace;
            FaceParameterValue val = (FaceParameterValue)this.getObject().getObject().getParameterValue(this.faceIndexParam);
            double[] param = val.getValue();
            this.hideFace = new boolean[obj.getFaces().length];
            for (int i = 0; i < param.length; ++i) {
                int index = (int)param[i];
                if (index >= oldHideFace.length) continue;
                this.hideFace[i] = oldHideFace[index];
            }
        }
        this.setHiddenFaces(this.hideFace);
        this.updateJointWeightParam();
        this.findSelectionDistance();
        this.boundary = null;
        this.currentTool.getWindow().updateMenus();
    }

    public void objectChanged() {
        super.objectChanged();
        this.findQuads();
    }

    public void setTool(EditingTool tool) {
        if (tool instanceof GenericTool) {
            if (this.selectMode == this.modes.getSelection()) {
                return;
            }
            if (this.undoItem != null) {
                this.setUndoRecord(new UndoRecord(this, false, 15, new Object[]{this, new Integer(this.selectMode), this.selected}));
            }
            this.setSelectionMode(this.modes.getSelection());
            this.theView[this.currentView].getCurrentTool().activate();
        } else {
            for (int i = 0; i < this.theView.length; ++i) {
                this.theView[i].setTool(tool);
            }
            this.currentTool = tool;
        }
    }

    public void updateImage() {
        if (this.lastSelectedJoint != ((MeshViewer)this.theView[this.currentView]).getSelectedJoint()) {
            this.updateJointWeightParam();
        }
        super.updateImage();
    }

    public void updateMenus() {
        int i;
        super.updateMenus();
        TriangleMesh theMesh = (TriangleMesh)this.objInfo.getObject();
        MeshViewer view = (MeshViewer)this.theView[this.currentView];
        boolean any = false;
        for (i = 0; i < this.selected.length && !this.selected[i]; ++i) {
        }
        if (i < this.selected.length) {
            any = true;
            this.editMenuItem[0].setEnabled(true);
            this.editMenuItem[1].setEnabled(true);
            this.editMenuItem[6].setEnabled(true);
            for (i = 0; i < 12; ++i) {
                this.meshMenuItem[i].setEnabled(true);
            }
            if (this.selectMode == 1) {
                this.meshMenuItem[0].setText(Translate.text("menu.subdivideEdges"));
                int[][] boundaryList = this.findSelectedBoundaries();
                this.meshMenuItem[6].setEnabled(false);
                this.meshMenuItem[7].setEnabled(boundaryList.length > 0);
                this.meshMenuItem[8].setEnabled(boundaryList.length == 2);
                this.meshMenuItem[9].setEnabled(false);
            } else if (this.selectMode == 2) {
                this.meshMenuItem[0].setText(Translate.text("menu.subdivideFaces"));
                this.meshMenuItem[7].setEnabled(false);
                this.meshMenuItem[8].setEnabled(false);
                this.meshMenuItem[10].setEnabled(false);
                this.meshMenuItem[11].setEnabled(false);
            } else {
                this.meshMenuItem[0].setEnabled(false);
                this.meshMenuItem[7].setEnabled(false);
                this.meshMenuItem[8].setEnabled(false);
                this.meshMenuItem[9].setEnabled(false);
                this.meshMenuItem[10].setEnabled(false);
            }
            this.meshMenuItem[1].setText(Translate.text("menu.simplify"));
        } else {
            this.editMenuItem[0].setEnabled(false);
            this.editMenuItem[1].setEnabled(false);
            this.editMenuItem[6].setEnabled(false);
            this.meshMenuItem[0].setEnabled(false);
            for (i = 2; i < 12; ++i) {
                this.meshMenuItem[i].setEnabled(false);
            }
            this.meshMenuItem[1].setText(Translate.text("menu.simplifyMesh"));
        }
        this.editMenuItem[5].setEnabled(theMesh.getSmoothingMethod() == 3 || theMesh.getSmoothingMethod() == 2);
        this.selectMenuItem[0].setEnabled(!this.objInfo.getObject().isClosed());
        this.selectMenuItem[1].setEnabled(any);
        this.selectMenuItem[2].setEnabled(any && this.selectMode == 1);
        this.selectMenuItem[3].setEnabled(any && this.selectMode == 1);
        Skeleton s = theMesh.getSkeleton();
        Joint selJoint = s.getJoint(view.getSelectedJoint());
        this.skeletonMenuItem[0].setEnabled(selJoint != null);
        this.skeletonMenuItem[1].setEnabled(selJoint != null && selJoint.children.length == 0);
        this.skeletonMenuItem[2].setEnabled(selJoint != null);
        this.skeletonMenuItem[4].setEnabled(any);
    }

    public boolean[] getHiddenFaces() {
        return this.hideFace;
    }

    public void setHiddenFaces(boolean[] hidden) {
        this.hideFace = hidden;
        this.hideVert = new boolean[this.mesh.getVertices().length];
        if (this.hideFace != null) {
            for (int i = 0; i < this.hideVert.length; ++i) {
                this.hideVert[i] = true;
            }
            TriangleMesh.Face[] face = this.mesh.getFaces();
            for (int i = 0; i < face.length; ++i) {
                if (this.hideFace[i]) continue;
                this.hideVert[face[i].v3] = false;
                this.hideVert[face[i].v2] = false;
                this.hideVert[face[i].v1] = false;
            }
        } else {
            for (int i = 0; i < this.hideVert.length; ++i) {
                this.hideVert[i] = false;
            }
        }
        FaceParameterValue val = (FaceParameterValue)this.objInfo.getObject().getParameterValue(this.faceIndexParam);
        double[] param = val.getValue();
        for (int i = 0; i < param.length; ++i) {
            param[i] = i;
        }
        val.setValue(param);
        this.objInfo.getObject().setParameterValue(this.faceIndexParam, val);
        this.objInfo.clearCachedMeshes();
        this.findQuads();
        this.updateImage();
    }

    private void addExtraParameters() {
        if (this.faceIndexParam != null) {
            return;
        }
        this.faceIndexParam = new TextureParameter(this, "Face Index", 0.0, Double.MAX_VALUE, 0.0);
        this.jointWeightParam = new TextureParameter(this, "Joint Weight", 0.0, 1.0, 0.0);
        TriangleMesh mesh = (TriangleMesh)this.getObject().getObject();
        TextureParameter[] params = mesh.getParameters();
        TextureParameter[] newparams = new TextureParameter[params.length + 2];
        ParameterValue[] values = mesh.getParameterValues();
        ParameterValue[] newvalues = new ParameterValue[values.length + 2];
        for (int i = 0; i < params.length; ++i) {
            newparams[i] = params[i];
            newvalues[i] = values[i];
        }
        newparams[params.length] = this.faceIndexParam;
        newvalues[values.length] = new FaceParameterValue(mesh, this.faceIndexParam);
        double[] faceIndex = new double[mesh.getFaces().length];
        for (int i = 0; i < faceIndex.length; ++i) {
            faceIndex[i] = i;
        }
        ((FaceParameterValue)newvalues[values.length]).setValue(faceIndex);
        newparams[params.length + 1] = this.jointWeightParam;
        newvalues[values.length + 1] = new VertexParameterValue(mesh, this.jointWeightParam);
        mesh.setParameters(newparams);
        mesh.setParameterValues(newvalues);
        this.getObject().clearCachedMeshes();
        this.updateJointWeightParam();
    }

    public void removeExtraParameters() {
        if (this.faceIndexParam == null) {
            return;
        }
        this.faceIndexParam = null;
        this.jointWeightParam = null;
        TriangleMesh mesh = (TriangleMesh)this.getObject().getObject();
        TextureParameter[] params = mesh.getParameters();
        TextureParameter[] newparams = new TextureParameter[params.length - 2];
        ParameterValue[] values = mesh.getParameterValues();
        ParameterValue[] newvalues = new ParameterValue[values.length - 2];
        for (int i = 0; i < newparams.length; ++i) {
            newparams[i] = params[i];
            newvalues[i] = values[i];
        }
        mesh.setParameters(newparams);
        mesh.setParameterValues(newvalues);
        this.getObject().clearCachedMeshes();
    }

    private void updateJointWeightParam() {
        MeshVertex[] vert = this.mesh.getVertices();
        double[] jointWeight = new double[vert.length];
        int selJointId = ((MeshViewer)this.theView[this.currentView]).getSelectedJoint();
        Joint selJoint = this.getObject().getSkeleton().getJoint(selJointId);
        for (int i = 0; i < jointWeight.length; ++i) {
            Joint vertJoint = this.getObject().getSkeleton().getJoint(vert[i].ikJoint);
            jointWeight[i] = selJoint == null ? 0.0 : (vert[i].ikJoint == selJointId ? (selJoint.parent == null ? 1.0 : vert[i].ikWeight) : (vertJoint != null && vertJoint.parent == selJoint ? 1.0 - vert[i].ikWeight : 0.0));
        }
        VertexParameterValue value = (VertexParameterValue)this.getObject().getObject().getParameterValue(this.jointWeightParam);
        value.setValue(jointWeight);
        this.getObject().getObject().setParameterValues(this.getObject().getObject().getParameterValues());
        this.lastSelectedJoint = selJointId;
        this.objInfo.clearCachedMeshes();
    }

    public TextureParameter getFaceIndexParameter() {
        return this.faceIndexParam;
    }

    public TextureParameter getJointWeightParam() {
        return this.jointWeightParam;
    }

    public boolean getProjectOntoSurface() {
        return this.projectOntoSurface;
    }

    public void setProjectOntoSurface(boolean project) {
        lastProjectOntoSurface = this.projectOntoSurface = project;
        this.savePreferences();
    }

    int[] findProjectedEdges() {
        if (!this.getProjectOntoSurface() || this.mesh.getSmoothingMethod() != 3 && this.mesh.getSmoothingMethod() != 2) {
            this.lastPreview = null;
            return null;
        }
        RenderingMesh preview = this.getObject().getPreviewMesh();
        if (preview == this.lastPreview) {
            return this.projectedEdge;
        }
        this.lastPreview = preview;
        this.divMesh = this.mesh.convertToTriangleMesh(ArtOfIllusion.getPreferences().getInteractiveSurfaceError());
        TriangleMesh.Edge[] divEdge = this.divMesh.getEdges();
        double[] param = ((FaceParameterValue)this.divMesh.getParameterValue(this.getFaceIndexParameter())).getValue();
        this.projectedEdge = new int[divEdge.length];
        TriangleMesh.Edge[] e = this.mesh.getEdges();
        TriangleMesh.Face[] face = this.mesh.getFaces();
        int[] specialEdge = null;
        int numSpecial = 0;
        for (int i = 0; i < divEdge.length; ++i) {
            int f2;
            this.projectedEdge[i] = -1;
            int f1 = (int)param[divEdge[i].f1];
            int n = f2 = divEdge[i].f2 == -1 ? -1 : (int)param[divEdge[i].f2];
            if (f1 == f2) continue;
            if (f2 != -1) {
                this.projectedEdge[i] = face[f1].getSharedFace(face[f2]);
                continue;
            }
            int boundaryCount = 0;
            TriangleMesh.Face f = face[f1];
            if (e[f.e1].f2 == -1) {
                this.projectedEdge[i] = f.e1;
                ++boundaryCount;
            }
            if (e[f.e2].f2 == -1) {
                this.projectedEdge[i] = f.e2;
                ++boundaryCount;
            }
            if (e[f.e3].f2 == -1) {
                this.projectedEdge[i] = f.e3;
                ++boundaryCount;
            }
            if (boundaryCount == 1) continue;
            if (specialEdge == null) {
                specialEdge = new int[divEdge.length];
            }
            specialEdge[numSpecial++] = i;
            this.projectedEdge[i] = -1;
        }
        if (numSpecial > 0) {
            int numOriginalVert = this.mesh.getVertices().length;
            MeshVertex[] divVert = this.divMesh.getVertices();
            for (int i = 0; i < numSpecial; ++i) {
                int[] vertEdges;
                int currentVert;
                int v1;
                if (this.projectedEdge[specialEdge[i]] > -1) continue;
                TriangleMesh.Edge thisEdge = divEdge[specialEdge[i]];
                if (thisEdge.v1 < numOriginalVert) {
                    v1 = thisEdge.v1;
                    currentVert = thisEdge.v2;
                } else {
                    if (thisEdge.v2 >= numOriginalVert) continue;
                    v1 = thisEdge.v2;
                    currentVert = thisEdge.v1;
                }
                ArrayList<Integer> sequential = new ArrayList<Integer>();
                int currentEdge = specialEdge[i];
                int v2 = -1;
                while (true) {
                    sequential.add(currentEdge);
                    if (thisEdge.v1 != v1 && thisEdge.v1 < numOriginalVert) {
                        v2 = thisEdge.v1;
                        break;
                    }
                    if (thisEdge.v2 != v1 && thisEdge.v2 < numOriginalVert) {
                        v2 = thisEdge.v2;
                        break;
                    }
                    vertEdges = ((TriangleMesh.Vertex)divVert[currentVert]).getEdges();
                    currentEdge = vertEdges[0] != currentEdge ? vertEdges[0] : vertEdges[vertEdges.length - 1];
                    thisEdge = divEdge[currentEdge];
                    currentVert = thisEdge.v1 == currentVert ? thisEdge.v2 : thisEdge.v1;
                }
                vertEdges = ((TriangleMesh.Vertex)this.mesh.getVertices()[v1]).getEdges();
                TriangleMesh.Edge first = e[vertEdges[0]];
                int originalEdge = first.v1 == v2 || first.v2 == v2 ? vertEdges[0] : vertEdges[vertEdges.length - 1];
                for (int j = 0; j < sequential.size(); ++j) {
                    this.projectedEdge[((Integer)sequential.get((int)j)).intValue()] = originalEdge;
                }
            }
        }
        return this.projectedEdge;
    }

    TriangleMesh getSubdividedMesh() {
        return this.divMesh;
    }

    protected void doOk() {
        TriangleMesh theMesh = (TriangleMesh)this.objInfo.getObject();
        if (((TriangleMesh)this.oldMesh).getMaterial() != null) {
            if (!theMesh.isClosed()) {
                String[] options = new String[]{Translate.text("button.ok"), Translate.text("button.cancel")};
                BStandardDialog dlg = new BStandardDialog("", UIUtilities.breakString(Translate.text("surfaceNoLongerClosed")), BStandardDialog.WARNING);
                int choice = dlg.showOptionDialog(this, options, options[0]);
                if (choice == 1) {
                    return;
                }
                theMesh.setMaterial(null, null);
            } else {
                theMesh.setMaterial(((TriangleMesh)this.oldMesh).getMaterial(), ((TriangleMesh)this.oldMesh).getMaterialMapping());
            }
        }
        this.removeExtraParameters();
        this.oldMesh.copyObject(theMesh);
        this.oldMesh = null;
        this.dispose();
        if (this.onClose != null) {
            this.onClose.run();
        }
        this.parentWindow.updateImage();
        this.parentWindow.updateMenus();
    }

    public boolean isTolerant() {
        return this.tolerant;
    }

    public void setTolerant(boolean tol) {
        lastTolerant = this.tolerant = tol;
        this.savePreferences();
    }

    public boolean isQuadMode() {
        return this.showQuads;
    }

    public void setQuadMode(boolean quads) {
        lastShowQuads = this.showQuads = quads;
        this.findQuads();
        this.findSelectionDistance();
        this.savePreferences();
    }

    public boolean isEdgeHidden(int which) {
        return this.hideEdge[which];
    }

    private void findQuads() {
        int i;
        int i2;
        TriangleMesh mesh = (TriangleMesh)this.getObject().getObject();
        TriangleMesh.Vertex[] v = (TriangleMesh.Vertex[])mesh.getVertices();
        TriangleMesh.Edge[] e = mesh.getEdges();
        TriangleMesh.Face[] f = mesh.getFaces();
        if (this.hideEdge == null || this.hideEdge.length != e.length) {
            this.hideEdge = new boolean[e.length];
        }
        if (this.hideFace == null) {
            for (i2 = 0; i2 < e.length; ++i2) {
                this.hideEdge[i2] = false;
            }
        } else {
            for (i2 = 0; i2 < e.length; ++i2) {
                this.hideEdge[i2] = this.hideFace[e[i2].f1] && (e[i2].f2 == -1 || this.hideFace[e[i2].f2]);
            }
        }
        if (!this.showQuads) {
            return;
        }
        boolean[] candidate = new boolean[e.length];
        Vec3[] norm = new Vec3[f.length];
        for (i = 0; i < f.length; ++i) {
            TriangleMesh.Face fc = f[i];
            norm[i] = v[fc.v2].r.minus(v[fc.v1].r).cross(v[fc.v3].r.minus(v[fc.v1].r));
            double length = norm[i].length();
            if (!(length > 0.0)) continue;
            norm[i].scale(1.0 / length);
        }
        for (i = 0; i < e.length; ++i) {
            candidate[i] = e[i].f2 != -1 && norm[e[i].f1].dot(norm[e[i].f2]) > 0.99;
        }
        class EdgeScore
        implements Comparable {
            public int edge;
            public double score;

            public EdgeScore(int edge, double score) {
                this.edge = edge;
                this.score = score;
            }

            public int compareTo(Object o) {
                double diff = this.score - ((EdgeScore)o).score;
                if (diff < 0.0) {
                    return -1;
                }
                if (diff > 0.0) {
                    return 1;
                }
                return 0;
            }
        }
        Vector<EdgeScore> scoreVec = new Vector<EdgeScore>(e.length);
        Vec3 temp0 = new Vec3();
        Vec3 temp1 = new Vec3();
        Vec3 temp2 = new Vec3();
        for (int i3 = 0; i3 < e.length; ++i3) {
            if (!candidate[i3]) continue;
            TriangleMesh.Edge ed = e[i3];
            int v1 = ed.v1;
            int v2 = ed.v2;
            TriangleMesh.Face fc = f[ed.f1];
            int v3 = fc.v1 != v1 && fc.v1 != v2 ? fc.v1 : (fc.v2 != v1 && fc.v2 != v2 ? fc.v2 : fc.v3);
            fc = f[ed.f2];
            int v4 = fc.v1 != v1 && fc.v1 != v2 ? fc.v1 : (fc.v2 != v1 && fc.v2 != v2 ? fc.v2 : fc.v3);
            temp0.set(v[v1].r.minus(v[v2].r));
            temp0.normalize();
            temp1.set(v[v1].r.minus(v[v3].r));
            temp1.normalize();
            temp2.set(v[v1].r.minus(v[v4].r));
            temp2.normalize();
            if (Math.acos(temp0.dot(temp1)) + Math.acos(temp0.dot(temp2)) > Math.PI) continue;
            double dot = temp1.dot(temp2);
            double score = dot > 0.0 ? dot : -dot;
            temp1.set(v[v2].r.minus(v[v3].r));
            temp1.normalize();
            temp2.set(v[v2].r.minus(v[v4].r));
            temp2.normalize();
            if (Math.acos(-temp0.dot(temp1)) + Math.acos(-temp0.dot(temp2)) > Math.PI) continue;
            dot = temp1.dot(temp2);
            scoreVec.addElement(new EdgeScore(i3, score += dot > 0.0 ? dot : -dot));
        }
        if (scoreVec.size() == 0) {
            return;
        }
        Object[] score = new EdgeScore[scoreVec.size()];
        scoreVec.copyInto(score);
        Arrays.sort(score);
        boolean[] hasHiddenEdge = new boolean[f.length];
        for (int i4 = 0; i4 < score.length; ++i4) {
            TriangleMesh.Edge ed = e[((EdgeScore)score[i4]).edge];
            if (hasHiddenEdge[ed.f1] || hasHiddenEdge[ed.f2]) continue;
            this.hideEdge[((EdgeScore)score[i4]).edge] = true;
            hasHiddenEdge[ed.f2] = true;
            hasHiddenEdge[ed.f1] = true;
        }
    }

    public void setSelectionMode(int mode) {
        boolean[] newSel;
        TriangleMesh mesh = (TriangleMesh)this.getObject().getObject();
        TriangleMesh.Vertex[] v = (TriangleMesh.Vertex[])mesh.getVertices();
        TriangleMesh.Edge[] e = mesh.getEdges();
        TriangleMesh.Face[] f = mesh.getFaces();
        if (mode == this.selectMode) {
            return;
        }
        if (mode == 0) {
            newSel = new boolean[v.length];
            if (this.selectMode == 1) {
                for (int i = 0; i < e.length; ++i) {
                    if (!this.selected[i]) continue;
                    newSel[e[i].v2] = true;
                    newSel[e[i].v1] = true;
                }
            } else {
                for (int i = 0; i < f.length; ++i) {
                    if (!this.selected[i]) continue;
                    newSel[f[i].v3] = true;
                    newSel[f[i].v2] = true;
                    newSel[f[i].v1] = true;
                }
            }
        } else if (mode == 1) {
            newSel = new boolean[e.length];
            if (this.selectMode == 0) {
                if (this.tolerant) {
                    for (int i = 0; i < e.length; ++i) {
                        newSel[i] = !this.hideEdge[i] && (this.selected[e[i].v1] || this.selected[e[i].v2]);
                    }
                } else {
                    for (int i = 0; i < e.length; ++i) {
                        newSel[i] = !this.hideEdge[i] && this.selected[e[i].v1] && this.selected[e[i].v2];
                    }
                }
            } else {
                for (int i = 0; i < f.length; ++i) {
                    if (!this.selected[i]) continue;
                    newSel[f[i].e3] = true;
                    newSel[f[i].e2] = true;
                    newSel[f[i].e1] = true;
                }
            }
        } else {
            newSel = new boolean[f.length];
            if (this.selectMode == 0) {
                if (this.tolerant) {
                    for (int i = 0; i < f.length; ++i) {
                        newSel[i] = this.selected[f[i].v1] || this.selected[f[i].v2] || this.selected[f[i].v3];
                    }
                } else {
                    for (int i = 0; i < f.length; ++i) {
                        newSel[i] = this.selected[f[i].v1] && this.selected[f[i].v2] && this.selected[f[i].v3];
                    }
                }
            } else {
                for (int i = 0; i < f.length; ++i) {
                    newSel[i] = this.selected[f[i].e1] && this.selected[f[i].e2] && this.selected[f[i].e3];
                }
            }
        }
        this.selectMode = mode;
        this.setSelection(newSel);
        if (this.modes.getSelection() != mode) {
            this.modes.selectTool(this.modes.getTool(mode));
        }
    }

    public int getSelectionMode() {
        return this.selectMode;
    }

    public void setSelection(boolean[] sel) {
        this.selected = sel;
        this.findSelectionDistance();
        this.updateMenus();
        for (ViewerCanvas view : this.theView) {
            view.repaint();
        }
    }

    public boolean[] getSelection() {
        return this.selected;
    }

    public int[] getSelectionDistance() {
        if (this.maxDistance != this.getTensionDistance()) {
            this.findSelectionDistance();
        }
        return this.selectionDistance;
    }

    void findSelectionDistance() {
        int i;
        TriangleMesh mesh = (TriangleMesh)this.getObject().getObject();
        int[] dist = new int[mesh.getVertices().length];
        TriangleMesh.Edge[] e = mesh.getEdges();
        TriangleMesh.Face[] f = mesh.getFaces();
        this.maxDistance = this.getTensionDistance();
        if (this.selectMode == 0) {
            for (i = 0; i < dist.length; ++i) {
                dist[i] = this.selected[i] ? 0 : -1;
            }
        } else if (this.selectMode == 1) {
            for (i = 0; i < dist.length; ++i) {
                dist[i] = -1;
            }
            for (i = 0; i < this.selected.length; ++i) {
                if (!this.selected[i]) continue;
                dist[e[i].v2] = 0;
                dist[e[i].v1] = 0;
            }
        } else {
            for (i = 0; i < dist.length; ++i) {
                dist[i] = -1;
            }
            for (i = 0; i < this.selected.length; ++i) {
                if (!this.selected[i]) continue;
                dist[f[i].v3] = 0;
                dist[f[i].v2] = 0;
                dist[f[i].v1] = 0;
            }
        }
        for (i = 0; i < this.maxDistance; ++i) {
            for (int j = 0; j < e.length; ++j) {
                if (this.hideEdge[j]) continue;
                if (dist[e[j].v1] == -1 && dist[e[j].v2] == i) {
                    dist[e[j].v1] = i + 1;
                    continue;
                }
                if (dist[e[j].v2] != -1 || dist[e[j].v1] != i) continue;
                dist[e[j].v2] = i + 1;
            }
        }
        this.selectionDistance = dist;
    }

    protected void doCancel() {
        this.oldMesh = null;
        this.dispose();
    }

    private void tolerantModeChanged() {
        this.setTolerant(((BCheckBoxMenuItem)this.editMenuItem[2]).getState());
    }

    private void freehandModeChanged() {
        this.setFreehand(((BCheckBoxMenuItem)this.editMenuItem[3]).getState());
    }

    private void quadModeChanged() {
        this.setQuadMode(((BCheckBoxMenuItem)this.editMenuItem[4]).getState());
        this.updateImage();
    }

    private void projectModeChanged() {
        this.setProjectOntoSurface(((BCheckBoxMenuItem)this.editMenuItem[5]).getState());
        this.updateImage();
    }

    private void smoothingChanged(CommandEvent ev) {
        Widget source = ev.getWidget();
        for (int i = 0; i < this.smoothItem.length; ++i) {
            if (source != this.smoothItem[i]) continue;
            this.setSmoothingMethod(i);
        }
    }

    private void skeletonDetachedChanged() {
        for (int i = 0; i < this.theView.length; ++i) {
            ((TriMeshViewer)this.theView[i]).setSkeletonDetached(((BCheckBoxMenuItem)this.skeletonMenuItem[5]).getState());
        }
    }

    public void bindSkeletonCommand() {
        super.bindSkeletonCommand();
        this.updateJointWeightParam();
        this.updateImage();
    }

    public void setPointsCommand() {
        super.setPointsCommand();
        this.updateJointWeightParam();
        this.updateImage();
    }

    public void selectAllCommand() {
        int i;
        this.setUndoRecord(new UndoRecord(this, false, 15, new Object[]{this, new Integer(this.selectMode), this.selected.clone()}));
        for (i = 0; i < this.selected.length; ++i) {
            this.selected[i] = true;
        }
        if (this.selectMode == 1) {
            for (i = 0; i < this.selected.length; ++i) {
                if (!this.isEdgeHidden(i)) continue;
                this.selected[i] = false;
            }
        }
        this.setSelection(this.selected);
    }

    public void hideSelectionCommand() {
        int i;
        TriangleMesh theMesh = (TriangleMesh)this.objInfo.getObject();
        boolean[] hide = new boolean[theMesh.getFaces().length];
        if (this.selectMode == 2) {
            System.arraycopy(this.selected, 0, hide, 0, this.selected.length);
        } else if (this.selectMode == 1) {
            TriangleMesh.Edge[] edge = theMesh.getEdges();
            for (i = 0; i < this.selected.length; ++i) {
                if (!this.selected[i]) continue;
                hide[edge[i].f2] = true;
                hide[edge[i].f1] = true;
            }
        } else {
            TriangleMesh.Face[] face = theMesh.getFaces();
            for (i = 0; i < face.length; ++i) {
                hide[i] = this.selected[face[i].v1] || this.selected[face[i].v2] || this.selected[face[i].v3];
            }
        }
        boolean[] wasHidden = this.hideFace;
        if (wasHidden != null) {
            for (i = 0; i < wasHidden.length; ++i) {
                if (!wasHidden[i]) continue;
                hide[i] = true;
            }
        }
        this.setHiddenFaces(hide);
        for (i = 0; i < this.selected.length; ++i) {
            this.selected[i] = false;
        }
        this.setSelection(this.selected);
    }

    public void showAllCommand() {
        this.setHiddenFaces(null);
    }

    public void selectObjectBoundaryCommand() {
        TriangleMesh theMesh = (TriangleMesh)this.objInfo.getObject();
        TriangleMesh.Edge[] edge = theMesh.getEdges();
        boolean[] newSel = new boolean[edge.length];
        for (int i = 0; i < newSel.length; ++i) {
            newSel[i] = edge[i].f2 == -1;
        }
        this.setUndoRecord(new UndoRecord(this, false, 15, new Object[]{this, new Integer(this.selectMode), this.selected}));
        this.setSelectionMode(1);
        this.setSelection(newSel);
    }

    public void selectSelectionBoundaryCommand() {
        boolean[] newSel = TriMeshSelectionUtilities.findSelectionBoundary(this.mesh, this.selectMode, this.selected);
        this.setUndoRecord(new UndoRecord(this, false, 15, new Object[]{this, new Integer(this.selectMode), this.selected}));
        this.setSelectionMode(1);
        this.setSelection(newSel);
    }

    public void invertSelectionCommand() {
        boolean[] newSel = new boolean[this.selected.length];
        for (int i = 0; i < newSel.length; ++i) {
            newSel[i] = !this.selected[i];
        }
        this.setUndoRecord(new UndoRecord(this, false, 15, new Object[]{this, new Integer(this.selectMode), this.selected}));
        this.setSelection(newSel);
    }

    public void selectEdgeLoopCommand() {
        boolean[] newSel = TriMeshSelectionUtilities.findEdgeLoops(this.mesh, this.selected);
        if (newSel == null) {
            new BStandardDialog("", UIUtilities.breakString(Translate.text("cannotFindEdgeLoop")), BStandardDialog.ERROR).showMessageDialog(this);
            return;
        }
        this.setUndoRecord(new UndoRecord(this, false, 15, new Object[]{this, new Integer(this.selectMode), this.selected}));
        this.setSelection(newSel);
    }

    public void selectEdgeStripCommand() {
        boolean[] newSel = TriMeshSelectionUtilities.findEdgeStrips(this.mesh, this.selected);
        if (newSel == null) {
            new BStandardDialog("", UIUtilities.breakString(Translate.text("cannotFindEdgeStrip")), BStandardDialog.ERROR).showMessageDialog(this);
            return;
        }
        this.setUndoRecord(new UndoRecord(this, false, 15, new Object[]{this, new Integer(this.selectMode), this.selected}));
        this.setSelection(newSel);
    }

    public void extendSelectionCommand() {
        int i;
        TriangleMesh theMesh = (TriangleMesh)this.objInfo.getObject();
        int[] dist = this.getSelectionDistance();
        boolean[] selectedVert = new boolean[dist.length];
        TriangleMesh.Edge[] edge = theMesh.getEdges();
        this.setUndoRecord(new UndoRecord(this, false, 15, new Object[]{this, new Integer(this.selectMode), this.selected.clone()}));
        for (i = 0; i < edge.length; ++i) {
            if (dist[edge[i].v1] != 0 && dist[edge[i].v2] != 0 || this.isEdgeHidden(i)) continue;
            selectedVert[edge[i].v2] = true;
            selectedVert[edge[i].v1] = true;
        }
        if (this.selectMode == 0) {
            this.setSelection(selectedVert);
        } else if (this.selectMode == 1) {
            for (i = 0; i < edge.length; ++i) {
                this.selected[i] = selectedVert[edge[i].v1] && selectedVert[edge[i].v2];
            }
            this.setSelection(this.selected);
        } else {
            TriangleMesh.Face[] face = theMesh.getFaces();
            for (int i2 = 0; i2 < face.length; ++i2) {
                this.selected[i2] = selectedVert[face[i2].v1] && selectedVert[face[i2].v2] && selectedVert[face[i2].v3];
            }
            this.setSelection(this.selected);
        }
    }

    public void deleteCommand() {
        int i;
        int i2;
        int i3;
        if (!this.topology) {
            return;
        }
        TriangleMesh theMesh = (TriangleMesh)this.objInfo.getObject();
        TriangleMesh.Vertex[] vert = (TriangleMesh.Vertex[])theMesh.getVertices();
        TriangleMesh.Edge[] edge = theMesh.getEdges();
        TriangleMesh.Face[] face = theMesh.getFaces();
        boolean[] deleteVert = new boolean[vert.length];
        boolean[] deleteFace = new boolean[face.length];
        if (this.selectMode == 0) {
            for (i3 = 0; i3 < deleteVert.length; ++i3) {
                deleteVert[i3] = this.selected[i3];
            }
            for (i3 = 0; i3 < deleteFace.length; ++i3) {
                deleteFace[i3] = deleteVert[face[i3].v1] || deleteVert[face[i3].v2] || deleteVert[face[i3].v3];
            }
        } else if (this.selectMode == 1) {
            for (i3 = 0; i3 < deleteFace.length; ++i3) {
                deleteFace[i3] = this.selected[face[i3].e1] || this.selected[face[i3].e2] || this.selected[face[i3].e3];
            }
            for (i3 = 0; i3 < deleteVert.length; ++i3) {
                deleteVert[i3] = true;
            }
            for (i3 = 0; i3 < deleteFace.length; ++i3) {
                if (deleteFace[i3]) continue;
                deleteVert[face[i3].v3] = false;
                deleteVert[face[i3].v2] = false;
                deleteVert[face[i3].v1] = false;
            }
        } else {
            for (i3 = 0; i3 < deleteFace.length; ++i3) {
                deleteFace[i3] = this.selected[i3];
            }
            for (i3 = 0; i3 < deleteVert.length; ++i3) {
                deleteVert[i3] = true;
            }
            for (i3 = 0; i3 < deleteFace.length; ++i3) {
                if (deleteFace[i3]) continue;
                deleteVert[face[i3].v3] = false;
                deleteVert[face[i3].v2] = false;
                deleteVert[face[i3].v1] = false;
            }
        }
        for (i3 = 0; i3 < vert.length; ++i3) {
            int[] e = vert[i3].getEdges();
            int fprev = edge[e[0]].f1;
            int breaks = 0;
            for (int j = 1; j < e.length; ++j) {
                int f;
                int n = f = edge[e[j]].f1 == fprev ? edge[e[j]].f2 : edge[e[j]].f1;
                if (f == -1) break;
                if (!deleteFace[fprev] && deleteFace[f]) {
                    ++breaks;
                }
                fprev = f;
            }
            if (!deleteFace[fprev] && (edge[e[0]].f2 == -1 || deleteFace[edge[e[0]].f1])) {
                ++breaks;
            }
            int[] vertFaceCount = new int[vert.length];
            for (int j = 0; j < face.length; ++j) {
                if (deleteFace[j]) continue;
                int n = face[j].v1;
                vertFaceCount[n] = vertFaceCount[n] + 1;
                int n2 = face[j].v2;
                vertFaceCount[n2] = vertFaceCount[n2] + 1;
                int n3 = face[j].v3;
                vertFaceCount[n3] = vertFaceCount[n3] + 1;
            }
            boolean strayVert = false;
            for (int j = 0; j < vertFaceCount.length; ++j) {
                if (deleteVert[j] || vertFaceCount[j] != 0) continue;
                strayVert = true;
            }
            if (breaks <= 1 && !strayVert) continue;
            new BStandardDialog("", UIUtilities.breakString(Translate.text("illegalDelete")), BStandardDialog.ERROR).showMessageDialog(this);
            return;
        }
        int newVertCount = 0;
        int newFaceCount = 0;
        int[] newVertIndex = new int[vert.length];
        for (i2 = 0; i2 < deleteVert.length; ++i2) {
            newVertIndex[i2] = -1;
            if (deleteVert[i2]) continue;
            ++newVertCount;
        }
        for (i2 = 0; i2 < deleteFace.length; ++i2) {
            if (deleteFace[i2]) continue;
            ++newFaceCount;
        }
        TriangleMesh.Vertex[] v = new TriangleMesh.Vertex[newVertCount];
        int[][] f = new int[newFaceCount][];
        newVertCount = 0;
        for (i = 0; i < vert.length; ++i) {
            if (deleteVert[i]) continue;
            newVertIndex[i] = newVertCount;
            v[newVertCount++] = vert[i];
        }
        newFaceCount = 0;
        for (i = 0; i < face.length; ++i) {
            if (deleteFace[i]) continue;
            f[newFaceCount++] = new int[]{newVertIndex[face[i].v1], newVertIndex[face[i].v2], newVertIndex[face[i].v3]};
        }
        ParameterValue[] oldParamVal = theMesh.getParameterValues();
        ParameterValue[] newParamVal = new ParameterValue[oldParamVal.length];
        for (int i4 = 0; i4 < oldParamVal.length; ++i4) {
            int j;
            int k;
            Object newval;
            double[] oldval;
            if (oldParamVal[i4] instanceof VertexParameterValue) {
                oldval = ((VertexParameterValue)oldParamVal[i4]).getValue();
                newval = new double[newVertCount];
                k = 0;
                for (j = 0; j < oldval.length; ++j) {
                    if (deleteVert[j]) continue;
                    newval[k++] = oldval[j];
                }
                newParamVal[i4] = new VertexParameterValue((double[])newval);
                continue;
            }
            if (oldParamVal[i4] instanceof FaceParameterValue) {
                oldval = ((FaceParameterValue)oldParamVal[i4]).getValue();
                newval = new double[newFaceCount];
                k = 0;
                for (j = 0; j < oldval.length; ++j) {
                    if (deleteFace[j]) continue;
                    newval[k++] = oldval[j];
                }
                newParamVal[i4] = new FaceParameterValue((double[])newval);
                continue;
            }
            if (oldParamVal[i4] instanceof FaceVertexParameterValue) {
                FaceVertexParameterValue fvpv = (FaceVertexParameterValue)oldParamVal[i4];
                newval = new double[newFaceCount][3];
                k = 0;
                for (j = 0; j < fvpv.getFaceCount(); ++j) {
                    if (deleteFace[j]) continue;
                    newval[k][0] = fvpv.getValue(j, 0);
                    newval[k][1] = fvpv.getValue(j, 1);
                    newval[k][2] = fvpv.getValue(j, 2);
                    ++k;
                }
                newParamVal[i4] = new FaceVertexParameterValue((double[][])newval);
                continue;
            }
            newParamVal[i4] = oldParamVal[i4].duplicate();
        }
        TriangleMesh newmesh = new TriangleMesh(v, (int[][])f);
        TriangleMesh.Edge[] newedge = newmesh.getEdges();
        newmesh.getSkeleton().copy(theMesh.getSkeleton());
        newmesh.copyTextureAndMaterial(theMesh);
        newmesh.setSmoothingMethod(theMesh.getSmoothingMethod());
        newmesh.setParameterValues(newParamVal);
        for (int i5 = 0; i5 < edge.length; ++i5) {
            int r1 = newVertIndex[edge[i5].v1];
            int r2 = newVertIndex[edge[i5].v2];
            for (int j = 0; j < newedge.length; ++j) {
                if ((r1 != newedge[j].v1 || r2 != newedge[j].v2) && (r1 != newedge[j].v2 || r2 != newedge[j].v1)) continue;
                newedge[j].smoothness = edge[i5].smoothness;
            }
        }
        this.setUndoRecord(new UndoRecord(this, false, 0, new Object[]{newmesh, theMesh}));
        this.setMesh(newmesh);
        this.updateImage();
    }

    public void subdivideCommand() {
        int i;
        TriangleMesh theMesh = (TriangleMesh)this.objInfo.getObject();
        if (this.selectMode != 1 && this.selectMode != 2) {
            return;
        }
        for (i = 0; !this.selected[i] && i < this.selected.length; ++i) {
        }
        if (i == this.selected.length) {
            return;
        }
        if (this.selectMode == 1) {
            i = theMesh.getVertices().length;
            TriangleMesh newmesh = theMesh.getSmoothingMethod() == 3 ? TriangleMesh.subdivideLoop(theMesh, this.selected, Double.MAX_VALUE) : (theMesh.getSmoothingMethod() == 2 ? TriangleMesh.subdivideButterfly(theMesh, this.selected, Double.MAX_VALUE) : TriangleMesh.subdivideLinear(theMesh, this.selected));
            this.setUndoRecord(new UndoRecord(this, false, 0, new Object[]{newmesh, theMesh}));
            this.setMesh(newmesh);
            TriangleMesh.Edge[] edges = newmesh.getEdges();
            boolean[] newselection = new boolean[edges.length];
            for (int j = 0; j < edges.length; ++j) {
                newselection[j] = edges[j].v1 >= i || edges[j].v2 >= i;
            }
            this.setSelection(newselection);
        } else {
            i = theMesh.getVertices().length;
            TriangleMesh newmesh = TriangleMesh.subdivideFaces(theMesh, this.selected);
            this.setUndoRecord(new UndoRecord(this, false, 0, new Object[]{newmesh, theMesh}));
            this.setMesh(newmesh);
            TriangleMesh.Face[] faces = newmesh.getFaces();
            boolean[] newselection = new boolean[faces.length];
            for (int j = 0; j < faces.length; ++j) {
                newselection[j] = faces[j].v1 >= i || faces[j].v2 >= i || faces[j].v3 >= i;
            }
            this.setSelection(newselection);
        }
    }

    public void simplifyCommand() {
        int i;
        boolean[] newSel;
        TriangleMesh.Edge[] e;
        TriangleMesh theMesh = (TriangleMesh)this.objInfo.getObject();
        boolean[] selection = this.selected;
        ValueField errorField = new ValueField(0.01, 1);
        ComponentsDialog dlg = new ComponentsDialog(this, Translate.text("simplifyMeshTitle"), new Widget[]{errorField}, new String[]{Translate.text("maxSurfaceError")});
        if (!dlg.clickedOk()) {
            return;
        }
        this.setUndoRecord(new UndoRecord(this, false, 0, new Object[]{theMesh, theMesh.duplicate()}));
        if (this.selectMode == 0) {
            e = theMesh.getEdges();
            newSel = new boolean[e.length];
            for (i = 0; i < e.length; ++i) {
                newSel[i] = selection[e[i].v1] && selection[e[i].v2];
            }
            selection = newSel;
        }
        if (this.selectMode == 2) {
            e = theMesh.getEdges();
            newSel = new boolean[e.length];
            for (i = 0; i < e.length; ++i) {
                newSel[i] = selection[e[i].f1] || e[i].f2 > -1 && selection[e[i].f2];
            }
            selection = newSel;
        }
        for (i = 0; i < selection.length && !selection[i]; ++i) {
        }
        if (i == selection.length) {
            selection = new boolean[selection.length];
            for (i = 0; i < selection.length; ++i) {
                selection[i] = true;
            }
        }
        new TriMeshSimplifier(theMesh, selection, errorField.getValue(), this);
        this.setMesh(theMesh);
        this.updateImage();
    }

    public void optimizeCommand() {
        BStandardDialog dlg = new BStandardDialog("", UIUtilities.breakString(Translate.text("optimizeMeshTitle")), BStandardDialog.QUESTION);
        String[] options = new String[]{Translate.text("button.ok"), Translate.text("button.cancel")};
        if (dlg.showOptionDialog(this, options, options[0]) == 1) {
            return;
        }
        TriangleMesh theMesh = (TriangleMesh)this.objInfo.getObject();
        this.setUndoRecord(new UndoRecord(this, false, 0, new Object[]{theMesh, theMesh.duplicate()}));
        theMesh.copyObject(TriangleMesh.optimizeMesh(theMesh));
        this.setMesh(theMesh);
        for (int i = 0; i < this.selected.length; ++i) {
            this.selected[i] = false;
        }
        this.setSelection(this.selected);
        this.updateImage();
    }

    public void bevelCommand() {
        final TriangleMesh theMesh = (TriangleMesh)this.objInfo.getObject();
        final ValueField heightField = new ValueField(0.0, 0);
        final ValueField widthField = new ValueField(0.0, 0);
        final ObjectPreviewCanvas preview = new ObjectPreviewCanvas(new ObjectInfo(theMesh, new CoordinateSystem(), ""));
        final int[] bevelMode = this.selectMode == 2 ? new int[]{1, 0} : (this.selectMode == 0 ? new int[]{3, 3} : new int[]{2, 2});
        final BComboBox applyChoice = new BComboBox(new String[]{Translate.text("selectionAsWhole"), Translate.text("individualFaces")});
        applyChoice.addEventLink(ValueChangedEvent.class, new Object(){

            void processEvent() {
                TriMeshBeveler beveler = new TriMeshBeveler(theMesh, TriMeshEditorWindow.this.selected, bevelMode[applyChoice.getSelectedIndex()]);
                double height = heightField.getValue();
                double width = widthField.getValue();
                preview.setObject(beveler.bevelMesh(height, width));
                preview.repaint();
            }
        });
        Object listener = new Object(){

            void processEvent() {
                TriMeshBeveler beveler = new TriMeshBeveler(theMesh, TriMeshEditorWindow.this.selected, bevelMode[applyChoice.getSelectedIndex()]);
                double height = heightField.getValue();
                double width = widthField.getValue();
                preview.setObject(beveler.bevelMesh(height, width));
                preview.repaint();
            }
        };
        heightField.addEventLink(ValueChangedEvent.class, listener);
        widthField.addEventLink(ValueChangedEvent.class, listener);
        preview.setPreferredSize(new Dimension(200, 200));
        ComponentsDialog dlg = this.selectMode == 2 ? new ComponentsDialog(this, Translate.text("bevelFacesTitle"), new Widget[]{heightField, widthField, applyChoice, preview}, new String[]{Translate.text("extrudeHeight"), Translate.text("bevelWidth"), Translate.text("applyTo"), ""}) : (this.selectMode == 0 ? new ComponentsDialog(this, Translate.text("bevelPointsTitle"), new Widget[]{heightField, widthField, preview}, new String[]{Translate.text("extrudeHeight"), Translate.text("bevelWidth"), ""}) : new ComponentsDialog(this, Translate.text("bevelEdgesTitle"), new Widget[]{heightField, widthField, preview}, new String[]{Translate.text("extrudeHeight"), Translate.text("bevelWidth"), ""}));
        if (!dlg.clickedOk()) {
            return;
        }
        double height = heightField.getValue();
        double width = widthField.getValue();
        this.setUndoRecord(new UndoRecord(this, false, 0, new Object[]{theMesh, theMesh.duplicate()}));
        TriMeshBeveler beveler = new TriMeshBeveler(theMesh, this.selected, bevelMode[applyChoice.getSelectedIndex()]);
        theMesh.copyObject(beveler.bevelMesh(height, width));
        this.setMesh(theMesh);
        this.setSelection(beveler.getNewSelection());
    }

    private boolean isBoundaryClosed(int[] edges) {
        if (edges.length < 3) {
            return false;
        }
        TriangleMesh theMesh = (TriangleMesh)this.objInfo.getObject();
        TriangleMesh.Edge[] ed = theMesh.getEdges();
        TriangleMesh.Edge first = ed[edges[0]];
        TriangleMesh.Edge last = ed[edges[edges.length - 1]];
        return first.v1 == last.v1 || first.v1 == last.v2 || first.v2 == last.v1 || first.v2 == last.v2;
    }

    private int[][] findSelectedBoundaries() {
        if (this.getSelectionMode() != 1) {
            return new int[0][0];
        }
        if (this.boundary == null) {
            this.boundary = ((TriangleMesh)this.getObject().getObject()).findBoundaryEdges();
        }
        Vector<int[]> all = new Vector<int[]>();
        for (int i = 0; i < this.boundary.length; ++i) {
            int start;
            for (start = this.boundary[i].length - 1; start > 0 && this.selected[this.boundary[i][start]]; --start) {
            }
            Vector<Integer> current = null;
            int j = start;
            do {
                boolean isSelected;
                if (isSelected = this.selected[this.boundary[i][j]]) {
                    if (current == null) {
                        current = new Vector<Integer>();
                    }
                    current.addElement(this.boundary[i][j]);
                }
                if (++j == this.boundary[i].length) {
                    j = 0;
                }
                if (isSelected && j != start || current == null) continue;
                int[] edgeList = new int[current.size()];
                for (int k = 0; k < edgeList.length; ++k) {
                    edgeList[k] = (Integer)current.elementAt(k);
                }
                all.addElement(edgeList);
                current = null;
            } while (j != start);
        }
        int[][] index = new int[all.size()][];
        all.copyInto((Object[])index);
        return index;
    }

    public void closeBoundaryCommand() {
        int i;
        int i2;
        TriangleMesh theMesh = (TriangleMesh)this.objInfo.getObject();
        TriangleMesh.Vertex[] vt = (TriangleMesh.Vertex[])theMesh.getVertices();
        TriangleMesh.Edge[] ed = theMesh.getEdges();
        TriangleMesh.Face[] fc = theMesh.getFaces();
        int[][] boundaryList = this.findSelectedBoundaries();
        Vec3[] newvert = new Vec3[vt.length + boundaryList.length];
        int count = 0;
        for (i2 = 0; i2 < vt.length; ++i2) {
            newvert[i2] = vt[i2].r;
        }
        for (i2 = 0; i2 < boundaryList.length; ++i2) {
            count += boundaryList[i2].length;
        }
        int[][] newface = new int[fc.length + count][];
        for (i2 = 0; i2 < fc.length; ++i2) {
            newface[i2] = new int[]{fc[i2].v1, fc[i2].v2, fc[i2].v3};
        }
        int faceIndex = fc.length;
        int vertIndex = vt.length;
        for (int i3 = 0; i3 < boundaryList.length; ++i3) {
            TriangleMesh.Edge e;
            int k;
            if (boundaryList[i3].length < 2) continue;
            TriangleMesh.Edge ed0 = ed[boundaryList[i3][0]];
            TriangleMesh.Edge ed1 = ed[boundaryList[i3][1]];
            boolean closed = this.isBoundaryClosed(boundaryList[i3]);
            if (boundaryList[i3].length == 2 || boundaryList[i3].length == 3 && closed) {
                int thirdVert;
                TriangleMesh.Face f = fc[ed0.f1];
                int n = thirdVert = ed0.v1 == ed1.v1 || ed0.v2 == ed1.v1 ? ed1.v2 : ed1.v1;
                if (f.v1 == ed0.v1 && f.v2 == ed0.v2 || f.v2 == ed0.v1 && f.v3 == ed0.v2 || f.v3 == ed0.v1 && f.v1 == ed0.v2) {
                    newface[faceIndex++] = new int[]{ed0.v2, ed0.v1, thirdVert};
                    continue;
                }
                newface[faceIndex++] = new int[]{ed0.v1, ed0.v2, thirdVert};
                continue;
            }
            Vec3 center = new Vec3();
            int j = ed0.v1 == ed1.v1 || ed0.v1 == ed1.v2 ? ed0.v2 : ed0.v1;
            for (k = 0; k < boundaryList[i3].length; ++k) {
                center.add(vt[j].r);
                e = ed[boundaryList[i3][k]];
                j = e.v1 == j ? e.v2 : e.v1;
            }
            if (closed) {
                center.scale(1.0 / (double)boundaryList[i3].length);
            } else {
                center.add(vt[j].r);
                center.scale(1.0 / (double)(boundaryList[i3].length + 1));
            }
            newvert[vertIndex] = center;
            for (k = 0; k < boundaryList[i3].length; ++k) {
                e = ed[boundaryList[i3][k]];
                TriangleMesh.Face f = fc[e.f1];
                newface[faceIndex++] = f.v1 == e.v1 && f.v2 == e.v2 || f.v2 == e.v1 && f.v3 == e.v2 || f.v3 == e.v1 && f.v1 == e.v2 ? new int[]{e.v2, e.v1, vertIndex} : new int[]{e.v1, e.v2, vertIndex};
            }
            ++vertIndex;
        }
        if (faceIndex < newface.length) {
            int[][] newface2 = new int[faceIndex][];
            System.arraycopy(newface, 0, newface2, 0, faceIndex);
            newface = newface2;
        }
        if (vertIndex < newvert.length) {
            Vec3[] newvert2 = new Vec3[vertIndex];
            System.arraycopy(newvert, 0, newvert2, 0, vertIndex);
            newvert = newvert2;
        }
        TriangleMesh newmesh = new TriangleMesh(newvert, (int[][])newface);
        TriangleMesh.Vertex[] newvt = (TriangleMesh.Vertex[])newmesh.getVertices();
        TriangleMesh.Edge[] newed = newmesh.getEdges();
        newmesh.copyTextureAndMaterial(theMesh);
        newmesh.setSmoothingMethod(theMesh.getSmoothingMethod());
        TextureParameter[] param = theMesh.getParameters();
        ParameterValue[] oldParamVal = theMesh.getParameterValues();
        ParameterValue[] newParamVal = new ParameterValue[oldParamVal.length];
        for (i = 0; i < oldParamVal.length; ++i) {
            int j;
            Object newval;
            double[] oldval;
            if (oldParamVal[i] instanceof VertexParameterValue) {
                oldval = ((VertexParameterValue)oldParamVal[i]).getValue();
                newval = new double[newvert.length];
                for (j = 0; j < oldval.length; ++j) {
                    newval[j] = oldval[j];
                }
                for (j = oldval.length; j < ((double[])newval).length; ++j) {
                    newval[j] = param[i].defaultVal;
                }
                newParamVal[i] = new VertexParameterValue((double[])newval);
                continue;
            }
            if (oldParamVal[i] instanceof FaceParameterValue) {
                oldval = ((FaceParameterValue)oldParamVal[i]).getValue();
                newval = new double[newface.length];
                for (j = 0; j < oldval.length; ++j) {
                    newval[j] = oldval[j];
                }
                for (j = oldval.length; j < ((double[])newval).length; ++j) {
                    newval[j] = param[i].defaultVal;
                }
                newParamVal[i] = new FaceParameterValue((double[])newval);
                continue;
            }
            if (oldParamVal[i] instanceof FaceVertexParameterValue) {
                FaceVertexParameterValue fvpv = (FaceVertexParameterValue)oldParamVal[i];
                newval = new double[newface.length][3];
                for (j = 0; j < 3; ++j) {
                    int k;
                    for (k = 0; k < fvpv.getFaceCount(); ++k) {
                        newval[k][j] = fvpv.getValue(k, j);
                    }
                    for (k = fvpv.getFaceCount(); k < newface.length; ++k) {
                        newval[k][j] = param[i].defaultVal;
                    }
                }
                newParamVal[i] = new FaceVertexParameterValue((double[][])newval);
                continue;
            }
            newParamVal[i] = oldParamVal[i].duplicate();
        }
        newmesh.setParameterValues(newParamVal);
        for (i = 0; i < vt.length; ++i) {
            newvt[i].smoothness = vt[i].smoothness;
        }
        for (i = 0; i < newed.length; ++i) {
            if (newed[i].v1 >= vt.length || newed[i].v2 >= vt.length) continue;
            for (int j = 0; j < ed.length; ++j) {
                if ((newed[i].v1 != ed[j].v1 || newed[i].v2 != ed[j].v2) && (newed[i].v1 != ed[j].v2 || newed[i].v2 != ed[j].v1)) continue;
                newed[i].smoothness = ed[j].smoothness;
            }
        }
        this.setUndoRecord(new UndoRecord(this, false, 0, new Object[]{newmesh, theMesh}));
        this.setMesh(newmesh);
        this.updateImage();
    }

    public void joinBoundariesCommand() {
        int maxsteps;
        final int[][] boundaryList = this.findSelectedBoundaries();
        if (boundaryList.length != 2) {
            return;
        }
        final int[][] boundaryVert = new int[2][];
        TriangleMesh theMesh = (TriangleMesh)this.objInfo.getObject();
        TriangleMesh.Vertex[] vt = (TriangleMesh.Vertex[])theMesh.getVertices();
        TriangleMesh.Edge[] ed = theMesh.getEdges();
        boolean closed = this.isBoundaryClosed(boundaryList[0]);
        if (closed != this.isBoundaryClosed(boundaryList[1])) {
            new BStandardDialog("", Translate.text("cannotJoinOpenAndClosed"), BStandardDialog.ERROR).showMessageDialog(this);
            return;
        }
        for (int j = 0; j < 2; ++j) {
            boundaryVert[j] = new int[boundaryList[j].length + (closed ? 0 : 1)];
            boundaryVert[j][0] = boundaryList[j].length == 1 || ed[boundaryList[j][0]].v1 == ed[boundaryList[j][1]].v1 || ed[boundaryList[j][0]].v1 == ed[boundaryList[j][1]].v2 ? ed[boundaryList[j][0]].v2 : ed[boundaryList[j][0]].v1;
            for (int i = 0; i < boundaryVert[j].length - 1; ++i) {
                TriangleMesh.Edge e = ed[boundaryList[j][i]];
                boundaryVert[j][i + 1] = e.v1 == boundaryVert[j][i] ? e.v2 : e.v1;
            }
        }
        double offset = 0.0;
        boolean reverse = false;
        int n = maxsteps = boundaryList[0].length > boundaryList[1].length ? boundaryList[0].length : boundaryList[1].length;
        if (closed) {
            double step0 = (double)boundaryList[0].length / (double)maxsteps;
            double step1 = (reverse ? -1.0 : 1.0) * (double)boundaryList[1].length / (double)maxsteps;
            double mindist = Double.MAX_VALUE;
            for (int i = 0; i < maxsteps - 1; ++i) {
                int i1;
                int i0;
                double p1;
                double p0;
                int j;
                double dist = 0.0;
                for (j = 0; j < maxsteps; ++j) {
                    p0 = (double)j * step0;
                    p1 = (double)(i + j) * step1;
                    i0 = ((int)Math.round(p0) + boundaryList[0].length) % boundaryList[0].length;
                    i1 = ((int)Math.round(p1) + boundaryList[1].length) % boundaryList[1].length;
                    dist += vt[boundaryVert[0][i0]].r.distance2(vt[boundaryVert[1][i1]].r);
                }
                if (dist < mindist) {
                    mindist = dist;
                    offset = (double)i * step1;
                    reverse = false;
                }
                dist = 0.0;
                for (j = 0; j < maxsteps; ++j) {
                    p0 = (double)j * step0;
                    p1 = (double)(i - j) * step1;
                    i0 = ((int)Math.round(p0) + boundaryList[0].length) % boundaryList[0].length;
                    i1 = ((int)Math.round(p1) + boundaryList[1].length) % boundaryList[1].length;
                    dist += vt[boundaryVert[0][i0]].r.distance2(vt[boundaryVert[1][i1]].r);
                }
                if (!(dist < mindist)) continue;
                mindist = dist;
                offset = (double)i * step1;
                reverse = true;
            }
        } else {
            double fdist = 0.0;
            double rdist = 0.0;
            double step0 = (double)boundaryList[0].length / (double)maxsteps;
            double step1 = (double)boundaryList[1].length / (double)maxsteps;
            int revStart = boundaryVert[1].length - 1;
            for (int i = 0; i < maxsteps; ++i) {
                int i0 = (int)Math.round((double)i * step0);
                int i1 = (int)Math.round((double)i * step1);
                fdist += vt[boundaryVert[0][i0]].r.distance2(vt[boundaryVert[1][i1]].r);
                rdist += vt[boundaryVert[0][i0]].r.distance2(vt[boundaryVert[1][revStart - i1]].r);
            }
            reverse = fdist > rdist;
        }
        final ValueSlider offsetSlider = new ValueSlider(-0.5 * (double)boundaryList[1].length, 0.5 * (double)boundaryList[1].length, 2 * maxsteps, 0.0);
        final BCheckBox reverseBox = new BCheckBox(Translate.text("reverseDirection"), false);
        final ObjectPreviewCanvas preview = new ObjectPreviewCanvas(new ObjectInfo(this.doJoinBoundaries(boundaryList, boundaryVert, offset, reverse), new CoordinateSystem(), ""));
        final double baseOffset = offset;
        final boolean baseReverse = reverse;
        FormContainer content = new FormContainer(new double[]{1.0}, new double[]{0.0, 0.0, 1.0});
        if (closed) {
            RowContainer row = new RowContainer();
            row.add(new BLabel(Translate.text("Offset") + ":"));
            row.add(offsetSlider);
            content.add(row, 0, 0);
        }
        content.add(reverseBox, 0, 1);
        content.add(preview, 0, 2, new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.BOTH, null, null));
        preview.setPreferredSize(new Dimension(200, 200));
        preview.setRenderMode(1);
        Object listener = new Object(){

            void processEvent() {
                preview.setObject(TriMeshEditorWindow.this.doJoinBoundaries(boundaryList, boundaryVert, baseOffset + offsetSlider.getValue(), baseReverse ^ reverseBox.getState()));
                preview.repaint();
            }
        };
        offsetSlider.addEventLink(ValueChangedEvent.class, listener);
        reverseBox.addEventLink(ValueChangedEvent.class, listener);
        PanelDialog dlg = new PanelDialog((WindowWidget)this, Translate.text("joinBoundardiesTitle"), content);
        if (!dlg.clickedOk()) {
            return;
        }
        this.setUndoRecord(new UndoRecord(this, false, 0, new Object[]{preview.getObject().getObject(), theMesh}));
        this.setMesh((Mesh)((Object)preview.getObject().getObject()));
        this.updateImage();
    }

    TriangleMesh doJoinBoundaries(int[][] boundary, int[][] boundaryVert, double offset, boolean reverse) {
        int i;
        int i1prev;
        int i0prev;
        double p1;
        double p0;
        int i2;
        int maxsteps = boundary[0].length > boundary[1].length ? boundary[0].length : boundary[1].length;
        double step0 = (double)boundary[0].length / (double)maxsteps;
        double step1 = (reverse ? -1.0 : 1.0) * (double)boundary[1].length / (double)maxsteps;
        TriangleMesh theMesh = (TriangleMesh)this.objInfo.getObject();
        TriangleMesh.Vertex[] vt = (TriangleMesh.Vertex[])theMesh.getVertices();
        TriangleMesh.Edge[] ed = theMesh.getEdges();
        TriangleMesh.Face[] fc = theMesh.getFaces();
        Vec3[] newvert = new Vec3[vt.length];
        int[][] newface = new int[fc.length + boundary[0].length + boundary[1].length][];
        for (i2 = 0; i2 < vt.length; ++i2) {
            newvert[i2] = vt[i2].r;
        }
        for (i2 = 0; i2 < fc.length; ++i2) {
            newface[i2] = new int[]{fc[i2].v1, fc[i2].v2, fc[i2].v3};
        }
        int count = fc.length;
        if (this.isBoundaryClosed(boundary[0])) {
            p0 = 0.0;
            p1 = offset;
            i0prev = 0;
            i1prev = ((int)Math.round(p1) + boundary[1].length) % boundary[1].length;
            for (i = 1; i <= maxsteps; ++i) {
                int v2;
                int v1;
                TriangleMesh.Face f;
                TriangleMesh.Edge e;
                p0 += step0;
                p1 += step1;
                while (p1 < 0.0) {
                    p1 += (double)boundary[1].length;
                }
                int i0 = (int)Math.round(p0) % boundary[0].length;
                int i1 = (int)Math.round(p1) % boundary[1].length;
                if (i0 != i0prev) {
                    e = ed[boundary[0][step0 > 0.0 ? i0prev : i0]];
                    f = fc[e.f1];
                    v1 = boundaryVert[0][i0prev];
                    v2 = boundaryVert[0][i0];
                    newface[count++] = f.v1 == v1 && f.v2 == v2 || f.v2 == v1 && f.v3 == v2 || f.v3 == v1 && f.v1 == v2 ? new int[]{v2, v1, boundaryVert[1][i1prev]} : new int[]{v1, v2, boundaryVert[1][i1prev]};
                }
                if (i1 != i1prev) {
                    e = ed[boundary[1][step1 > 0.0 ? i1prev : i1]];
                    f = fc[e.f1];
                    v1 = boundaryVert[1][i1prev];
                    v2 = boundaryVert[1][i1];
                    newface[count++] = f.v1 == v1 && f.v2 == v2 || f.v2 == v1 && f.v3 == v2 || f.v3 == v1 && f.v1 == v2 ? new int[]{v2, v1, boundaryVert[0][i0]} : new int[]{v1, v2, boundaryVert[0][i0]};
                }
                i0prev = i0;
                i1prev = i1;
            }
        } else {
            p0 = 0.0;
            p1 = reverse ? (double)boundary[1].length : 0.0;
            i0prev = 0;
            i1prev = (int)Math.round(p1);
            while (count < newface.length) {
                int v2;
                int v1;
                TriangleMesh.Face f;
                TriangleMesh.Edge e;
                int i0 = (int)Math.round(p0 += step0);
                int i1 = (int)Math.round(p1 += step1);
                if (i0 < 0) {
                    i0 = 0;
                }
                if (i1 < 0) {
                    i1 = 0;
                }
                if (i0 > boundary[0].length) {
                    i0 = boundary[0].length;
                }
                if (i1 > boundary[1].length) {
                    i1 = boundary[1].length;
                }
                if (i0 != i0prev) {
                    e = ed[boundary[0][i0prev < i0 ? i0prev : i0]];
                    f = fc[e.f1];
                    v1 = boundaryVert[0][i0prev];
                    v2 = boundaryVert[0][i0];
                    newface[count++] = f.v1 == v1 && f.v2 == v2 || f.v2 == v1 && f.v3 == v2 || f.v3 == v1 && f.v1 == v2 ? new int[]{v2, v1, boundaryVert[1][i1prev]} : new int[]{v1, v2, boundaryVert[1][i1prev]};
                }
                if (i1 != i1prev) {
                    e = ed[boundary[1][i1prev < i1 ? i1prev : i1]];
                    f = fc[e.f1];
                    v1 = boundaryVert[1][i1prev];
                    v2 = boundaryVert[1][i1];
                    newface[count++] = f.v1 == v1 && f.v2 == v2 || f.v2 == v1 && f.v3 == v2 || f.v3 == v1 && f.v1 == v2 ? new int[]{v2, v1, boundaryVert[0][i0]} : new int[]{v1, v2, boundaryVert[0][i0]};
                }
                i0prev = i0;
                i1prev = i1;
            }
        }
        TriangleMesh newmesh = new TriangleMesh(newvert, (int[][])newface);
        TriangleMesh.Vertex[] newvt = (TriangleMesh.Vertex[])newmesh.getVertices();
        TriangleMesh.Edge[] newed = newmesh.getEdges();
        newmesh.copyTextureAndMaterial(theMesh);
        newmesh.setSmoothingMethod(theMesh.getSmoothingMethod());
        TextureParameter[] param = theMesh.getParameters();
        ParameterValue[] oldParamVal = theMesh.getParameterValues();
        ParameterValue[] newParamVal = new ParameterValue[oldParamVal.length];
        for (i = 0; i < oldParamVal.length; ++i) {
            int j;
            Object newval;
            if (oldParamVal[i] instanceof FaceParameterValue) {
                double[] oldval = ((FaceParameterValue)oldParamVal[i]).getValue();
                newval = new double[newface.length];
                for (j = 0; j < oldval.length; ++j) {
                    newval[j] = oldval[j];
                }
                if (param[i] == this.getFaceIndexParameter()) {
                    for (j = oldval.length; j < ((double[])newval).length; ++j) {
                        newval[j] = j;
                    }
                } else {
                    for (j = oldval.length; j < ((double[])newval).length; ++j) {
                        newval[j] = param[i].defaultVal;
                    }
                }
                newParamVal[i] = new FaceParameterValue((double[])newval);
                continue;
            }
            if (oldParamVal[i] instanceof FaceVertexParameterValue) {
                FaceVertexParameterValue fvpv = (FaceVertexParameterValue)oldParamVal[i];
                newval = new double[newface.length][3];
                for (j = 0; j < 3; ++j) {
                    int k;
                    for (k = 0; k < fvpv.getFaceCount(); ++k) {
                        newval[k][j] = fvpv.getValue(k, j);
                    }
                    for (k = fvpv.getFaceCount(); k < newface.length; ++k) {
                        newval[k][j] = param[i].defaultVal;
                    }
                }
                newParamVal[i] = new FaceVertexParameterValue((double[][])newval);
                continue;
            }
            newParamVal[i] = oldParamVal[i].duplicate();
        }
        newmesh.setParameterValues(newParamVal);
        for (i = 0; i < vt.length; ++i) {
            newvt[i].smoothness = vt[i].smoothness;
        }
        for (i = 0; i < newed.length; ++i) {
            if (newed[i].v1 >= vt.length || newed[i].v2 >= vt.length) continue;
            for (int j = 0; j < ed.length; ++j) {
                if ((newed[i].v1 != ed[j].v1 || newed[i].v2 != ed[j].v2) && (newed[i].v1 != ed[j].v2 || newed[i].v2 != ed[j].v1)) continue;
                newed[i].smoothness = ed[j].smoothness;
            }
        }
        return newmesh;
    }

    public void extractFacesCommand() {
        String name;
        Widget parent;
        int i;
        TriangleMesh theMesh = (TriangleMesh)this.objInfo.getObject();
        TriangleMesh.Vertex[] vt = (TriangleMesh.Vertex[])theMesh.getVertices();
        TriangleMesh.Face[] fc = theMesh.getFaces();
        Vector<Integer> faces = new Vector<Integer>();
        TreeSet<Integer> vertices = new TreeSet<Integer>();
        if (this.selectMode != 2) {
            return;
        }
        for (int i2 = 0; i2 < this.selected.length; ++i2) {
            if (!this.selected[i2]) continue;
            faces.addElement(i2);
        }
        if (faces.size() == 0) {
            return;
        }
        for (Integer face : faces) {
            vertices.add(fc[face.intValue()].v1);
            vertices.add(fc[face.intValue()].v2);
            vertices.add(fc[face.intValue()].v3);
        }
        int[] vertIndex = new int[vt.length];
        Arrays.fill(vertIndex, -1);
        Vec3[] v = new Vec3[vertices.size()];
        int count = 0;
        for (Integer vertex : vertices) {
            v[count] = new Vec3(vt[vertex.intValue()].r);
            vertIndex[vertex.intValue()] = count++;
        }
        int[][] f = new int[faces.size()][];
        count = 0;
        for (Integer face : faces) {
            f[count++] = new int[]{vertIndex[fc[face.intValue()].v1], vertIndex[fc[face.intValue()].v2], vertIndex[fc[face.intValue()].v3]};
        }
        TriangleMesh mesh = new TriangleMesh(v, (int[][])f);
        mesh.copyTextureAndMaterial(theMesh);
        mesh.setSmoothingMethod(theMesh.getSmoothingMethod());
        int[] vertexEdgeCount = new int[vertices.size()];
        for (i = 0; i < mesh.getEdges().length; ++i) {
            TriangleMesh.Edge edge = mesh.getEdges()[i];
            if (edge.f2 != -1) continue;
            int n = edge.v1;
            vertexEdgeCount[n] = vertexEdgeCount[n] + 1;
            int n2 = edge.v2;
            vertexEdgeCount[n2] = vertexEdgeCount[n2] + 1;
        }
        for (i = 0; i < vertexEdgeCount.length; ++i) {
            if (vertexEdgeCount[i] == 0 || vertexEdgeCount[i] == 2) continue;
            new BStandardDialog("", Translate.text("illegalExtract"), BStandardDialog.ERROR).showMessageDialog(this);
            return;
        }
        for (Integer vertex : vertices) {
            ((TriangleMesh.Vertex)mesh.getVertices()[vertIndex[vertex.intValue()]]).smoothness = vt[vertex.intValue()].smoothness;
        }
        for (int i3 = 0; i3 < faces.size(); ++i3) {
            TriangleMesh.Face face = fc[(Integer)faces.get(i3)];
            TriangleMesh.Face newFace = mesh.getFaces()[i3];
            mesh.getEdges()[newFace.e1].smoothness = theMesh.getEdges()[face.e1].smoothness;
            mesh.getEdges()[newFace.e2].smoothness = theMesh.getEdges()[face.e2].smoothness;
            mesh.getEdges()[newFace.e3].smoothness = theMesh.getEdges()[face.e3].smoothness;
        }
        ParameterValue[] oldValues = theMesh.getParameterValues();
        ParameterValue[] newValues = mesh.getParameterValues();
        for (int i4 = 0; i4 < oldValues.length; ++i4) {
            int j;
            Object val;
            ParameterValue old;
            if (oldValues[i4] instanceof FaceParameterValue) {
                old = (FaceParameterValue)oldValues[i4];
                val = new double[faces.size()];
                for (j = 0; j < ((double[])val).length; ++j) {
                    val[j] = ((FaceParameterValue)old).getValue()[(Integer)faces.get(j)];
                }
                newValues[i4] = new FaceParameterValue((double[])val);
                continue;
            }
            if (oldValues[i4] instanceof VertexParameterValue) {
                old = (VertexParameterValue)oldValues[i4];
                val = new double[vertices.size()];
                for (j = 0; j < vertIndex.length; ++j) {
                    if (vertIndex[j] == -1) continue;
                    val[vertIndex[j]] = ((VertexParameterValue)old).getValue()[j];
                }
                newValues[i4] = new VertexParameterValue((double[])val);
                continue;
            }
            if (!(oldValues[i4] instanceof FaceVertexParameterValue)) continue;
            old = (FaceVertexParameterValue)oldValues[i4];
            val = new double[faces.size()][];
            for (j = 0; j < ((double[])val).length; ++j) {
                int faceIndex = (Integer)faces.get(j);
                val[j] = (double)new double[]{((FaceVertexParameterValue)old).getValue(faceIndex, 0), ((FaceVertexParameterValue)old).getValue(faceIndex, 1), ((FaceVertexParameterValue)old).getValue(faceIndex, 2)};
            }
            newValues[i4] = new FaceVertexParameterValue((double[][])val);
        }
        for (parent = (Widget)((Object)this.parentWindow); parent != null && !(parent instanceof LayoutWindow); parent = parent.getParent()) {
        }
        if (parent != null && (name = new BStandardDialog("", Translate.text("extractedMeshName"), BStandardDialog.QUESTION).showInputDialog(this, null, "Extracted Mesh")) != null) {
            ((LayoutWindow)parent).addObject(mesh, ((MeshViewer)this.theView[this.currentView]).thisObjectInScene.getCoords().duplicate(), name, null);
            ((LayoutWindow)parent).updateImage();
        }
    }

    public void extractCurveCommand() {
        String name;
        Widget parent;
        int smoothingMethod;
        TriangleMesh.Edge first;
        int i;
        TriangleMesh theMesh = (TriangleMesh)this.objInfo.getObject();
        TriangleMesh.Vertex[] vt = (TriangleMesh.Vertex[])theMesh.getVertices();
        TriangleMesh.Edge[] ed = theMesh.getEdges();
        Vector<TriangleMesh.Edge> edges = new Vector<TriangleMesh.Edge>();
        if (this.selectMode != 1) {
            return;
        }
        for (i = 0; i < this.selected.length; ++i) {
            if (!this.selected[i]) continue;
            edges.addElement(ed[i]);
        }
        if (edges.size() == 0) {
            return;
        }
        TriangleMesh.Edge last = first = (TriangleMesh.Edge)edges.elementAt(0);
        Vector<TriangleMesh.Edge> ordered = new Vector<TriangleMesh.Edge>();
        ordered.addElement(first);
        edges.removeElementAt(0);
        while (edges.size() > 0) {
            for (i = 0; i < edges.size(); ++i) {
                TriangleMesh.Edge e = (TriangleMesh.Edge)edges.elementAt(i);
                if (e.v1 == first.v1 || e.v2 == first.v1 || e.v1 == first.v2 || e.v2 == first.v2) {
                    ordered.insertElementAt(e, 0);
                    first = e;
                    break;
                }
                if (e.v1 != last.v1 && e.v2 != last.v1 && e.v1 != last.v2 && e.v2 != last.v2) continue;
                ordered.addElement(e);
                last = e;
                break;
            }
            if (i == edges.size()) {
                new BStandardDialog("", Translate.text("edgesNotContinuous"), BStandardDialog.ERROR).showMessageDialog(this);
                return;
            }
            edges.removeElementAt(i);
        }
        boolean closed = ordered.size() > 2 && (last.v1 == first.v1 || last.v2 == first.v1 || last.v1 == first.v2 || last.v2 == first.v2);
        Vec3[] v = new Vec3[closed ? ordered.size() : ordered.size() + 1];
        float[] smoothness = new float[v.length];
        TriangleMesh.Edge second = ordered.size() == 1 ? first : (TriangleMesh.Edge)ordered.elementAt(1);
        int prev = first.v1 == second.v1 || first.v1 == second.v2 ? first.v2 : first.v1;
        for (i = 0; i < ordered.size(); ++i) {
            TriangleMesh.Edge e = (TriangleMesh.Edge)ordered.elementAt(i);
            v[i] = new Vec3(vt[prev].r);
            smoothness[i] = vt[prev].smoothness;
            prev = e.v1 == prev ? e.v2 : e.v1;
        }
        if (!closed) {
            v[i] = new Vec3(vt[prev].r);
            smoothness[i] = vt[prev].smoothness;
        }
        if ((smoothingMethod = theMesh.getSmoothingMethod()) == 1) {
            smoothingMethod = 0;
        }
        Curve cv = new Curve(v, smoothness, smoothingMethod, closed);
        for (parent = (Widget)((Object)this.parentWindow); parent != null && !(parent instanceof LayoutWindow); parent = parent.getParent()) {
        }
        if (parent != null && (name = new BStandardDialog("", Translate.text("extractedCurveName"), BStandardDialog.QUESTION).showInputDialog(this, null, "Extracted Curve")) != null) {
            ((LayoutWindow)parent).addObject(cv, ((MeshViewer)this.theView[this.currentView]).thisObjectInScene.getCoords().duplicate(), name, null);
            ((LayoutWindow)parent).updateImage();
        }
    }

    public void setSmoothnessCommand() {
        int i;
        final TriangleMesh theMesh = (TriangleMesh)this.objInfo.getObject();
        TriangleMesh oldMesh = (TriangleMesh)theMesh.duplicate();
        final TriangleMesh.Vertex[] vt = (TriangleMesh.Vertex[])theMesh.getVertices();
        final TriangleMesh.Edge[] ed = theMesh.getEdges();
        final boolean pointmode = this.selectMode == 0;
        final ActionProcessor processor = new ActionProcessor();
        for (i = 0; i < this.selected.length && !this.selected[i]; ++i) {
        }
        if (i == this.selected.length) {
            return;
        }
        float value = pointmode ? vt[i].smoothness : ed[i].smoothness;
        value = 0.001f * (float)Math.round(value * 1000.0f);
        final ValueSlider smoothness = new ValueSlider(0.0, 1.0, 100, value);
        smoothness.addEventLink(ValueChangedEvent.class, new Object(){

            void processEvent() {
                processor.addEvent(new Runnable(){

                    public void run() {
                        float s = (float)smoothness.getValue();
                        for (int i = 0; i < TriMeshEditorWindow.this.selected.length; ++i) {
                            if (!TriMeshEditorWindow.this.selected[i]) continue;
                            if (pointmode) {
                                vt[i].smoothness = s;
                                continue;
                            }
                            ed[i].smoothness = s;
                        }
                        theMesh.setSmoothingMethod(theMesh.getSmoothingMethod());
                        TriMeshEditorWindow.this.objectChanged();
                        TriMeshEditorWindow.this.updateImage();
                    }
                });
            }
        });
        ComponentsDialog dlg = new ComponentsDialog(this, Translate.text(pointmode ? "setPointSmoothness" : "setEdgeSmoothness"), new Widget[]{smoothness}, new String[]{Translate.text("Smoothness")});
        processor.stopProcessing();
        if (dlg.clickedOk()) {
            this.setUndoRecord(new UndoRecord(this, false, 0, new Object[]{theMesh, oldMesh}));
        } else {
            theMesh.copyObject(oldMesh);
            this.objectChanged();
            this.updateImage();
        }
    }

    public void reverseNormalsCommand() {
        TriangleMesh theMesh = (TriangleMesh)this.objInfo.getObject();
        this.setUndoRecord(new UndoRecord(this, false, 0, new Object[]{theMesh, theMesh.duplicate()}));
        theMesh.reverseNormals();
        this.objectChanged();
        this.updateImage();
    }

    void setSmoothingMethod(int method) {
        TriangleMesh theMesh = (TriangleMesh)this.objInfo.getObject();
        this.setUndoRecord(new UndoRecord(this, false, 0, new Object[]{theMesh, theMesh.duplicate()}));
        for (int i = 0; i < this.smoothItem.length; ++i) {
            this.smoothItem[i].setState(false);
        }
        this.smoothItem[method].setState(true);
        theMesh.setSmoothingMethod(method);
        this.objectChanged();
        this.updateMenus();
        this.updateImage();
    }

    public void adjustDeltas(Vec3[] delta) {
        int i;
        int[] dist = this.getSelectionDistance();
        int[] count = new int[delta.length];
        TriangleMesh theMesh = (TriangleMesh)this.objInfo.getObject();
        TriangleMesh.Edge[] edge = theMesh.getEdges();
        int maxDistance = this.getTensionDistance();
        double tension = this.getMeshTension();
        double[] scale = new double[maxDistance + 1];
        for (i = 0; i < delta.length; ++i) {
            if (dist[i] == 0) continue;
            delta[i].set(0.0, 0.0, 0.0);
        }
        for (i = 0; i < maxDistance; ++i) {
            int j;
            for (j = 0; j < count.length; ++j) {
                count[j] = 0;
            }
            for (j = 0; j < edge.length; ++j) {
                if (dist[edge[j].v1] == i && dist[edge[j].v2] == i + 1) {
                    int n = edge[j].v2;
                    count[n] = count[n] + 1;
                    delta[edge[j].v2].add(delta[edge[j].v1]);
                    continue;
                }
                if (dist[edge[j].v2] != i || dist[edge[j].v1] != i + 1) continue;
                int n = edge[j].v1;
                count[n] = count[n] + 1;
                delta[edge[j].v1].add(delta[edge[j].v2]);
            }
            for (j = 0; j < count.length; ++j) {
                if (count[j] <= 1) continue;
                delta[j].scale(1.0 / (double)count[j]);
            }
        }
        for (i = 0; i < scale.length; ++i) {
            scale[i] = Math.pow(((double)(maxDistance - i) + 1.0) / ((double)maxDistance + 1.0), tension);
        }
        for (i = 0; i < delta.length; ++i) {
            if (dist[i] <= 0) continue;
            delta[i].scale(scale[dist[i]]);
        }
    }
}

