/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.texture.Texture;
import artofillusion.texture.TextureMapping;
import artofillusion.ui.ValueChecker;
import artofillusion.ui.ValueField;
import artofillusion.ui.ValueSlider;
import buoy.widget.Widget;

public class TextureParameter {
    public final Object owner;
    public final String name;
    public final double minVal;
    public final double maxVal;
    public final double defaultVal;
    public int identifier;
    public int type;
    public static final int NORMAL_PARAMETER = 0;
    public static final int X_COORDINATE = 1;
    public static final int Y_COORDINATE = 2;
    public static final int Z_COORDINATE = 3;
    private static int nextID = 0;

    public TextureParameter(Object owner, String name, double minVal, double maxVal, double defaultVal) {
        this.owner = owner;
        this.name = name;
        this.minVal = minVal;
        this.maxVal = maxVal;
        this.defaultVal = defaultVal;
        this.identifier = -1;
        this.type = 0;
    }

    public TextureParameter duplicate() {
        return this.duplicate(this.owner);
    }

    public TextureParameter duplicate(Object owner) {
        TextureParameter tp = new TextureParameter(owner, this.name, this.minVal, this.maxVal, this.defaultVal);
        tp.identifier = this.identifier;
        tp.type = this.type;
        return tp;
    }

    public boolean equals(Object o) {
        if (!(o instanceof TextureParameter)) {
            return false;
        }
        TextureParameter param = (TextureParameter)o;
        boolean sameOwner = false;
        if (param.owner == this.owner) {
            sameOwner = true;
        } else if (param.owner instanceof Texture && this.owner instanceof Texture && ((Texture)param.owner).getID() == ((Texture)this.owner).getID()) {
            sameOwner = true;
        } else if (this.owner instanceof TextureMapping && this.owner.getClass() == param.owner.getClass()) {
            sameOwner = true;
        }
        if (!sameOwner) {
            return false;
        }
        if (this.identifier == -1 || param.identifier == -1) {
            return param.name.equals(this.name);
        }
        return this.identifier == param.identifier;
    }

    public int hashCode() {
        if (this.identifier == -1) {
            return this.name.hashCode();
        }
        return this.identifier;
    }

    public void assignNewID() {
        this.identifier = TextureParameter.getUniqueID();
    }

    public static synchronized int getUniqueID() {
        return nextID++;
    }

    public void setID(int newid) {
        this.identifier = newid;
    }

    public Widget getEditingWidget(double currentValue) {
        if (this.minVal == -1.7976931348623157E308 || this.maxVal == Double.MAX_VALUE) {
            ValueField field = new ValueField(currentValue, 0);
            field.setValueChecker(new ValueChecker(){

                public boolean isValid(double val) {
                    return val >= TextureParameter.this.minVal && val <= TextureParameter.this.maxVal;
                }
            });
            return field;
        }
        return new ValueSlider(this.minVal, this.maxVal, 100, currentValue);
    }
}

