/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.MeshViewer;
import artofillusion.RenderingMesh;
import artofillusion.TextureParameter;
import artofillusion.UndoRecord;
import artofillusion.animation.SkeletonTool;
import artofillusion.math.Mat4;
import artofillusion.math.RGBColor;
import artofillusion.math.Vec2;
import artofillusion.math.Vec3;
import artofillusion.object.MeshVertex;
import artofillusion.object.ObjectInfo;
import artofillusion.object.SplineMesh;
import artofillusion.ui.MeshEditController;
import artofillusion.view.ConstantVertexShader;
import artofillusion.view.FlatVertexShader;
import artofillusion.view.ParameterVertexShader;
import artofillusion.view.SmoothVertexShader;
import artofillusion.view.TexturedVertexShader;
import artofillusion.view.VertexShader;
import buoy.event.WidgetMouseEvent;
import buoy.widget.RowContainer;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;

public class SplineMeshViewer
extends MeshViewer {
    private int deselect;
    private Point[] screenVert;
    private double[] screenZ;
    private boolean draggingSelectionBox;
    private boolean dragging;
    boolean[] visible;
    static final RGBColor surfaceRGB = new RGBColor(0.8f, 0.8f, 1.0f);
    static final Color surfaceColor = new Color(0.8f, 0.8f, 1.0f);

    public SplineMeshViewer(MeshEditController window, RowContainer p) {
        super(window, p);
        SplineMesh mesh = (SplineMesh)window.getObject().getObject();
        this.visible = new boolean[mesh.getVertices().length];
    }

    public void updateImage() {
        SplineMesh mesh = (SplineMesh)this.getController().getObject().getObject();
        MeshVertex[] v = mesh.getVertices();
        this.screenVert = new Point[v.length];
        this.screenZ = new double[v.length];
        double clipDist = this.theCamera.getClipDistance();
        for (int i = 0; i < v.length; ++i) {
            Vec2 p = this.theCamera.getObjectToScreen().timesXY(v[i].r);
            this.screenVert[i] = new Point((int)p.x, (int)p.y);
            this.screenZ[i] = this.theCamera.getObjectToView().timesZ(v[i].r);
            this.visible[i] = this.screenZ[i] > clipDist;
        }
        super.updateImage();
    }

    protected void drawObject() {
        Color selectedColor;
        Color meshColor;
        SplineMesh mesh = (SplineMesh)this.getController().getObject().getObject();
        this.drawSurface();
        Vec3 displace = new Vec3(0.0, 0.0, -0.01);
        this.theCamera.getViewToWorld().transformDirection(displace);
        this.getDisplayCoordinates().toLocal().transformDirection(displace);
        Mat4 oldTransform = this.theCamera.getObjectToWorld();
        this.theCamera.setObjectTransform(oldTransform.times(Mat4.translation(displace.x, displace.y, displace.z)));
        if (this.currentTool instanceof SkeletonTool) {
            meshColor = disabledColor;
            selectedColor = new Color(255, 127, 255);
        } else {
            meshColor = lineColor;
            selectedColor = highlightColor;
            if (this.showSkeleton && mesh.getSkeleton() != null) {
                mesh.getSkeleton().draw(this, false);
            }
        }
        if (this.controller.getSelectionMode() == 0) {
            this.drawEdges(disabledColor, disabledColor);
            this.drawVertices(meshColor, this.currentTool.hilightSelection() ? selectedColor : meshColor);
        } else {
            this.drawEdges(meshColor, this.currentTool.hilightSelection() ? selectedColor : meshColor);
        }
        if (this.currentTool instanceof SkeletonTool && this.showSkeleton && mesh.getSkeleton() != null) {
            mesh.getSkeleton().draw(this, true);
        }
    }

    private void drawSurface() {
        if (!this.showSurface) {
            return;
        }
        ObjectInfo objInfo = this.controller.getObject();
        Vec3 viewDir = this.getDisplayCoordinates().toLocal().timesDirection(this.theCamera.getViewToWorld().timesDirection(Vec3.vz()));
        if (this.renderMode == 0) {
            this.renderWireframe(objInfo.getWireframePreview(), this.theCamera, surfaceColor);
        } else if (this.renderMode == 4) {
            this.renderMeshTransparent(objInfo.getPreviewMesh(), new ConstantVertexShader(surfaceRGB), this.theCamera, viewDir, null);
        } else {
            VertexShader shader;
            RenderingMesh mesh = objInfo.getPreviewMesh();
            if (this.renderMode == 1) {
                shader = new FlatVertexShader(mesh, surfaceRGB, viewDir);
            } else if (this.surfaceColoringParameter != null) {
                shader = null;
                TextureParameter[] params = objInfo.getObject().getParameters();
                for (int i = 0; i < params.length; ++i) {
                    if (!params[i].equals(this.surfaceColoringParameter)) continue;
                    shader = new ParameterVertexShader(mesh, mesh.param[i], lowValueColor, highValueColor, this.surfaceColoringParameter.minVal, this.surfaceColoringParameter.maxVal, viewDir);
                    break;
                }
            } else {
                shader = this.renderMode == 2 ? new SmoothVertexShader(mesh, surfaceRGB, viewDir) : new TexturedVertexShader(mesh, objInfo.getObject(), 0.0, viewDir).optimize();
            }
            this.renderMesh(mesh, shader, this.theCamera, objInfo.getObject().isClosed(), null);
        }
    }

    private void drawVertices(Color unselectedColor, Color selectedColor) {
        int i;
        if (!this.showMesh) {
            return;
        }
        SplineMesh mesh = (SplineMesh)this.getController().getObject().getObject();
        MeshVertex[] v = mesh.getVertices();
        ArrayList<Rectangle> boxes = new ArrayList<Rectangle>();
        ArrayList<Double> depths = new ArrayList<Double>();
        boolean[] selected = this.controller.getSelection();
        for (i = 0; i < v.length; ++i) {
            if (selected[i] || !this.visible[i]) continue;
            boxes.add(new Rectangle(this.screenVert[i].x - 2, this.screenVert[i].y - 2, 5, 5));
            depths.add(this.screenZ[i] - 0.02);
        }
        this.renderBoxes(boxes, depths, unselectedColor);
        boxes.clear();
        depths.clear();
        for (i = 0; i < v.length; ++i) {
            if (!selected[i] || !this.visible[i]) continue;
            boxes.add(new Rectangle(this.screenVert[i].x - 2, this.screenVert[i].y - 2, 5, 5));
            depths.add(this.screenZ[i] - 0.02);
        }
        this.renderBoxes(boxes, depths, selectedColor);
    }

    private void drawEdges(Color unselectedColor, Color selectedColor) {
        int j;
        int i;
        if (!this.showMesh) {
            return;
        }
        SplineMesh mesh = (SplineMesh)this.getController().getObject().getObject();
        MeshVertex[] v = mesh.getVertices();
        int usize = mesh.getUSize();
        int vsize = mesh.getVSize();
        boolean uclosed = mesh.isUClosed();
        boolean vclosed = mesh.isVClosed();
        boolean[] selected = this.controller.getSelection();
        if (this.controller.getSelectionMode() == 0) {
            for (i = 0; i < usize; ++i) {
                for (j = 0; j < vsize - 1; ++j) {
                    this.renderLine(v[i + j * usize].r, v[i + (j + 1) * usize].r, this.theCamera, unselectedColor);
                }
                if (!vclosed) continue;
                this.renderLine(v[i + j * usize].r, v[i].r, this.theCamera, unselectedColor);
            }
            for (j = 0; j < vsize; ++j) {
                for (i = 0; i < usize - 1; ++i) {
                    this.renderLine(v[i + j * usize].r, v[i + 1 + j * usize].r, this.theCamera, unselectedColor);
                }
                if (!uclosed) continue;
                this.renderLine(v[i + j * usize].r, v[j * usize].r, this.theCamera, unselectedColor);
            }
        } else {
            for (i = 0; i < usize; ++i) {
                if (selected[i]) continue;
                for (j = 0; j < vsize - 1; ++j) {
                    this.renderLine(v[i + j * usize].r, v[i + (j + 1) * usize].r, this.theCamera, unselectedColor);
                }
                if (!vclosed) continue;
                this.renderLine(v[i + j * usize].r, v[i].r, this.theCamera, unselectedColor);
            }
            for (j = 0; j < vsize; ++j) {
                if (selected[j + usize]) continue;
                for (i = 0; i < usize - 1; ++i) {
                    this.renderLine(v[i + j * usize].r, v[i + 1 + j * usize].r, this.theCamera, unselectedColor);
                }
                if (!uclosed) continue;
                this.renderLine(v[i + j * usize].r, v[j * usize].r, this.theCamera, unselectedColor);
            }
        }
        if (this.controller.getSelectionMode() == 0) {
            return;
        }
        for (i = 0; i < usize; ++i) {
            if (!selected[i]) continue;
            for (j = 0; j < vsize - 1; ++j) {
                this.renderLine(v[i + j * usize].r, v[i + (j + 1) * usize].r, this.theCamera, selectedColor);
            }
            if (!vclosed) continue;
            this.renderLine(v[i + j * usize].r, v[i].r, this.theCamera, selectedColor);
        }
        for (j = 0; j < vsize; ++j) {
            if (!selected[j + usize]) continue;
            for (i = 0; i < usize - 1; ++i) {
                this.renderLine(v[i + j * usize].r, v[i + 1 + j * usize].r, this.theCamera, selectedColor);
            }
            if (!uclosed) continue;
            this.renderLine(v[i + j * usize].r, v[j * usize].r, this.theCamera, selectedColor);
        }
    }

    protected void mousePressed(WidgetMouseEvent e) {
        boolean[] selected;
        int k;
        int j;
        boolean wantHandleClicks;
        SplineMesh mesh = (SplineMesh)this.getController().getObject().getObject();
        int usize = mesh.getUSize();
        int vsize = mesh.getVSize();
        Point pos = e.getPoint();
        this.requestFocus();
        this.sentClick = false;
        this.deselect = -1;
        this.dragging = false;
        this.clickPoint = e.getPoint();
        this.activeTool = this.metaTool != null && e.isMetaDown() ? this.metaTool : (this.altTool != null && e.isAltDown() ? this.altTool : this.currentTool);
        if ((this.activeTool.whichClicks() & 1) != 0) {
            this.activeTool.mousePressed(e, this);
            this.dragging = true;
            this.sentClick = true;
        }
        boolean allowSelectionChange = this.activeTool.allowSelectionChanges();
        boolean bl = wantHandleClicks = (this.activeTool.whichClicks() & 4) != 0;
        if (!allowSelectionChange && !wantHandleClicks) {
            return;
        }
        int i = this.findClickTarget(e.getPoint());
        if (i == -1) {
            if (allowSelectionChange) {
                this.draggingSelectionBox = true;
                this.beginDraggingSelection(pos, false);
            }
            return;
        }
        if (this.controller.getSelectionMode() == 1) {
            int dist;
            j = 0;
            int closest = Integer.MAX_VALUE;
            if (i < usize) {
                for (k = 0; k < vsize; ++k) {
                    dist = Math.abs(pos.x - this.screenVert[i + usize * k].x) + Math.abs(pos.y - this.screenVert[i + usize * k].y);
                    if (dist >= closest) continue;
                    j = i + usize * k;
                }
            } else {
                for (k = 0; k < usize; ++k) {
                    dist = Math.abs(pos.x - this.screenVert[k + usize * (i - usize)].x) + Math.abs(pos.y - this.screenVert[k + usize * (i - usize)].y);
                    if (dist >= closest) continue;
                    j = k + usize * (i - usize);
                }
            }
        } else {
            j = i;
        }
        if ((selected = this.controller.getSelection())[i]) {
            if (e.isShiftDown() && allowSelectionChange) {
                this.deselect = i;
            }
            if (wantHandleClicks) {
                this.activeTool.mousePressedOnHandle(e, this, 0, j);
                this.sentClick = true;
            }
            return;
        }
        if (!allowSelectionChange) {
            return;
        }
        boolean[] oldSelection = (boolean[])selected.clone();
        if (!e.isShiftDown()) {
            for (k = 0; k < selected.length; ++k) {
                selected[k] = false;
            }
        }
        selected[i] = true;
        this.currentTool.getWindow().setUndoRecord(new UndoRecord(this.currentTool.getWindow(), false, 15, new Object[]{this.controller, this.controller.getSelectionMode(), oldSelection}));
        this.controller.setSelection(selected);
        this.currentTool.getWindow().updateMenus();
        if (!e.isShiftDown() && wantHandleClicks) {
            this.activeTool.mousePressedOnHandle(e, this, 0, j);
            this.sentClick = true;
        }
    }

    protected void mouseDragged(WidgetMouseEvent e) {
        if (!this.dragging) {
            Point p = e.getPoint();
            if (Math.abs(p.x - this.clickPoint.x) < 2 && Math.abs(p.y - this.clickPoint.y) < 2) {
                return;
            }
        }
        this.dragging = true;
        this.deselect = -1;
        super.mouseDragged(e);
    }

    protected void mouseReleased(WidgetMouseEvent e) {
        int i;
        SplineMesh mesh = (SplineMesh)this.getController().getObject().getObject();
        int usize = mesh.getUSize();
        int vsize = mesh.getVSize();
        this.moveToGrid(e);
        this.endDraggingSelection();
        boolean[] selected = this.controller.getSelection();
        boolean[] oldSelection = (boolean[])selected.clone();
        if (this.draggingSelectionBox && !e.isShiftDown() && !e.isControlDown()) {
            for (i = 0; i < selected.length; ++i) {
                selected[i] = false;
            }
        }
        if (this.selectBounds != null) {
            boolean newsel;
            boolean bl = newsel = !e.isControlDown();
            if (this.controller.getSelectionMode() == 0) {
                for (i = 0; i < selected.length; ++i) {
                    if (!this.selectionRegionContains(this.screenVert[i])) continue;
                    selected[i] = newsel;
                }
            } else {
                int j;
                for (i = 0; i < usize; ++i) {
                    for (j = 0; j < vsize && this.selectionRegionContains(this.screenVert[i + j * usize]); ++j) {
                    }
                    if (j != vsize) continue;
                    selected[i] = newsel;
                }
                for (i = 0; i < vsize; ++i) {
                    for (j = 0; j < usize && this.selectionRegionContains(this.screenVert[j + i * usize]); ++j) {
                    }
                    if (j != usize) continue;
                    selected[i + usize] = newsel;
                }
            }
        }
        this.draggingSelectionBox = false;
        this.draggingBox = false;
        if (this.sentClick) {
            if (!this.dragging) {
                Point p = e.getPoint();
                e.translatePoint(this.clickPoint.x - p.x, this.clickPoint.y - p.y);
            }
            this.activeTool.mouseReleased(e, this);
        }
        if (this.deselect > -1) {
            selected[this.deselect] = false;
        }
        for (int k = 0; k < selected.length; ++k) {
            if (selected[k] == oldSelection[k]) continue;
            this.currentTool.getWindow().setUndoRecord(new UndoRecord(this.currentTool.getWindow(), false, 15, new Object[]{this.controller, this.controller.getSelectionMode(), oldSelection}));
            break;
        }
        this.controller.setSelection(selected);
        this.currentTool.getWindow().updateMenus();
    }

    int findClickTarget(Point pos) {
        SplineMesh mesh = (SplineMesh)this.getController().getObject().getObject();
        MeshVertex[] vt = mesh.getVertices();
        double closestz = Double.MAX_VALUE;
        boolean sel = false;
        int which = -1;
        boolean uclosed = mesh.isUClosed();
        boolean vclosed = mesh.isVClosed();
        boolean[] selected = this.controller.getSelection();
        boolean priorityToSelected = this.getRenderMode() == 0 || this.getRenderMode() == 4;
        int usize = mesh.getUSize();
        int vsize = mesh.getVSize();
        if (this.controller.getSelectionMode() == 0) {
            for (int i = 0; i < vt.length; ++i) {
                double z;
                if (!this.visible[i] || sel && !selected[i] && priorityToSelected) continue;
                Point v1 = this.screenVert[i];
                if (pos.x < v1.x - 2 || pos.x > v1.x + 2 || pos.y < v1.y - 2 || pos.y > v1.y + 2 || !((z = this.theCamera.getObjectToView().timesZ(vt[i].r)) < closestz) && (sel || !selected[i] || !priorityToSelected)) continue;
                which = i;
                closestz = z;
                sel = selected[i];
            }
        } else {
            double z;
            int j;
            int i;
            for (i = 0; i < usize; ++i) {
                if (sel && !selected[i] && priorityToSelected) continue;
                for (j = 1; j < vsize; ++j) {
                    z = this.lineClickDepth(pos, vt, i + (j - 1) * usize, i + j * usize);
                    if (!(z < closestz) && (!(z < Double.MAX_VALUE) || sel || !selected[i] || !priorityToSelected)) continue;
                    which = i;
                    closestz = z;
                    sel = selected[i];
                }
                if (!vclosed || !((z = this.lineClickDepth(pos, vt, i + (j - 1) * usize, i)) < closestz) && (!(z < Double.MAX_VALUE) || sel || !selected[i] || !priorityToSelected)) continue;
                which = i;
                closestz = z;
                sel = selected[i];
            }
            for (i = 0; i < vsize; ++i) {
                if (sel && !selected[i + usize] && priorityToSelected) continue;
                for (j = 1; j < usize; ++j) {
                    z = this.lineClickDepth(pos, vt, j - 1 + i * usize, j + i * usize);
                    if (!(z < closestz) && (!(z < Double.MAX_VALUE) || sel || !selected[i] || !priorityToSelected)) continue;
                    which = i + usize;
                    closestz = z;
                    sel = selected[i + usize];
                }
                if (!uclosed || !((z = this.lineClickDepth(pos, vt, j - 1 + i * usize, i * usize)) < closestz) && (!(z < Double.MAX_VALUE) || sel || !selected[i] || !priorityToSelected)) continue;
                which = i + usize;
                closestz = z;
                sel = selected[i + usize];
            }
        }
        return which;
    }

    private double lineClickDepth(Point pos, MeshVertex[] vt, int p1, int p2) {
        double w;
        double u;
        double v;
        if (!this.visible[p1] || !this.visible[p2]) {
            return Double.MAX_VALUE;
        }
        Point v1 = this.screenVert[p1];
        Point v2 = this.screenVert[p2];
        if (pos.x < v1.x - 2 && pos.x < v2.x - 2 || pos.x > v1.x + 2 && pos.x > v2.x + 2 || pos.y < v1.y - 2 && pos.y < v2.y - 2 || pos.y > v1.y + 2 && pos.y > v2.y + 2) {
            return Double.MAX_VALUE;
        }
        if (Math.abs(v1.x - v2.x) > Math.abs(v1.y - v2.y)) {
            if (v2.x > v1.x) {
                v = ((double)pos.x - (double)v1.x) / (double)(v2.x - v1.x);
                u = 1.0 - v;
            } else {
                u = ((double)pos.x - (double)v2.x) / (double)(v1.x - v2.x);
                v = 1.0 - u;
            }
            w = u * (double)v1.y + v * (double)v2.y - (double)pos.y;
        } else {
            if (v2.y > v1.y) {
                v = ((double)pos.y - (double)v1.y) / (double)(v2.y - v1.y);
                u = 1.0 - v;
            } else {
                u = ((double)pos.y - (double)v2.y) / (double)(v1.y - v2.y);
                v = 1.0 - u;
            }
            w = u * (double)v1.x + v * (double)v2.x - (double)pos.x;
        }
        if (Math.abs(w) > 2.0) {
            return Double.MAX_VALUE;
        }
        return u * this.theCamera.getObjectToView().timesZ(vt[p1].r) + v * this.theCamera.getObjectToView().timesZ(vt[p2].r);
    }
}

